/********************************************************************
 *
 * FILE:      raw2pov.c
 * AUTHOR:    Robbert de Groot
 * COPYRIGHT: 2002 Robbert de Groot
 *
 * USAGE: 
 * This small program is so dorky, if you want to use/modify/abuse it
 * go right ahead.  If you do. Keep this header and add your header
 * below explaining the changes you have made.  Include your own
 * copyright.
 *
 * DESC:
 * This small program will convert a dither raw image to a pov 
 * include file.  All black pixels in the dither image is mapped
 * to an object.
 * 
 *******************************************************************/

/********************************************************************
 * Includes
 *******************************************************************/
#include "stdlib.h"
#include "stdio.h"

/********************************************************************
 * Local Functions
 *******************************************************************/
static void _r2pPixel(FILE *fpout, int a, int b);
static void _r2pRowStart(FILE *fpout, int row);
static void _r2pRowStop(FILE *fpout);
static void _r2pStart(FILE *fpout);
static void _r2pStop(FILE *fpout);

/********************************************************************
 * Global Functions
 *******************************************************************/
/********************************************************************
 * FUNC: main
 *
 * The main program function
 *
 * PARAM:
 * acount, alist
 *    int, char **
 *    in, in
 *    The argument list.
 * 
 * RETURN:
 * int
 *    The return value of the program.
 *******************************************************************/
int main(int acount, char **alist)
{
   int   a,
         b,
         x, 
         y,
         dx,
         dy;
   FILE *fpin,
        *fpout;
   char  pixel[3];

   /* Check the input.*/
   if (acount < 5) {
      /* bad call, print information.*/
      printf(
         "raw2pov.exe\n"
         "~~~~~~~~~~~\n\n"
         "Usage: raw2pov [image_file] [x] [y] [dx] [dy] [pov_file]\n\n"
         "image_file : The raw image file to convert.\n"
         "x, y       : The dimension of the image file.\n"
         "dx, dy     : The dimension of the image to actually process.\n"
         "pov_file   : The file to write to.\n");
      return 0;
   }

   /* Get X and Y values */
   x  = atoi(alist[2]);
   y  = atoi(alist[3]);
   dx = atoi(alist[4]);
   dy = atoi(alist[5]);

   /* Open the files */
   fpin  = fopen(alist[1], "rb");
   fpout = fopen(alist[6], "wb");

   /* Validate the input */
   if (x  <= 0 ||
       y  <= 0 ||
       dx <= 0 ||
       dy <= 0 ||
       !fpin   ||
       !fpout) {
      printf(
         "raw2pov.exe\n"
         "~~~~~~~~~~~\n\n"
         "Bad inputs or could not open input or output file.\n");
      goto raw2povDONE;
   }

   dx = (dx > x) ? x : dx;
   dy = (dy > y) ? y : dy;

   /* prep work.*/
   _r2pStart(fpout);

   for (b = 0; b < dy; b++) {

      _r2pRowStart(fpout, b);

      for (a = 0; a < x; a++) {
         /* Read in 3 bytes. The pixel*/
         if (!fread(pixel, 1, 3, fpin)) {
            break;
         }

         if (a < dx) {
            /* If the pixel is black, we are assuming a B&W image. */
            if (!pixel[0]) {
               /* Write out the pov code.*/
               _r2pPixel(fpout, a, b);
            }
         }
      }

      _r2pRowStop(fpout);
   }

   /* post work. */
   _r2pStop(fpout);

raw2povDONE:
   /* Clean up */
   if (fpin) {
      fclose(fpin);
   }
   if (fpout) {
      fclose(fpout);
   }

   return 0;
}

/********************************************************************
 * Local Functions
 *******************************************************************/
/********************************************************************
 * FUNC: _r2pPixel
 *
 * Write the pov code for the location.
 *
 * PARAM:
 * fpout
 *    FILE *
 *    in
 *    The file to write to.
 *
 * a, b
 *    int, int
 *    in, in
 *    The location of the pixel.
 *******************************************************************/
void _r2pPixel(FILE *fpout, int a, int b)
{
   fprintf(fpout, 
      "PIXEL(%6d, %6d, _XSCALE, _YSCALE, _OBJECT)\n",
      a, b);
}

/********************************************************************
 * FUNC: _r2pPixel
 *
 * Write the pov code for the location.
 *
 * PARAM:
 * fpout
 *    FILE *
 *    in
 *    The file to write to.
 *
 * a, b
 *    int, int
 *    in, in
 *    The location of the pixel.
 *******************************************************************/
void _r2pRowStart(FILE *fpout, int row)
{
   fprintf(fpout, "#if (_ROW = %d)\n", row);
}

/********************************************************************
 * FUNC: _r2pRowStop
 *
 * End of a row.
 *
 * PARAM:
 * fpout
 *    FILE *
 *    in
 *    The file to write to.
 *******************************************************************/
void _r2pRowStop(FILE *fpout)
{
   fprintf(fpout, "#end\n");
}

/********************************************************************
 * FUNC: _r2pStart
 *
 * Write out the start of the include file.
 *
 * PARAM:
 * 
 * RETURN:
 *******************************************************************/
void _r2pStart(FILE *fpout) 
{
   fprintf(fpout,
      "#macro PIXEL(_X,_Y,_XSCALE,_YSCALE,_OBJECT)\n"
      "object {"
      "  _OBJECT\n"
      "  translate <_X * _XSCALE, _Y * _YSCALE, 0>\n"
      "}\n"
      "#end\n\n"
      "#macro BWIMAGE(_ROW,_XSCALE,_YSCALE,_OBJECT)\n"
      );
}

/********************************************************************
 * FUNC: _r2pStop
 *
 * Write out the start of the include file.
 *
 * PARAM:
 * 
 * RETURN:
 *******************************************************************/
void _r2pStop(FILE *fpout) 
{
   fprintf(fpout,
      "#end\n\n"
      );
}

