// File: rjg-dream.pov
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: IRTC Stills Entry June 30, Dreaming.
                                             
// To indicate to the included files that they are included.                                             
#declare _INCLUDED     = 1;                                 

// To indicate the rendering mode to use.
// 0 - final render.
// 1 - test render, simpler textures.
#declare _SPEED_RENDER = 0;          

// Camera setting. For a 200x300 aspect image.
camera {
   location    <0, 10, 55>
   up          y
   right       x / (3/2)
   look_at     <0, 5, 0>
   angle       40
   perspective
}                                             

// Lighting. 
// The lights are arranged around a circle at <0, 70, 0> 100
#declare _LIGHT_INT  = 2;    
#declare _NUM_LIGHTS = 32;
#declare _COUNT      = 0;
#while (_COUNT < _NUM_LIGHTS)

   light_source {
      <100, 70, 0>
      colour rgb < _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS>
      #if (_SPEED_RENDER = 1) 
      shadowless
      #end
      rotate <0, _COUNT * 360 / _NUM_LIGHTS, 0>
   }                            
   
   #declare _COUNT = _COUNT + 1;

#end

// background
background { 
   color rgb < 0, 0, 0 > 
}                
 
// Include the pieces
#debug "Dreamer\n"
#include "dreamer.pov"
#debug "DNA\n"
#include "dna.pov"
#debug "Dither\n"
#include "dither.pov"
#debug "Done\n"

// Insert the pieces into the scene.
object {
   _DREAMER
   rotate      <0, 180-35, 0>  
   scale       3                
   translate   <0, -6, 5>
}                       

object {
   _DNA
   scale       <-1.5, 1.5, 0>
   translate   <0, 10, 0>
}

object {
   _DITHER
   scale       .75
   translate   <0, 5, -10>
}
                                    
// The liquid floor.
plane {
   y, -20
   texture {
      pigment {
         color rgb <0.9, 0.91, 0.98>
      }
      normal {
         average
         normal_map {
            [bumps , 1.0 
             scale  2.0]
            [bumps , 2.0
             scale  4.0]
            [bumps , 3.0
             scale  16.0]
         }
         scale  0.5
         rotate -45.0 * z
      }      
      finish {
         ambient     0.0
         diffuse     1
         brilliance  6.0
         phong       0.75
         phong_size  80.0
         reflection  0.25
      }
   }   
}