//EMAIL: castlewrks@aol.com
//NAME: Robert J Becraft
//TOPIC: Dreaming
//COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//TITLE: Wheels
//COUNTRY: USA
//WEBPAGE: 
//RENDERER USED: POVRAY 3.1g
//TOOLS USED: PaintShop Pro (Label, JPEG conversion), POSER (3)
//RENDER TIME: 26 min 27 secs
//HARDWARE USED: Pentium 400mhz
//IMAGE DESCRIPTION:
// Wheels is inspired by a dream I had that also inspired a short story.
// The basic premis is that each wheel represents a life spinning through its days.
// Everyone has fast days and slow days... two things in this image affect how fast a
// wheel spins... first is the weeds growing on some of the wheels.  The second is the
// human-like creatures that are climbing through the wheel world.
// 
//DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//  The image creation was rather simple... created a wheel, used several random loops to
//  place the wheels.  The ones for the figures were hand placed with random placement of
//  the background wheels.  There are a couple of different wheel textures.
//
//  Finally, creation of the figures which was done in POSER.  This was important because they are there to 
//  represent other aspects of the dream world.  First and most obvious is the dream-world
//  fear of falling, represented by the girl hanging on by one hand and accented by the
//  600x1200 size of the image.
//
//  There is also a dream world representation of erotica by the lack of clothing on
//  the figures.  The male figure is in the dominent, higher position.  This
//  in and of itself represents many things dream-wise... male dominence, male potency,
//  male adventurism, strength (better/faster climber), etc.  The third female figure
//  is there to represent male dominence again (2 females + 1 male), she sits passively
//  watching the other two (the dreamers position).
//
//  There is a lack of details on purpose.  Dreams tend to have a focus and much of the
//  details of real life are missing or blurred.
//  There is light, but it is there to illuminate.
//


#include "finish.inc"
#include "kolors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "Glass.inc"
#include "golds.inc" 

 global_settings {
                  radiosity{
                            brightness 3.6      // 3.3 default
                            count 150            // 100 default 
                            distance_maximum 30 //0 default
                            error_bound .34      // .4 default
                            gray_threshold .6   // .5 default
                            low_error_factor .8 // .8 default
                            minimum_reuse .015  // .015 default
                            nearest_count 6     // 6 default
                            recursion_limit 1   // 1 default 
                           }
                    max_trace_level 25          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }
                 
                 
camera
{
  location <0,0 ,-25> up y right 
     1/2*x 
     //4/3*x
     look_at <0,0,0>   // look at
}

light_source {  <-6000,15000,-15000> color White*2 }

#declare Figures=on; // uncomment to turn on Figures  
#declare MoreWheels=on; // uncomment to turn on distant wheels  
#declare Wheels1=on; // uncomment to turn on 2nd level wheels
#declare WeedON=on; // uncomment to turn on weeds

fog {                                                 // White ground fog
  distance 150
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 10
  fog_alt 4
  turbulence 1.0
  turb_depth 3.0
}

#declare RS=seed(199);

#declare Rusty_Aluminum =
//texture{Brushed_Aluminum}
texture{pigment{color SeaGreen}}
texture { 
    pigment {
        bozo
        color_map {
            [0.0 rgbf <0.8100, 0.7100,0.2300, .1>]
            [0.35 rgbf <0.89, 0.51, 0.28, .4  >]
            [0.45 rgbf <0.70, 0.13, 0.00, .65 >]
            [0.5 rgbf <0.69, 0.41, 0.08, .2  >]
            [0.56 rgbf <0.49, 0.31, 0.28, .9  >]
            [0.89 rgbf <0.89, 0.51, 0.28, .4  >]
            [1.0 rgb <0,0,0>]
        }
    }
    finish { ambient 0.2 diffuse 0.4 }
  scale .005
}

#declare Wheel1=union{
  difference{
    cylinder{<-.06,0,0><.06,0,0> .55}
    cylinder{<-.061,0,0><.061,0,0> .5}
  }
  difference{
    cylinder{<-.05,0,0><.05,0,0> .5}
    cylinder{<-.051,0,0><.051,0,0> .4}
  }
}  

#declare Wheel2=union{
   object{Wheel1}
   
   cylinder{<-.05,0,0><.05,0,0> .15}
   cylinder{<-.2,0,0><.2,0,0> .1}
   cylinder{<-.25,0,0><.25,0,0> .05}   
   cylinder{<-.35,0,0><.35,0,0> .025 texture{Bright_Bronze}}   
   
   #declare R1=0;
   #while (R1<360)
      cylinder{<0,.1,0><0,.4,0> .02 rotate<R1,0,0>}
      #declare R1=R1+45;
   #end
}

#declare Weed1=union{
  cylinder{<0,-.15,0><0,.15,0> .001 texture{pigment{color Wheat}}}
  triangle{<0,0,0><0,.1,.1><.015,.1,.1>}
  triangle{<0,.05,0><0,.13,-.1><-.015,.14,-.1>}
  triangle{<0,.13,0><0,.17,-.15><.01,.15,-.05>}
}

#declare Weed2=union{
  #declare R1=1;
  #while(R1<35)
    #declare ROY=rand(RS)*360;
    #declare ROX=-rand(RS)*10;
    #declare RY=rand(RS)*1-.5;
    #declare RX=rand(RS)*.05;
    
    object{Weed1 rotate<ROX,ROY,0> translate<RX,RY,0> rotate<0,ROY,0>}
    #declare R1=R1+1; 
  #end
}

#ifdef(Figures)
#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "../../Poser/OBJuvPOV.png"
        }
    }
}
#declare OBJuvPOV_Texture_OBJuvPOVskin1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipples1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrows1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlashes1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupils1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVfingerNails1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtoeNails1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVLeather2 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVHead3 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVBraid1A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid2A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid3A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid4A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid5A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid6A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid7A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid8A3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVTail23 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid1B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid2B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid3B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid4B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid5B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid6B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid7B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVBraid8B3 = texture {pigment{color DarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVTail13 = texture {pigment{color DarkBrown}}
#declare WheelFem1 =
union
{
    #include "../../Poser/WheelFem1.inc"
    scale 1.5
}
#declare WheelFem2 =
union
{
    #include "../../Poser/WheelFem2.inc"
    scale 1.5
}


#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "../../Poser/NudeManTexture.png"
        }
    }
}
#declare OBJuvPOV_Texture_OBJuvPOVskin1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVLeather2 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial5 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial6 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial7 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial8 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial9 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial10 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial11 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial12 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial13 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial4 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmaterial3 = texture {OBJuvPOV_Texture}
#declare WheelMale =
union
{
    #include "../../Poser/WheelMale.inc"
    scale 1.5
}
#end //ifdef(Figures)


//*********************************************************** OBJECTS...
//**********************************************************************
//**********************************************************************

union{
  union{
    object {Wheel2 rotate<0,90,0> translate<0,1.5,0>texture{Bright_Bronze}}
    #ifdef(Figures)
      object {WheelFem1 rotate<0,-115,0> translate<-.35,-.36+.5,-.14>}
      object {WheelMale rotate<0,20,0> translate<.1,1.98,.15>}
    #end //ifdef(Figures)
//  object{Wheel2 texture{Rusty_Aluminum}}
    object{Weed2 translate<.1,.75,0> texture{pigment{color Green}}}
    object{Weed2 translate<0,1,0> texture{pigment{color Khaki}}}             
  rotate<0,-160,0>
  }
  
  object{Wheel2 translate<1,-1.30,.25> texture{Rusty_Aluminum}}
//  object {WheelFem2 rotate<0,0,0> translate<1,.48,.15>}
  object{Weed2 translate<1,-1.8,.25> texture{pigment{color Khaki}}}
  object{Weed2 translate<1,-2.05,.30> texture{pigment{color Khaki}}}
  object{Weed2 translate<.85,-1.85,.15> texture{pigment{color Khaki}}}
                                                         
  object{Wheel2 rotate<0,45,0> translate<-.5,-.2,.5> texture{Rusty_Aluminum}}                                                         
  #ifdef(Figures)  
    object{WheelFem2 rotate<0,-45,0> translate<-.75,.025,.35>}
  #end // ifdef(Figures)
  object{Weed2 translate<-.5,-.7,.5> texture{pigment{color Khaki}}}
  object{Weed2 translate<-.45,-.75,.35> texture{pigment{color ForestGreen}}}
  object{Weed2 translate<-.65,-.85,.45> texture{pigment{color GreenCopper}}}
  object{Weed2 translate<-.5,-1.2,.5> texture{pigment{color Green}}}      
  object{Weed2 translate<-.5,-1.5,.5> texture{pigment{color GreenCopper}}}
  object{Weed2 translate<-.5,-2,.5> texture{pigment{color Green}}}

  object{Wheel2 rotate<0,20,0> translate<-2,-2.25,.5> texture{Rusty_Aluminum}}
  object{Weed2 translate<-2.1,-2.75,.5> texture{pigment{color Green}}}
  object{Weed2 translate<-2,-2.5,.5> texture{pigment{color Khaki}}}       
  object{Weed2 translate<-2.1,-3.25,.5> texture{pigment{color Green}}}
  object{Weed2 translate<-2,-3,.5> texture{pigment{color Khaki}}}        
  object{Weed2 translate<-2.1,-3.75,.5> texture{pigment{color Green}}}
  object{Weed2 translate<-2,-3.55,.5> texture{pigment{color Khaki}}}        

  object{Wheel2 rotate<0,-30,0> translate<1.05,-2,-1> texture{Rusty_Aluminum}}
  object{Weed2 translate<1.2,-2.75,-1> texture{pigment{color GreenCopper}}}
  object{Weed2 translate<1.15,-3,-1> texture{pigment{color Green}}}       
  object{Weed2 translate<1.2,-3.25,-1> texture{pigment{color Khaki}}}
  object{Weed2 translate<1.15,-3.5,-1> texture{pigment{color GreenCopper}}}        
  object{Weed2 translate<1.2,-4.25,-1> texture{pigment{color Green}}}
  object{Weed2 translate<1.15,-3.75,-1> texture{pigment{color GreenCopper}}}   
  
  rotate<0,140,0>
  translate<0,0,-17>
}  



#ifdef(Wheels1)
#declare RC=1;
#while (RC<300)
   #declare ROY=rand(RS)*-90-45;
   #declare RY=rand(RS)*30-15;
   #declare RX=rand(RS)*35+2;
   #declare ROY1=rand(RS)*360;
   #declare ROZ1=rand(RS)*360;
   #declare ROX1=rand(RS)*360;
   #declare RSS=rand(RS)*.75+.5;
   #declare RxC=int(rand(RS)*10+1);



  union{         
  
 #ifdef(WeedON)    
   #declare M1=int(rand(RS)*8);
   #declare MC=1;
   object{Weed2 translate<0,-.5,0> texture{pigment{color Green}}}   
   #while (MC<M1)
    // #declare WD=int(rand(RS)*10+1);
    // #switch (WD)
    //   #range(1,5) 
            #declare WLY=rand(RS)*1-.5*M1/2;
            #declare WLX=rand(RS)*.5-.25;  
            #declare WC=int(rand(RS)*5+1);
            
            object{Weed2 translate<WLX,-.5+WLY,0>
                   texture{pigment{color 
                     #switch (WC)
                       #case(1) Green #break
                       #case(2) ForestGreen #break
                       #case(3) Khaki #break
                       #case(4) Green #break
                       #case(5) HuntersGreen #break    
                       #case(6) Honeydew #break                       
                       #case(7) GreenCopper #break                       
                       #else Green #break 
                     #end // switch(WC)
                   }}
            }
    //      #break
    //   #else       #break
    // #end // switch (WD)   
     #declare MC=MC+1;
   #end
 #end // #ifdef(WeedON)  
      
   object{Wheel2 scale RSS 
     texture{
     #switch (RxC)
       #range(1,9) Rusty_Aluminum #break
       #else       Bright_Bronze #break
     #end // switch (RxC)
   }}
   
    rotate<0,ROY1,0> translate<RX,RY,0> rotate<0,ROY,0>
   } // union
   
   #declare RC=RC+1;
#end
#end //#ifdef(Wheels1)

#ifdef(MoreWheels)
//#declare RS=seed(99);
#declare RC=1;
#while (RC<2000)
   #declare ROY=rand(RS)*-110-40;
   #declare RY=rand(RS)*60-30;
   #declare RX=rand(RS)*75+50;
   #declare ROY1=rand(RS)*360;
   #declare ROZ1=rand(RS)*360;
   #declare ROX1=rand(RS)*360;
   #declare RSS=rand(RS)*.5+.75;
   #declare RxC=int(rand(RS)*10+1);
   
   
   object{Wheel2 scale RSS rotate<0,ROY1,0> translate<RX,RY,0> rotate<0,ROY,0> 
     texture{
     #switch (RxC)
       #range(1,9) Rusty_Aluminum #break
       #else       Bright_Bronze #break
     #end
   }}
   
   #declare RC=RC+1;
#end
#end //#ifdef(MoreWheels)