// Loneliness, as I see it



// DEBUG FLAGS
// -----------

// Disables glass material for bottles and draws a grid for easy placement
#declare DEBUG = 0;

// Disables background
#declare NOBACKGROUND = 0;

// Sets point-of-view to high above the scene
#declare OVERVIEW = 0;

// Disables focal blur
#declare NOFBLUR = 0;



// Diffuse value of background
#declare BGDIFFUSE = .2;



global_settings
{
	max_trace_level 10
}



// Bottle models
#include "kabby/bottles.inc"






// Table (NB: the side stripe is not visible in the current scene)
#declare Table = union
{
	box
	{
		<-10, -.5, -10>,
		<10, 0, 5>

		// Main woody texture
		texture
		{
			pigment
			{
				marble
				color_map
				{
					[0 color rgb <.6, .3, .1>]
					[1 color rgb <.8, .5, .1>]
				}
				rotate 90 * y
				warp { turbulence z }
				scale <10, 1, 1> / 5
			}
			finish { Shiny }
		}
		
		// Brings down saturation on some large, smooth areas, while darkening a bit some other ones
		texture
		{
			pigment
			{
				bozo
				color_map
				{
					[.5 color Clear]
					[1 color rgbt <1, 1, 1, .95>]
				}
				translate <20, 20, 20>
			}
		}
		texture
		{
			pigment
			{
				bozo
				color_map
				{
					[.5 color Clear]
					[1 color rgbt <1, 1, 1, .5>]
				}
			}
			scale 3
		}
		
		// Sow ash-like dust
		texture
		{
			pigment
			{
				bozo
				turbulence 1
				color_map
				{
					[.8 color Clear]
					[.8 color Black]
					[1 color White]
				}
			}
			scale .05
		}
	}
	
	// Black side stripe
	superellipsoid
	{
		<.5, .5>
		texture
		{
			pigment { color Black }
			finish { Shiny }
		}
		scale <10, .2499, .1>
		translate <0, -.25, -5>
	}
}






// Bottle cork (regular with a slight depression in the middle, sitting on the side on y-plane and lying along x-axis)
#declare KCork = union
{
	cone
	{
		<-.2, 0, 0>, .105
		<0, 0, 0>, .1
	}
	cone
	{
		<0, 0, 0>, .1
		<.2, 0, 0>, .105
	}
	translate .105 * y
	texture { Cork scale .8 }
}





// Bottle cork (as tucked down into a bottle, standing on y-plane)
#declare KCork2 = cone
{
	<0, 0, 0>, .09
	<0, .4, 0>, .105
	texture { Cork scale .8 }
}



// Empty bottle (scaled down to match scene)
#macro KEmptyBottle (ang)
	object
	{
		EmptyBottle (ang)
		scale .2
		rotate -90 * z
	}
#end



// Full sealed bottle (scaled down to match scene)
#declare KBottle = union
{
	object
	{
		Bottle2
		scale .2
	}
	object
	{
		KCork2
		translate 2.2 * y
	}
}










object { Table }







// Where empty bottles lie (x, y = position on y-plane; z = angle)
#declare NLBOTTLES = 14;	// 15
#declare LBOTTLES = array [NLBOTTLES]
{
	<-7.5, 2, -50>,
	<-3, 1.75, -160>,
	<-3, 4.5, 60>,
	<-4, -.5, -45>,
	<-4.25, -1.25, -130>,
	<-1.25, 2, -40>,
	<0, -.75, -170>,
	<-3.5, -3, -30>,
	<-.5, -5.75, -120>,
	<.5, 1.75, 60>,
	<4.25, 1.75, -135>,
	<4.25, .5, 40>,
	<2, -1.5, 5>,
	<4.5, -5.5, -180>,
	//<0, -4, 20>			Looks bad with focal blur enabled
}


// Random number seed for bottle tilting
#declare _SEED = seed (90877);


#declare i = 0;
#while (i < NLBOTTLES)
	#declare p = LBOTTLES [i];
	object
	{
		KEmptyBottle (360 * rand (_SEED))
		rotate p.z * y
		translate <p.x, 2 * .9 * .2, p.y>
	}
	#declare i = i + 1;
#end




// Where corks lie (same conventions)
#declare NCORKS = 17;
#declare CORKS = array [NCORKS]
{
	<-7.5, 3.5, 20>,
	<-4.5, 4, -5>,
	<-4.75, 3.25, -70>,
	<-.75, 4.25, 80>,
	<-1.5, .5, 15>,
	<-1, 1, -10>,
	<-3, -1.5, 30>,
	<-1.25, -3, 20>,
	<2.5, -3, -35>,
	<2, -.75, -20>,
	<2, 0, 10>,
	<3, -.25, 15>,
	<2.25, .5, -60>,
	<1.75, 3.5, -70>,
	<1.75, 4.25, -25>,
	<4.75, 3.5, -10>,
	<0, -5, -10>
}


#declare i = 0;
#while (i < NCORKS)
	#declare p = CORKS [i];
	object
	{
		KCork
		rotate p.z * y
		translate <p.x, 0, p.y>
	}
	#declare i = i + 1;
#end





// Grid
#if (DEBUG)
	#declare i = -10;
	#while (i < 10)
		#declare j = -10;
		#while (j < 10)
			sphere
			{
				<i, 0, j>, .1
				texture
				{
					pigment
					{
						#if ((i = 0) & (j = 0))
							color Red
						#else
							color Green
						#end
					}
				}
			}
			cylinder
			{
				<i, 0, j>,
				<i + 1, 0, j>, .05
				texture
				{
					pigment { color Blue }
				}
			}
			cylinder
			{
				<i, 0, j>,
				<i, 0, j + 1>, .05
				texture
				{
					pigment { color Blue }
				}
			}
			#declare j = j + 1;
		#end
		#declare i = i + 1;
	#end
	// Field of view (roughly)
	cylinder
	{
		<1.5, 0, -7.5>,
		<-10, 0, 4>, .05
		texture
		{
			pigment { color Red }
		}
	}
	cylinder
	{
		<1.5, 0, -7.5>,
		<7, 0, 5>, .05
		texture
		{
			pigment { color Red }
		}
	}
#end




// Gross background
#if (!NOBACKGROUND)
	union
	{
		box
		{
			<-100, -100, 50>,
			<-20, 100, 100>
		}
		box
		{
			<-20, -100, 100>,
			<100, 100, 200>
		}
		box
		{
			<-40, -5, 45>,
			<-30, 10, 50>
		}
		box
		{
			<-15, -5, 95>,
			<30, 10, 100>
		}
		union
		{
			box
			{
				<-40, -5, 44>,
				<-30, 10, 45>
			}
			box
			{
				<-15, -15, 94>,
				<30, 10, 95>
			}
			texture
			{
				pigment { color rgb <1, 1, .9> }
				finish
				{
					diffuse BGDIFFUSE
					specular .1
				}
			}
		}
		union
		{
			box
			{
				<-100, 12, 49>,
				<-20, 14, 50>
			}
			box
			{
				<-20, 12, 49>,
				<-19, 14, 99>
			}
			box
			{
				<-20, 12, 99>,
				<100, 14, 100>
			}
			texture
			{
				pigment { color rgb <.5, .8, .9> }
				finish
				{
					diffuse BGDIFFUSE
					specular .1
				}
			}
		}
		texture
		{
			pigment { color rgb <.7, .9, .9> }
			normal
			{
				bumps .1
				scale .3
			}
			finish
			{
				Dull
				diffuse BGDIFFUSE
				specular .1
			}
		}
	}
#end




// A glass
difference
{
	quartic
	{
		<1, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, -.6, 1, 0,
		 0, 0, 0>
		scale .2
		translate -.8 * y
		//texture { pigment { color rgbt <1, 0, 0, .8> } }
	}
	plane
	{
		-y, -.8
	}
	quartic
	{
		<1, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 0, 0, 0, 0, -.8, 1, 0,
		 0, 0, 0>
		scale .2
		texture
		{
			pigment
			{
				gradient y
				turbulence .1
				color_map
				{
					[0 color KColor2]
					[.2 color GColor]
				}
			}
		}
		translate .05 * y
		//texture { pigment { color Blue } }
	}
	texture
	{
		pigment { color GColor }
		finish
		{
			F_Glass3
			ambient .4
		}
	}
	interior { I_Glass }
	translate <1.75, 0, -2.5>
}




// THE central model -- an untouched bottle
object
{
	KBottle
	translate <1, 0, -2>
}



/*
light_source
{
	<-10, 15, -10>
	color White / 2
}



light_source
{
	<10, 15, -20>
	color White / 2
}
*/


light_source
{
	<10, 20, -20>
	color White
}



// Camera
#if (OVERVIEW)
	camera
	{
		location <0, 18, 0>
		look_at <0, 0, 0>
	}
#else
	camera
	{
		location <1.5, 2, -7.5>
		look_at <0, 0, 0>
		#if (!NOFBLUR)
			focal_point <1, 1, -2>
			aperture .3
			blur_samples 100
			variance .00001
		#end
	}
#end
