// Persistence of Vision Ray Tracer Scene Description File
// File: SideTable.inc
// Vers: 3.5
// Desc: A side table
// Date: 08/28/2002
// Auth: Jeff M. Thomas
//


#macro mLeg()
  #local Texture_Side_Wood=
  texture { T_Wood12 }
  #declare Leg=
  difference
  {
    #local myTranslate = -.08;
    #local myLean = .4;
    box
    {
      <-.05,0,-.05><.1,2.175,.05>
    }
    box
    {
      <-.051,-.2,-.051><.051,2.275,.051>
      rotate myLean*z
      translate myTranslate*x
    }
    box
    {
      <-.051,-.2,-.051><.051,2.275,.051>
      rotate myLean*z
      translate myTranslate*x
      rotate 90*y
    }
    box
    {
      <-.051,-.2,-.051><.051,2.275,.051>
      rotate myLean*z
      translate myTranslate*x
      rotate 180*y
    }
    box
    {
      <-.051,-.2,-.051><.051,2.275,.051>
      rotate myLean*z
      translate myTranslate*x
      rotate -90*y
    }
    texture { Texture_Side_Wood rotate 90*x scale .5}
  }
#end // macro mLeg

#macro mSideTable()
  #local Texture_Side_Wood=
  texture { T_Wood12 }
  #declare SideTable=
  difference
  {
    union
    {
      union
      {
        cylinder
        {
          .05*y, 0, 1
          translate<0,2.5,0>
        }
        torus
        {
          1, .05
          translate<0,2.5,0>
        }
        texture{ T_Stone41 }
      }
      difference
      {                 
        cylinder
        {
          -.3*y, 0, .9
          translate<0,2.475,0>
          texture { Texture_Side_Wood }
        }
        torus
        {
          .9, .03
          texture { Texture_Side_Wood }
          scale 3.5*y
          translate<0,2.325,0>
        }
        torus
        {
          .8, .03
          texture { Texture_Side_Wood }
          //scale 3.5*y
          translate<0,2.175,0>
        }
        #local Count=0;
        #local Number=16;
        #while( Count < Number )
          torus
          {
            .05, .075
            texture { Texture_Side_Wood }
            rotate 90*x
            scale 1.25*z
            //scale 3.5*y
            translate<-.95,2.325,0>
            rotate (360/Number)*Count*y
          }
          #local Count = Count + 1;
        #end
      }
      torus
      {
        .9, .015
        texture{ T_Chrome_2B }
        //scale 3.5*y
        translate<0,2.175,0>
      }
      mLeg()
      object
      {
        Leg
        translate<-.05,0,.75>
      }
      object
      {
        Leg
        translate<-.05,0,-.75>
      }
      object
      {
        Leg
        translate<-.8,0,0>
      }
      cylinder
      {
        .025*y, 0, .85
        translate<0,1,0>
        texture { Texture_Side_Wood }
      }
      torus
      {
        .85, .025
        texture { Texture_Side_Wood }
        translate<0,1,0>
      }
/*      prism 
      {
        conic_sweep
        linear_spline
        2.175, // sweep the following shape from here ...
        -5, // ... down through here
        6, // the number of points making up the shape ...
        <0,0><-.05,-.05><-.05,.05><.05,.05><.05,-.05><-.05,-.05>
        pigment { Green }
        translate -.25*x
      }
*/
    }
    box
    {
      <0,-5,-5>
      <5,5,5>
      pigment{ Black }
    }
    difference
    {
      cylinder
      {
        -.31*y, 0, .8
        translate<0,2.475,0>
        texture { Texture_Side_Wood }
      }
      box
      {
        <-.1,-5,-5>
        <5,5,5>
        texture { Texture_Side_Wood }
      }
    }
  }     
#end // macro mSideTable


