// Persistence of Vision Ray Tracer Scene Description File
// File: StoneWall.inc
// Vers: 3.5
// Desc: Basic Scene Example
// Date: 01/24/02
// Auth: Jeff M. Thomas
//

#version 3.5;

#include "functions.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "skies.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones.inc"
#include "woods.inc"     

#include "transforms.inc"

#declare StoneType_NonISO = 1;
#declare StoneType_Pitted = 2;
#declare StoneType_Rough = 3;
#declare StoneType_Rougher = 8;
#declare StoneType_RougherCracked = 9;
#declare StoneType_VeryRough = 4;
#declare StoneType_LightlyPitted = 5;
#declare StoneType_Rippled = 6;
#declare StoneType_Sandstone = 7;
#declare StoneType_ImbedSample = 10;
#declare StoneType_WildBlue = 11;

#declare BrickType_NonISO = 1;
#declare BrickType_Rounded = 2;
#declare BrickType_SmoothCut = 3;
#declare BrickType_SmoothFace = 4;

#macro Dents(Rand, Scale)
  #ifdef (fn_Dents)
    #undef fn_Dents
  #end
  #declare fn_Dents=function 
  {
    pigment 
    {
      agate  
      warp{ turbulence <0.1,0.1,0> octaves 6 lambda .5 omega .5 }
      scale Scale
      translate <1.3*Rand,.63*Rand,.2*Rand>
    }
  }
#end

#macro Granite1(Rand)  
  #debug concat( "Rand = ", str(Rand,7,2), "\n" )
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      granite  
      //warp{ turbulence <0.1,0.1,0> octaves 6 lambda .5 omega .5 }
      color_map { [0 rgb 0.0][.5 rgb 0.1][.8 rgb 0.75][1 rgb .9] }
      translate <20.3*Rand,10.63*Rand,50.2*Rand>
      scale .4
      rotate 128*Rand    
    }
  }
#end

#macro GraniteLightlyPitted(Rand)  
  #debug concat( "Rand = ", str(Rand,7,2), "\n" )
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      granite  
      //warp{ turbulence <0.1,0.1,0> octaves 6 lambda .5 omega .5 }
      color_map { [0 rgb 0.0][.8 rgb 0.1][1 rgb .75] }
      translate <20.3*Rand,10.63*Rand,50.2*Rand>
      scale .6
      rotate 128*Rand    
    }
  }
#end

#macro Granite2(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      granite
      //agate
      color_map { [0 rgb 0.0][.3 rgb 0.10][1 rgb 1] }
      scale .3
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro Granite4(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      granite
      //agate
      color_map { [0 rgb 0.0][.3 rgb 0.10][1 rgb 1] }
      scale .45
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro Granite3(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      granite
      //agate
      color_map { [0 rgb 0.0][1 rgb .75] }
      scale .6
      scale<1,.5,1>
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro Rippled(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      wood
      turbulence .5
      //agate
      color_map { [0 rgb 0.0][1 rgb .75] }
      //color_map { [0 rgb 0.0][.5 rgb 0.1][.8 rgb 0.3][1 rgb .5] }
      scale .3
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end
   
#macro Sandstone(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      wood
      turbulence .5
      //agate
      color_map { [0 rgb 0.0][1 rgb .75] }
      //color_map { [0 rgb 0.0][.5 rgb 0.1][.8 rgb 0.3][1 rgb .5] }
      scale .3
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro ImbedSample(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment 
    {
        crackle
        turbulence 0.6
        lambda 1.75
        omega 0.55
        octaves 4
        scale 0.45
        rotate <0, 5, 60>
        color_map 
        { 
            [0.01 color rgbt <0.00, 0.00, 0.00, 0.00> ]
            [0.02 color rgbt <0.40, 0.25, 0.15, 0.20> ]
            [0.05 color rgbt <0.40, 0.35, 0.20, 0.40> ]
            [0.10 color rgbt <0.45, 0.55, 0.25, 0.60> ]
            [0.65 color Clear ]
        }
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro WildBlue(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment {
        granite
        rotate y*90
        color_map { 
            [0.02 color rgbt <0.25, 0.45, 0.60, 0.0> ]
            [0.06 color rgbt <0.20, 0.40, 0.55, 0.0> ]
            [0.10 color rgbt <0.15, 0.20, 0.25, 0.0> ]
            [1.00 color rgbt <0.40, 0.60, 0.75, 0.0> ]
        }
        frequency 6
        rotate <0, 10, 0>
        turbulence <0.05, 0.05, 0.05>
        octaves 6
        omega 0.7
        lambda 2
        scale 1.5
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end   

#macro Cracks(Rand)
  #ifdef (fn_cracks)
    #undef fn_cracks 
  #end
  #declare fn_cracks=function
  {
    pigment
    {
      crackle solid
      //agate
      color_map { [0 rgb 0.0][.3 rgb 0.10][1 rgb 1] }
      scale .6
      warp 
      {                  // deforming the bricks ...
        turbulence <01.5,01.51,01.51>
        octaves 6
        lambda .5
        omega .5
      }
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end

#macro Warp(Rand)
  #declare fn_Warp=function 
  {
    pigment
    {
      dents
      warp 
      {                  // deforming the bricks ...
        turbulence <0.05,0.1,0.1>
        octaves 6
        lambda .5
        omega .5
      }
      scale <0.5,0.5,0.5>         
      translate <1.3*Rand,3.63*Rand,2.2*Rand>
    }
  }
#end

#macro StoneSurface( StoneType )
  //#debug concat( "-----------------------------------> HERE ", str(StoneType,7,3) )
  #ifdef (fn_Stone)
    #undef fn_Stone
  #end
  #declare fn_Stone=
    #switch( StoneType )
      #case( StoneType_NonISO ) // simple box bricks
        function{ 1 } 
        #break
      #case( StoneType_Pitted ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.0025)}
        #break
      #case( StoneType_Rough ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.00125)}
        #break
      #case( StoneType_Rougher ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.005)}
        #break
      #case( StoneType_RougherCracked ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.005)+(fn_cracks(x,y,z).gray*.005)}
        #break
      #case( StoneType_VeryRough ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.0100)}
        #break
      #case( StoneType_LightlyPitted ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.00125)}
        #break
      #case( StoneType_Rippled ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.0025)}
        #break
      #case( StoneType_Sandstone ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x,y,z).gray*.0025)}
        #break
      #case( StoneType_ImbedSample ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+((.5-fn_surface(x,y,z).gray)*.005)}
        #break
      #case( StoneType_WildBlue ) // 
        function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+((fn_surface(x,y,z).gray)*.0075)}
        #break
    #end // switch StoneType
  
  #declare MaxGradient=
    #switch( StoneType )
      #case( StoneType_NonISO ) // simple box bricks  
        1;
        #break
      #case( StoneType_Pitted ) // 
        1.1;
        #break
      #case( StoneType_Rough ) //
        1; 
        #break
      #case( StoneType_Rougher ) //
        1; 
        #break
      #case( StoneType_RougherCracked ) //
        1; 
        #break
      #case( StoneType_VeryRough ) //
        1; 
        #break
      #case( StoneType_LightlyPitted ) //
        1; 
        #break
      #case( StoneType_Rippled ) //
        1; 
        #break
      #case( StoneType_Sandstone ) //
        1; 
        #break
      #case( StoneType_ImbedSample ) //
        1; 
        #break
      #case( StoneType_WildBlue ) //
        1; 
        #break
    #end // switch StoneType
#end // StoneSurface

#macro Stone( StartVect, EndVect, BrickType, StoneType, Interior, UseTextureCallback, TextureMap, TranslateTextures, StoneRandom )
  #local xSize = abs(EndVect.x-StartVect.x);
  #local ySize = abs(EndVect.y-StartVect.y);
  #local zSize = abs(EndVect.z-StartVect.z);
  #local textureRandomizer = rand(StoneRandom)*71;
  //#debug concat( str(textureRandomizer,7,2), "\n" ) 
  #switch( StoneType )
    #range( StoneType_NonISO, StoneType_Pitted ) 
      Granite1(textureRandomizer)
      StoneSurface( StoneType )
      #break
    #case( StoneType_Rough )
      Granite2(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_Rougher )
      Granite4(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_RougherCracked )
      Cracks(textureRandomizer)
      Granite4(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_VeryRough )
      Granite3(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_LightlyPitted )
      GraniteLightlyPitted(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_Rippled )
      Rippled(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_Sandstone )
      Sandstone(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_ImbedSample )
      ImbedSample(textureRandomizer)
      StoneSurface( StoneType )
      #break;
    #case( StoneType_WildBlue )
      WildBlue(textureRandomizer)
      StoneSurface( StoneType )
      #break;
  #end // switch StoneType
  #declare StoneObject =
    object
    {
    #switch( BrickType )
      #case( BrickType_NonISO ) // simple box bricks 
        object
        {
          //#declare Random = StoneRandom;
          box { StartVect, EndVect }         
          //box { <-StoneSize.x/2,-StoneSize.y/2,-StoneSize.z/2>, <StoneSize.x/2,StoneSize.y/2,StoneSize.z/2> }
          //#debug concat( 
        }
        #if (UseTextureCallback > 0)
          MakeStoneTexture(UseTextureCallback, rand(StoneRandom)*10, rand(StoneRandom)*10, rand(StoneRandom)*10)
          texture 
          {
            function{fn_surface(x,y,z).gray}
            texture_map { Texture_StoneSpecial }
          }
        #else
          texture 
          {
            function{fn_surface(x,y,z).gray}
            texture_map { TextureMap }
            #if ( TranslateTextures != 0 )
              translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
            #end
          }
        #end // UseTextureCallback
        #break
      #case( BrickType_Rounded ) // isosurface bricks with rough rounded edges
        isosurface
        {
          #local padding = 0;//.001;
          function{ fn_Stone( x, y, z, xSize, ySize, zSize ) }
          max_gradient MaxGradient
          contained_by 
          { 
            box 
            { 
              <-(xSize/2)-padding,-(ySize/2)-padding,-(zSize/2)-padding>,<(xSize/2)+padding,(ySize/2)+padding,(zSize/2)+padding>
            } 
          }  
          all_intersections
          #if (UseTextureCallback > 0)
            MakeStoneTexture(UseTextureCallback, textureRandomizer, rand(StoneRandom)*10, rand(StoneRandom)*10)
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { Texture_StoneSpecial }
            }
          #else
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { TextureMap }
              #if ( TranslateTextures != 0 )
                translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
              #end
            }
          #end // UseTextureCallback
          translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) > 
        }

        //#debug concat( "there . . . ", str(-(xSize/2),7,2), ",", str(-(ySize/2),7,2), ",", str(-(zSize/2),7,2), " : ", str((xSize/2),7,2), ",", str((ySize/2),7,2), ",", str((zSize/2),7,2), "\n" )
        #break
      #case( BrickType_SmoothCut ) // isosurface bricks with rough face, smooth top and sides
        isosurface
        {
          #local padding = 0;//.001;
          function{ fn_Stone( x, y, z, xSize+.1, ySize+.1, zSize ) }
          max_gradient MaxGradient
          contained_by 
          { 
            box 
            { 
              <-(xSize/2)-padding,-(ySize/2)-padding,-(zSize/2)-padding>,<(xSize/2)+padding,(ySize/2)+padding,(zSize/2)+padding>
            } 
          }  
          all_intersections
          #if (UseTextureCallback > 0)
            MakeStoneTexture(UseTextureCallback, rand(StoneRandom)*10, rand(StoneRandom)*10, rand(StoneRandom)*10)
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { Texture_StoneSpecial }
            }
          #else
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { TextureMap }
              #if ( TranslateTextures != 0 )
                translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
              #end
            }
          #end // UseTextureCallback
          translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) > 
        }
        #break
      #case( BrickType_SmoothFace ) // isosurface bricks with rough edges, smooth face
        isosurface
        {
          #local padding = 0;//.001;
          function{ fn_Stone( x, y, z, xSize, ySize, zSize+.1 ) }
          max_gradient MaxGradient
          contained_by 
          { 
            box 
            { 
              <-(xSize/2)-padding,-(ySize/2)-padding,-(zSize/2)-padding>,<(xSize/2)+padding,(ySize/2)+padding,(zSize/2)+padding>
            } 
          }  
          all_intersections
          #if (UseTextureCallback > 0)
            MakeStoneTexture(UseTextureCallback, rand(StoneRandom)*10, rand(StoneRandom)*10, rand(StoneRandom)*10)
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { Texture_StoneSpecial }
            }
          #else
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { TextureMap }
              #if ( TranslateTextures != 0 )
                translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
              #end
            }
          #end // UseTextureCallback
          translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) > 
        }
        #break
      #case( 5 ) // isosurface bricks with rough non rounded edges
        isosurface
        {
          #local padding = 0;//.001;
          function{ fn_Stone( x, y, z, xSize, ySize, zSize ) }
          max_gradient MaxGradient
          contained_by 
          { 
            box 
            { 
              <-(xSize/2)-padding,-(ySize/2)-padding,-(zSize/2)-padding>,<(xSize/2)+padding,(ySize/2)+padding,(zSize/2)+padding>
            } 
          }  
          all_intersections
          #if (UseTextureCallback > 0)
            MakeStoneTexture(UseTextureCallback, rand(StoneRandom)*10, rand(StoneRandom)*10, rand(StoneRandom)*10)
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { Texture_StoneSpecial }
            }
          #else
            texture 
            {
              function{fn_surface(x,y,z).gray}
              texture_map { TextureMap }
              #if ( TranslateTextures != 0 )
                translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
              #end
            }
          #end // UseTextureCallback
          rotate<0,180,0>
          translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) > 
        }
        //#debug concat( "there . . . ", str(-(xSize/2),7,2), ",", str(-(ySize/2),7,2), ",", str(-(zSize/2),7,2), " : ", str((xSize/2),7,2), ",", str((ySize/2),7,2), ",", str((zSize/2),7,2), "\n" )
        #break
    #end // switch BrickType
    
    }
#end // Stone macro

#macro MakeStoneWall(StoneSize, MortorSize, MortorDepth, WallSize, Interior, UseTextureCallback, TextureMap, TranslateTexture, BrickType, StoneType, Translucent, Stagger, RandomSeed)
  
  #local StoneRandom = seed(RandomSeed);

  #declare xWidth = StoneSize.x*WallSize.x;//(((StoneSize.x+MortorSize.x)*WallSize.x)-MortorSize.x);
  #declare yWidth = StoneSize.y*WallSize.y;//(((StoneSize.y+MortorSize.y)*WallSize.y)-MortorSize.y);
  #declare zWidth = StoneSize.z*WallSize.z;//(((StoneSize.z+MortorSize.z)*WallSize.z)-MortorSize.z);
  
  #declare xLoc = (0 - (xWidth/2)) + (StoneSize.x/2);
  #declare yLoc = (0 - (yWidth/2)) + (StoneSize.y/2);
  #declare zLoc = (0 - (zWidth/2)) + (StoneSize.z/2);

  #local MortorObject =
  object
  {
    //box { <-xWidth/2+MortorDepth.x+MortorSize.x,-yWidth/2+MortorDepth.y+MortorSize.y,-zWidth/2+MortorDepth.z+MortorSize.z>, <xWidth/2-MortorDepth.x-MortorSize.x,yWidth/2-MortorDepth.y-MortorSize.y,zWidth/2-MortorDepth.z-MortorSize.x> }
    #local xMortor = xWidth-(MortorSize.x+MortorDepth.z);
    #local yMortor = yWidth-(MortorSize.y+MortorDepth.x);
    #local zMortor = zWidth-(MortorSize.z+MortorDepth.y);
    box { <0,0,0>,<xMortor,yMortor,zMortor> }
    //+MortorSize.x,-yWidth/2+MortorDepth.y+MortorSize.y,-zWidth/2+MortorDepth.z+MortorSize.z>, <xWidth/2-MortorDepth.x-MortorSize.x,yWidth/2-MortorDepth.y-MortorSize.y,zWidth/2-MortorDepth.z-MortorSize.x> }
    texture
    {
      pigment{ Gray }
      normal
      {
        agate
        agate_turb .5
        scale .020
      }
    }
    translate< -(xMortor/2), -(yMortor/2), -(zMortor/2) >
  }
  
  #local Stones =
  union
  {
    #local currentOffset = 0;
    #local xMinLimit = (0 - (xWidth/2));
    #local yMinLimit = (0 - (yWidth/2));
    #local xMaxLimit = (xWidth/2);
    #local yMaxLimit = (yWidth/2);
    #local zStart = (0 - (zWidth/2)) + (StoneSize.z/2);
    #local iCount = 0;
    
    #debug concat( "Widths: ", str(xWidth,7,2), " : ", str(yWidth,7,2), " : ", str(zWidth,7,2), "\n" )
    
    #local xAddon = 0;
    #if ( Stagger != 0 )
      #local xAddon = 1;
    #end
    #local iz = 0;
    #while (iz < WallSize.z)
      #local iy = 0;
      #while (iy < WallSize.y)
        #local ix = 0;
        #while (ix < WallSize.x + xAddon)
          #local xStart = (ix*StoneSize.x)+currentOffset;
          #local xEnd = xStart + StoneSize.x;
          #if (xStart < 0)
            #local xStart = 0;
          #end
          #if (xEnd > xWidth)
            #local xEnd = xWidth;
          #end
          #local yStart = iy*StoneSize.y;
          #local yEnd = yStart + StoneSize.y;
          #local zStart = iz*StoneSize.z;
          #local zEnd = zStart + StoneSize.z;
          
          //#debug concat( "Here . . . ", str(currentOffset,7,2), " : ", str(xStart,7,2), ",", str(yStart,7,2), ",", str(zStart,7,2), " : ", str(xEnd,7,2), ",", str(yEnd,7,2), ",", str(zEnd,7,2), "\n" )
          #if (xStart != xEnd)
            Stone( <xStart+(MortorSize.x/2),yStart+(MortorSize.y/2),zStart+(MortorSize.z/2)>, <xEnd-(MortorSize.x/2),yEnd-(MortorSize.y/2),zEnd-(MortorSize.z/2)>, BrickType, StoneType, Interior, UseTextureCallback, TextureMap, TranslateTexture, StoneRandom )
            
            object{
              StoneObject
            }
          #end           
          #local ix = ix + 1;
        #end // ix
        #debug concat( "\n" )
        #local currentOffset = currentOffset - Stagger;
        #if ( currentOffset <= -StoneSize.x )
          #local currentOffset = currentOffset + StoneSize.x;
        #end
        #local iy = iy + 1;
      #end // iy
      #local iz = iz + 1;
    #end // iz
    translate ( <-(xWidth/2), -(yWidth/2), -(zWidth/2)> )
    //texture{ T_Stone1 }  
  } // Stones union
  #declare StoneWall =
    #if (Translucent = false)
      union
      {    
        object{ Stones }
        object{ MortorObject }
      } 
    #else
      union
      {    
        object{ Stones }
        difference
        {
          object{ MortorObject }
          object{ Stones }
        }
      } 
    #end

#end // MakeStoneWall macro


// some samples

#declare Interior_Stone=
  interior {
//    ior 1.5
//    fade_distance 1.0
//    fade_power 2
//    fade_color Col_Glass_Old
  }
/*  
#declare Texture_Sandstone =
    pigment {
      bozo  
      turbulence .5
      color_map {
        [0.0 color rgb <.86,.71,.55> ]
        [0.1 color rgb <.7,.57,.49> ]
        [0.2 color rgb <.91,.65,.44> ] 
        [0.3 color rgb <.79,.57,.39> ] 
        [0.4 color rgb <.84,.66,.46> ] 
        [0.5 color rgb <1,.84,.71> ] 
        [0.7 color rgb <.93,.7,.51> ] 
        [1.0 color rgb <.741,.54,.42> ]
      }   
      scale .1
      scale <3,.2,0>
    }*/
#declare Texture_Sandstone =
    pigment {
      bozo  
      turbulence .5
      color_map {
        [0.000 color rgbt <.86,.71,.55> ] 
        [0.101 color rgbt <.93,.7,.51> ] 
        [0.398 color rgbt <.91,.65,.44> ]   
        [0.559 color rgbt <.84,.66,.46> ]     
        [0.729 color rgbt <.79,.57,.39> ]       
        [1.000 color rgbt <.751,.55,.43> ]     
      }   
      scale .1
      scale <3,.2,0>
    }



#macro MakeStoneTexture(CallbackID, Rand1, Rand2, Rand3)
  #switch( CallbackID )
    #case( 1 )     
      #declare Texture_StoneSpecial=
        texture_map 
         {
          [0.000   T_Chrome_4C translate<10*Rand1,5*Rand2,8*Rand3> rotate Rand1*10 ] 
          [0.101   T_Chrome_4B translate<10*Rand1,5*Rand2,8*Rand3> rotate Rand1*10 ] 
          [0.398   T_Chrome_3A  finish{phong 0.0}]   
          [0.559   pigment{ color rgbt <0.699, 0.572, 0.521, 0.000> } finish{phong 0.0}]     
          [0.729   pigment{ color rgbt <0.689, 0.562, 0.511, 0.000> } finish{phong 0.0}]       
          [1.000   pigment{ color rgbt <0.679, 0.552, 0.501, 0.000> } finish{phong 0.0}]     
         }
       #break
    #case( 2 )     
      #declare Texture_StoneSpecial=
        texture_map 
         {
          [0.000   T_Grnt12 translate<10*Rand1,5*Rand2,8*Rand3> rotate Rand1*10 finish{phong .5}] 
          [0.101   T_Grnt12 translate<10*Rand1,5*Rand2,8*Rand3> rotate Rand1*10 finish{phong 0.25}] 
          [0.398   pigment{Gray}  finish{phong 0.0}]   
          [0.559   pigment{ color rgbt <0.699, 0.572, 0.521, 0.000> } finish{phong 0.0}]     
          [0.729   pigment{ color rgbt <0.689, 0.562, 0.511, 0.000> } finish{phong 0.0}]       
          [1.000   pigment{ color rgbt <0.679, 0.552, 0.501, 0.000> } finish{phong 0.0}]     
         }
       #break
    #case( 3 ) // sandstone     
      #declare Texture_StoneSpecial=
        texture_map 
         {
          [1.000   Texture_Sandstone translate<10*Rand1,5*Rand2,8*Rand3> ]     
         }
       #break
    #case( 4 ) // dark marble     
      #declare Texture_StoneSpecial=
        texture_map 
         {                            
          [1.000   T_Stone29 translate <1.3*Rand1,4.63*Rand1,5.2*Rand1> scale .45 ]     
         }
       #break
   #end // switch CallbackID
#end // macro MakeStoneTexture

#declare Texture_BrownMarble=
  texture_map 
   {
    [1.000   T_Stone32 scale .5]     
   }
#declare Texture_ImbedSample=
  texture_map 
   {
    [1.000   T_Stone29 finish{phong .6 reflection 0.25} ]     
   }
#declare Texture_WildBlue=
  texture_map 
   {
    [1.000   T_Stone26 scale 1.5]     
   }
#declare Texture_Sandstone2=
  texture_map 
   {
    [0.000   pigment{ color rgbt <.86,.71,.55> } finish{phong 0.0}] 
    [0.101   pigment{ color rgbt <.93,.7,.51> } finish{phong 0.0}] 
    [0.398   pigment{ color rgbt <.91,.65,.44> } finish{phong 0.0}]   
    [0.559   pigment{ color rgbt <.84,.66,.46> } finish{phong 0.0}]     
    [0.729   pigment{ color rgbt <.79,.57,.39> } finish{phong 0.0}]       
    [1.000   pigment{ color rgbt <.751,.55,.43> } finish{phong 0.0}]     
   }
#declare Texture_DamagedPlaster2=
  texture_map 
   {
    [0.000   pigment{White} finish{phong .5}] 
    [0.101   pigment{White} finish{phong 0.25}] 
    [0.398   pigment{Gray}  finish{phong 0.0}]   
    [0.559   pigment{ color rgbt <0.699, 0.572, 0.521, 0.000> } finish{phong 0.0}]     
    [0.729   pigment{ color rgbt <0.689, 0.562, 0.511, 0.000> } finish{phong 0.0}]       
    [1.000   pigment{ color rgbt <0.679, 0.552, 0.501, 0.000> } finish{phong 0.0}]     
   }
#declare Texture_ErrodedRose=
  texture_map 
   {
    [0.000   pigment{ color rgbt <0.729, 0.602, 0.551, 0.000> } finish{phong .5}] 
    [0.101   pigment{ color rgbt <0.719, 0.592, 0.541, 0.000> } finish{phong 0.25}] 
    [0.398   pigment{ color rgbt <0.709, 0.582, 0.531, 0.000> } finish{phong 0.0}]   
    [0.559   pigment{ color rgbt <0.699, 0.572, 0.521, 0.000> } finish{phong 0.0}]     
    [0.729   pigment{ color rgbt <0.689, 0.562, 0.511, 0.000> } finish{phong 0.0}]       
    [1.000   pigment{ color rgbt <0.679, 0.552, 0.501, 0.000> } finish{phong 0.0}]     
   }
#declare Texture_ErrodedRose2=
  texture_map 
   {
    [0.000   pigment{ color rgbt <0.729, 0.602, 0.551, 0.000> } finish{phong .5}] 
    [0.101   pigment{ color rgbt <0.729, 0.602, 0.551, 0.000> } finish{phong 0.25}] 
    [0.398   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong 0.1}]   
    [0.559   pigment{ color rgbt <0.780, 0.667, 0.561, 0.000> } finish{phong 0.1}]     
    [0.729   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong 0.1}]       
    [1.000   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong 0.1}]     
   }
#declare Texture_ErrodedRoseInverted=
  texture_map 
   {
    [0.000   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong .5}] 
    [0.101   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong 0.25}] 
    [0.198   pigment{ color rgbt <0.780, 0.667, 0.561, 0.000> } finish{phong 0.1}]   
    [0.259   pigment{ color rgbt <0.741, 0.659, 0.576, 0.000> } finish{phong 0.1}]     
    [0.329   pigment{ color rgbt <0.729, 0.602, 0.551, 0.000> } finish{phong 0.1}]       
    [1.000   pigment{ color rgbt <0.729, 0.602, 0.551, 0.000> } finish{phong 0.1}]     
   }
//  texture_map 
//  {
//    [0.153 finish{phong 1}]
//    [1     finish{phong 0}]
//  }


// Sandstone
//MakeStoneWall(<.5,0.25,.5>, <.010,.010,.010>, <.015,.015,.015>, <4,4,1>, Interior_Stone, 3, Texture_Sandstone2, 0, BrickType_Rounded, StoneType_Sandstone, false, .20, 2)
//MakeStoneWall(<.5,0.25,.5>, <.010,.010,.010>, <.015,.015,.015>, <4,4,1>, Interior_Stone, 0, Texture_Sandstone2, 0, BrickType_Rounded, StoneType_Sandstone, false, .20, 2)

// Damaged metal coated 
//MakeStoneWall(<.5,0.25,.5>, <.0,.0,.0>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 1, Texture_ErrodedRose, 0, BrickType_Rounded, StoneType_Pitted, false, .20, 3)

// Damaged Plaster
//MakeStoneWall(<.5,0.25,.5>, <.00,.00,.00>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_DamagedPlaster2, 0, BrickType_Rounded, StoneType_LightlyPitted, false, .20, 2)


// Very rough face rose granite, smooth cut
//MakeStoneWall(<.5,0.25,.5>, <.015,.015,.015>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_ErrodedRose, 0, BrickType_SmoothCut, StoneType_VeryRough, false, .20, 1)

// Textured face rose granite
//MakeStoneWall(<.5,0.25,.5>, <.005,.005,.005>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_ErrodedRose, 0, BrickType_Rounded, StoneType_Rough, false, .20, 1)

// Rough textured face rose granite
//MakeStoneWall(<.5,0.25,.5>, <.005,.005,.005>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_ErrodedRose, 0, BrickType_Rounded, StoneType_Rougher, false, .20, 1)

// Rough textured face rose granite with cracks
//MakeStoneWall(<.5,0.25,.5>, <.005,.005,.005>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_ErrodedRose, 0, BrickType_Rounded, StoneType_RougherCracked, false, .20, 1)

// Marble with black imbeded rivulets
//MakeStoneWall(<.5,0.25,.5>, <.005,.005,.005>, <.018,.018,.018>, <4,4,1>, Interior_Stone, 0, Texture_ImbedSample, 1,  BrickType_Rounded, StoneType_ImbedSample, false, .20, 1)

// Wild Blue, really shows of the cobination of texture and carved isosurface
//MakeStoneWall(<1,1,2>, <.005,.005,.005>, <.018,.018,.018>, <1,1,1>, Interior_Stone, 0, /*Texture_ErrodedRose*/Texture_WildBlue, 1,  BrickType_Rounded, StoneType_WildBlue, false, .20, 1)
