// Persistence of Vision Ray Tracer Scene Description File
// File: AnyTimeNow.pov
// Vers: 3.5
// Desc: AnyTimeNow
// Date: 08/26/02
// Auth: Jeff M. Thomas
//

#version 3.5;

#include "functions.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "skies.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones.inc"
#include "woods.inc"     

////////////////////////////////////////////////////////////
//
// --------------------------------------- Option Flags
//
////////////////////////////////////////////////////////////


#local FULL_RENDER = true;

#if (FULL_RENDER)

  #local CAMERA = 0;
  
  #local WORKLIGHT = false;
  #local PHOTONS = false;
  #local PHOTONS_LOAD = false;
  #local RADIOSITY = true;
  #local WINDOW_LIGHT = true;
  #local AREA_LIGHT = true;
  
  #local OUTSIDE = true;
  
  #local OTHER_ROOM_LIGHT = true;
  #local WALL_LIGHT = true;
  #local ENTRY_LAMP = true;

  #local SKY_SPHERE = true;
  
  #local ENTRY_WAY = true;
  #local GLASS_WINDOW = true;

  #local DOOR = true;
  #local TEXTURED_DOOR = true;
  
  #local SIDE_TABLE = true;
  #local UMBRELLA_STAND = true;
  #local GOLD_BOX = true;
  #local OLD_MIRROR = true;
  #local LIGHT_SWITCH = true;
  #local DESK_PICTURE = true;
  #local SPEAKER = true;

  #local ISO_STONE_FLOOR = true;
  
  #local DOG = true;
  #local BONE = true;
  #local BALL = true;

#else // working render

  #local CAMERA = 0;
  
  #local WORKLIGHT = false;
  #local PHOTONS = false;
  #local PHOTONS_LOAD = false;
  #local RADIOSITY = true;
  #local WINDOW_LIGHT = false;
  #local AREA_LIGHT = true;
  
  #local OUTSIDE = true;
  
  #local OTHER_ROOM_LIGHT = true;
  #local WALL_LIGHT = true;
  #local ENTRY_LAMP = true;
  
  #local SKY_SPHERE = true;
  
  #local ENTRY_WAY = true;
  #local GLASS_WINDOW = false;
  
  #local DOOR = true;
  #local TEXTURED_DOOR = true;
  
  #local SIDE_TABLE = true;
  #local UMBRELLA_STAND = true;
  #local GOLD_BOX = false;
  #local OLD_MIRROR = true;
  #local LIGHT_SWITCH = true;
  #local DESK_PICTURE = true;
  #local SPEAKER = true;


  #local ISO_STONE_FLOOR = false;
  
  #local DOG = true;
  #local BONE = true;
  #local BALL = true;

#end // FULL_RENDER

////////////////////////////////////////////////////////////
//
// --------------------------------------- Declares
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
//
// --------------------------------------- Textures
//
////////////////////////////////////////////////////////////

// this texture taken from wallstucco.pov by Ingo Janssen
// then played with
#declare Stucco=
texture
{ 
  pigment 
  {    //Stucco
    granite
    scale 0.55
    colour_map {
      //[0, rgb 0.96]
      [0, rgb 0.96]
      [1, rgb 1]
    }
  }
  //normal
  //{
  //  granite .05
  //  scale 0.55
  //}
  normal
  {
    granite
    normal_map {
      [ 0.0 granite .075]
      [ 0.39 granite .075]
      [ 0.4 ripples .001 scale .01]
    }
    scale 0.45
  }
  finish { specular 0.15 roughness 0.05 ambient 0.3 }
      //finish { specular 0.15 roughness 0.05 ambient 0.3 }
}

#declare NewFloor =
texture {
    pigment {
        gradient x
        turbulence 0.75
        frequency 6
        scale 0.5
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgb <0.10, 0.25, 0.35> ]
            [0.06 color rgb <0.10, 0.25, 0.10> ]
            [0.10 color rgb <0.00, 0.20, 0.25> ]
            [1.00 color rgb <0.10, 0.25, 0.35> ]
        }
    }
}
#declare TNewFloor =
texture_map 
 {
  [1.000   NewFloor finish{phong .6 reflection 0.25} ]     
 }

#local T_01 = texture { pigment { color Clear } finish { F_Glass1 } }
#local T_02 = texture { pigment { color Clear } finish { F_Glass2 } }
#local Material_Pane =
material{ texture { T_01 } interior { I_Glass fade_color Col_Blue_01 } }

#local Material_GlassFlame =
material{ texture { T_02 } interior { I_Glass fade_color Col_Yellow_01 } }

#local TLampMetal=
texture
{
  pigment{ DimGray }
  finish { F_MetalA }
  normal{ granite .05 scale .1 }
}

#local TDog=
texture
{      
  pigment
  {
    agate
    color_map
    {
      [ .0 VeryDarkBrown ]
      [ 1 DarkBrown ]
    }
  }
}

#declare T_myWood = 
    texture {  pigment{ P_WoodGrain14A color_map { M_Wood19A }}} 
    texture {  pigment{ P_WoodGrain14B color_map { M_Wood19B }}}

#local TDoor=
texture
{
  pigment{ DarkGreen }
  finish { specular 0.35 roughness 0.05 ambient 0.3 }
  normal
  {
    bumps .10
    scale .9
  }
}
/*
texture
{ 
  T_myWood
  finish { specular 0.35 roughness 0.05 ambient 0.3 }
  translate x*1
  rotate <45, 70, 90>
  translate y*2
  scale .25

  normal
  {
    bumps .10
    scale .9
  }

  translate<0,3.5,10>

}
*/

#local TStand=
  texture  {
      pigment {
        marble
        turbulence 1.5
        omega 0.6235
        lambda 2.25
        colour_map  {
            [0.15 colour rgbt <0.03922, 0.40784, 0.42941, 0.0>]
            [0.45 colour rgbt <0.03922, 0.40784, 0.42941, 0.0>]
            [0.55 colour rgbt <0.22745, 0.43922, 0.32353, 0.0>]
            [0.75 colour rgbt <0.20784, 0.50980, 0.44118, 0.0>]
            [1.00 colour rgbt <0.20784, 0.50980, 0.44118, 0.0>]
        }
        rotate <0, 0, 85>
        scale <0.75, 1.33, 0.35>
        rotate <10, 5, 45>
      }
      finish { brilliance 1.825 specular 0.30 roughness 1/20 reflection 0.05 }
      normal
      {
        marble .05
        turbulence 1.5
        omega 0.6235
        lambda 2.25
        rotate <0, 0, 85>
        scale <0.75, 1.33, 0.35>
        rotate <10, 5, 45>
      }
  }

#local myMetallic_Finish =
    finish {
        metallic
        ambient 0.1
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection 0.45
        brilliance 1.5
    }
#local TGoldLeaf = 
texture 
{
  granite
  texture_map
  {
    [0  pigment{ Brown }]
    [.1 pigment{ Brown }]
    [.2  pigment{ rgb <0.85, 0.65, 0.10> } finish { Metallic_Finish }]
    [1  pigment{ rgb <0.85, 0.65, 0.10> } finish { Metallic_Finish }]
  }
    
}

#local TMirror_Frame=
  texture
  {
    crackle
    texture_map
    {
      [0   pigment{ Brown } ]
      [.05 TGoldLeaf scale .05 ]
      //[1   TGoldLeaf scale .05 ]
    }
    scale .05
  }

#local TOldMirror=
  texture
  {
    granite
    texture_map
    {
      [0  T_Chrome_5D]
      [.2 T_Chrome_5C]
      [.35 T_Chrome_5E]
      //[.4 T_Chrome_5E]
    }
    scale 1.25
  }

#declare CaneWood2A = 
color_map { 
    [0.0, 0.1 color rgb <0.45, 0.16, 0.12 >* 0.5
              color rgb <0.45, 0.16, 0.12>* 0.5]
    [0.1, 0.9 color rgb <0.45, 0.20, 0.16>* 0.5
              color rgb <0.56, 0.26, 0.18>* 0.5]
    [0.9, 1.0 color rgb <0.56, 0.26, 0.18>* 0.5
              color rgb <0.45, 0.16, 0.12>* 0.5]
}
#declare CaneWood2B = 
color_map { 
    [0.0, 0.1 color rgbt <0.65, 0.30, 0.20, 0.100> 
              color rgbt <0.65, 0.30, 0.20, 0.500>]
    [0.1, 0.9 color rgbt <0.65, 0.30, 0.20, 0.650>
              color rgbt <0.65, 0.25, 0.15, 0.975>]
    [0.9, 1.0 color rgbt <0.65, 0.25, 0.15, 0.975>
              color rgbt <0.65, 0.30, 0.20, 0.000>]
}
#declare CaneWood   =
    texture { pigment { P_WoodGrain2A  color_map { CaneWood2A }}}
    texture { pigment { P_WoodGrain2B  color_map { CaneWood2B }}}

////////////////////////////////////////////////////////////
//
// --------------------------------------- Global Settings
//
////////////////////////////////////////////////////////////

global_settings {
  max_trace_level 10
  assumed_gamma 1.0
  ambient_light .1
  #if (PHOTONS | PHOTONS_LOAD)
    photons
    {
      #if(PHOTONS_LOAD)
        load_file "AnyTimeNow.ph"
        #undef PHOTONS
        #declare PHOTONS = false; 
      #else
        // use non-adaptive search radius
        max_trace_level 20
    	  spacing 0.005
    	  //radius 0.005
    	  //radius 0.005
        //gather 20, 100
        //autostop 0
        //media 100
        jitter 0.9
        save_file "AnyTimeNow.ph"
      #end
    } 
  #end // PHOTONS
  #if (RADIOSITY)
    radiosity 
    {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness .75                  // brightness of radiosity effects (0..1) [1]
  
      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end // RADIOSITY
}

////////////////////////////////////////////////////////////
//
// --------------------------------------- Cameras
//
////////////////////////////////////////////////////////////

#if (CAMERA = 0)// main camera
  camera 
  {
    location  <0.0, .5, 0.250>
    //location  <40.0, 25.5, 25.50>
    //direction 1.5*z
    //right     x*image_width/image_height
    look_at   <0.0,7,20>
  }
#end // CAMERA = 0

#if (CAMERA = 1)// kickboard
  camera 
  {
    location  <4.5, .6, -1.0>
    //direction 1.5*z
    //right     x*image_width/image_height
    look_at   <5.0,0,10>
  }
#end // CAMERA = 0

#if (CAMERA = 2)// far shot
  camera 
  {
    location  <0.0, .5, -10.0>
    //direction 1.5*z
    //right     x*image_width/image_height
    look_at   <0.0,4,10>
  }
#end // CAMERA = 0

#if (CAMERA = 3)// door
  camera 
  {
    location  <2, 4, 8.0>
    //direction 1.5*z
    //right     x*image_width/image_height
    look_at   <2,4,10>
  }
#end // CAMERA = 0


#if (CAMERA = 5)// side table
  camera 
  {
    location  <3, 2.6, 5.0>
    //direction 1.5*z
    //right     x*image_width/image_height
    look_at   <3.4,2.5,7>
  }
#end // CAMERA = 0

////////////////////////////////////////////////////////////
//
// --------------------------------------- Global Lighting
//
////////////////////////////////////////////////////////////
/*
light_source 
{
  <0, 0, 0>
  color rgb <1.0, 1.0, 0.8>*.15 //1
  translate <150000,200000,-100000>

  area_light <0, 0, 0>, <10000,10000,-10000>, 50, 50
  adaptive 1
  jitter
  #if (PHOTONS)
    photons 
    {
      reflection off
      refraction off
    }
  #end
}
*/

// the light rays
#if (WINDOW_LIGHT)
  light_source 
  {
    <0, 0, 0>
    color rgb <0.5, 0.35, 0.1>*2  // light's color
    translate <0.0, 26.5, 64.0>
    parallel
    spotlight
    #if (AREA_LIGHT)
      area_light <1, 0, 0>, <0,1,0>, 10, 10
      adaptive 1                    
      orient
    #else
      cylinder
    #end
    point_at <0, 0, 18>
    falloff 40
    radius 9
    #if (PHOTONS)
      photons 
      {
        reflection on
        refraction on
        #if (AREA_LIGHT)
          //area_light This breaks it for some reason
        #end
      }
    #end
  }
#end // WINDOW_LIGHT

#if (WALL_LIGHT & !ENTRY_LAMP)
  light_source {
    <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)             
    color rgb <.225, .225, .125>  // light's color
  #else
    color rgb <.45, .45, .35>  // light's color
  #end // RADIOSITY
    translate <3.5, 6, 7>
  #if (PHOTONS)
    photons {
      reflection off
      refraction off
    }
  #end
  } 
#end // WALL_LIGHT

#if (OTHER_ROOM_LIGHT)
  light_source {
    <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)             
    color rgb <.125, .125, .125>  // light's color
  #else
    color rgb <.25, .25, .25>  // light's color
  #end // RADIOSITY
    translate <-10, 7.5, 5>
  #if (PHOTONS)
    photons {
      reflection off
      refraction off
    }
  #end
  } 
#end // OTHER_ROOM_LIGHT
#if (WORKLIGHT)
  light_source {
    <0, 0, 0>            // light's position (translated below)
    color rgb <.1, .1, .1>  // light's color
    translate <-05, 10, -20>
  #if (PHOTONS)
    photons {
      reflection off
      refraction off
    }
  #end
  } 
#end // WORKLIGHT

////////////////////////////////////////////////////////////
//
// --------------------------------------- Macros
//
////////////////////////////////////////////////////////////

#macro mDoor( SIZE )
  #local xGutter = .035; // precentile
  #local yGutter = .0125; // precentile
  #local xCount = 2;
  #local yCount = 2;
  #local gutterXSize = SIZE.x*xGutter;
  #local gutterYSize = SIZE.y*yGutter;
  #local boxXSize = (SIZE.x/xCount)-gutterXSize;
  #local boxYSize = (SIZE.y/yCount)-gutterYSize;
  #declare Door=
  union
  {
    union
    {
      difference
      {
        box 
        {
          <-(SIZE.x/2), -(SIZE.y/2), -(SIZE.z/2)>
          < SIZE.x/2,  SIZE.y/2,  SIZE.z/2>
        }
        #local xBox = 0;
        #while( xBox < xCount )
          #local yBox = 0;
          #while( yBox < yCount )
            #local mySide = 1; // I dropped the 2 sidedness
            #while ( mySide < 2 )
              difference
              {
                box
                { 
                  //#debug concat( " xBox = ",str(xBox,7,2), " yBox = ",str(yBox,7,2), "\n" )
                  <-boxXSize/2,-boxYSize/2,-(SIZE.z*.25)>
                  < boxXSize/2, boxYSize/2, (SIZE.z*.25)>
                  //< -(SIZE.x/2)+((SIZE.x/2)*xBox)+(SIZE.x*xGutter)/2, -(SIZE.y/2)+((SIZE.y/2)*xBox)+(SIZE.y*yGutter)/2, (-(SIZE.z/2)*mySide)-(SIZE.z*.25) >
                  //< -(SIZE.x/2)+((SIZE.x/2)*xBox)+(SIZE.x*xGutter)/2+(, -(SIZE.y/2)+((SIZE.y/2)*xBox)+(SIZE.y*yGutter)/2, (-(SIZE.z/2)*mySide)+(SIZE.z*.25) >
                }
                box
                {
                  <-boxXSize/2,-boxYSize/2,-(SIZE.z*.25)>
                  < boxXSize/2, boxYSize/2, (SIZE.z*.25)>
                  rotate -25*y
                  translate<-boxXSize/2,0,-(SIZE.z*.25)>
                }
                box
                {
                  <-boxXSize/2,-boxYSize/2,-(SIZE.z*.25)>
                  < boxXSize/2, boxYSize/2, (SIZE.z*.25)>
                  rotate -25*y
                  translate<-boxXSize/2,0,-(SIZE.z*.25)>
                  rotate 180*z
                }
                box
                {
                  <-boxXSize/2,-boxYSize/2,-(SIZE.z*.25)>
                  < boxXSize/2, boxYSize/2, (SIZE.z*.25)>
                  rotate 25*x
                  translate<0,-boxYSize/2,-(SIZE.z*.25)>
                }
                box
                {
                  <-boxXSize/2,-boxYSize/2,-(SIZE.z*.25)>
                  < boxXSize/2, boxYSize/2, (SIZE.z*.25)>
                  rotate 25*x
                  translate<0,-boxYSize/2,-(SIZE.z*.25)>
                  rotate 180*z
                }
                #if ( mySide = 0 )
                  #local zSide = 1;
                #else
                  #local zSide = -1;
                #end            
                translate<-(SIZE.x/2)+(gutterXSize/2)+(boxXSize/2)+((SIZE.x/xCount)*xBox),-(SIZE.y/2)+(gutterYSize/2)+(boxYSize/2)+((SIZE.y/yCount)*yBox),zSide*(SIZE.z/2)>
                #if ( mySide = 0 )
                  rotate 180*y
                #end            
              } // difference
              #local mySide = mySide + 1;
            #end  // while mySide
            #local yBox = yBox + 1;
          #end // while yBox       
          #local xBox = xBox + 1;
        #end // while xBox
      } // difference
      #local xBox = 0;
      #while( xBox < xCount )
        #local yBox = 0;
        #while( yBox < yCount )
          #local mySide = 1;  // I dropped the 2 sidedness
          #while ( mySide < 2 )
            union
            {
              box
              {
                <(-boxXSize/2)*.60,(-boxYSize/2)*.80,(-(SIZE.z*.25))*.90>
                < (boxXSize/2)*.60, (boxYSize/2)*.80, ((SIZE.z*.25))*.90>
              }
              #if ( mySide = 0 )
                #local zSide = 1;
              #else
                #local zSide = -1;
              #end            
              translate<-(SIZE.x/2)+(gutterXSize/2)+(boxXSize/2)+((SIZE.x/xCount)*xBox),-(SIZE.y/2)+(gutterYSize/2)+(boxYSize/2)+((SIZE.y/yCount)*yBox),(zSide*(SIZE.z/2))*.25>
            } // difference
            #local mySide = mySide + 1;
          #end  // while mySide
          #local yBox = yBox + 1;
        #end // while yBox       
        #local xBox = xBox + 1;
      #end // while xBox
#if (TEXTURED_DOOR)
      texture
      { 
        TDoor
      }
#else
      pigment{ White }
#end // TEXTURED_DOOR
    } // wood door union
    // knob
    union  // door knob
    {
      intersection
      {
        cone 
        {
          .05*z,  0.05,
          -.05*z, .1
          // open
        }
        sphere
        {
          <0, 0, 0> // center of sphere <X Y Z>
          0.1
          translate<0,0,.02>
        }
      }
      torus 
      {
        0.058,
        0.026
        rotate 90*x
        scale <1,1,.55>
        translate<0,0,-.04>
      }
      cylinder {
        0*z,  -.055*z,  .025
        // open
      }
      torus 
      {
        0.02,
        0.0099
        rotate 90*x
        scale <1,1,.85>
        translate<0,0,-.049>
      }

      texture
      { 
        //pigment{ P_Copper1}
        //finish{ F_MetalA }
        T_Brass_4A
        
        normal
        {
          bumps .05
          scale .025
        }
      }
      scale 1.2
      translate<(SIZE.x/2)*.91,(SIZE.y*.01),-((SIZE.z/2)+.05)> 
    }
              
    union  // bolt lock
    {
      intersection
      {
        cone 
        {
          .05*z,  0.05,
          -.05*z, .1
          // open
        }
        sphere
        {
          <0, 0, 0> // center of sphere <X Y Z>
          0.1
          translate<0,0,.02>
        }
      }
      cylinder
      {
        -.015*x,  .015*x,  .065
        scale<0,.25,0>
        rotate<90,0,45>
        translate<0,0,-.05>
      }
      texture
      { 
        //pigment{ P_Copper1}
        //finish{ F_MetalA }
        T_Brass_4A
        
        normal
        {
          bumps .05
          scale .025
        }
      }
      scale 1.1
      translate<(SIZE.x/2)*.92,(SIZE.y*.08),-((SIZE.z/2)-.025)> 
    }
    // hinge
    union
    {
      cylinder
      {
        .1*y, 0, .05
        translate<0,.303,0>
      }
      cylinder
      {
        .1*y, 0, .05
        translate<0,.2015,0>
      }
      cylinder
      {
        .1*y, 0, .05
        translate<0,.1,0>
      }
      scale 1.5*y
      //sphere{0,.2}
      texture
      { 
        //pigment{ P_Copper1}
        //finish{ F_MetalA }
        T_Brass_4A
        
        normal
        {
          bumps .05
          scale .025
        }
      }
      translate<-(SIZE.x/2)*.975,(SIZE.y*.28),-((SIZE.z/2)+.150)>
    } 
    // hinge
    union
    {
      cylinder
      {
        .1*y, 0, .05
        translate<0,.303,0>
      }
      cylinder
      {
        .1*y, 0, .05
        translate<0,.2015,0>
      }
      cylinder
      {
        .1*y, 0, .05
        translate<0,.1,0>
      }
      scale 1.5*y
      //sphere{0,.2}
      texture
      { 
        //pigment{ P_Copper1}
        //finish{ F_MetalA }
        T_Brass_4A
        
        normal
        {
          bumps .05
          scale .025
        }
      }
      translate<-(SIZE.x/2)*.975,-(SIZE.y*.34),-((SIZE.z/2)+.150)>
    } 
  } // main union
#end // macro Door

#macro mKickboard( SIZE )
  #local kbHeight = .095;
  #local kbDepth = .04;
  #declare Kickboard=
  union
  {
    box
    {
      <-kbDepth,-kbHeight,-SIZE.z/2>
      < kbDepth, kbHeight, SIZE.z/2>
    }
    cylinder
    {
      <0,kbHeight,-SIZE.z/2>,<0,kbHeight, SIZE.z/2>,kbDepth 
    }
    texture 
    {
      pigment { White }
    }
  }
#end // macro Kboard
#macro mWall( SIZE, KICKBOARD )
  // wall
  #declare Wall=
  union
  {
    box 
    { 
      <-SIZE.x/2,-SIZE.y/2,-SIZE.z/2>
      <SIZE.x/2,SIZE.y/2,SIZE.z/2>
      texture 
      {
        Stucco
      }
    }

    #if (KICKBOARD)
      mKickboard( SIZE )
      object
      {
        Kickboard
        translate<-SIZE.x/2,(-SIZE.y/2)+.1,0>
      }
      mKickboard( SIZE )
      object
      {
        Kickboard
        translate<SIZE.x/2,(-SIZE.y/2)+.1,0>
      }
      mKickboard( <SIZE.z,SIZE.y,SIZE.x> )
      object
      {
        Kickboard
        rotate 90*y
        translate<0,(-SIZE.y/2)+.1,SIZE.z/2>
      }
      mKickboard( <SIZE.z,SIZE.y,SIZE.x> )
      object
      {
        Kickboard
        rotate 90*y
        translate<0,(-SIZE.y/2)+.1,-SIZE.z/2>
      }
    #end // KICKBOARD

  } // Wall
#end // macro Wall

////////////////////////////////////////////////////////////
//
// --------------------------------------- Scene
//
//////////////////////////////////////////////////////////// 

#if (SKY_SPHERE)
sky_sphere
{
  //pigment {planar colour_map{[0,rgb <0.9,0.9,1>][1, rgb <0.1,0.2,1>]}}
  pigment { gradient y color_map{[.3 rgb<.55,.1,.25>][0.7 color MidnightBlue]} }
  pigment{ P_Cloud1 }
}
/*sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}*/
#end // SKY_SPHERE
/*
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}
*/

// front door
/*
box {
  <-2, -4, -.1>  // one corner position <X1 Y1 Z1>
  < 2,  4,  .1>  // other corner position <X2 Y2 Z2>
  texture {
    pigment { White }
    finish{
      specular 0.6
    }
  }
  translate<0,4,10>
}           
*/
mDoor( <4,7,.2> )
object
{
  Door
  translate<0,3.5,10>
}

#if (ENTRY_WAY)
// entry way
union
{
  // back wall
  mWall( <10,9,.5>, true )
  difference
  {
    object
    {
      Wall
    }
    // door hole
    box 
    {
      <-2, -3.5, -.5>  // one corner position <X1 Y1 Z1>
      < 2,  3.5,  .5>  // other corner position <X2 Y2 Z2>
      texture 
      {
        Stucco
      }
      translate<0,-1,0>
    }
    #if (GLASS_WINDOW)
      // Window hole    
      box
      {
        <-.4350,-2.505,-.5>
        < .4350, 2.475, .5>
        translate<-3,-.78,0>
        texture{ pigment{ White } }
      }
    #end // GLASS_WINDOW
    translate<0,4.5,10>
  }
  // Kitchen back wall
  mWall( <10,9,.5>, true )
  difference
  {
    object
    {
      Wall
    }
    translate<-10,4.5,10>
  }
  // front wall (behind camera
  mWall( <20,9,.5>, true )
  difference
  {
    object
    {
      Wall
    }
    translate<-5,4.5,-2>
  }
  
  // left wall
  mWall( <.5,9,14>, true )
  difference
  {
    object
    {
      Wall
    }
    // kitchen entry
    box 
    {
      <-.5, -3.5, -3>  // one corner position <X1 Y1 Z1>
      < .5,  3.5,  3>  // other corner position <X2 Y2 Z2>
      texture {
        pigment{ White }
      }
      translate<0,-1,0>
    }           
    translate<-4,4.5,5>
  }
  // far left wall
  mWall( <.5,9,14>, true )
  difference
  {
    object
    {
      Wall
    }
    translate<-15,4.5,5>
  }

  // right wall
  mWall( <.5,9,14>, true )
  object
  {
    Wall
    translate<4,4.5,5>
  }
  // ceiling
  box {
    <-20, -.1, -2>  // one corner position <X1 Y1 Z1>
    < 5,  .1, 10>  // other corner position <X2 Y2 Z2>
    texture {
      Stucco
    }
    translate<0,8,0>
  }
  // other room floor
  box {
    <-6.4, -.1, -2>  // one corner position <X1 Y1 Z1>
    < 5,  .1, 10>  // other corner position <X2 Y2 Z2>
    texture {
      pigment { White }
    }
    translate<-8.7,0,0>
  }

  #if( ISO_STONE_FLOOR )
    #include "StoneWallAdvanced.inc"
    MakeStoneWall(<.75,0.75,.75>, <.01,.01,.01>, <.0075,.0075,.0075>, <10,10,1>, Interior_Stone, 0, TNewFloor, 1,  BrickType_Rounded, StoneType_ImbedSample, false, .00, 1)
    object
    { 
      StoneWall
      //scale 2.5
      rotate 90*x 
      translate<0,-.269,5.805> 
    }    
    box {
      <-5, -.1, 0>  // one corner position <X1 Y1 Z1>
      < 5,  .1, 10>  // other corner position <X2 Y2 Z2>
      texture {
        pigment { White }
      }
      translate<-8.7,0,0>
    }
  #else
    // floor
    box {
      <-5, -.1, -2>  // one corner position <X1 Y1 Z1>
      < 5,  .1, 10>  // other corner position <X2 Y2 Z2>
      texture {
        pigment { White }
      }
      translate<0,0,0>
    }
  #end // ISO_STONE_FLOOR
}

#end // ENTRY_WAY

#if (UMBRELLA_STAND)
  #macro mUmbrellaStand()
    #declare UmbrellaStand=
    union
    {
      difference
      {
        cylinder{2.25*y, 0, .7}
        cylinder{2.26*y, <0,-.01,0>, .69}
        //texture{ New_Penny normal{bumps .2 scale .1}}
        //texture{ TStand finish{ phong .9 } normal{granite .2 turbulence 0.0} scale 2 }
        texture{ TStand }
      }
      difference
      {
        cylinder{2.25*y, 2.20*y, .725}
        cylinder{2.251*y, 2.15*y, .7}
        texture{ T_Brass_1A }
      }
      difference
      {
        cylinder{0.05*y, 0, .725}
        cylinder{0.051*y, -0.005*y, .7}
        texture{ T_Brass_1A }
      }
      // cane
      union
      {
        cylinder{0,<0,2,0> .035}
        union
        {
          difference
          {
            torus{.125, .035 rotate 90*x}
            plane{ y, 0 }
          }
          sphere{0, .035 translate <-.125,0,0>}
          translate<-.12475, 2, 0>
        }
        texture{ CaneWood rotate 90*x scale .25 }
        rotate -80*y
        rotate < -15,0, 10 >
        translate<0, .2, 0>
        scale 1.25
      }
    }
  #end // UmbrellaStand
  
  mUmbrellaStand()
  object{ UmbrellaStand scale .95 translate<-3.110,.10,9> }
#end // UMBRELLA_STAND

#if (OUTSIDE)
  union
  {
    box // house
    {
      -5, 5
      translate <-7,5,50>
    }
    box
    {
      <-5,-5,-.1><5,5,.1>
      rotate<0,90,-45>
      translate <-10,14,50>
    }
    union // aerial
    {
      cylinder{0,5*y,.1}
      union
      {
        cylinder{-1*x,1*x,.05}
        cylinder{-.8*x,.8*x,.05 translate .5*z}
        cylinder{-.8*x,.8*x,.05 translate 1*z}
        cylinder{-.8*x,.8*x,.05 translate -.5*z}
        cylinder{-.6*x,.6*x,.05 translate -1*z}
        cylinder{-1.25*z,1.25*z,.05}
        rotate 35*y
        translate<0,5,0>
      }
      translate<-9.75,10,40>
    }
    translate<-2,4,0>
  }
#end // OUTSIDE

#if (BALL)
sphere {
  0.0, .1
  texture {
    pigment {
      radial
      frequency 8
      color_map {
        [0.00 color rgb <1.0,0.4,0.2> ]
        [0.33 color rgb <0.2,0.4,1.0> ]
        [0.66 color rgb <0.4,1.0,0.2> ]
        [1.00 color rgb <1.0,0.4,0.2> ]
      }
    }
    finish{
      specular 0.6
    }
  }
  rotate <-84,120,220>
  translate<-1,.19,7>
}
#end // BALL

#if (ENTRY_LAMP)
  #include "EntryLamp.inc"
  mEntryLamp( Material_Pane, Material_GlassFlame, TLampMetal, WALL_LIGHT, RADIOSITY, PHOTONS )
  object
  {
    EntryLamp
    scale<1.5,1.5,1.25>
    translate<3.1,5.5,7>
  }
#end // ENTRY_LAMP

#if (DOG)
  #include "Dog.inc"
  mDog( TDog )      
  object{ Dog scale .75 translate<1.75,.125,8> }
#end // DOG

#if (SIDE_TABLE)
  #include "SideTable.inc"
  mSideTable()      
  object{ SideTable scale .95 translate<3.70,0,7> }
#end // SIDE_TABLE

#if (BONE)
  #include "Bone.inc"
  mBone()      
  object{ Bone scale .55 rotate 66*y translate<.5,.125,5.5> }
#end // BONE

#if (GOLD_BOX)
  #include "GoldBox.inc"
  mGoldBox()      
  object{ GoldBox scale .35 rotate 36*y translate<3.4,1.25,7> }
#end // GOLD_BOX

#if (GLASS_WINDOW)                    
  #include "GlassCubeSpecial.inc"
  difference
  {
    object{ StoneWall }
    box{ <.4,-6,-1><4,6,1> }
    box{ <-.4,-6,-1><-4,6,1> }
    scale 1.65 
    translate<-3,3.7,9.90>
    //translate <0,3,5>
  }
#end // GLASS_WINDOW
 
#if (OLD_MIRROR)
  #include "Mirror.inc"
  mOldMirror( TMirror_Frame, TOldMirror )      
  object{ OldMirror scale<0,1.35,.85> translate<3.7,3.75,7> }
#end // OLD_MIRROR

#if (LIGHT_SWITCH)
  #include "LightSwitch.inc"
  mLightSwitch()      
  object{ LightSwitch translate<2.75,4,9.75> }
#end // LIGHT_SWITCH

#if (DESK_PICTURE)
  #include "DeskPicture.inc"
  mDeskPicture()      
  object{ DeskPicture scale .75 rotate<20,45,0> translate<3.2,2.595,7> }
#end // DESK_PICTURE

#if (SPEAKER)
  #include "Speaker.inc"
  mSpeaker()      
  object{ Speaker scale .95 rotate 45*y translate<-5.2,.095,9.5> }
#end // DESK_PICTURE



