
// POV-Ray Object File - Apples
// created 15-Aug-02
// last update 30-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Apples.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// SphereApple
// GoodApple
// GoodAppleStemless
// GoodAppleWithLeaf
// BestApple
// BestAppleStemless
// BestAppleWithLeaf
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Applee origin is at the base of the apple
// Stem extends into +Y

#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc"
#end

//===============================================
//             Objects
//===============================================

#declare SphereApple =
	sphere {
		<0,0,0>,1.6
		texture {
			pigment {
				image_map { "Apple3UVskin.png" map_type 1 }
			}
			finish { specular 0.7 roughness 0.009 }
		}
		rotate x*90
		translate <0,0,1.6>
		
	}

#include "Apple2UV.inc"
#declare GoodApple =
	union {
		object { poser_object scale 0.65 rotate x*90 }
		sphere_sweep {
			b_spline
			5,
			<0.00,0,-0.1>,0.05,
			<0.00,0,0.0>,0.05,
			<0.04,0,0.3>,0.05,
			<0.22,0,0.6>,0.07
			<0.28,0,0.7>,0.07
			texture { pigment { color rgb <0.416,0.290,0.173> } }
			scale 1
			rotate y*12
			translate <0,0,2.4>
		}
		translate <0,0,0.0> // set apple on it's base
	} // end union
#declare GoodAppleStemless =
		object { poser_object scale 0.65 rotate x*90 translate <0,0,0> }

#include "Apple3UV.inc"
#declare BestApple =
	union {
		object { Apple3_object scale 0.65 rotate x*90 }
		sphere_sweep {
			b_spline
			5,
			<0.00,0,-0.1>,0.05,
			<0.00,0,0.0>,0.05,
			<0.04,0,0.7>,0.05,
			<0.22,0,1.0>,0.07
			<0.28,0,1.1>,0.07
			texture { pigment { color rgb <0.416,0.290,0.173> } }
			scale 1
			rotate y*12
			translate <0,0,2.4>
		}
		translate <0,0,0.0> // set apple on it's base
	} // end union
#declare BestAppleStemless =
		object { Apple3_object scale 0.65 rotate x*90 translate <0,0,0> }

#declare AppleLeaf =
	difference {
//		union {
		height_field {
			png "AppleLeafHF.png"
			smooth
//			water_level .10
			scale <2.5,0.5,3.20>
		}

		height_field {
			png "AppleLeafHF.png"
			smooth
//			water_level .02
			scale <2.62,0.50,3.33>
			translate <-0.04,-0.04,-0.06>
		}

			box {
			<0,-1,0>,<2.78,0.00,3.4>
			translate <-0.12,0.01,-0.14>
		}

			texture { pigment { rgb<.125,.41,.185>}finish { specular 0.3 roughness 0.13 }}
/*
			texture {
				pigment {
					image_map { png "AppleLeafColorMap.png" }
					scale <2.5,-0.5,2.5>
				}
				finish { specular 0.4 roughness 0.03 }
			}
*/
		translate <-0.4,0,-0.2> // center stem on origin
	} // end difference

#declare GoodAppleWithLeaf =
	union {
		object { GoodApple }
		object { AppleLeaf scale 0.75 rotate <-60,0,-60> translate <-0.06,0.4,2.77> }
	} // end union
#declare BestAppleWithLeaf =
	union {
		object { BestApple }
		object { AppleLeaf scale 0.75 rotate <-60,0,-60> translate <-0.06,0.4,2.93> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 20
		location  <1, -18, 6>
		look_at <0,0,2>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }

object { SphereApple rotate z*120 translate <0,0,0> }
/*
object { GoodAppleWithLeaf rotate z*0 translate <0,0,0> }
object { GoodAppleWithLeaf rotate <90,0,0> translate <-3,4,3> }
object { GoodAppleWithLeaf rotate <-90,0,0> translate <3,4,3> }

object { AppleLeaf rotate x*-50 translate <1,0,0> }
object { AppleLeaf rotate x*-50 rotate z*-45 translate <-1,2,0> }
object { AppleLeaf rotate x*-50 rotate z*-90 translate <-2,0,0> }
object { AppleLeaf rotate x*-50 rotate z*-180 translate <-3,6,1> }
object { AppleLeaf rotate x*-5 rotate z*-180 translate <0,6,1> }
*/
#end
