
// POV-Ray Object File - An Apple Peeler
// created 17-Aug-02
// last update 30-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Peeler.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// PeelerS // simple version
// Peeler // complex version
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Peeler origin is at the center of the the base
// Height extends into +Z

#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PTex =
	texture {
		pigment {
			color rgb<.6,.6,.6>
		}
		normal { bumps 0.12 scale .12 }
		finish { specular 0.35 roughness 0.113 metallic }
	}

#declare BriteTex =
	texture {
		pigment {
			color rgb<.336,.357,.412>
		}
		finish { specular 0.95 roughness 0.028 metallic reflection 0.24 }
	}

#declare PHandleTex =
	texture {
		pigment {
			radial
			color_map {
				[ 0.0 rgb <0.616,0.024,0.000>*1.3 ]
				[ 1.0 rgb <0.616,0.024,0.000>*.1 ]
			}
			frequency 18
			rotate z*90
			turbulence 0.1
		}
		normal { bumps 0.15 scale <1.3,.16,.16> }
		finish { specular 0.63 roughness 0.037 }
	}

#declare PadTex =
	texture {
		pigment {
			color rgb <0.706,0.286,0.153>
		}
		normal { bumps 0.02 scale .05 }
		finish { specular 0.23 roughness 0.033 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare PeelerS =
	union {
		box { // base
			<0,-0.5,0>,<8,0.5,1>
		}
		box { // upright
			<-1,-0.5,-3>,<0,0.5,5>
		}
		box { // blade arm
			<0,-0.5,0>,<1,0.5,3>
			translate <6,0.5,0.5>
			rotate x*-10
		}
		cylinder {
			<-1.6,0,0>,<0,0,0>,0.4
			translate <0,0,5>
		}
		cylinder { // shaft
			<-1.9,0,0>,<6,0,0>,0.17
			translate <0,0,5>
		}
		texture { PTex }
	} // end union

#declare PeelerFrameHalf =
	height_field { // extruded into +Y
		png "PeelerHF.png"
		water_level 0.02
		scale <-16,1,16>
		translate <10,0,-6.7>
		texture { PTex }
	}

#declare PHandle =
	difference {
		sphere_sweep {
			b_spline
			5,
			<0.2,0,0>,0.5
			<0,0,0>,0.5,
			<-0.3,0,0>,0.18,
			<-3.0,0,0>,0.5,
			<-3.3,0,0>,0.5
		}
		cylinder {
			<0,0,0>,<2,0,0>,1
		}
		texture { PHandleTex }
	} // end difference

#declare MainShaft =
	union {
		cylinder {
			<-3.6,0,0>,<0,0,0>,0.25
		}
		cylinder {
			<0,0,0>,<6,0,0>,0.17
		}
		#declare TP = 0;
		#while ( TP < 5.8 )
			cylinder {
				<0,0,0>,<0.1,0,0>,0.25
				rotate y*8
				translate <TP,0,0>
			}
			#declare TP = TP + 0.21;
		#end
		cylinder { <0,0,0>,<.06,0,0>,.45 translate <6,0,0> }
		cylinder { <0.05,0,0>,<0.20,0,0>,.35 translate <6,0,0> }
		cylinder { <0,0,0>,<.06,0,0>,.45 translate <6.2,0,0> }
		prism {
			linear_spline conic_sweep -2,0,5,
			<0,-0.07>,<0.05,0.0>,<-0.05,0.0>,<0,0>,<0,-0.07>
			rotate <-2,0,-90> translate <6.2+2,0,0.24> rotate x*(0+17)
		}
		prism {
			linear_spline conic_sweep -2,0,5,
			<0,-0.07>,<0.05,0.0>,<-0.05,0.0>,<0,0>,<0,-0.07>
			rotate <-2,0,-90> translate <6.2+2,0,0.24> rotate x*(120+17)
		}
		prism {
			linear_spline conic_sweep -2,0,5,
			<0,-0.07>,<0.05,0.0>,<-0.05,0.0>,<0,0>,<0,-0.07>
			rotate <-2,0,-90> translate <6.2+2,0,0.24> rotate x*(240+17)
		}
		texture { BriteTex }
	} // end union

#declare BladeArm =
	union {
		union { // this is the blade
			difference {
				cylinder { <0,0,0>,<0,0,0.4>,0.40 }
				cylinder { <0,0,-0.1>,<0,0,0.41>,0.32 }
				box { <-0.5,0,-0.2>,<0.5,1,1> }
			} // end difference
			box { <-0.40,0,0>,<-0.32,0.6,0.4> }
			box { < 0.32,0,0>,< 0.40,0.6,0.4> }
			translate <0,-0.8,3.7>
			texture { BriteTex }
		} // end union
		cylinder { <-1.2,0,0>,<1.2,0,0>,0.2 } // shaft
		cylinder { // spring
			<-1.05,0,0>,<-0.55,0,0>,0.36
			texture {
				pigment {
					gradient x
					color_map {
						[ 0.5 color rgb<.336,.357,.412> ]
						[ 0.5 color rgbt<.336,.357,.412,1> ]
					}
					scale .12
				}
				finish { specular 0.95 roughness 0.028 metallic reflection 0.24 }
			}
		}
		object { // support
			RoundedHalfBox(.3)
			scale <.7,.4,3.3>
			translate <0,0,3.3/2>
		}
		object { // platform
			RoundedBox(.3)
			scale <1.3,1.3,0.35>
			translate <0,0,0.35/2+3.3>
		}
		cylinder { <0,0,0>,<0,0,.3>,0.2 translate <0,0,3.55> texture { BriteTex } }
		box { <-0.3,-1.2,0>,<0.3,0.3,0.07> translate <0,0,3.7> texture { BriteTex } }
		texture { PTex }
	} // end union

#declare HandleGroup =
	union { // handle
		cylinder {
			<-0.5,0,0>,<0,0,0>,0.3
		}
		box { // handle link
			<-0.5,-0.2,-3.5>,<-0.25,0.2,0>
			}
		cylinder {
			<-0.8,0,0>,<-0.25,0,0>,0.2
			translate <0,0,-3.5>
		}
		cylinder { // handle shaft
			<-1,0,0>,<0,0,0>,0.14
			translate <-0.5,0,-3.5>
		}
		object { PHandle translate <-1.0,0,-3.5> }
	} // end union

#declare ClampGroup =
	union {
		cylinder { <0,0,-0.1>,<0,0,0>,0.6 }
		cylinder { <0,0,-0.3>,<0,0,-0.1>,0.38 }
		cylinder { <0,0,-3.0>,<0,0,-0.1>,0.18 }
		#declare CP = 0;
		#while ( CP < 2.8 )
			cylinder {
				<0,0,0>,<0,0,0.1>,0.25
				rotate y*8
				translate <0,0,-2.9+CP>
			}
			#declare CP = CP + 0.21;
		#end
		sphere { <0,0,-3.0>,0.18 }
		cylinder { <0,0,0>,<0,0,-1.2>,0.18 rotate x*16 translate <0,0,-3> }
		sphere { <0,0,0>,0.18 translate <0,0,-1.2> rotate x*16 translate <0,0,-3> }
//		cylinder { <-0.06,0,0>,<0.06,0,0>,1.1 scale <1,1,0.7> translate <0,0,-3>}
//		torus { 1.1,0.06 rotate z*90 scale <1,1,0.7> translate <0,0,-3>}
		texture { BriteTex }
	} // end union
#declare FrameGroup =
	union {
		object { PeelerFrameHalf }
		object { PeelerFrameHalf scale <1,-1,1> }
		cylinder { <0,0,0>,<4,0,0>,0.08 texture { BriteTex } translate <4.5,0,1.2> } // small shaft
		sphere { <0,0,0>,0.08 texture { BriteTex } translate <8.5,0,1.2> } // small shaft
		object { RoundedBox(.2) scale <1.4,2.0,0.4> translate <1.4,0,0.2> texture { PadTex } }
		object { RoundedBox(.2) scale <1.4,2.0,0.4> translate <6.0,0,0.2> texture { PadTex } }
		cylinder { <0,0,0>,<0,0,0.5>,.38 translate <1.7,0,-2.7> } // clamp area
	} // end union

#declare Peeler =
	union {
		object { FrameGroup }
		object { MainShaft translate <0,0,5> }
		object { BladeArm rotate x*-16 translate <6,0.5,0.7> }
		object { HandleGroup translate <-3.6,0,5> }
		object { ClampGroup rotate z*30 translate <1.7,0,-1.6> }
		texture { PTex }
	} // end union



//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 25
		location  <1, -36, 10> // overall
		look_at <4,0,8>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { Peeler scale 1 rotate z*160 translate <4,0,4> }


#end
