 //////////////////////////////////////////////////////
// Persistence of Vision Ray Tracer                  //
// File: cell.pov                                    //
// Vers: 3.1                                         //
// Desc: a scene repepresenting Loneliness           //
// Date: 27-07-2002                                  //
// Auth: Siim Annuk (siim@aai.ee | www.aai.ee/~siim) //
//////////////////////////////////////////////////////



global_settings { assumed_gamma 2.6 ambient_light 2.7 }


#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "skies.inc"
#include "pinkmarb.map"


background {White}

camera {
   ultra_wide_angle
   location <-15, 2, 12>
   look_at <4.5, 8, -10>
   angle 150
   }


light_source
{
  0*x                     
  color rgb 4       
  translate <-100,60,300> 
  area_light <5, 0, 0>, <0, 5, 0>, 15, 15
  adaptive 0
  jitter
  media_interaction off
}

light_source
{
  0*x                     
  color rgb <2, 2, 3>*2
  translate <50,40,0>
  area_light <1, 0, 0>, <0, 1, 0>, 5, 5
  adaptive 0
  jitter
}


light_source
{
  0*x                     
  color rgb .75       
  translate <0,12,0> 
  area_light <5, 0, 0>, <0, 5, 0>, 10, 10  
  adaptive 0
  jitter
  media_interaction off
}



fog{
    color rgb <.5,.5,.5>
    fog_type 2
    fog_alt 6
    fog_offset 0
    distance 80
    turbulence <.015, .015, .015>
    omega 0.35
    lambda 1.25
    octaves 5
}


/// Textures 
///////////////////////////////////

#declare floor_tex = texture {
   pigment{rgb .3}
   normal{
     crackle 0.2
     scale 0.55
   }
}


#declare wall_tex = texture {
   pigment{rgb .3}
   normal{
     crackle 0.6
     scale 0.24
   }
}

#declare door_tex = texture {
   pigment{rgb .3}
}

#declare tex1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 9.0
        reflection .2
    }
    pigment { rgb .25 }
}

#declare bar_tex = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        reflection .1
    }
    pigment { rgb .01 }
}

// end Textures

  

/// The scnene 
///////////////////////////////////

// Floor
plane { y, 0 texture {floor_tex} }

// Walls
#declare wall_1 = object {
superellipsoid { <.2, .2> scale <1,.38,.4>*4 translate <0,1.5,-20> texture {wall_tex} }
}

#declare wall_2 = union {
object {wall_1}
object {wall_1 translate 8*x}               
object {wall_1 translate 8*x*2}
object {wall_1 translate 8*x*3}               
object {wall_1 translate 8*x*4}
object {wall_1 translate 8*x*5}
object {wall_1 translate 8*x*6}
}

#declare wall_back = union {
object {wall_2}
object {wall_2 translate 3*y translate 4*x}
object {wall_2 translate 3*y*2}
object {wall_2 translate 3*y*3 translate 4*x}                               
object {wall_2 translate 3*y*4}
object {wall_2 translate 3*y*5 translate 4*x}
object {wall_2 translate 3*y*6}
object {wall_2 translate 3*y*7 translate 4*x}
object {wall_2 translate 3*y*8}
object {wall_2 translate 3*y*9 translate 4*x}
object {wall_2 translate 3*y*10}
}

#declare wall_vv = difference {
object {wall_back}
box { <16, 0, -50> < 0,  9,  5> translate <16,21,0> texture {wall_tex} }
}

#declare wall_vv2 = difference {
object {wall_back}
box { <16, -30, -50> < -4,  9,  5> translate <24,21,0> texture {wall_tex} }
}

#declare wall_w = union {
object {wall_vv}
cone { 9*y,  .25, 0*y, .25 translate <19,21,-20>}
cone { 9*y,  .25, 0*y, .25 translate <28,21,-20>}
cone { 9*y,  .25, 0*y, .25 translate <23.75,21,-20>}
}

object {wall_back translate <-24,0,-20>}

object {wall_w rotate -90*y translate <8,0,-39>}

object {wall_back rotate -90*y translate <-45,0,-38>}

object {wall_vv2 translate <-24,0,34>}

// Roof
box { <-30, 34, -58> < 36,  36,  50> texture {wall_tex} }


box { <30, 0, 0> <29,  35,  100> translate <5,0,0> pigment {rgb .5} }


box { <-50, -1, -.35> < 50,  20,  .35> translate -40*z pigment {rgb 0}}



#include "creature.inc"

object {creature rotate <0,25,0> translate <2.5,-.3,-3.5> scale 7}


#include "door.inc"

object {door2 translate -10*x rotate <0,75,0> translate <6,23,0> translate 10*x}


#include "stuff.inc"

object {stuff rotate <0,-65,0> translate <-4,0,0> scale 2}



