#version unofficial MegaPov 0.7;

#include "grass_blade.inc"

#macro grass_patch(field_width,field_depth,field_center,blade_count,obj,hbase,hvar,wbase,wvar,tbase,tvar,bbase,bvar,segments,tex)

#local S1 = seed(8421);
#local blade_num = 0;

#while ( blade_num < blade_count )

  #if ( vlength( tex ) = 0 )
  
    #local prand = rand(S1);
   
    #local pig1 = pigment{ color rgb <0.25882, 0.43529, 0.18431> }
    #local pig2 = pigment{ color rgb <0.27843, 0.46667, 0.2> }
    #local pig3 = pigment{ color rgb <0.2549, 0.42353, 0.18431> }
    
          #switch ( prand )
            #range ( 0,.3 )
              #local gtex =
                texture{
                  pigment{ pig1 }
                  finish{ phong .05 phong_size 10 ambient .1 diffuse .5 reflection .1 }
                }
            #break
            #range ( .3,.65 )
              #local gtex =
                texture{
                  pigment{ pig2 }
                  finish{ phong .05 phong_size 10 ambient .1 diffuse .5 reflection .1 }
                }
            #break
            #range ( .65,1 )
              #local gtex =
                texture{
                  pigment{ pig3 }
                  finish{ phong .05 phong_size 10 ambient .1 diffuse .5 reflection .1 }
                }
            #break
          #end
    
  #else
  
    #local gtex =
    texture{
      pigment{ color rgb tex }
      finish{ phong .05 phong_size 10 ambient .02 reflection .05 }
      }
    
  #end 

  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  #local rotx = 20*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-10;
  #local roty = 360*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1));
  #local rotz = 20*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-10;
  
  #local hrand = hvar*(rand(S1)+.1*rand(S1))+hbase;
  #local wrand = wvar*(rand(S1)+.1*rand(S1))+wbase;
  #local trand = tvar*(rand(S1)+.1*rand(S1))+tbase;
  #local brand = bvar*(rand(S1)+.1*rand(S1))+bbase;
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,30,posz>, <0,-1,0>, norm );
  
  #if ( norm.y != 0 )
  
  object{ 
    grass_blade(hrand,wrand,trand,brand,segments) 
    rotate roty*y
    rotate <rotx,0,rotz>
    translate pos 
    texture{ gtex } 
  }
  
  #end

  #local blade_num = blade_num + 1;

#end

#end







