#include "shapes.inc"

#macro BlockWallDefault(WALL_LENGTH,WALL_HEIGHT)
	BlockWall(WALL_LENGTH,WALL_HEIGHT,2,1,1,0.05,true,true)
#end

#macro BlockWall(WALL_LENGTH, WALL_HEIGHT, BLOCK_WIDTH, BLOCK_HEIGHT, BLOCK_DEPTH, BLOCK_RADIUS, FINISHED_START, FINISHED_END)
	
	#local TOTAL_ROWS = ceil(WALL_HEIGHT/BLOCK_HEIGHT);
	#local TOTAL_BLOCKS = ceil(WALL_LENGTH/BLOCK_WIDTH);
	
	#local CURRENT_ROW = 0;
	
	union {
		#while (CURRENT_ROW < TOTAL_ROWS)
			#local BLOCK_OFFSET = BLOCK_WIDTH * mod(CURRENT_ROW,2) / 2;
			#local CURRENT_BLOCK = 0;
			
			#while (CURRENT_BLOCK < TOTAL_BLOCKS)
				#if (BLOCK_OFFSET != 0)
					#if (CURRENT_BLOCK=0)
						#if (FINISHED_START=true)
							Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
						#else
							Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
						#end
					#else
						#if (CURRENT_BLOCK = TOTAL_BLOCKS-1)
							#if (FINISHED_END=true)
								Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
								Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH+BLOCK_WIDTH/2,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
							#else
								Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
							#end
						#else
							// Non-end block
							Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
						#end
					#end
				#else
					Round_Box_Union ( <CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET,CURRENT_ROW*BLOCK_HEIGHT,0>,<CURRENT_BLOCK*BLOCK_WIDTH-BLOCK_OFFSET+BLOCK_WIDTH,CURRENT_ROW*BLOCK_HEIGHT+BLOCK_HEIGHT,BLOCK_DEPTH>,BLOCK_RADIUS)
				#end
				#local CURRENT_BLOCK = CURRENT_BLOCK + 1;
			#end
			
			#local CURRENT_ROW = CURRENT_ROW + 1;
		#end
	
	texture { pigment {color White }}
	
	}

#end