#version unofficial Megapov 0.7;

#macro distort(Object,xl,xr,yd,yu,zf,zb)
// First scale left and right halves separately and rejoin
#local Xl=object {
  Object clipped_by {
    plane {
      x, 0
      }
    }
  scale <xl,1,1>
  }
#local Xr=object {
  Object clipped_by {
    plane {
      x, 0 scale -1
      }
    }
  scale <xr,1,1>
  }
#local First=union {
  object {
    Xl
    }
  object {
    Xr
    }
  }
// Now scale the upper and lower halves of the product of the above section and rejoin 
#local XYd=object {
  First clipped_by {
    plane {
      y, 0
      }
    }
  scale <1,yd,1>
  }
#local XYu=object {
  First clipped_by {
    plane {
      y, 0 scale -1
      }
    }
  scale <1,yu,1>
  }
#local Second=union {
  object {
    XYd
    }
  object {
    XYu
    }
  }
// ...and finally, do the same with the front and back halves...You're getting the idea!! 
#local XYZf=object {
  Second clipped_by {
    plane {
      z, 0
      }
    }
  scale <1,1,zf>
  }
#local XYZb=object {
  Second clipped_by {
    plane {
      z, 0 scale -1
      }
    }
  scale <1,1,zb>
  }
#local Final=union {
  object {
    XYZf
    }
  object {
    XYZb
    }
  }
// Now let POVray know that this is what to use for rendering 
object {
  Final
  }
// ....and we're done. Easy, innit!!
#end


#declare Power_Module = union {
  sphere {
    <0, 0, 0>, 4
    uv_mapping
      texture {
        pigment {
          cells
          color_map {
            [.35 rgb <0.039, 0.041,0.043>*4]
            [.55 rgb <0.39, 0.41, 0.43>*0.8]
            }
          }  
        scale <0.1, 0.05, 0.1>
        finish {
          ambient 0.5
          brilliance 2
          diffuse 0.3
          specular 0.4
          roughness 0.1
          reflection 0.1
          }
        }
    scale <1, 0.75, 1>
    }
  cone {
    <-3, 0, 0>, 1.5
    <-8, 0, 0>, 0.75
    texture {
      T_Silver_1B
      }
    }
  }

#declare Wing_Sphere = sphere {
  < 0, 0, 0>, 1
  }
  
#declare Atmos_Wing = union {
  distort (Wing_Sphere, 3, 2.5, 0.1, 0.15, 10, 10)
  difference {
    intersection {
      torus {
        6.3, 1
        scale <1, 3, 1>
        rotate z*90
        }
      torus {
        4.8, 1
        scale <1, 3, 1>
        rotate z*90
        }
      scale <1, 0.75, 1>
      }
    box {
      <-8, -2, -8>, <8, -8, 8>
      pigment {
        color Clear
        }
      }
    translate < 0, 2, 0>
    }
  texture {
    pigment {
      cells
      color_map {
        [.35 rgb <0.039, 0.041,0.043>*4]
        [.55 rgb <0.39, 0.41, 0.43>*0.8]
        }
      }  
    scale 0.5
    finish {
      ambient 0.5
      brilliance 2
      diffuse 0.3
      specular 0.4
      roughness 0.1
      reflection 0.1
      }
    }
  }      
  
#declare CockpitA = union {
  difference {
    sphere {
      <0, 0, 0>, 4.5
      uv_mapping
      texture {
        pigment {
          cells
          color_map {
            [.45 rgb <0.039, 0.041,0.043>*4]
            [.55 rgb <0.39, 0.41, 0.43>*0.8]
            }
          }  
        scale <0.1, 0.05, 0.1>
        finish {
          ambient 0.5
          brilliance 2
          diffuse 0.3
          specular 0.4
          roughness 0.1
          reflection 0.01
          }
        }
      hollow
      }
    box {
      <0, 0.3, -4.6>, <4.6, 2.5, 4.6>
      pigment {
        colour Clear
        }
      }
    }
  intersection {
    sphere {
      <0, 0, 0>, 4.5
      texture {
        pigment {
          color rgbft <1.0, 0.875, 0.575, 0.4, 0.8>
            }
          }
        finish {
      	  brilliance 0.25
	        diffuse 0.2
       		phong 1.0
       		phong_size 600
         	reflection_type 1
	       	reflection_min 0.1
	      	reflection_max 0.55
	       	reflection_falloff 0.7
        	conserve_energy
        	}
	      interior {
	        ior 1.21
	        fade_distance 2
	        fade_power 3
          caustics 1
        }
	    }
    box {
      <0, 0.3, -4.6>, <4.6, 2.5, 4.6>
      pigment {
        colour Clear
        }
      }
    sphere {
      <0, 0, 0>, 4.3
      pigment {
        color rgb < 0, 0, 0.25>
        }
      finish {
        ambient 0.75
        }
      } 
    } 
  scale <1, 0.75, 1>
  }

#declare CockpitB = distort (CockpitA, 1, 1.5, 1, 1, 1, 1)
     

#declare Fuselage = union{
  union {
    cylinder {
      <-10, 1, 1>, <10, 1, 1>, 1.5
      open
      }
    cylinder {
      <-10, -1, 1>, <10, -1, 1>, 1.5
      open
      }
    cylinder {
      <-10, 1, -1>, <10, 1, -1>, 1.5
      open
      }
    cylinder {
      <-10, -1, -1>, <10, -1, -1>, 1.5
      open
      }
    texture {
      pigment {
        cells
        color_map {
          [.35 rgb <0.039, 0.041,0.043>*4]
          [.55 rgb <0.39, 0.41, 0.43>*0.8]
          }
        }  
      scale <0.75, 0.5, 0.25>
      finish {
        ambient 0.5
        brilliance 2
        diffuse 0.3
        specular 0.4
        roughness 0.1
        reflection 0.1
        }
      }
    }
    
  #declare coil_point1 = <-9, 0, 0>;
  #declare coil_point2 = <9, 0, 0>;
  #declare coil_type = 3;
  #declare coil_thickness = 1.1;
  #declare coil_radius = 1.65;
  #declare coil_revolutions = 15;
  
  object {
    #include "Coil.inc"  //------this is Chris Colefax's brilliant coil generator------
    texture {
      T_Copper_3C
      }
    rotate x * clock * 360
    }
  }
  
#declare Starship = union {
  object {
    distort (Fuselage, 1, 1, 1, 0.5, 1, 0.5)
    }
       
  object {
    Power_Module
    translate <-12, 0, 0>
    }
    
  object {
    Atmos_Wing
    translate <-12, 0, 0>
    }
    
  object {
    Atmos_Wing
    scale < 1.5, 1, 1.5>
    translate < 6, -1.5, 0>
    }
    
  object {
    CockpitB
    scale < 1, 1, 0.75>
    translate < 12, 0, 0>
    }
  scale Ss_Scale
  rotate Ss_Rot
  translate Ss_Trans
  }
  
//------Ion-drive glow------

glow {
	type 1
	location <0, 0, 0>
	size 2.55
	radius 3.1
	fade_power 1.24
	color	rgb <1.0, 0, 0.65>
	translate <-21.5, 0, 0>
	scale Ss_Scale
	rotate Ss_Rot
  translate Ss_Trans
  }
  
glow {
	type 1
	location <0, 0, 0>
	size 1.2
	radius 10.5
	fade_power 3
	color	rgb <1.0, 0, 0.65>*1.5
	translate <-21.5, 0, 0>
	scale Ss_Scale
	rotate Ss_Rot
  translate Ss_Trans
	}		