// -----------------------------------------------------------------------
#version unofficial MegaPov 0.7;




// -----------------------------------------------------------------------
// --- STANDARD INCLUDES -------------------------------------------------
// -----------------------------------------------------------------------
#include "colors.inc"
#include "shapes.inc"




// -----------------------------------------------------------------------
// --- GLOBAL SETTINGS ---------------------------------------------------
// -----------------------------------------------------------------------
global_settings {
  assumed_gamma 1.8
  }




// -----------------------------------------------------------------------
// --- SOME VARIABLES ----------------------------------------------------
// -----------------------------------------------------------------------
#declare globalLight = false;

#declare useAreaLights = true;
#declare useLightFading = false;

#declare drawLambris = true;
#declare drawMirroir = true;
#declare drawPiece = true;




// -----------------------------------------------------------------------
// M A C R O ------------------------------------------------------------
// ----------------------------------------------------------------------
#macro makePolygon (polyNbPts, polyRadius, verbose)
	#if (verbose)
		#debug "\n\n\npolygon generation :\n"
		#debug "--------------------\n\n"
	#end
	
	#local polyAngle = 2*pi/polyNbPts;
	#local index=0;
	#while (index<polyNbPts)
		#local xPoly = polyRadius*sin(polyAngle*index);
		#local zPoly = polyRadius*cos(polyAngle*index);
		#declare polyPoints[index] = <xPoly, zPoly>;
		#if (verbose)
			#debug concat(str(index,3,0)," : <",str(polyPoints[index].x,5,3)," ,",str(polyPoints[index].y,5,3),">\n")
		#end
		#local index=index+1;
	#end
#end



// -----------------------------------------------------------------------
// --- CAMERA AND LIGHTS -------------------------------------------------
// -----------------------------------------------------------------------
camera {
  location <28, 9, 21>
  look_at <1, 8, 1>
  }




// -----------------------------------------------------------------------
#if (globalLight)
	// -----------------------------------------------------------------------
	light_source {
	  <10, 20, 10>
	  color White*2
	  }
#else
	// -----------------------------------------------------------------------
	#declare LightBulb = sphere {
	  <0.50, 12, 8> 0.50
	  texture {
	    pigment { color White }
	    finish { ambient 1 diffuse 2 }
	    }
	  }
	#declare ligthPos = <1.00, 15.00, 10.00>;
	light_source {
	  ligthPos
	  color White*2.50
	  #if (useAreaLights)
	    area_light x,y,9,9
	    adaptive 5
	    jitter
	    circular
	    orient
	  #end
	  #if (useLightFading)
	    fade_distance 12
	    fade_power 1
	  #end
	  }
#end




// -----------------------------------------------------------------------
// --- OBJECTS -----------------------------------------------------------
// -----------------------------------------------------------------------




// -----------------------------------------------------------------------
// --- SOL ---------------------------------------------------------------
// -----------------------------------------------------------------------
#declare nbPoints = 6;
#declare nbX = 12;
#declare nbZ = 12;

#declare rayon = 2;
#declare polyPoints = array [nbPoints]
makePolygon(nbPoints, rayon, false)
#declare tomette1 = prism {
	linear_spline
	linear_sweep
	0,
	-0.20
	nbPoints+1,
	#declare index=0;
	#while (index<nbPoints)
		<polyPoints[index].x, polyPoints[index].y>,
		#declare index=index+1;
	#end
	<polyPoints[0].x, polyPoints[0].y>
	sturm
	texture {
		pigment { color Red*0.40 }
		normal { bumps 0.2 }
		}
	}

#declare rayon = rayon+0.1;
#declare polyPoints = array [nbPoints]
makePolygon(nbPoints, rayon, false)
#declare tomette2 = prism {
	linear_spline
	linear_sweep
	-0.01,
	-0.20,
	nbPoints+1,
	#declare index=0;
	#while (index<nbPoints)
		<polyPoints[index].x, polyPoints[index].y>,
		#declare index=index+1;
	#end
	<polyPoints[0].x, polyPoints[0].y>
	sturm
	texture {
		pigment { color White }
		finish { ambient 0.80 diffuse 1 }
		}
	}

#declare tomette = union {
	object { tomette1 }
	object { tomette2 }
	}
	
#declare deltaX = rayon*sqrt(3);
#declare deltaZ = (3*rayon/2);

#declare indexX=0;
#declare tomettesX = union {
	#while (indexX<nbX)
		object {
			tomette
			translate <deltaX*indexX, 0, 0>
			}
		#declare indexX=indexX+1;
	#end
	}

#declare flag = 0;
#declare indexZ=0;
#declare sol = union {
	#while (indexZ<nbZ)
		object {
			tomettesX
			translate <flag*rayon * sqrt(3) /2, 0, deltaZ*indexZ>
			}
		#declare indexZ=indexZ+1;
		#declare flag=1-flag;
	#end
	}

object { sol }




// -----------------------------------------------------------------------
// --- MURS --------------------------------------------------------------
// -----------------------------------------------------------------------
#if (drawLambris)
	#declare latteHauteur = 17.0;
	// --- texture lambris ------------------------------------------------
	#declare colorMapLambris1 = color_map {
		[0.000 rgb <0.725, 0.659, 0.455>]
		[0.171 rgb <0.682, 0.549, 0.420>]
		[0.274 rgb <0.557, 0.451, 0.322>]
		[0.393 rgb <0.725, 0.659, 0.455>]
		[0.564 rgb <0.682, 0.549, 0.420>]
		[0.701 rgb <0.482, 0.392, 0.278>]
		[1.000 rgb <0.725, 0.659, 0.455>]
		}
	#declare colorMapLambris2 = color_map {
		[0.000 rgbf <0.682, 0.604, 0.380, 1.000>]
		[0.087 rgbf <0.761, 0.694, 0.600, 0.020>]
		[0.226 rgbf <0.635, 0.553, 0.325, 1.000>]
		[0.348 rgbf <0.761, 0.694, 0.600, 0.020>]
		[0.496 rgbf <0.682, 0.604, 0.380, 1.000>]
		[0.565 rgbf <0.761, 0.694, 0.600, 0.020>]
		[0.661 rgbf <0.682, 0.604, 0.380, 1.000>]
		[0.835 rgbf <0.761, 0.694, 0.600, 0.020>]
		[1.000 rgbf <0.682, 0.604, 0.380, 1.000>]
		}
	#declare textureLambris = 
		texture {
			pigment {
				bozo
				turbulence 0.2
				color_map { colorMapLambris1 }
				scale <0.2, 0.2, 1>
				scale 2
				}
			}
		texture {
			pigment {
				bozo
				turbulence 0.8
				color_map { colorMapLambris2 }
				scale 0.4
				}
			}
	// --- lambris ------------------------------------------------
	#declare latteX = prism {
		linear_spline
		linear_sweep
		0.0, latteHauteur,
		7,
		< 0.0, -0.5>, < 1.0, -0.5>, < 1.0, -0.1>,
		< 0.9,  0.0>, < 0.1,  0.0>, < 0.0, -0.1>,
		< 0.0, -0.5>
		}
	#declare latteZ = prism {
		linear_spline
		linear_sweep
		0.0, latteHauteur,
		7,
		<-0.1, 0.0>, <-0.5, 0.0>, < -0.5, 1.0>,
		<-0.1, 1.0>, 	< 0.0, 0.9>, < 0.0, 0.1>,
		<-0.1, 0.0>
		}
	// --- lambris X ----------------------------------------------
	#declare index = 0;
	#declare down = 0;
	#while (index<25)
		object {
			latteX
			translate <index,-(down*latteHauteur)/2,0>
			texture { textureLambris rotate 90*x }
			}
		object {
			latteX
			translate <index,latteHauteur+0.06-(down*latteHauteur)/2,0>
			texture { textureLambris rotate 90*x }
			}
		#declare index = index + 1;
		#declare down = 1 - down;
	#end
	// --- lambris Z ----------------------------------------------
	#declare index = 0;
	#declare down = 0;
	#while (index<40)
		object {
			latteZ
			translate <0,-(down*latteHauteur)/2,index>
			texture { textureLambris rotate 90*x }
			}
		object {
			latteZ
			translate <0,latteHauteur+0.06-(down*latteHauteur)/2,index>
			texture { textureLambris rotate 90*x }
			}
		#declare index = index + 1;
		#declare down = 1 - down;
	#end
	box {
		<-0.1, 0, -0.10>
		<+0.1, 50, +0.10>
		rotate 45*y
		texture { textureLambris rotate 90*x }
		}
#end




// -----------------------------------------------------------------------
// --- LUMINAIRE ---------------------------------------------------------
// -----------------------------------------------------------------------
#declare vasque = difference {
  sphere { <0, 0, 0> 1 }
  sphere { <0, 0, 0> 0.90 }
  plane { y, 0 inverse }
  }
object {
  vasque
  translate <0, ligthPos.y-0.50, ligthPos.z>
  texture {
    pigment { color White }
    finish { ambient 0.20 phong 0.75 phong_size 50 metallic }
    }
  }




// -----------------------------------------------------------------------
// --- MIRROIR -----------------------------------------------------------
// -----------------------------------------------------------------------
#if (drawMirroir)
	#declare rayonMirroir = 6;
	union {
		cylinder {
			<0, 0, 0>
			<0, 0, 0.05>
			rayonMirroir
			texture {
				pigment { color Black }
				finish { ambient 0 diffuse 2 reflection 1 }
				}
			}
		torus {
			rayonMirroir, 0.20
			rotate 90*x
			texture {
				pigment { color Silver }
				finish { ambient 0.20 phong 0.75 phong_size 100 metallic }
				}
			}
		scale <0.80, 1.00, 1.00>
		translate <rayonMirroir+5, rayonMirroir+2.5, 0.00>
		}
#end




// -----------------------------------------------------------------------
// --- PIECE D'ECHEC : ROI OU REINE --------------------------------------
// -----------------------------------------------------------------------
#if (drawPiece)
	// --- texture de la piece ---------------------------------
	#declare texturePiece = texture {
		pigment {
			color White*0.76
			}
		finish {
			ambient 0.25
			brilliance 4
			diffuse 0.5
			metallic
			specular 0.80
			roughness 0.0125
			reflection 0.5
			}
		}

	// --- piece d'echec - chess2.pov --------------------------
	// Note : CHESS2.POV was created from Ville Saari's chess.pov
	#declare PieceBase = union {
	  intersection {
	    sphere { <0, 0, 0>, 3 }
	    plane { -y, 0 }
	    }
	  cylinder { 0, y*0.35, 3.0 pigment { Black }  }
	  }
	#declare QueenAndKing = union {
	  sphere { <0, 10.5, 0>, 1.5 }
	    intersection {
	      union {
	        sphere { <1.75, 12, 0>, 0.9  rotate 150*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate 120*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate 90*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate 60*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate 30*y }
	        sphere { <1.75, 12, 0>, 0.9  }
	        sphere { <1.75, 12, 0>, 0.9  rotate -30*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate -60*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate -90*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate -120*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate -150*y }
	        sphere { <1.75, 12, 0>, 0.9  rotate  180*y }
	        inverse
	        }
	    plane { y, 11.5 }
	    object { QCone_Y scale <1, 3, 1> translate 5*y }
	    plane { -y, -8 }
	    }
	  sphere { <0, 0, 0>, 1 scale <1.8, 0.4, 1.8> translate 8*y }
	  intersection {
	    plane { y, 8 }
	    object { Hyperboloid_Y scale <0.7, 1.6, 0.7> translate 7*y }
	    plane { -y, -3 }
	    }
	  sphere { <0, 0, 0>, 1 scale <2.5, 0.5, 2.5> translate 2.8*y }
	  object { PieceBase }
	  }
	#declare King = union {
	  intersection {
	    union {
	      intersection {
	        plane { y, 13 }
	        plane { -y, -12.5 }
	        }
	      intersection {
	        plane { +x, 0.25 }
	        plane { -x, 0.25 }
	        }   
	      }
	    plane { +z,  0.25 }
	    plane { -z,  0.25 }
	    plane { +x,  0.75 }
	    plane { -x,  0.75 }
	    plane { +y,  13.5  }
	    plane { -y,  -11.5  }
	    }
	  object { QueenAndKing }
	  }
	#declare Queen = union {
		sphere { <0, 12.3, 0>, 0.4 }
		object { QueenAndKing }
		}
	object {
		Queen
		scale 0.80
		translate <10, 0, 9>
		texture { texturePiece }
		}
	// --- eclairage suplementaire -----------------------------
	light_source {
		<12, 3, 11>
		color White*0.60
		shadowless
		}
#end
