// Persistence of Vision Ray Tracer Scene Description File
// File: mg_kit.pov (mg_kitchen.pov)
// Vers: 3.5
// Desc: IRTC entry. Topic: Loneliness
// Date:  August 08 2002
// Auth: Marjorie Graterol
/*
The kitchen. Where loneliness becomes solitude. 

*/

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "mg_kit_tex.inc"
#include "kit_01.inc"
#include "kit_02.inc"

//#default {pigment {White}}


camera{
	location < 0, 4.8, -32 >
	look_at < -6.740, 1, 2.196 > 
	angle 45              
	right     1.5/2*x 
}



media {
  
  intervals 15
  samples 1,1            
  confidence 0.9         
  variance 1.0/350
  ratio 0.9              
  scattering {           
    3,                   
    Black
    extinction 1.0     
  }
  method 3               
  aa_threshold 0.1     
  aa_level 4           
  
}

global_settings{
	adc_bailout 0.0039
	ambient_light rgb 0
	assumed_gamma 2.0
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  radiosity {
      pretrace_start 0.08           
      pretrace_end   0.04           
      count 35                      
      nearest_count 5               
      error_bound 1.8               
      recursion_limit 3             
      low_error_factor .5           
      gray_threshold 0.0            
      minimum_reuse 0.015           
      brightness 1.8                  
      adc_bailout 0.01/2
      normal on                   
      media on                    

    }  
}


// Luces
light_source {
  0*x                  
  color rgb <1,1,1>    
  translate <100,10,-100>
  media_interaction on
  media_attenuation on
  fade_distance 80
  fade_power 1 
}
// create a regular point light source

light_source {
  0*x                  
  color rgb <1,1,1>    
  translate <0, 10, 15>
  fade_power 1
  fade_distance 16
}


object{cocina_basica}




/*Pared de la cocina-completa*/

//paredes


#local curva=
//pared curva
//cilindro externo
difference{
  cylinder { 
    -10*y,  20*y,  10.75 
    translate <-7.25,0,-3.75>
  }
//cilindro interno
  cylinder { 
    -11*y,  21*y,  10.25 
    translate <-7.25,0,-3.75>
  } 
}

// NO MOVER

#declare curvatura=

difference{
  object{
    curva
  }
  box{
    <-18,-11,-15><4,21,-3.75> 
    pigment {Clear}
  }

  box{
  <-7.25,-11,-3.75><18,21,7> 
  pigment {Clear}
  }

}

//ventana detras del fregador

light_source {
  0*x                  
  color rgb <1,1,1>    
  translate <-10, 20, 15>
}

#declare ventana_pared=
difference{
//pared de la ventana
  union{
    box{
    <-7.40,-10,6.55><12,20,6.75>
    }
    box{<-1.50,2.50,5><6.50,14.50,7> 
    texture {Old_Wood}
    }
  }
//huecos izq-der, abajo-arriba
  box{<-1,3,4.50><2.25,8.25,7.25> } 
  box{<2.75,3,4.50><6,8.25,7.25>}
  box{<-1,8.75,4.50><2.25,14,7.25> } 
  box{<2.75,8.75,4.50><6,14,7.25> } 

}


#declare cocina_pared=
//pared de la cocina
box{
  <-17.50,-10,-14.75><-18,21,-3.50> 
}

 
#declare pared_completa=
union{
  object{curvatura}
  object{ventana_pared}
  object{cocina_pared}
}
 
object {
  pared_completa 
  texture {
    pared_kit
  }
  texture {
    pigment {
      bozo
      turbulence 0.25
      color_map{
        [0.25 Gray70 filter 0.8]
        [0.66 Clear]
      }
    }
    normal {
      agate 0.05  
      turbulence 0.25
    }
    finish {
      crand 0.02
    }
    scale <6,7,4>
    translate 0.01*y
  }

  translate 0.25*x
} 
 

/*Gabinetes inferiores*/
#local gabinetes=
union {
//lateral cocina  
  box{
    <-15.75,-8,-14.25><-7.75,0.25,-13.75>
    texture {
      formica2 
      scale 3
    }
  }
//banda superior encima del horno
  box{
  <-8.25,-2,-14.00><-7.75,0.25,-3.75>
    texture {
      formica2 
      scale 3
    }
  }

//lateral del horno-mueble
  box{
  <-8.25,-8,-5.50><-7.75,0.25,-3.75>
    texture {
      formica2 
      scale 3
    }
  }


//superior del fregador
  box{
    <-7.70,-2,-3.70><5.90,0.19,-3.20>
    texture {
      formica2 
      scale 3
    }
  } //

//conjunto frontales del fregador


//panel 1
  box{
    <-7.70,-8,-3.70><-5,-2.15,-3.20> 
    texture {
      formica2 
      scale 3
    }
  }


//puerta izquierda
  box{
  <-4.75,-8,-3.70><-0.125,-2.15,-3.20> 
    texture {
      formica2 
      scale 3 
      rotate 7*y 
      translate -0.10*z
    }
  }

//puerta derecha
  box{
    <0.1255,-8,-3.70><4.30,-2.15,-3.20> 
    texture {
      formica2 
      scale 3
    }
  }

//panel 2
  box{
    <4.40,-8,-3.70><5.90,-2.15,-3.20> 
    texture {
      formica2 
      scale 3
    }
  }

//horno

  box{
    <-8.25,-8,-13.50><-7.70,-2.25,-5.50> 
    pigment{
      Black 
      filter 0.2
    }
    normal{
      gradient x
      frequency 2
    }
    finish {
      ambient 0.4 
      diffuse 0.4 
      brilliance 0.80 
      phong 0.5
    }
  }

}//termina union


object{gabinetes }

//patas de la cocina

union{
  cone {   
    -8*y,  0.12, -10*y, 0.10 
    translate <-8,0,-3.75> 
  }
  cone {   
  -8*y,  0.12, -10*y, 0.10 
  translate <-8,0,-14.25> 
  }

  texture {
    Aluminum
  }
}


#local piso=
texture{
  pigment {
    checker
      color  White
      color  Gray40
    rotate 45*y
    
  }
  normal{
    checker 
      normal { bumps 0.02}, 
      normal {bumps 0.02}
  }    
  finish {
    ambient 0.4 
    diffuse 0.4 
    reflection 0.25
  }//
}



#include "de_todo01.inc"

object{
  detodo_fre
}


#include "de_todo02.inc"

object{
  detodo_fre02
}


//kit_02

object{
  cocina_superior 
  translate -0.50*x
}

#include "sarten.inc"

object{
  sarten 
  rotate 90*x 
  rotate 90*z 
  translate <-3,7,5.65>
} 

#include "paila.inc"

object {
  paila 
  translate<-12.75,0.05,-8>
}

#include "cortinita.inc"

object {
  cortinita 
  scale<1.15,1,1>
  translate<2.5,2.5,4.50>
}


#include "controles.inc"

object {
  controles
}

//asas gabinetes
#include "asa_cab.inc"
object {
  asa_cab 
  rotate 7*y 
  rotate 90*z 
  scale 0.75 
  translate <-0.25,-3,-3.80>
}
object {
  asa_cab 
  rotate 90*z 
  scale 0.75 
  translate <0.80,-3,-3.70>
}
object {
  asa_cab 
  rotate 90*z 
  scale 0.75 
  translate <-5,-3,-3.70>
}
object {
  asa_cab 
  rotate 90*z 
  scale 0.75 
  translate <5.25,-3,-3.70>
}


//gavetas de arriba 

//derecha
object {
  asa_cab 
  scale 0.75 
  translate <5.25,-1,-3.70>
}



#include "almanaque.inc"
object {
  almanaque 
  scale 1.25 
  translate <-6,7,5.65>
}


#include "reloj_p"
object {
  reloj_p 
  scale 0.60 
  rotate -90* y 
  translate <-11.75,15.5,-8>
} 


#include "de_todo03.inc"
object {
  detodo_rep
} 

//mesa

cylinder { 
  -0.50*y, -1*y, 7  
  texture {
    Old_Wood 
    scale <0.75, 0.50, 0.75>
  } 
  translate <6,-3,-19> 
  no_shadow
}

//silla
#include "silla.inc"

object {
  silla  
  no_shadow 
  scale 0.80 
  rotate -70*y 
  translate <-0.75,-10,-20>
}

#include "kit_03.inc"

object {
  fondo
}


#include "kit_04.inc"
object {
  detodo_rep3
}

//paos de la mesa

#local individual=
box{
  <-1.75,0,-1.25><1.75,0.01,1.25> 
  texture {
    stuff2 
    scale 1.75
  } 
} 
  
object {individual rotate 22*y translate<2.50,-3.50,-17> }  
object {individual rotate 60*y translate<2.60,-3.49,-17> }
object {individual rotate 75*y translate<4.25,-3.47,-17> }



// luz bufa
light_source {
  0*x                     
  color Gray40
  spotlight
  parallel               
  translate <-17,-8,-18> 
  point_at <5, -10, -7>      
  radius 5
  tightness 15
  falloff 25
  media_attenuation on
  

}
 

#include "asa_horno.inc"
object {
  asa_horno 
  translate -0.15*x
}




  