/*
POV-Ray scene file for "Padded Cell," created for the 
 "Loneliness" competition at http://www.irtc.org on August 31.
By John Haggerty (http://www.slimeland.com/ , slm@slimeland.com) 
 and Corey Woodworth (Schitz0boy@hotmail.com).

Creation process can be seen at
 http://www.ozoneasylum.com/Forum11/HTML/000446.html
 for a short time.
*/

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "glass.inc"
#include "rand.inc"


global_settings {
  assumed_gamma 1.0
  max_trace_level 20
}

#default {finish{ambient 0}}


#declare usearealight = yes;
#declare usebeamarealight = yes;
#declare usehighqualityarealight = no; // not necessary
#declare usebeammedia = yes;
#declare usemedia = yes;
#declare usebulb = yes;
#declare usehair = yes;
#declare usedrain = no;
#declare usefog = no; // i added fading to the main light source so this isn't really necessary anymore

#declare light_pos = <0, 2.15, 0>;
//#declare light_col = <1,.9,.7>;
//decided to go with a cooler inside color and a warmer outside color to fit with the lonliness theme.
#declare light_col = <.9,.9,1>;
#declare drain_pos = <-.56,0,.87> + y*.05;
#declare drain_rad = .25;

#macro paddedWall (X,Y)
  union {
  #declare J=1;
  #while (J<=Y)   
    #declare I =1;
    #while(I<=X)
      sphere {0,1 scale <1.1,1.1,1> translate <I,J,0>}
      sphere {<I+.5,J+.5,-.74>,.1}
      sphere {<I+.5,J+.5, .74>,.1}
      #declare I=I+1;
    #end
  #declare J=J+1; 
  #end
  }
#end

#declare Wall = object {paddedWall (12,10)  scale .5 
  //pigment {color rgb <.3,.3,.3>}
  pigment {
  		bozo
  		color_map {
  			[0 rgb <.1,0,0>]
  			[.1 rgb <.2,.05,.05>]
  			[.2 rgb <.3,.1,.0>]
  			[.25 rgb <.3,.3,.3>]
  			[.4 rgb <.3,.3,.3>]
  			[.5 rgb <.25,.26,.25>]
  			[.83 rgb <.1,.12,.0>]
  			[1 rgb <.0,.005,0>]
  		}
  		warp {
  			turbulence .7
  			octaves 8
  			lambda 4
  			omega .6
  		}
  		scale .3
  	}
}
// ---------------------------------------- Camera & Lights

camera {
  ultra_wide_angle

  
  location <-.27, 2.63, -.27>
  //location <.65,.7,-.5>
  //location <.65,2,-1.6>
  //location light_pos + x*.1 look_at light_pos
  //location  <-0.5, 0.2, -2> //+ y*2
  //location  <-.25,1.65,3.8>  
  //look_at   <-.25,1.65,0>
  //look_at light_pos - y*1//*2
  look_at <1,-3,1>
  //look_at <.65,.0501,-1.6>
  angle 130 
  
}

light_source {
  light_pos            // light's position
  color rgb light_col
  #if (usebulb)
   looks_like {
     sphere_sweep {
       b_spline
       7,
       <-.03, 0, .03>, .001
       <-.03, 0, .03>, .001
       <-.01, -.015, .015>, .001
       <0, .0, 0>, .001
       <.017, .01, -.008>, .001
       <.03, 0, -.03>, .001
       <.03, 0, -.03>, .001
       tolerance 0.01
       pigment {rgb light_col}
       finish {ambient 1.2 diffuse 0}
       no_shadow
     }
   }
  #end
  
  #if (usearealight)
  	area_light
  	x*.1,y*.1,
  	#if (usehighqualityarealight)
  		17,17
  		adaptive 1
  	#else
  		5,5
	  	adaptive 0
  	#end
  	circular orient
  #end
  
  fade_distance 1.8
  fade_power 7 // corners hardly lit, walls lit well enough to see; creates a nice atmosphere
}

light_source { // just barely lights the top of the light holder
	light_pos + <.1,.2,-.5>
	rgb light_col*.008
	shadowless
	fade_distance .5
	fade_power 10
}
      
// ---------------------------------------- Floor

difference {
	box {
	  <-10, .05, -10>  // one corner position <X1 Y1 Z1>
	  < 10, -40,  10>  // other corner position <X2 Y2 Z2>  
	}
	#if (usedrain)
		cylinder { // drain hole
			drain_pos-y*5,
			drain_pos+.01*y,
			drain_rad-.001
		}
	#end
  texture {
  	pigment {
  		bozo
  		color_map {
  			[0 rgb <.2,.3,.2>]
  			[.33 rgb <.12,.12,.12>]
  			[.67 rgb <.15,.17,.15>]
  			[1 rgb <.25,.25,.25>]
  		}
  		warp {
  			turbulence .4
  			octaves 3
  			lambda 3
  			omega .7
  		}
  		scale .3
  	}
  }
  
  texture {
	    pigment {
	      		bozo
	  		color_map {    
  		        	[0 rgbt <.1,0,0,0>]
  			        [.1 rgbt <.2,.05,.00,.2>]
  			        [.2 rgbt <.3,.1,.0,1>]
  			        [.4 rgbt <.25,.26,.25,1>]
  			        [.8 rgbt <.1,.101,.0,.5>]
  			        [1 rgbt <.0,.0,0,0>]

	  		}                
  		        warp {
  			        turbulence .7
  			        octaves 8
  			        lambda 4
  			        omega .6
  		        }
  		scale .5
  		translate 3
	    }
	    #if (!usedrain)
		  	normal {
		  		dents 1
		  		scale .3
		  		translate -drain_pos
		  	}
	    #end
  } 
  
  #if (usedrain)
	  texture {finish {ambient 1 diffuse 0}
		pigment{
			pigment_pattern {
				#declare basespherefunc = function (x,y,z,a) {min(max(f_noise3d(x*a,y*a+5,z*a)*1.4-.2,0),1)};
				function {basespherefunc(x,y,z,2.5/sqrt(x*x+y*y+z*z)) * pow(f_spherical(x/2.5,y/2.5,z/2.5),2)}
				
				scale 3
				warp {
					turbulence .5
					octaves 5
					omega .5
					lambda 3.5
				}
				scale 1/3
			}
			pigment_map {
				#declare thedrainfloorpig = pigment {
					bozo
					color_map {
						[0 rgb <.5,.25,0>*.08]
						[1 rgb <.3.55,.05>*.09]
					}
					warp {
						turbulence 1.5
						octaves 4
						omega .45
						lambda 4
					}
					scale .2
				}
				[0 thedrainfloorpig transmit 1]
				[1 thedrainfloorpig]
			}
		}
		
	  	normal {
	  		dents 1
	  		scale .3
	  		translate -drain_pos
	  	}
		translate drain_pos
	  }
  #end
}

// ---------------------------------------- Ceiling
box {
  <-3, 3, -5>  // one corner position <X1 Y1 Z1>
  < 3, 4,  5>  // other corner position <X2 Y2 Z2>
  pigment {rgb <.8,.9,.8>}
  /*texture {
    pigment {color rgb <0.9, 0.9, 0.9>}       
    finish{ ambient 0 }
    scale 3
  } */
}
// ---------------------------------------- Bulb
#if (usebulb)
	#declare bulb = 
	    difference {
	     merge {
		    sphere { <0, 0, 0>, .08 }
		    cone { <0, 1.4553, 0>/3*.08, 2.6234/3*.08, <0, 3.3, 0>/3*.08, 1.6/3*.08 }
		    cylinder { <0, 3.3, 0>/3*.08-.01*y, <0, 4.6, 0>/3*.08, 1.6/3*.08 }
	     }
	     union {
		    sphere { <0, 0, 0>, .07 }
		    cone { <0, 1.4553, 0>/3*.07, 2.6234/3*.07, <0, 3.3, 0>/3*.07, 1.6/3*.07 }
		    cylinder { <0, 3.3, 0>/3*.07-.01*y, <0, 4.6, 0>/3, 1.6/3*.07 }
	     }
	     rotate -4*x
	    }
	    
	object {
	  bulb
	  texture {
		  pigment {rgb light_col filter .49 transmit .49}
		  normal {
		  	bumps .0175
		  	scale .01
		  }
		  finish {
		  	reflection .05
		  	specular .3
		  	roughness .003
		  }
		}
	  interior {
	  	ior 1.5
	  }
	  no_shadow
	  translate light_pos
	}
	
	union {
		union {
			cylinder { // top of bulb holder
				<0,.15,0>,<0,.165,0>,.08
			}
			#declare cagebar = sphere_sweep {
				cubic_spline
				6,
				<.068,.17,0>,.005,
				<.068,.15,0>,.005,
				<.09,.07,0>,.005,
				<.09,-.07,0>,.005,
				<.045,-.14,0>,.005,
				<0,-.14,0>,.005
				//#if (!usearealight) no_shadow #end
				no_shadow
			}
			object {
				cagebar
			}
			object {
				cagebar
				rotate 60*y
			}
			object {
				cagebar
				rotate 120*y
			}
			object {
				cagebar
				rotate 180*y
			}
			object {
				cagebar
				rotate 240*y
			}
			object {
				cagebar
				rotate 300*y
			}
			torus {
				.105,.005
				//#if (!usearealight) no_shadow #end
				no_shadow
			}
			torus {
				.045,.005
				translate -.14*y
				//#if (!usearealight) no_shadow #end
				no_shadow
			}
	
			rotate 27*y
			rotate -4*x
			translate light_pos
		}

		// ---------------------------------------- Cable
		sphere_sweep {
			cubic_spline
			6,
			<.01,3.4,-.03>, .01,
			<0,3,0>, .01,
			<-.01,2.75,.04>, .01
			<.06,2.5,-.005>, .01
			<0,2.26,0>, .01
			<0,2.1,.03>, .01
			no_shadow
		}
		texture {
			pigment {
				bozo
				color_map {
					[0 rgb .05]
					[.4 rgb .2]
					[1 rgb .5*<.5,1,.5>]
				}
				warp {
					turbulence .8
					octaves 4
					omega .6
					lambda 4
				}
				scale .004
			}
			normal {
				dents 2
				scale .02
			}
		}
	}
	
	sphere_sweep {
	  //linear_spline                 // linear curve
	  cubic_spline                // alternative spline curves
	  //b_spline
	  6,                            // number of specified sphere positions
	  light_pos+<-.03, 0, .03>, .001                // position, radius
	  light_pos+<-.03, 0, .03>, .001                // position, radius
	  <-.001,2.26,.01>, .001                 // ...
	  <.001,2.26,-.01>, .001
	  light_pos+<.03, 0, -.03>, .001
	  light_pos+<.03, 0, -.03>, .001
	  //tolerance 0.00000001             // optional 
	  pigment {rgb 1}
	  no_shadow // so small that shadow should be inconsequential
	}
	
	/*#declare cordshadow = disc { // fake blurred shadow from cord on ceiling
		0,y,1
		pigment {
			spherical
			color_map {
				[0 rgbt <0,0,0,1>]
				[1 rgbt <0,0,0,.35>]
			}
			cubic_wave
			warp {
				turbulence .2
				octaves 4
				omega .4
				lambda 3
			}
			scale .5
		}
		hollow
		no_shadow
	}
	// transparent objects in fog cause shadows. It's a bug. So i turn off their shadows and use the actual objects real close to the ceiling.
	object {
		cordshadow
		scale 3
		translate 2.998*y
	}
	object {
		cordshadow
		scale .7
		translate 2.999*y
	}*/
#end //usebulb

// ---------------------------------------- Door
union {
	difference {
		//This Door has spacing between the door and walls. It was causing artifacts.
		/*box {<-.7495,-.0495,2.5>,<.2495,1.9995,2.75>}
		box {<-.6495,1.2005,2.55>,<.1495,1.8995,0>}
		box {<-.6495,.1595,2.55>,<.1495,1.1005,0>}
		box {<-.5,1.6,-5>,<0,1.5,5>}*/
		
		//This door is flush with the walls and floor but artifact free :)
		box {<-.75,-.05,2.5>,<.25,2.01,2.75>} // base
		box {<-.65,1.2,2.55>,<.15,1.9,0>} // top hole
		box {<-.65,.16,2.55>,<.15,1.1,0>} // bottom hole
		box {<-.5,1.6,-5>,<0,1.5,5>} // window
	}
	cylinder { // not sure what these are, but they blocked my light source so i moved them =)
				// They're supposed to be window bars. I think I fixed 'em.
				// yup. They're better now. Couldn't tell earlier, sorry =)
		<-.25,1.7,2.65>,  <-.25,1.4,2.65>,  .015
		pigment {color Black}
	}
	cylinder {
		<-.375,1.7,2.65>,  <-.375,1.4,2.65>,  .015
		//pigment {color Black}
	}
	cylinder {
		<-.125,1.7,2.65>,  <-.125,1.4,2.65>,  .015
		//pigment {color Black}
	}

	texture {
		#declare basedoorpattern = // allows us to turbulate the pattern without the textures contained in it
			pigment {
				bozo
				color_map {[0 rgb 0][1 rgb 1]}
				warp {
					turbulence .4
					octaves 6
					lambda 2.5
					omega .5
				}
				scale <.05,.1,.1>*3
				translate -z*2.55*2
			}
		pigment_pattern {basedoorpattern}
		#declare rustthreshold = .73;
		#declare doornormal = normal {
			#declare basefunc = function{pattern{pigment_pattern {basedoorpattern}}};
			#declare doornormalmainfunc = function(a){select(a-rustthreshold,1/((rustthreshold-a)/.3+1),0)}; // make it slope up near where the rust starts, like paint peeling
			function {doornormalmainfunc(basefunc(x,y,z))*.8 + f_noise3d(x,y,z)*.2}
			//bozo .2 scale .08
		}
		#declare doorfinish = finish {
			specular .3
			roughness .007
			//phong 0.9 phong_size 100
		}
		texture_map {
			[0    pigment{rgb <.15,.17,.15>*.5} finish {doorfinish} normal{doornormal}]
			[rustthreshold-.04 pigment{rgb <.15,.17,.15>} finish {doorfinish} normal{doornormal}]
			[rustthreshold+.01  pigment{rgb <.5,.25,0>*.07} normal{doornormal}]
			[1    pigment{rgb <.5,.25,0>*.04} normal{doornormal}]
		}
	}
}

// ---------------------------------------- Outside light and beam of light

#declare beamstartpos = <-1.1,2.05,5>; // moving this may require adjusting the beams, which are not based on the exact corners of the window in the door.
//#declare beamcolor = <1,.955,.93>*3; //decided to go with a cooler inside color and a warmer outside color to fit with the lonliness theme.
#declare beamcolor = <1,.9,.8>*3;

#declare beamz = 2.5;

#declare beamtop = 1.56;
#declare beambottom = 1.485;

#declare barthickness = .0155;
#declare bar1pos = -.375+.049;
#declare bar2pos = -.25+.05;
#declare bar3pos = -.125+.051;

#declare beam1left = -.44;
#declare beam2left = bar1pos+barthickness;
#declare beam3left = bar2pos+barthickness;
#declare beam4left = bar3pos+barthickness;
#declare beam1right = bar1pos-barthickness;
#declare beam2right = bar2pos-barthickness;
#declare beam3right = bar3pos-barthickness;
#declare beam4right = .026;
#declare beamdist = 7.3;

//background {rgb beamcolor*.2} // for light outside door

light_source {
	beamstartpos
	rgb beamcolor
	
	#if (usebeamarealight)
		area_light
		x*.025,y*.025,5,5
		adaptive 1
		circular orient
	#end
	
	spotlight // points at the window and nothing else; should speed calculation in other areas of the scene since it's an area light
	point_at <-.22,1.5325,2.5>
	falloff 7.5
	radius 7.5
}

#if (usebeammedia)
	mesh {
		#macro makebeamside(start,d,p1,p2)
			triangle {
				vnormalize(p1-start)*d+start,
				vnormalize(p2-start)*d+start,
				start
			}
		#end
		#macro makebeam(start,d,top,btm,left,rght)
			makebeamside(start,d,<left,btm,beamz>,<left,top,beamz>)
			makebeamside(start,d,<left,top,beamz>,<rght,top,beamz>)
			makebeamside(start,d,<rght,top,beamz>,<rght,btm,beamz>)
			makebeamside(start,d,<rght,btm,beamz>,<left,btm,beamz>)
			triangle {
				vnormalize(<left,top,beamz>-start)*d+start,
				vnormalize(<rght,top,beamz>-start)*d+start,
				vnormalize(<rght,btm,beamz>-start)*d+start
			}
			triangle {
				vnormalize(<left,top,beamz>-start)*d+start,
				vnormalize(<left,btm,beamz>-start)*d+start,
				vnormalize(<rght,btm,beamz>-start)*d+start
			}
		#end
		makebeam(beamstartpos,beamdist, beamtop,beambottom, beam1left,beam1right)
		makebeam(beamstartpos,beamdist, beamtop,beambottom, beam2left,beam2right)
		makebeam(beamstartpos,beamdist, beamtop,beambottom, beam3left,beam3right)
		makebeam(beamstartpos,beamdist, beamtop,beambottom, beam4left,beam4right)
		pigment {//rgbt 1}
		         rgb beamcolor/3 transmit 1 // does this really make a difference, since it's 100% transmitted anyway?
		         //rgb 1
		}
		interior {
			media {
				emission .05* beamcolor
				density {
					spherical
					color_map {
						[0 rgb 0]
						[.7 rgb 1]
					}
					cubic_wave
					scale beamdist
					translate beamstartpos
				}
			}
		}
		hollow
		no_shadow
	}
#end

// ---------------------------------------- Back Wall
 difference {
        object {Wall translate <-2.5,-2.25,3>}
        box {<-.75,-.05,-5>,<.25,2,5>} // door space
 }

// ---------------------------------------- Left Wall
object {Wall rotate y*90  translate <-2.5,-2.25, 3.25>}

// ---------------------------------------- Right Wall
object {Wall rotate y*90  translate < 2.5,-2.25, 3.25>}

// ---------------------------------------- Front Wall (behind camera)
object {Wall              translate <-2.5,-2.25, -3>}

// ---------------------------------------- Mattress
#declare mattressandinmate = union {
	union {
		superellipsoid { <.2, .2> 
		  texture {
		    pigment {
		    	#declare line1pig = pigment {
			    	checker White, <.4,.4,1>
				    scale <100,100,.04>
				    translate <5,50,.03>
		    	}
		    	#declare line2pig = pigment {
			    	checker White, <.4,.4,1>
				    scale <100,.04/.19,100>
				    translate <5,.03,50>
		    	}
		    	#declare seampig = pigment {
		    		rgb .03
		    	}
		    	pigment_pattern {
		    		gradient y
		    		scale 2*y
		    		translate -y
		    	}
		    	#declare seamsize = .05;
		    	#declare distfromedges = .18;
		    	pigment_map {
		    		[distfromedges-seamsize/2 line1pig]
		    		[distfromedges-seamsize/2 seampig]
		    		[distfromedges+seamsize/2 seampig]
		    		[distfromedges+seamsize/2 line2pig]
		    		[1-distfromedges-seamsize/2 line2pig]
		    		[1-distfromedges-seamsize/2 seampig]
		    		[1-distfromedges+seamsize/2 seampig]
		    		[1-distfromedges+seamsize/2 line1pig]
		    	}
			}
		  }
		  texture {
		    pigment {
		      		bozo
		  		color_map {
		  			[0 rgbf  <.5,.4,.4,1>]
		  			[.3 rgbf <.3,.2,.1,1>]
		  			[.6 rgbf <.3,.2,0,.8>]
					[1 rgbf  <.2,.1,0,0>]
		  		}                
		  		warp {
		  			turbulence .4
		  			octaves 8
		  			lambda 5
		  			omega .7
		  		}
		  		scale .3
		    }
		  }
		  scale <1, .19, .52>
		  translate <.65,.05+.19,-1.6>
		  rotate y*-12
		}
		
		// ---------------------------------------- Blanket
		
		height_field {
			jpeg "blankethf.jpg"
			smooth
			
			texture {
				function {min(x,z,1-x,1-z)}
				texture_map {
					[.05 // lining
						pigment{
							rgb <.15,.12,.03>
						}
						finish {
							specular .05
							roughness .1
						}
						normal {
							function {min(x,z,1-x,1-z)} 2
							slope_map {
								[0 <0,.3>]
								//[.02 <1,0>]
								[.025 <.01,0>]
								[.05 <0,-.3>]
							}
						}
					]
					[.05 // blanket part
						pigment{
						/*	pigment_pattern {
								bozo
								color_map {[0 rgb 0][1 rgb 1]}
								warp {
									turbulence .5
									octaves 4
									omega .4
									lambda 3
								}
								scale .15
							}
							pigment_map {
								[.55 // plaid
									#declare plaidfunc = function(a,b) {select(a-.5,select(b-.5,0,.25),select(b-.5,.5,.75))}
									function {plaidfunc(x-int(x),z-int(z))}
									color_map {
										[0 rgb <.4,.4,.5>]
										[.25 rgb <.5,.4,.4>]
										[.5 rgb <0,0,0>]
										[.75 rgb <1,1,1>]
									}
									scale 1/12
								]
								[.8 // discoloration
									rgb <.25,.125,0>
								]
							}*/
												
							rgb <.15,.12,.03>
						
						}
						normal { // sort of fuzzy from a distance
							bozo 5
							warp {
								turbulence 2
								octaves 6
								omega .6
								lambda 4
							}
							scale .1
						}
					]
				}
			}
			
			translate <-.5,0,-.5>
			scale <1,.69,1>*230/190*.52*2 * 1.2
			rotate (35+90)*y
			translate <1,.0501,-1.4>
		}
		translate -<1,0,-1.4> // back to origin or so
		rotate -11*y
		translate <.8,0,-1.4>
	}
	#if (usehair)
		#declare headpos = <1.46,.57,-2>;
		sphere { // head
			headpos,.2
			pigment {rgb 0}
		}
	#end
}
object {mattressandinmate}

// ---------------------------------------- Inmate's Hair

#if (usehair)
	// headpos defined just above
	
	/*#declare mattressandinmate = union {
		object {mattressandinmate}
		sphere { // head
			headpos,.2
		}
	}*/
	
	#macro makehair(start,overalldir,startdir,length,hairthickness,numsteps)
		#declare lengthsofar = 0;
		#declare pos = start;
		#declare distperstep = length/numsteps; // distance between each point in the sphere sweep
		#declare followingblanket = no; // is the hair in the air or laying on the blanket?
		sphere_sweep {
			cubic_spline
			numsteps+2,
			start-vnormalize(startdir)*distperstep,hairthickness, // a point inside the head
			start,hairthickness // starting point
			#declare thisstep = 0;
			#while (thisstep < numsteps)
				#declare dir = vnormalize(startdir*pow((1-lengthsofar/length),2)*.5 + overalldir*(lengthsofar/length)); // find the direction with respect to the starting direction and overall direction the hair should go in
				#declare dir = dir-y*.7; // gravity
				#declare dir = dir + vnormalize(<f_noise3d(pos.x*7,100,pos.z*7),0,f_noise3d(pos.x*7,200,pos.z*7)>*2-<1,0,1>)*.65*pow((lengthsofar/length),.5); // a little turbulence in the direction
				#declare dir = vnormalize(dir);
				
				#declare thenorm = <0,0,0>;
				#declare intpoint = trace(mattressandinmate,pos,dir,thenorm); // check to see if we hit the blanket or mattress (or head)
				#if (vlength(thenorm) > 0 & vlength(intpoint-pos) < distperstep)
					#declare followingblanket = yes; // if we did, just follow it from now on
				#end
				
				#if (followingblanket) // is the hair is merely lying on the blanket/mattress?
					#declare intpoint = trace(mattressandinmate,pos+vnormalize(dir*<1,0,1>)*distperstep+y*.1,-y,thenorm); // find the next part of the blanket to lie on
					#if (vlength(thenorm) > 0)
						#declare lengthsofar = lengthsofar + vlength(intpoint-pos);
						#declare pos = intpoint + thisradius*y; // lie on it
					#else
						#declare followingblanket = no; // if we found no point to lie on, just do the normal thing
						#declare pos = pos + distperstep*dir;
						#declare lengthsofar = lengthsofar + distperstep;
					#end
				#else
					#declare pos = pos + distperstep*dir; // if we're not on the blanket, just follow the dir
					#declare lengthsofar = lengthsofar + distperstep;
				#end
				
				#declare thisradius = hairthickness*(1-lengthsofar/length);
				
				,pos,thisradius // put the point in the sphere sweep
				
				#declare thisstep = thisstep + 1;
			#end
			
			// I thought some white streaks and a bit of randomness would be nice
			#if (rand(hairrnd2) < .2)
			  pigment {rgb <.75,.7,.8>*(1+rand(hairrnd2))}
			#else
			  pigment {rgb <.15,.125,.1>*(1.5+rand(hairrnd2))}
			#end	
		}
	#end
	
	union { // create the hairs:
		#declare numhairs = 160;
		#declare hairnum = 0;
		#declare hairrnd = seed(861);
		#declare hairrnd2 = seed(42);
		#while (hairnum < numhairs)
			#declare thishairposbase = VRand_In_Sphere(hairrnd)*.2+headpos+y*.2001;
			#declare thishairpos = vnormalize(thishairposbase-headpos)*.2+headpos; // selects a point on the "head" (which is a sphere around the point headpos with radius .2)
			makehair(
				thishairpos, // hair starts here
				<-1,0,.5>, // hair goes in this general direction
				vnormalize(y+vnormalize(thishairpos-headpos))*.5, // hair comes out of the head in this direction; partially straight up, partially straight out of the head (sphere)
				.55+(rand(hairrnd2)/10), // length of hair
				.006,//.007, // thickness of hair at base
				11) // number of points in the sphere sweep to make up the hair
			#declare hairnum = hairnum + 1;
		#end
		texture {
			//pigment {rgb <.3,.18,0>*1.5} // pigment now specified per sphere sweep
			finish {
				specular .4
				roughness .015
			}
		}
	}                                      
#end

#if (usedrain)
	#declare drain = union {
		difference {	
			cylinder {
				drain_pos-.06*y,
				drain_pos+.001*y,
				drain_rad
			}
			cylinder {
				drain_pos-.101*y,
				drain_pos+.002*y,
				drain_rad - .07*5/6
			}
		}
		difference {
			union {
				#declare numingrid = 13;
				#declare gridthickness = .009*5/6;
				#declare gridboxnum = 0;
				#while (gridboxnum < numingrid)
					#declare centerpos = drain_rad*(gridboxnum/(numingrid-1)*2-1);
					box {
						drain_pos+<centerpos-gridthickness,-.02,-drain_rad>,drain_pos+<centerpos+gridthickness,-.04,drain_rad>
					}
					box {
						drain_pos+<-drain_rad,-.02,centerpos-gridthickness>,drain_pos+<drain_rad,-.04,centerpos+gridthickness>
					}
					#declare gridboxnum = gridboxnum + 1;
				#end
				cylinder {
					drain_pos-.04*y,
					drain_pos-.01*y,
					.09*5/6
				}
			}
			cylinder {
				drain_pos-.02*y,
				drain_pos,
				.075*5/6
			}
		}
		prism { // random logoish looking thing
			linear_spline
			-1,0
			11,
			<.3,.7>,<.2,.6>,<.25,.9>,<.9,.4>,<.1,.3>,<.7,.8>,<.35,.2>,<.4,.85>,<.5,.6>,<.7,.9>,<.3,.7>
			translate <-.5,0,-.5>
			scale .075*2*<1,0,1>*5/6+.03*y
			translate drain_pos-.01*y
		}
		translate -.03*y
		texture {
			pigment {
				bozo
				color_map {
					[.1 rgb <.5,.25,0>*1.1]
					[.55 rgb <.55,.2,0>*.035]
					[.85 rgb <.3,.56,.1>*.65]
				}
				warp {
					turbulence 1.5
					octaves 5
					omega .65
					lambda 5
				}
				scale .2
				translate 2
			}
		}
	}
	object {drain}
#end

// ---------------------------------------- Light emission

#if (usemedia)
	intersection {
		#declare scaleamnt = .6;
		sphere {
			0,1
			scale scaleamnt
		}
		plane {
			y,(3-light_pos.y)-.002 // avoids sphere intersection with ceiling, which appears to be buggy causing a shadow because of the absorption, regardless of the no_shadow.
		}
		cone { // cuts out the part that is in shadow of the top of the light's cage
			.15*y,.08,
			scaleamnt*y,.08/.15*scaleamnt
			rotate -5*x
			inverse
		}
		pigment {rgbt 1}
		interior {
			media {
				// simulate scattering media by using emission and black fog
				#declare meddensity = .25;
				emission meddensity * light_col
				
				method 3
				samples 100,100
				
				density {
					spherical
					cubic_wave
				}
				density {
					#declare basespherefunc2 = function (x,y,z,a) {f_noise3d(x*a,y*a,z*a)};
					function {basespherefunc2(x,y,z,4/sqrt(x*x+y*y+z*z))}
					cubic_wave
				}
				/*density {
					bozo
					color_map {[.2 rgb 0][1 rgb 1]}
					scale .4
				}*/
				scale scaleamnt
			}
		}
		hollow
		no_shadow
		translate light_pos
	}
#end

#if (usefog)
	fog {
		distance 2
		color rgb 0
	}
#end