//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Scan surface Method macr ver 0.1r000419a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
#macro Scan_write(File_name,Comment)
 #fopen Scan_data File_name write
 #write (Scan_data,Scmax,",",Sdmax,",\n")
 #local Sj=0; #while(Sj<Scmax) #local Si=0; #while(Si<Sdmax)
  #write (Scan_data,Vp[Sj][Si].x,",",Vp[Sj][Si].y,",",Vp[Sj][Si].z,",")
  #if(mod(Si+1,Sdmax)=0 & Sj+1!=Scmax) #write (Scan_data,"\n") #end
 #local Si=Si+1; #end #local Sj=Sj+1; #end
 #write (Scan_data,"\n","\"",Comment,"\"",","," By S.Nishimura")
 #fclose Scan_data 
#end
//----------------------------------------------------------------------------------
#macro Scan_read(File_name)
 #fopen Scan_data File_name read
 #read (Scan_data,Scmax,Sdmax)
 #declare Vp=array[Scmax][Sdmax]
 #local Sj=0; #while(Sj<Scmax) #local Si=0; #while(Si<Sdmax)
  #read (Scan_data,Pvx,Pvy,Pvz) #declare Vp[Sj][Si]=<Pvx,Pvy,Pvz>;
 #local Si=Si+1; #end #local Sj=Sj+1; #end
 #fclose Scan_data 
#end
//**********************************************************************************
#macro RtoSpherical_coordinates(Pv)
 #local RR=vlength(Pv); #local Rh=vlength(<Pv.x,0,Pv.z>);
 #if(Rh!=0) 
  #if(Pv.z/Rh>=0) #local Sg=1; #else #local Sg=-1; #end
  #local HH=Sg*acos(Pv.x/Rh);
 #else #local HH=0; #end
 #if(RR!=0)
  #if(Pv.y/RR>=0) #local Sg=1; #else #local Sg=-1; #end 
  #local VV=Sg*acos(Rh/RR);
 #else #local VV=0; #end
 #local Pv=<RR,HH,VV>;
#end
//**********************************************************************************
#macro Coordinate_convert(Cnv_type,Sv0,Pv0,Pv)
 #switch(Cnv_type)
  #case(1) #local Pv=vrotate(Pv,<0,degrees(Sv0.y),0>); #break //height scan
  #case(2) #if(Sv0.y=pi) #local Pv=vrotate(Pv,<0,180,0>); #end #break //line scan
 #end
 #local Pv=vrotate(Pv,<0,0,degrees(Sv0.z)>);
 #local Pv=vrotate(Pv,<0,-degrees(Sv0.y),0>);
 #local Pv=Pv+Pv0;
#end
//**********************************************************************************
#macro Normal_vector(Tp1,Tp2,Tp3,Vn)
 #local Va=Tp3-Tp2; #local Vb=Tp2-Tp1;
 #local Lx=Va.y*Vb.z-Va.z*Vb.y; #local My=Va.z*Vb.x-Va.x*Vb.z; #local Nz=Va.x*Vb.y-Va.y*Vb.x;
 #local Dc=-Tp1.x*Lx-Tp1.y*My-Tp1.z*Nz;
 #if(Dc>=0) #local Sg=1; #else #local Sg=-1; #end
 #local Vn=<-Lx*Sg,-My*Sg,-Nz*Sg>; #if(vlength(Vn)=0) #local Vn=<0,0,1>; #end
#end
//**********************************************************************************
// sample functions
/*
#macro Line_function(Tp,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px=20*sin(Tp); #local Py=10*Tp; #local Pz=0; #break    // sin
  #case(2) #local Px=5*cos(Tp); #local Py=0; #local Pz=5*sin(Tp); #break // start circle
  #case(3) #local Px=1*cos(Tp); #local Py=0; #local Pz=1*sin(Tp); #break // end circle

  #case(4) #local Px=0; #local Py=10*Tp; #local Pz=0; #break              // line
  #case(5) #local Px=0*cos(Tp); #local Py=0; #local Pz=0*sin(Tp); #break  //1 start circle
  #range(6,10) #local Px=6*cos(Tp); #local Py=0; #local Pz=6*sin(Tp); #break
  #case(11) #local Px=2*cos(Tp); #local Py=0; #local Pz=2*sin(Tp); #break //7 end circle

  #case(12) #local Px=0; #local Py=-5*Tp; #local Pz=0; #break // line
 #end
#end
*/
//**********************************************************************************
#macro Scan_trif3(V1,V2,Func_type) // mesh triangle
#local Ts=V2.x; #local Te=V2.y; #local Ta=V2.z; #local Section_sf=Func_type+1; #local Section_ef=Func_type+2;
#local Px=0; #local Py=0; #local Pz=0;
 mesh {
 Line_function(Ts,   Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #while(Ts<Te)
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
  #local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
  #while(Sp<Ep)
   Line_function(Sp,   Px,Py,Pz,Section_sf) #local Ps=<Px,Py,Pz>;
   Line_function(Sp,   Px,Py,Pz,Section_ef) #local Pe=<Px,Py,Pz>;
   #local Pv=Ps+(Pe-Ps)*(Ts-V2.x+Ta*0)/(Te-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;
   #local Pv=Ps+(Pe-Ps)*(Ts-V2.x+Ta*1)/(Te-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Section_sf) #local Ps=<Px,Py,Pz>;
   Line_function(Sp+Ap,Px,Py,Pz,Section_ef) #local Pe=<Px,Py,Pz>;
   #local Pv=Ps+(Pe-Ps)*(Ts-V2.x+Ta*0)/(Te-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;
   #local Pv=Ps+(Pe-Ps)*(Ts-V2.x+Ta*1)/(Te-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   triangle { Pd11, Pd12, Pd22 }
   triangle { Pd11, Pd21, Pd22 }
  #local Sp=Sp+Ap; #end
 #local Ts=Ts+Ta; #local P1=P2; #local P2=P3; #local S1=S2; #end
 }
#end
//**********************************************************************************
#macro Scan_strif3(V1,V2,Func_type) // mesh smooth triangle
#local Smax=6; #local Pmax=4; #local Snv=array[Pmax][Smax]
#local Ts=V2.x; #local Te=V2.y; #local Ta=V2.z; #local Section_sf=Func_type+1; #local Section_ef=Func_type+2;
#local Px=0; #local Py=0; #local Pz=0; #local Vn=<0,0,0>;
 mesh {
 Line_function(Ts-Ta,  Px,Py,Pz,Func_type) #local P0=<Px,Py,Pz>;
 Line_function(Ts,     Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,  Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P1-P0; RtoSpherical_coordinates(Pv) #local S0=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
 #while(Ts<Te)
 Line_function(Ts+Ta*3,Px,Py,Pz,Func_type) #local P4=<Px,Py,Pz>;
 #local Pv=P4-P3; RtoSpherical_coordinates(Pv) #local S3=<Pv.x,Pv.y,Pv.z-pi/2>;
  #local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
  #while(Sp<Ep)
   Line_function(Sp,   Px,Py,Pz,Section_sf) #local Ps1=<Px,Py,Pz>;
   Line_function(Sp,   Px,Py,Pz,Section_ef) #local Pe1=<Px,Py,Pz>;
   #local Pv=Ps1+(Pe1-Ps1)*(Ts-V2.x+Ta*0)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;
   #local Pv=Ps1+(Pe1-Ps1)*(Ts-V2.x+Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Section_sf) #local Ps2=<Px,Py,Pz>;
   Line_function(Sp+Ap,Px,Py,Pz,Section_ef) #local Pe2=<Px,Py,Pz>;
   #local Pv=Ps2+(Pe2-Ps2)*(Ts-V2.x+Ta*0)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;
   #local Pv=Ps2+(Pe2-Ps2)*(Ts-V2.x+Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   // Pd11
   #local Pv=Ps1+(Pe1-Ps1)*(Ts-V2.x-Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   Line_function(Sp-Ap,Px,Py,Pz,Section_sf) #local Ps0=<Px,Py,Pz>;
   Line_function(Sp-Ap,Px,Py,Pz,Section_ef) #local Pe0=<Px,Py,Pz>;
   #local Pv=Ps0+(Pe0-Ps0)*(Ts-V2.x-Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   #local Pv=Ps0+(Pe0-Ps0)*(Ts-V2.x+Ta*0)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd03=Pv;
   Normal_vector(Pd02, Pd11, Pd01, Vn) #local Snv[0][0]=Vn;
   Normal_vector(Pd02, Pd03, Pd11, Vn) #local Snv[0][1]=Vn;
   Normal_vector(Pd03, Pd12, Pd11, Vn) #local Snv[0][2]=Vn;
   Normal_vector(Pd11, Pd12, Pd22, Vn) #local Snv[0][3]=Vn;
   Normal_vector(Pd11, Pd22, Pd21, Vn) #local Snv[0][4]=Vn;
   Normal_vector(Pd01, Pd11, Pd21, Vn) #local Snv[0][5]=Vn;
   #local Nv11=(Snv[0][0]+Snv[0][1]+Snv[0][2]+Snv[0][3]+Snv[0][4]+Snv[0][5])/Smax;
   // Pd12
   #local Pd02=Pd03;
   #local Pv=Ps0+(Pe0-Ps0)*(Ts-V2.x+Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd03=Pv;
   #local Pv=Ps1+(Pe1-Ps1)*(Ts-V2.x+Ta*2)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd04=Pv;
   #local Pv=Ps2+(Pe2-Ps2)*(Ts-V2.x+Ta*2)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv;
   #local Snv[1][0]=Snv[0][2];
   Normal_vector(Pd02, Pd03, Pd12, Vn) #local Snv[1][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd12, Vn) #local Snv[1][2]=Vn;
   Normal_vector(Pd12, Pd04, Pd05, Vn) #local Snv[1][3]=Vn;
   Normal_vector(Pd12, Pd05, Pd22, Vn) #local Snv[1][4]=Vn;
   #local Snv[1][5]=Snv[0][3];
   #local Nv12=(Snv[1][0]+Snv[1][1]+Snv[1][2]+Snv[1][3]+Snv[1][4]+Snv[1][5])/Smax;
   // Pd22
   #local Pd04=Pd05;
   Line_function(Sp+Ap*2,Px,Py,Pz,Section_sf) #local Ps3=<Px,Py,Pz>;
   Line_function(Sp+Ap*2,Px,Py,Pz,Section_ef) #local Pe3=<Px,Py,Pz>;
   #local Pv=Ps3+(Pe3-Ps3)*(Ts-V2.x+Ta*2)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv; 
   #local Pv=Ps3+(Pe3-Ps3)*(Ts-V2.x+Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd06=Pv;
   #local Snv[2][0]=Snv[0][4];
   #local Snv[2][1]=Snv[0][3];
   #local Snv[2][2]=Snv[1][4];
   Normal_vector(Pd22, Pd04, Pd05, Vn) #local Snv[2][3]=Vn;
   Normal_vector(Pd22, Pd05, Pd06, Vn) #local Snv[2][4]=Vn;
   Normal_vector(Pd21, Pd22, Pd06, Vn) #local Snv[2][5]=Vn;
   #local Nv22=(Snv[2][0]+Snv[2][1]+Snv[2][2]+Snv[2][3]+Snv[2][4]+Snv[2][5])/Smax;
   // Pd21
   #local Pv=Ps2+(Pe2-Ps2)*(Ts-V2.x-Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   #local Pv=Ps1+(Pe1-Ps1)*(Ts-V2.x-Ta*1)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   #local Pd05=Pd06;
   #local Pv=Ps3+(Pe3-Ps3)*(Ts-V2.x+Ta*0)/(V2.y-V2.x); Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd06=Pv;
   Normal_vector(Pd02, Pd21, Pd01, Vn) #local Snv[3][0]=Vn;
   #local Snv[3][1]=Snv[0][5];
   #local Snv[3][2]=Snv[0][4];
   #local Snv[3][3]=Snv[2][5];
   Normal_vector(Pd21, Pd05, Pd06, Vn) #local Snv[3][4]=Vn;
   Normal_vector(Pd01, Pd21, Pd06, Vn) #local Snv[3][5]=Vn;
   #local Nv21=(Snv[3][0]+Snv[3][1]+Snv[3][2]+Snv[3][3]+Snv[3][4]+Snv[3][5])/Smax;
   //
   smooth_triangle { Pd11,Nv11, Pd12,Nv12, Pd22,Nv22 }
   smooth_triangle { Pd11,Nv11, Pd22,Nv22, Pd21,Nv21 }
  #local Sp=Sp+Ap; #end
 #local P0=P1; #local P1=P2; #local P2=P3; #local P3=P4; #local S0=S1; #local S1=S2; #local S2=S3;
 #local Ts=Ts+Ta; #end
 }
#end
//**********************************************************************************
#macro Scan_trifn(V1,V2,Func_type) // mesh triangle
#local Ts=V2.x; #local Te=V2.y; #local Ta=V2.z; #local Sf=Func_type+1;
#local Px=0; #local Py=0; #local Pz=0; 
 mesh {
 Line_function(Ts,   Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #while(Ts<Te)
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
  #local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
  #while(Sp<Ep)
   Line_function(Sp,   Px,Py,Pz,Sf+0) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;
   Line_function(Sp,   Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Sf+0) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   triangle { Pd11, Pd12, Pd22 }
   triangle { Pd11, Pd21, Pd22 }
  #local Sp=Sp+Ap; #end
 #local Ts=Ts+Ta; #local Sf=Sf+1; #local P1=P2; #local P2=P3; #local S1=S2; #end
 }
#end
//**********************************************************************************
#macro Scan_strifn(V1,V2,Func_type) // mesh smooth triangle
#local Smax=6; #local Pmax=4; #local Snv=array[Pmax][Smax]
#local Ts=V2.x; #local Te=V2.y; #local Ta=V2.z; #local Sf=Func_type+1;
#local Px=0; #local Py=0; #local Pz=0; #local Vn=<0,0,0>; 
 mesh {
 Line_function(Ts-Ta,  Px,Py,Pz,Func_type) #local P0=<Px,Py,Pz>;
 Line_function(Ts,     Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,  Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P1-P0; RtoSpherical_coordinates(Pv) #local S0=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
 #while(Ts<Te)
 Line_function(Ts+Ta*3,Px,Py,Pz,Func_type) #local P4=<Px,Py,Pz>;
 #local Pv=P4-P3; RtoSpherical_coordinates(Pv) #local S3=<Pv.x,Pv.y,Pv.z-pi/2>;
 #if(Sf-1>Func_type) #local Sf_b=Sf-1; #else #local Sf_b=Sf; #end
 #if(Sf+2<Func_type+1+(Te-V2.x)/Ta+1) #local Sf_n=Sf+2; #else #local Sf_n=Sf+1; #end
  #local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
  #while(Sp<Ep)
   Line_function(Sp,   Px,Py,Pz,Sf+0) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;
   Line_function(Sp,   Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Sf+0) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   // Pd11
   Line_function(Sp,   Px,Py,Pz,Sf_b) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   Line_function(Sp-Ap,Px,Py,Pz,Sf_b) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   Line_function(Sp-Ap,Px,Py,Pz,Sf+0) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd03=Pv;
   Normal_vector(Pd02, Pd11, Pd01, Vn) #local Snv[0][0]=Vn;
   Normal_vector(Pd02, Pd03, Pd11, Vn) #local Snv[0][1]=Vn;
   Normal_vector(Pd03, Pd12, Pd11, Vn) #local Snv[0][2]=Vn;
   Normal_vector(Pd11, Pd12, Pd22, Vn) #local Snv[0][3]=Vn;
   Normal_vector(Pd11, Pd22, Pd21, Vn) #local Snv[0][4]=Vn;
   Normal_vector(Pd01, Pd11, Pd21, Vn) #local Snv[0][5]=Vn;
   #local Nv11=(Snv[0][0]+Snv[0][1]+Snv[0][2]+Snv[0][3]+Snv[0][4]+Snv[0][5])/Smax;
   // Pd12
   #local Pd02=Pd03;
   Line_function(Sp-Ap,Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd03=Pv;
   Line_function(Sp,   Px,Py,Pz,Sf_n) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd04=Pv;
   Line_function(Sp+Ap,Px,Py,Pz,Sf_n) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv;
   #local Snv[1][0]=Snv[0][2];
   Normal_vector(Pd02, Pd03, Pd12, Vn) #local Snv[1][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd12, Vn) #local Snv[1][2]=Vn;
   Normal_vector(Pd12, Pd04, Pd05, Vn) #local Snv[1][3]=Vn;
   Normal_vector(Pd12, Pd05, Pd22, Vn) #local Snv[1][4]=Vn;
   #local Snv[1][5]=Snv[0][3];
   #local Nv12=(Snv[1][0]+Snv[1][1]+Snv[1][2]+Snv[1][3]+Snv[1][4]+Snv[1][5])/Smax;
   // Pd22
   #local Pd04=Pd05;
   Line_function(Sp+Ap*2,Px,Py,Pz,Sf_n) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv; 
   Line_function(Sp+Ap*2,Px,Py,Pz,Sf+1) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd06=Pv;
   #local Snv[2][0]=Snv[0][4];
   #local Snv[2][1]=Snv[0][3];
   #local Snv[2][2]=Snv[1][4];
   Normal_vector(Pd22, Pd04, Pd05, Vn) #local Snv[2][3]=Vn;
   Normal_vector(Pd22, Pd05, Pd06, Vn) #local Snv[2][4]=Vn;
   Normal_vector(Pd21, Pd22, Pd06, Vn) #local Snv[2][5]=Vn;
   #local Nv22=(Snv[2][0]+Snv[2][1]+Snv[2][2]+Snv[2][3]+Snv[2][4]+Snv[2][5])/Smax;
   // Pd21
   Line_function(Sp+Ap,Px,Py,Pz,Sf_b) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   Line_function(Sp,   Px,Py,Pz,Sf_b) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   #local Pd05=Pd06;
   Line_function(Sp+Ap*2,Px,Py,Pz,Sf) #local Pv=<Px,Py,Pz>; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd06=Pv;
   Normal_vector(Pd02, Pd21, Pd01, Vn) #local Snv[3][0]=Vn;
   #local Snv[3][1]=Snv[0][5];
   #local Snv[3][2]=Snv[0][4];
   #local Snv[3][3]=Snv[2][5];
   Normal_vector(Pd21, Pd05, Pd06, Vn) #local Snv[3][4]=Vn;
   Normal_vector(Pd01, Pd21, Pd06, Vn) #local Snv[3][5]=Vn;
   #local Nv21=(Snv[3][0]+Snv[3][1]+Snv[3][2]+Snv[3][3]+Snv[3][4]+Snv[3][5])/Smax;
   //
   smooth_triangle { Pd11,Nv11, Pd12,Nv12, Pd22,Nv22 }
   smooth_triangle { Pd11,Nv11, Pd22,Nv22, Pd21,Nv21 }
  #local Sp=Sp+Ap; #end
 #local Sf=Sf+1; #local P0=P1; #local P1=P2; #local P2=P3; #local P3=P4; #local S0=S1; #local S1=S2; #local S2=S3;
 #local Ts=Ts+Ta; #end
 }
#end
//**********************************************************************************
#macro Scan_tridt(V1,V2,Func_type) // mesh triangle
#local Ts=V2.x; #local Te=V2.y; #local Ta=(Te-Ts)/(V1.x-1)+1e-12;
#local Px=0; #local Py=0; #local Pz=0; 
 mesh {
 Line_function(Ts,   Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Sc=0; #local Ec=V1.x-1;
 #while(Sc<Ec)
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
  #local Sd=0; #local Ed=V1.y-1;
  #while(Sd<Ed)
   #local Pv=Vp[Sc+0][Sd+0]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;   
   #local Pv=Vp[Sc+1][Sd+0]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;  
   #local Pv=Vp[Sc+0][Sd+1]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;    
   #local Pv=Vp[Sc+1][Sd+1]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   triangle { Pd11, Pd12, Pd22 }
   triangle { Pd11, Pd21, Pd22 }
  #local Sd=Sd+1; #end
 #local Ts=Ts+Ta; #local Sc=Sc+1; #local P1=P2; #local P2=P3; #local S1=S2; #end
 }
#end
//**********************************************************************************
#macro Scan_stridt(V1,V2,Func_type) // mesh smooth triangle
#local Smax=6; #local Pmax=4; #local Snv=array[Pmax][Smax]
#local Ts=V2.x; #local Te=V2.y; #local Ta=(Te-Ts)/(V1.x-1)+1e-12;
#local Px=0; #local Py=0; #local Pz=0; #local Vn=<0,0,0>; 
 mesh {
 Line_function(Ts-Ta,  Px,Py,Pz,Func_type) #local P0=<Px,Py,Pz>;
 Line_function(Ts,     Px,Py,Pz,Func_type) #local P1=<Px,Py,Pz>;
 Line_function(Ts+Ta,  Px,Py,Pz,Func_type) #local P2=<Px,Py,Pz>;
 Line_function(Ts+Ta*2,Px,Py,Pz,Func_type) #local P3=<Px,Py,Pz>;
 #local Pv=P1-P0; RtoSpherical_coordinates(Pv) #local S0=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv) #local S1=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Pv=P3-P2; RtoSpherical_coordinates(Pv) #local S2=<Pv.x,Pv.y,Pv.z-pi/2>;
 #local Sc=0; #local Ec=V1.x-1;
 #while(Sc<Ec)
 Line_function(Ts+Ta*3,Px,Py,Pz,Func_type) #local P4=<Px,Py,Pz>;
 #local Pv=P4-P3; RtoSpherical_coordinates(Pv) #local S3=<Pv.x,Pv.y,Pv.z-pi/2>;
  #if(Ts>V2.x) #local Sc_b=Sc-1; #else #local Sc_b=0; #end
  #if(Ts<Te-Ta) #local Sc_n=Sc+2; #else #local Sc_n=Sc+1; #end
  #local Sd=0; #local Ed=V1.y-1;
  #while(Sd<Ed)
   #if(Sd>0) #local Sd_b=Sd-1; #else #local Sd_b=0; #end
   #if(Sd<Ed-1) #local Sd_n=Sd+2; #else #local Sd_n=Ed; #end
   //
   #local Pv=Vp[Sc+0][Sd+0]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd11=Pv;   
   #local Pv=Vp[Sc+1][Sd+0]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd12=Pv;  
   #local Pv=Vp[Sc+0][Sd+1]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd21=Pv;    
   #local Pv=Vp[Sc+1][Sd+1]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd22=Pv;
   // Pd11
   #local Pv=Vp[Sc_b][Sd+0]; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   #local Pv=Vp[Sc_b][Sd_b]; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   #local Pv=Vp[Sc+0][Sd_b]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd03=Pv;
   Normal_vector(Pd02, Pd11, Pd01, Vn) #local Snv[0][0]=Vn;
   Normal_vector(Pd02, Pd03, Pd11, Vn) #local Snv[0][1]=Vn;
   Normal_vector(Pd03, Pd12, Pd11, Vn) #local Snv[0][2]=Vn;
   Normal_vector(Pd11, Pd12, Pd22, Vn) #local Snv[0][3]=Vn;
   Normal_vector(Pd11, Pd22, Pd21, Vn) #local Snv[0][4]=Vn;
   Normal_vector(Pd01, Pd11, Pd21, Vn) #local Snv[0][5]=Vn;
   #local Nv11=(Snv[0][0]+Snv[0][1]+Snv[0][2]+Snv[0][3]+Snv[0][4]+Snv[0][5])/Smax;
   // Pd12
   #local Pd02=Pd03;
   #local Pv=Vp[Sc+1][Sd_b]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd03=Pv;
   #local Pv=Vp[Sc_n][Sd+0]; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd04=Pv;
   #local Pv=Vp[Sc_n][Sd+1]; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv;
   #local Snv[1][0]=Snv[0][2];
   Normal_vector(Pd02, Pd03, Pd12, Vn) #local Snv[1][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd12, Vn) #local Snv[1][2]=Vn;
   Normal_vector(Pd12, Pd04, Pd05, Vn) #local Snv[1][3]=Vn;
   Normal_vector(Pd12, Pd05, Pd22, Vn) #local Snv[1][4]=Vn;
   #local Snv[1][5]=Snv[0][3];
   #local Nv12=(Snv[1][0]+Snv[1][1]+Snv[1][2]+Snv[1][3]+Snv[1][4]+Snv[1][5])/Smax;
   // Pd22
   #local Pd04=Pd05;
   #local Pv=Vp[Sc_n][Sd_n]; Coordinate_convert(Cnv_type,S3,P3,Pv) #local Pd05=Pv; 
   #local Pv=Vp[Sc+1][Sd_n]; Coordinate_convert(Cnv_type,S2,P2,Pv) #local Pd06=Pv;
   #local Snv[2][0]=Snv[0][4];
   #local Snv[2][1]=Snv[0][3];
   #local Snv[2][2]=Snv[1][4];
   Normal_vector(Pd22, Pd04, Pd05, Vn) #local Snv[2][3]=Vn;
   Normal_vector(Pd22, Pd05, Pd06, Vn) #local Snv[2][4]=Vn;
   Normal_vector(Pd21, Pd22, Pd06, Vn) #local Snv[2][5]=Vn;
   #local Nv22=(Snv[2][0]+Snv[2][1]+Snv[2][2]+Snv[2][3]+Snv[2][4]+Snv[2][5])/Smax;
   // Pd21
   #local Pv=Vp[Sc_b][Sd+1]; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd01=Pv;
   #local Pv=Vp[Sc_b][Sd+0]; Coordinate_convert(Cnv_type,S0,P0,Pv) #local Pd02=Pv;
   #local Pd05=Pd06;
   #local Pv=Vp[Sc+0][Sd_n]; Coordinate_convert(Cnv_type,S1,P1,Pv) #local Pd06=Pv;
   Normal_vector(Pd02, Pd21, Pd01, Vn) #local Snv[3][0]=Vn;
   #local Snv[3][1]=Snv[0][5];
   #local Snv[3][2]=Snv[0][4];
   #local Snv[3][3]=Snv[2][5];
   Normal_vector(Pd21, Pd05, Pd06, Vn) #local Snv[3][4]=Vn;
   Normal_vector(Pd01, Pd21, Pd06, Vn) #local Snv[3][5]=Vn;
   #local Nv21=(Snv[3][0]+Snv[3][1]+Snv[3][2]+Snv[3][3]+Snv[3][4]+Snv[3][5])/Smax;
   smooth_triangle { Pd11,Nv11, Pd12,Nv12, Pd22,Nv22 }
   smooth_triangle { Pd11,Nv11, Pd22,Nv22, Pd21,Nv21 }
  #local Sd=Sd+1; #end
 #local Ts=Ts+Ta; #local P0=P1; #local P1=P2; #local P2=P3; #local P3=P4; #local S0=S1; #local S1=S2; #local S2=S3;
 #local Sc=Sc+1; #end
 }
#end
//**********************************************************************************
#macro Scan_surface(Vclass,V1,V2,Func_type)
#local Cnv_type = Vclass.y;
 #switch(Vclass.x)
  #case(1) Scan_trif3(V1,V2,Func_type) #break
  #case(2) Scan_strif3(V1,V2,Func_type) #break
  #case(3) Scan_trifn(V1,V2,Func_type) #break
  #case(4) Scan_strifn(V1,V2,Func_type) #break
  #case(5) Scan_tridt(V1,V2,Func_type) #break
  #case(6) Scan_stridt(V1,V2,Func_type) #break
 #end
#end
//**********************************************************************************
// sample parameters
//
//object { Scan_surface(<1,1>,pi*<-1,1,1/8>,pi*<-1,1,1/16>,1) pigment { color rgb <0,1,0> } }
//object { Scan_surface(<2,1>,pi*<-1,1,1/6>,pi*<-1,1,1/12>,1) pigment { color rgb <0,1,0> } }
//object { Scan_surface(<3,1>,pi*<-1,1,1/8>,<-3,3,1>,4) pigment { color rgb <0,1,0> } }
//object { Scan_surface(<4,1>,pi*<-1,1,1/6>,<-3,3,1>,4) pigment { color rgb <0,1,0> } }
//----------------------------------------------------------------------------------
/*
#local Scmax=11; #local Sdmax=19; #local Vp=array[Scmax][Sdmax]

#local Ej=Scmax; #local Sj=0; #while(Sj<Ej)
 #if(Sj=Ej-1) #local Ty=-1; #local Cv=0; #else #local Ty=0; #local Cv=1; #end
 #local Rr=30*cos(pi/2*Sj/Ej); //#local Ty=0; #local Cv=1;
#local Ei=Sdmax-1; #local Si=0; #while(Si<Ei)
 #local Vp[Sj][Si]=<Rr*cos(2*pi*Si/Ei)*Cv,Ty,Rr*sin(2*pi*Si/Ei)*Cv>;
#local Si=Si+1; #end
 #local Vp[Sj][Si]=<Rr*cos(2*pi*0/Ei)*Cv,Ty,Rr*sin(2*pi*0/Ei)*Cv>;
#local Sj=Sj+1; #end

//Scan_write("Scan.dat.txt","Scan_surface data")
//Scan_read("Scan.dat.txt")

//object { Scan_surface(<5,1>,<Scmax,Sdmax>,<-4,4>,12) pigment { color rgb <0,1,0> } }
object { Scan_surface(<6,1>,<Scmax,Sdmax>,<-4,4>,12) pigment { color rgb <0,1,0> } }
*/
//**********************************************************************************