// fish view 
// +sc0.069182 +sr0.848739 +ec0.226415 +er1.000000
// boat view
// +sc0.761006 +sr0.470588 +ec0.893082 +er0.605042

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

global_settings { max_trace_level 7 }  // needed for sun

camera {
	location <5, 5, -11>
	look_at <5, 5.05, 0>
} 

#declare Sun_Media = 0.2;  // multiplication factor for media colour values used for the sun
#declare Sun_Rand = seed(56494);  // random seed for ray variations
#declare Ray_Shift = 12;  // total range of variance for rays

#declare Sun = union {
	// ball in middle
	cylinder { <0, 0, 0>, <0, 0, -1>, 2750
		hollow
		pigment { colour rgbt <1, 1, 1, 1> }
		interior {
			media {
				emission <1, 1, 1.00>
				intervals 20
				density {
					spherical
					turbulence 0.05
					density_map {
						[ 0.00 colour rgb <0.00, 0.00, 0.00>*Sun_Media ]
						[ 0.10 colour rgb <1.80, 0.70, -1.0>*Sun_Media ]
						[ 0.20 colour rgb <2.40, 0.90, -1.3>*Sun_Media ]
						[ 0.45 colour rgb <3.60, 1.25, -1.7>*Sun_Media ]
						[ 0.70 colour rgb <4.00, 1.50, -2.0>*Sun_Media ]
						[ 1.00 colour rgb <4.50, 1.70, -2.3>*Sun_Media ]
					}
					scale 2750
				}
			}
		}
	}
	// long rays
	merge {
		#local i = 0;
		#while ( i < 360 )
			cone { <750, 0, -0.5>, 0.3, <4000, 0, -0.5>, 0
				scale <1, 350, 1>
				rotate z*( i + Ray_Shift*( rand(Sun_Rand) - 0.5 ) )
			}
			#local i = i + 90;
		#end
		hollow
		pigment { colour rgbt <1, 1, 1, 1> }
		interior {
			media {
				emission <1, 1, 0.25>
				intervals 20
				density {
					spherical
					turbulence 0.05
					density_map {
						[ 0.00 colour rgb <0.00, 0.00, 0.00>*Sun_Media ]
						[ 0.60 colour rgb <1.80, 0.70, -1.0>*Sun_Media ]
						[ 0.90 colour rgb <3.20, 1.00, -1.5>*Sun_Media ]
						[ 1.00 colour rgb <4.00, 1.50, -2.0>*Sun_Media ]
					}
					scale 4000
				}
			}
		}
	}
	// medium rays	
	merge {
		#local i = 45;
		#while ( i < 360 )
			cone { <750, 0, -0.5>, 0.3, <3250, 0, -0.5>, 0
				scale <1, 300, 1>
				rotate z*( i + Ray_Shift*( rand(Sun_Rand) - 0.5 ) )
			}
			#local i = i + 90;
		#end
		hollow
		pigment { colour rgbt <1, 1, 1, 1> }
		interior {
			media {
				emission <1, 1, 0.25>
				intervals 20
				density {
					spherical
					turbulence 0.05
					density_map {
						[ 0.00 colour rgb <0.00, 0.00, 0.00>*Sun_Media ]
						[ 0.60 colour rgb <1.80, 0.70, -1.0>*Sun_Media ]
						[ 0.90 colour rgb <3.20, 1.00, -1.5>*Sun_Media ]
						[ 1.00 colour rgb <4.00, 1.50, -2.0>*Sun_Media ]
					}
					scale 3250
				}
			}
		}
	}
	// short rays	
	merge {
		#local i = 22.5;
		#while ( i < 360 )
			cone { <750, 0, -0.5>, 0.3, <2500, 0, -0.5>, 0
				scale <1, 250, 1>
				rotate z*( i + Ray_Shift*( rand(Sun_Rand) - 0.5 ) )
			}
			#local i = i + 45;
		#end
		hollow
		pigment { colour rgbt <1, 1, 1, 1> }
		interior {
			media {
				emission <1, 1, 0.25>
				intervals 20
				density {
					spherical
					turbulence 0.05
					density_map {
						[ 0.00 colour rgb <0.00, 0.00, 0.00>*Sun_Media ]
						[ 0.60 colour rgb <1.80, 0.70, -1.0>*Sun_Media ]
						[ 0.90 colour rgb <3.20, 1.00, -1.5>*Sun_Media ]
						[ 1.00 colour rgb <4.00, 1.50, -2.0>*Sun_Media ]
					}
					scale 2500
				}
			}
		}
	}	
}

light_source {
	<20000, 15000, 35000>
	colour rgb <1, 1, 0.75>
	looks_like { Sun }
}

#declare Cloud_Media = 0.0005;  // multiplication factor for cloud media colour values

// near clouds
difference {
	plane { -y, -10000 }
	plane { -y, -11000 } 
	plane { -z, -50000 }
	hollow
	pigment { colour rgbt <1, 1, 1, 1> }
	interior {
		media {
			emission 1
			intervals 20
			density {
				bozo
				turbulence 0.5
				omega 0.75
				density_map {
					[ 0.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media ]
					[ 0.20, colour rgb <0.28, 0.10, 0.00>*Cloud_Media ]
					[ 0.35, colour rgb <0.00, 0.00, 0.00>*Cloud_Media ]
					[ 0.65, colour rgb <0.00, 0.00, 0.00>*Cloud_Media ]
					[ 0.80, colour rgb <0.28, 0.10, 0.00>*Cloud_Media ]
					[ 1.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media ]
				}
				scale <5000, 5000, 7500>
				translate <27500, 0, 0>
			}
		}
	}
}
// middle clouds
difference {
	plane { -y, -10000 }
	plane { -y, -11000 } 
	plane { z, 60000 }
	plane { -z, -150000 }
	hollow
	pigment { colour rgbt <1, 1, 1, 1> }
	interior {
		media {
			emission 1
			intervals 20
			density {
				bozo
				turbulence 0.5
				omega 0.75
				density_map {
					[ 0.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media/1.5 ]
					[ 0.20, colour rgb <0.28, 0.10, 0.00>*Cloud_Media/1.5 ]
					[ 0.35, colour rgb <0.00, 0.00, 0.00>*Cloud_Media/1.5 ]
					[ 0.65, colour rgb <0.00, 0.00, 0.00>*Cloud_Media/1.5 ]
					[ 0.80, colour rgb <0.28, 0.10, 0.00>*Cloud_Media/1.5 ]
					[ 1.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media/1.5 ]
				}
				scale <5000, 5000, 7500>
				translate <27500, 0, 0>
			}
		}
	}
}
// horizon clouds
difference {
	plane { -y, -10000 }
	plane { -y, -11000 } 
	plane { z, 160000 }
	plane { -z, -3000000 }
	hollow
	pigment { colour rgbt <1, 1, 1, 1> }
	interior {
		media {
			emission 1
			intervals 20
			density {
				bozo
				turbulence 0.5
				omega 0.75
				density_map {
					[ 0.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media/2.5 ]
					[ 0.15, colour rgb <0.28, 0.10, 0.00>*Cloud_Media/2.5 ]
					[ 0.30, colour rgb <0.00, 0.00, 0.00>*Cloud_Media/2.5 ]
					[ 0.70, colour rgb <0.00, 0.00, 0.00>*Cloud_Media/2.5 ]
					[ 0.85, colour rgb <0.28, 0.10, 0.00>*Cloud_Media/2.5 ]
					[ 1.00, colour rgb <0.75, 0.35, 0.00>*Cloud_Media/2.5 ]
				}
				scale <7500, 7500, 10000>
				translate <27500, 0, 0>
			}
		}
	}
}

// Function for creating ripples
#declare Ripples = function {
	y - ( sqrt(x*x + z*z) <= 1/16 )*sin( 1/16*4*pi + 3*pi/2 ) / ( 12*1/16 + 50 )
		- ( sqrt(x*x + z*z) > 1/16 )*sin( sqrt(x*x + z*z)*4*pi + 3*pi/2 ) / ( 18*sqrt(x*x + z*z) + 50 )
		- ( sqrt( (x-4)*(x-4) + z*z ) <= 1/2 ) * sin( 1/2*4*pi - pi/2 ) / ( 3*1/2 + 85 )
		- ( sqrt( (x-4)*(x-4) + z*z ) > 1/2 ) * sin( sqrt( (x-4)*(x-4) + z*z )*4*pi - pi/2 ) / ( 7*sqrt( (x-4)*(x-4) + z*z ) + 85 )
}

// sea, isosurface merged with a plane
merge {
	plane { y, -1/26 +0.00001}	
	isosurface {
		function { Ripples(x, y, z) }
		contained_by { sphere { <0, 0, 0>, 60 } }
		max_gradient 1.311
	}
	pigment { colour rgbt <0.8, 0.8, 1.0, 0.2> }
	finish {
		conserve_energy
		reflection { 0.10, 0.30
			fresnel on
			metallic
			exponent 0.2
		}		
	}
	interior {
		ior 1.33
	}
	normal {
		waves 0.2
		turbulence 0.2
		scale 8
		frequency 17
	}
}

// background gradient
sky_sphere {
	pigment { 
		gradient y
		colour_map {
			[0.00 rgb <0.35, 0.75, 1.0>]
			[0.20 rgb <0.25, 0.65, 1.0>]
			[0.90 rgb <0.25, 0.65, 1.0>]
			[1.00 rgb <0.35, 0.75, 1.0>]
		}
	}
}

#declare F_Fish = finish {
	ambient 0.5
	reflection { 0.1 }
	irid { 0.35 thickness 0.15 }
	phong 1.0
	phong_size 100
}

#declare Fish = blob {
	threshold 0.5
	// tail body
	cylinder { <0, -0.5, 0>, <0, 0.2, 0>, 0.4, 1
		scale <1, 1, 0.4>
		texture {
			pigment {
				gradient x
				turbulence 0.1
				colour_map {
					[ 0.00 colour rgb <0.6, 0.6, 0.6> ]
					[ 0.70 colour rgb <0.6, 0.6, 0.6> ]		
					[ 0.90 colour rgb <0.8, 0.8, 0.8> ]
					[ 1.00 colour rgb <0.8, 0.8, 0.8> ]
				}
				translate <0.5, 0, 0>
			}
			finish { F_Fish }
		}
		texture {
			pigment {
				bozo
				turbulence 0.2
				colour_map {
					[ 0.00 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 0.20 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 0.25 colour rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.75 colour rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.80 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 1.00 colour rgbt <0.2, 0.2, 0.2, 0> ]
				}
				scale 0.10
			}
			finish { F_Fish }
		}
	}
	// tail bones
	#declare i = -9;
	#while ( i <= 9 )
		cylinder { <0, 0, 0>, <0, 0.5, 0>, 0.06, 0.12
			scale <0.1, 1, 1>
			rotate -z*i
			translate <0.03*i, 0, -0.01 + 0.02*abs(i)/8>
		}
		#declare i = i + 1;
	#end
	// fins
	cylinder { <0, 1.1, 0>, <0, 1.2, 0>, 0.8, -1.5
		scale <0.6, 1, 0.1>
	}
	sphere { <0, 0.7, 0>, 0.3, -0.5
		scale <0.8, 1, 1.2>
	}
	sphere { <-0.25, 0.45, 0>, 0.7, 0.51
		scale <1, 1, 0.1>
	}
	sphere { <0.25, 0.45, 0>, 0.7, 0.51
		scale <1, 1, 0.1>
	}
	// main body
	sphere { <0, -1.2, 0>, 1.5, 1.5
		scale <0.5, 1, 0.2>
		texture {
			pigment {
				gradient x
				turbulence 0.1
				colour_map {
					[ 0.00 colour rgb <0.5, 0.5, 0.5> ]
					[ 0.70 colour rgb <0.5, 0.5, 0.5> ]		
					[ 0.90 colour rgb <0.8, 0.8, 0.8> ]
					[ 1.00 colour rgb <0.8, 0.8, 0.8> ]
				}
				translate <0.5, 0, 0>
			}
			finish { F_Fish }
		}
		texture {
			pigment {
				bozo
				turbulence 0.2
				colour_map {
					[ 0.00 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 0.20 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 0.25 colour rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.75 colour rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.80 colour rgbt <0.2, 0.2, 0.2, 0> ]
					[ 1.00 colour rgbt <0.2, 0.2, 0.2, 0> ]
				}
				scale 0.10
			}
			finish { F_Fish }
		}
	}
	scale <0.8, 1, 1>
	pigment { colour rgb <0.6, 0.6, 0.6> }
	finish { F_Fish }
}

// random seed for the splash
#declare R = seed(46841);

// splash macro,
#macro Splash ( blob_threshold, str_min, str_max, v_y_min, v_y_max, exp_y, x_min, v_x_min, v_x_max, exp_x, exp_t, components, radius_min, radius_max, g, r_seed )
	blob {
		threshold blob_threshold
		#local i = 0;
		#while ( i < components )
			#debug concat( "component ", str( i + 1, 0, 0 ), "\n" )
			#local y_rotate = 359*(rand(r_seed) - 0.5);
			#local time = pow(rand(r_seed), exp_t);
			#local pos_y = ( v_y_min + (v_y_max - v_y_min)*pow(rand(r_seed), exp_y) )*time - 0.5*time*time*g;
			#local pos_x = ( v_x_min + (v_x_max - v_x_min)*pow(rand(r_seed), exp_x) )*time + x_min;
			#local blob_str = str_min + (str_max - str_min)*rand(r_seed);
			#local blob_radius = radius_min + (radius_max - radius_min)*rand(r_seed);
			sphere { <pos_x, pos_y, 0>, blob_radius, blob_str
				rotate y*y_rotate
			}
			#local i = i + 1;
		#end
		texture {
			pigment {
				gradient y
				turbulence 0.1
				colour_map {
					[ 0.00 rgbt <0.2, 0.2, 0.3, 0.2> ]
					[ 0.10 rgbt <0.2, 0.2, 0.3, 0.2> ]
					[ 0.20 rgbt <0.7, 0.7, 0.8, 0.7> ]
					[ 1.00 rgbt <0.7, 0.7, 0.8, 0.7> ]
				}
				translate <0, -0.05, 0>
			}
			finish {
				ambient 0.65
				conserve_energy
				reflection { 0.10, 0.30
					fresnel on
					metallic
					exponent 0.2
				}		
				phong 0.1
			}
		}
		interior {
			ior 1.33
		}
		rotate y*20
		translate <0.06, 0.00, 0>
	}
#end

Splash ( 0.5, 0.45, 0.55, 0.8, 1.5, 2.0, 0.2, 0.6, 0.64, 1, 2.0, 1000, 0.04, 0.06, 1.3, R )

#declare Hull = union {
	intersection {
		union {
			sphere { <0, 0, 0>, 2 }
			cylinder { <0, 0, 0>, <0, 0, 5>, 2 }
		}
		box { <-2, -2, -2>, <-0.7499, 0, 5> }
		translate <0.75, 0, 0>
	}
	intersection {
		union { 
			sphere { <0, 0, 0>, 2 }
			cylinder { <0, 0, 0>, <0, 0, 5>, 2 }
		}
		box { <0.7499, -2, -2>, <2, 0, 5> }
		translate <-0.75, 0, 0>
	}
	scale <1, 0.75, 1>
	texture {
		T_Wood7
		scale 0.5
		finish { ambient 0.75 }
	}
}

#declare Oar_Ring = union {
	box { <-0.065, -0.15, -0.15>, <0.065, 0, 0.15> }
	torus { 0.1, 0.03
		rotate z*90
		translate <0, 0.09, 0>
	}
	texture { T_Silver_3A }
}

#declare Boat = union {
	difference {
		object { Hull }
		object { Hull
			scale 0.9
			translate y*0.001
		}
	}
	cylinder { <0, 0, -sqrt(55)/4 + 0.1>, <0, 0.3, -sqrt(55)/4 + 0.1>, 0.1
		texture {
			T_Wood7
			scale 0.5
			finish { ambient 0.75 }
		}
	}
	object { Oar_Ring
		translate <1.1875, 0, 1.2>
	}
	object { Oar_Ring
		translate <-1.1875, 0, 1.2>
	}
}

#declare Rower = union {
	// body
	box { <-0.6, -0.5, 0>, <0.6, 1.5, 0.5> }
	// head
	sphere { <0, 0, 0>, 0.4
		scale <0.9, 1.2, 0.9>
		translate <0, 1.98, 0.35> 
		texture {
			pigment { colour rgb <0.40, 0.30, 0.10> }
			finish { ambient 0.5 }
		}
	}
	// neck
	cylinder { <0, 1.5, 0.25>, <0, 1.9, 0.25>, 0.25
		texture {
			pigment {
				gradient y
				colour_map {
					[ 0.00 colour rgb <0.80, 0.63, 0.56> ]
					[ 0.50 colour rgb <0.80, 0.63, 0.56> ]
					[ 0.51 colour rgb <0.40, 0.30, 0.10> ]
					[ 1.00 colour rgb <0.40, 0.30, 0.10> ]
				}
				scale 0.4
				translate y*1.5
			}
			finish { ambient 0.5 }
		}
	}
	// arms
	cylinder { <-0.5, 1.3, 0>, <-0.5, 1.3, 2>, 0.2
		texture {
			pigment {
				gradient z
				colour_map {
					[ 0.00 colour rgb <1, 1, 1> ]
					[ 0.40 colour rgb <1, 1, 1> ]
					[ 0.41 colour rgb <0.80, 0.63, 0.56> ]
					[ 1.00 colour rgb <0.80, 0.63, 0.56> ]
				}
				scale 2
			}
			finish { ambient 0.5 }
		}
	}
	cylinder { <0.5, 1.3, 0>, <0.5, 1.3, 2>, 0.2
		texture {
			pigment {
				gradient z
				colour_map {
					[ 0.00 colour rgb <1, 1, 1> ]
					[ 0.40 colour rgb <1, 1, 1> ]
					[ 0.41 colour rgb <0.80, 0.63, 0.56> ]
					[ 1.00 colour rgb <0.80, 0.63, 0.56> ]
				}
				scale 2
			}
			finish { ambient 0.5 }
		}
	}
	pigment {
		wrinkles
		turbulence 0.4
		omega 0.5
		lambda 3.0
		colour_map { 
			[ 0.00 colour rgb <1, 1, 1> ]
			[ 0.60 colour rgb <1, 1, 1> ]
			[ 0.80 colour rgb <0.8, 0.8, 0.8> ]
			[ 1.00 colour rgb <0.8, 0.8, 0.8> ]
		}
		scale 0.45
	}
	finish { ambient 0.5 }
	rotate x*10
}

#declare r_Ring = <1.1875, 0.09, 1.2>;
#declare r_Arm_End = 0.6*vrotate( <0.5, 1.3, 2>, <10, 0, 0> ) + <0, 0, 0.4>;
#declare r_AE_to_Ring = r_Ring - r_Arm_End;
#declare ru_AE_to_Ring = r_AE_to_Ring / vlength( r_AE_to_Ring );
#declare l_Ring = <-1.1875, 0.09, 1.2>;
#declare l_Arm_End = 0.6*vrotate( <-0.5, 1.3, 2>, <10, 0, 0> ) + <0, 0, 0.4>;
#declare l_AE_to_Ring = l_Ring - l_Arm_End;
#declare lu_AE_to_Ring = l_AE_to_Ring / vlength( l_AE_to_Ring );

#declare Manned_Boat = union {
	object { Boat }
	object { Rower
		scale 0.6
		translate <0, 0, 0.4>
	}
	cylinder { r_Arm_End - 0.3*ru_AE_to_Ring, r_Ring + 2.5*ru_AE_to_Ring, 0.07
		texture {
			T_Wood7
			scale 0.5
			finish { ambient 0.75 }
		}
	}
	cylinder { <-0.05, 0, 0>, <0.05, 0, 0>, 0.2
		scale <1, 2, 1>
		rotate <0, 180/pi*atan2(r_AE_to_Ring.x, r_AE_to_Ring.z), -180/pi*atan2(r_AE_to_Ring.x, r_AE_to_Ring.y)>
		texture {
			T_Wood7
			scale 0.5
			finish { ambient 0.75 }
		}
		translate r_Ring + 2.5*ru_AE_to_Ring
	} 
	cylinder { l_Arm_End - 0.3*lu_AE_to_Ring, l_Ring + 2.5*lu_AE_to_Ring, 0.07
		texture {
			T_Wood7
			scale 0.5
			finish { ambient 0.75 }
		}
	}
	cylinder { <-0.05, 0, 0>, <0.05, 0, 0>, 0.2
		scale <1, 2, 1>
		rotate <0, 180/pi*atan2(l_AE_to_Ring.x, l_AE_to_Ring.z), -180/pi*atan2(l_AE_to_Ring.x, l_AE_to_Ring.y)>
		texture {
			T_Wood7
			scale 0.5
			finish { ambient 0.75 }
		}
		translate l_Ring + 2.5*lu_AE_to_Ring
	} 
}

light_group {
	light_source {
		<-70, -500, -200>
		colour rgb <0.5, 0.5, 0.5>
		shadowless
	}
	object { Manned_Boat
		scale 2
		rotate y*35
		translate <75, 1.5, 150>
	}
	object { Fish
		scale <0.6, 0.75, 0.75>
		rotate <0, 5, -20>
		translate <0.07, 0.18, 0>
	}
	global_lights on
}