#declare CurveWidth=1.125;
#declare CurveBend=0.1;
#declare Thickness=0.03;
#declare PaperThick=0.005;
#declare BoxHalfWidth=1.4375;
#declare BoxLowerHeight=3.25;
#declare BoxUpperHeight=1.625;
#declare CartonWidth=2.75; // inside width
#declare CartonDepth=1; // inside depth

#declare CylinderCenter=(CurveBend*CurveBend-CurveWidth*CurveWidth)/2/CurveBend;

////////////////////////////////////////
// Textures
////////////////////////////////////////

#declare CardBoard=texture {
  pigment {
    bozo
    noise_generator 3
    scale < 0.02, 0.08, 0.02 >
    color_map {
      //[ 0 color rgb < 0.9, 0.8, 0.7 > ]
      //[ 1 color rgb < 1, 0.9, 0.8 > ]
      [ 0 color rgb < 0.6, 0.5, 0.4 > ]
      [ 1 color rgb < 0.7, 0.6, 0.5 > ]
    }
  }
  finish { ambient 0 diffuse 1 specular 0.3 roughness 0.5 }
}
/*texture {
  pigment {
    bozo
    noise_generator 3
    scale < 0.1, 0.5, 0.1 >
    translate 15*x
    color_map {
      [ 0.15 color rgb < 0.5, 0.4, 0.2 >]
      [ 0.15 color rgbt 1 ]
      [ 0.9 color rgbt 1 ]
      [ 0.9 color rgb < 0.9, 0.9, 0.9 > ]
    }
  }
  finish { ambient 0 diffuse 1 }
}*/

#declare PaperFront=texture {
  pigment {
    image_map { png "boxfront.png" }
    translate -0.5*x
    scale < 2*BoxHalfWidth, BoxLowerHeight+BoxUpperHeight, 1 >
  }
  finish { ambient 0 diffuse 1 }
}

#declare PaperSide=texture {
  pigment {
    image_map { png "boxside.png" }
    rotate -90*y
    translate -0.5*z
    scale < 1, BoxLowerHeight+BoxUpperHeight, 2*CurveWidth >
  }
  finish { ambient 0 diffuse 1 }
}

////////////////////////////////////////
// inner cardboard part of box
////////////////////////////////////////

#declare InnerCurveShape=difference {
  cylinder {
    < CylinderCenter, 0, 0 >,
    < CylinderCenter, 1, 0 >,
    CurveBend-CylinderCenter
  }
  cylinder {
    < CylinderCenter, -0.001, 0 >,
    < CylinderCenter, 1.001, 0 >,
    CurveBend-CylinderCenter-Thickness
  }
  plane { z, -CurveWidth }
  plane { -z, -CurveWidth }
  bounded_by {
    box {
      < -Thickness-0.01, -0.01, -CurveWidth-0.01 >,
      < CurveBend+0.01, 1.01, CurveWidth+0.01 >
    }
  }
}

#declare BoxLower=union {
  difference {
    InnerCurveShape
    scale < 1, BoxLowerHeight, 1 >
    translate < BoxHalfWidth, 0, 0 >
  }
  difference {
    InnerCurveShape
    scale < 1, BoxLowerHeight, 1 >
    rotate 180*y
    translate < -BoxHalfWidth, 0, 0 >
  }
  box {
    < -BoxHalfWidth, 0, -CurveWidth >,
    < BoxHalfWidth, BoxLowerHeight, -CurveWidth+Thickness >
  }
  box {
    < -BoxHalfWidth, 0, CurveWidth >,
    < BoxHalfWidth, BoxLowerHeight, CurveWidth-Thickness >
  }
  texture { CardBoard }
}

#declare BoxUpper=union {
  difference {
    InnerCurveShape
    scale < 1, BoxUpperHeight, 1 >
    translate < BoxHalfWidth, 0, 0 >
  }
  difference {
    InnerCurveShape
    scale < 1, BoxUpperHeight, 1 >
    rotate 180*y
    translate < -BoxHalfWidth, 0, 0 >
  }
  difference {
    InnerCurveShape
    scale < 1, 2*BoxHalfWidth, 1 >
    rotate 90*z
    translate < BoxHalfWidth, BoxUpperHeight, 0 >
  }
  box {
    < -BoxHalfWidth, 0, -CurveWidth >,
    < BoxHalfWidth, BoxUpperHeight, -CurveWidth+Thickness >
  }
  box {
    < -BoxHalfWidth, 0, CurveWidth >,
    < BoxHalfWidth, BoxUpperHeight, CurveWidth-Thickness >
  }
  texture { CardBoard }
}

////////////////////////////////////////
// outer paper part of box
////////////////////////////////////////

#declare OuterCurveShape=difference {
  cylinder {
    < CylinderCenter, 0, 0 >,
    < CylinderCenter, 1, 0 >,
    CurveBend-CylinderCenter+PaperThick
  }
  cylinder {
    < CylinderCenter, -0.001, 0 >,
    < CylinderCenter, 1.001, 0 >,
    CurveBend-CylinderCenter
  }
  plane { z, -CurveWidth }
  plane { -z, -CurveWidth }
  bounded_by {
    box {
      < -Thickness-0.01, -0.01, -CurveWidth-0.01 >,
      < CurveBend+0.01, 1.01, CurveWidth+0.01 >
    }
  }
}

#declare PaperLower=union {
  union {
    difference {
      OuterCurveShape
      scale < 1, BoxLowerHeight, 1 >
      translate < BoxHalfWidth, 0, 0 >
    }
    difference {
      OuterCurveShape
      scale < 1, BoxLowerHeight, 1 >
      rotate 180*y
      translate < -BoxHalfWidth, 0, 0 >
    }
    texture { PaperSide }
  }
  union {
    box {
      < -BoxHalfWidth, 0, -CurveWidth-PaperThick >,
      < BoxHalfWidth, BoxLowerHeight, -CurveWidth >
    }
    box {
      < -BoxHalfWidth, 0, CurveWidth >,
      < BoxHalfWidth, BoxLowerHeight, CurveWidth+PaperThick >
    }
    texture { PaperFront }
  }
}

#declare PaperUpper=union {
  union {
    difference {
      OuterCurveShape
      scale < 1, BoxUpperHeight, 1 >
      translate < BoxHalfWidth, 0, 0 >
    }
    difference {
      OuterCurveShape
      scale < 1, BoxUpperHeight, 1 >
      rotate 180*y
      translate < -BoxHalfWidth, 0, 0 >
    }
    difference {
      OuterCurveShape
      scale < 1, 2*BoxHalfWidth, 1 >
      rotate 90*z
      translate < BoxHalfWidth, BoxUpperHeight, 0 >
    }
    texture { PaperSide translate -BoxLowerHeight*y }
  }
  union {
    box {
      < -BoxHalfWidth, 0, -CurveWidth-PaperThick >,
      < BoxHalfWidth, BoxUpperHeight, -CurveWidth >
    }
    box {
      < -BoxHalfWidth, 0, CurveWidth >,
      < BoxHalfWidth, BoxUpperHeight, CurveWidth+PaperThick >
    }
    texture { PaperFront translate -BoxLowerHeight*y }
  }
}

////////////////////////////////////////
// crayon holding cartons
////////////////////////////////////////

#declare Carton=difference {
  union {
    box {
      < -Thickness, 0, -Thickness >,
      < CartonWidth+Thickness, BoxLowerHeight+0.625, CartonDepth+Thickness >
    }
    box {
      < -Thickness, 0, 0.375 >,
      < CartonWidth+Thickness, BoxLowerHeight+1+Thickness, CartonDepth+Thickness >
    }
    cylinder {
      < -Thickness, BoxLowerHeight+0.625, 0.375 >,
      < CartonWidth+Thickness, BoxLowerHeight+0.625, 0.375 >,
      0.375+Thickness
    }
  }
  box { // inside of carton
    < 0, Thickness, 0 >,
    < CartonWidth, BoxLowerHeight+1.01+Thickness, CartonDepth >
  }
  box { // open front
    < 0.0001, BoxLowerHeight, -Thickness-0.01 >,
    < CartonWidth-0.0001, BoxLowerHeight+1.01, 0.51 >
  }
  // curved cutout in back
  cylinder {
    < 0.875, BoxLowerHeight+1, CartonDepth-0.01 >,
    < 0.875, BoxLowerHeight+1, CartonDepth+Thickness+0.01 >,
    0.5
  }
  cylinder {
    < CartonWidth-0.875, BoxLowerHeight+1, CartonDepth-0.01 >,
    < CartonWidth-0.875, BoxLowerHeight+1, CartonDepth+Thickness+0.01 >,
    0.5
  }
  box {
    < 0.875, BoxLowerHeight+0.5, CartonDepth-0.01 >,
    < CartonWidth-0.875, BoxLowerHeight+1.01, CartonDepth+Thickness+0.01 >
  }
  texture { CardBoard }
}

////////////////////////////////////////
// complete box
////////////////////////////////////////

#declare CompleteBox=union {
  union { BoxLower }
  union { PaperLower }
  union {
    BoxUpper
    translate -CurveWidth*z
    rotate 105*x
    translate < 0, BoxLowerHeight, CurveWidth >
  }
  union {
    PaperUpper
    translate -CurveWidth*z
    rotate 105*x
    translate < 0, BoxLowerHeight, CurveWidth >
  }
  difference { Carton translate < -CartonWidth/2, 0, -CartonDepth-Thickness > }
  difference { Carton translate < -CartonWidth/2, 0.5, Thickness*2 > }
}
