#declare CrayonLength=3.1875;
#declare CrayonRadius=0.156;
#declare CrayonEdge=0.02;
#declare CrayonTip=0.44;
#declare CrayonPaperSpace=0.094;

#declare Crayon=union {
  // outer shaft
  cylinder { CrayonEdge*y, (CrayonLength-CrayonEdge)*y, CrayonRadius }
  // bottom shaft edge
  torus { CrayonRadius-CrayonEdge, CrayonEdge translate CrayonEdge*y }
  // top shaft edge
  torus { CrayonRadius-CrayonEdge, CrayonEdge translate (CrayonLength-CrayonEdge)*y }
  // inner shaft
  cylinder { 0, CrayonLength*y, CrayonRadius-CrayonEdge }
  // tip
  cone {
    CrayonLength*y,
    CrayonRadius-CrayonEdge*2,
    (CrayonLength+CrayonTip)*y,
    (CrayonRadius-CrayonEdge)/4
  }

  texture {
    pigment { color rgb < 0.1, 0.1, 0.6 > }
    finish { ambient 0 diffuse 1 specular 1 roughness 0.01 }
    normal { bozo scale 0.005 bump_size 1 }
  }
}

#declare CrayonPaper=cylinder {
  < 0, CrayonPaperSpace, 0>, < 0, CrayonLength-CrayonPaperSpace, 0 >, CrayonRadius+0.01
  texture {
    pigment {
      image_map { png "crayon.png" map_type 2 }
      scale < 1, CrayonLength-CrayonPaperSpace*2, 1 >
      translate CrayonPaperSpace*y
      rotate -135*y
    }
    finish { ambient 0 diffuse 1 specular 0.15 roughness 0.5 }
  }
}

#declare WholeCrayon=union {
  union { Crayon }
  cylinder { CrayonPaper }
}
