#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
#include "skies.inc"


#declare Photons=on;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  #if (Photons)          // global photon block
    photons {
      spacing 0.02                 // specify the density of photons
      //count 100000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      //save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }

  #end
}
  
// ----------------------------------------
 
camera {
  
  location  <0,30,-100>
  look_at   <0,0,0>
} 

light_source {
  <500,500,150>       // light's position
  color rgb 1.3       // light's color
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
}

/*sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}*/
  
// ----------------------------------------

#declare sol=
plane {
  y, 0
  texture {
    pigment { color rgb <1.0, 0.8, 0.6> }
    normal{granite scale 1.5}
  }
} 


  
  
  // ----------------------------------------
// Chair
// ----------------------------------------
#declare rCh=0.025/2;
#declare rCh2=rCh+0.002;
#declare rCh3=0.01;
#declare rCh4=0.05;
#declare yCh=0.43;
#declare yCh2=0.345;
#declare zCh=0.28;
#declare xCh=0.33;
#declare zCh3=0.07;
#declare yCh1=yCh-rCh4; 
#declare yCh5=yCh-rCh*2; 
#declare yCh3=sqrt(zCh3*zCh3+yCh5*yCh5);
#declare yCh4=yCh3-rCh4;
#declare aCh=degrees(atan2(zCh3,yCh1));
#declare aCh1=2;
#declare aCh2=5;
#declare aCh3=10;
#declare colChair=rgb <1, 0.40297, 0.10703>;
#declare colPChair1=rgb <0.24219, 0.5, 0.45313>*0.5;
#declare colPChair2=rgb <0.5, 0.25781, 0.13672>*0.1;
#declare pigChair1=pigment{
    wood
    turbulence 0.2
    lambda 3
    color_map{
        [0 colChair*0.5]
        [1 colChair]
    }
    rotate y*100 rotate x*20    scale 0.04 scale 0.01*<10,1,1>    
}                             
#declare pigChair2=pigment{
    wood
    turbulence 0.2
    lambda 3
    color_map{
        [0 colChair*0.15]
        [1 colChair*0.5]
    }
    rotate y*100 rotate z*80 scale 0.01 scale 0.8*<1,5,1>  
}    
#declare txtWoodChair=texture{
    pigment{
        pigment_pattern{
            agate agate_turb 0.3 lambda 3 
            color_map{[0.5 White][0.5 Black]}
            rotate x*148
            scale 0.2
        }
        pigment_map{
            [0 pigChair1]
            [1 pigChair2]
        }
    }
    finish{ambient 0 diffuse 1}
}

#declare txtLegChair=texture{
    pigment{
        granite
        color_map{
            [0 colPChair1]
            [0.3 colPChair1]
            [0.4 colPChair2]
            [1 colPChair2]
        }
    }
    finish{ambient 0 diffuse 1 metallic brilliance 4 specular 1 roughness 0.005}
    scale 0.02
}

#declare LegChairFront=union{
    cylinder{0,y*0.008,rCh2} // rubber
    torus{rCh,rCh2-rCh translate y*0.008}
    cylinder{0,y*yCh1,rCh} // montant Front
    difference{torus{rCh4,rCh rotate z*90} plane{y,0} plane{z,0 inverse} translate <0,yCh1,rCh4>}
    cylinder{0,z*zCh,rCh translate <0,yCh,rCh4>} // horizontal
    union{ // Back
        difference{torus{rCh4,rCh rotate z*90} plane{y,0 inverse rotate x*aCh3} plane{z,0} translate y*rCh4}
        union{
            cylinder{0,y*yCh2,rCh}
            union{
                cylinder{0,y*0.01,rCh2}
                sphere{0,rCh2 scale <1,0.004/rCh2,1> translate y*0.01}
                translate y*yCh2
            }   
            translate z*rCh4
            rotate x*aCh3
            translate y*rCh4
        }
        rotate -z*aCh2
        translate <0,yCh,rCh4+zCh>
    }
}
#declare LegChairRear=union{
    cylinder{0,y*0.008,rCh2} 
    torus{rCh,rCh2-rCh translate y*0.008}
    cylinder{0,y*yCh4,rCh} 
    difference{torus{rCh4,rCh rotate x*90} plane{y,0} plane{x,0} translate <-rCh4,yCh4,0>}
}              

#declare rChD1=xCh/2-sin(radians(aCh1))*(zCh+2*rCh4)+sin(radians(aCh2))*rCh4;
#declare rChD2=xCh/2-sin(radians(aCh1))*(zCh+2*rCh4)+sin(radians(aCh2))*(rCh4+yCh2);
#declare yChD=yCh2*cos(radians(aCh2));
#declare BackChair=difference{
    cone{0,rChD1,y*yChD,rChD2}
    cone{-y*0.001,rChD1*0.85,y*(yChD+0.001),rChD2*0.85}
    plane{z,0}
    plane{y,yCh2*0.5}
    scale <1,1,0.08/rChD2>
}       
#declare eChS=0.008;
#declare SeatChair=union{
    box{<-xCh/2,-eChS,0>,<xCh/2,0,zCh>}
    difference{cylinder{0,-eChS*y,xCh/2} plane{z,0} scale <1,1,0.05*2/xCh> translate z*zCh}
    difference{
        cylinder{-x*xCh/2,x*xCh/2,rCh4}
        cylinder{-x*1.1*xCh/2,x*1.1*xCh/2,rCh4-eChS}
        plane{z,0 inverse}
        plane{y,0 rotate x*25}
        translate -y*rCh4
    }
    texture{pigment{pigChair1} finish{ambient 0 diffuse 1}}
} 

#declare Chair=union{
    union{
        object{LegChairFront rotate -y*aCh1 translate x*xCh/2}
        object{LegChairFront rotate -y*aCh1 translate x*xCh/2 scale <-1,1,1>}
        cylinder{-xCh*x/2,xCh*x/2,rCh3 translate -z*rCh4 rotate x*25 translate z*rCh4+y*yCh1}
        union{
            object{LegChairRear translate x*(xCh/2+rCh4)}
            object{LegChairRear translate x*(xCh/2+rCh4) scale <-1,1,1>}
            union{
                cylinder{-xCh/2*x,x*xCh/2,rCh}
                union{
                    sphere{0,1 translate y scale <1,0.5,1> scale 0.01 translate y*rCh-x*0.6*xCh/2}
                    sphere{0,1 translate y scale <1,0.5,1> scale 0.01 translate y*rCh+x*0.6*xCh/2}
                    texture{pigment{White*0.6}finish{ambient 0 diffuse 1 specular 1 roughness 0.001 reflection 0.1}}
                    rotate x*aCh
                }
                translate y*yCh3
            }
            translate -y*yCh3
            rotate -x*aCh
            translate <0,yCh3,zCh+rCh4>
        }                     
        texture{txtLegChair}
    }
    union{         
        object{BackChair
            translate z*rCh4
            rotate x*aCh3
            translate <0,yCh+rCh4,rCh4+zCh>
            texture{txtWoodChair}
        }        
        object{SeatChair
            translate <0,yCh,rCh4>
        }
    }        
}

//=========================l'arbre ==================================
#declare dofile=true;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree1.inc" // file name for tree
#declare fvname="gtfoliage1.inc" // file name for foliage
#declare ffname="gtleaf1.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=1431;      // random seed
#declare rsd=1432;      // random seed
#declare rsd=1433;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=7;      // recursion level
//#declare level0=3;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=3;          // max number of branches per level
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=25;        // initial branch length
#declare rb0=1.4;         // initial branch radius
#declare ab0=35;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.67;       // branch length decrease ratio (1=constant length)
#declare qrb=0.59;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.88;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=1; // probability of branch apparition 
#declare jb=0.7;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.25;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.59; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,-1,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.2;       // force of push
#declare aboveground=0; // constrains the branches above this level 
#declare belowsky=140;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=1;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of roots;
#declare vroot=<1,0,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=0.8;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.1;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_0} // Leaf texture
#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1.2;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================
 #declare dunes=
 height_field{
 png "image.png"
 scale <3000,120,200>
  texture {
    pigment { color rgb <1.0, 0.8, 0.6> }
    normal{granite scale 1.5}
  }
 
 }


//========================la scene ================================ 
sky_sphere { S_Cloud5 }
object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
} 

object{ dunes translate<-350,-30,50>}
object{sol}

object{Chair translate <0,0,-2>
        rotate -y*45 
        translate -x*0.4 scale 20
         photons {  // photon block for an object
    target 1.0
    refraction on
    reflection on
  }

}