// File: cellblkd.pov
// Vers: 3.5
// Date: 07/27/02
// Auth: Tim Crockett
//

#version 3.5;

#include "colors.inc"
#include "metals.inc"
#include "finish.inc"

#declare DrawBed=on;
#declare DrawDoors=on;
#declare DrawSoftLights=on;

/****************************************************************
 * Textures                                                     *
 ****************************************************************/

#declare CementTexture = texture
{      
  pigment
  {
    bozo
    color_map
    {
      [ 0.0 rgbft <1.00, 1.00, 1.00, 0.00, 0.00> ]
      [ 0.2 rgbft <0.90, 0.90, 1.00, 0.00, 0.00> ]
      [ 0.4 rgbft <0.80, 0.80, 0.90, 0.00, 0.00> ]
      [ 0.6 rgbft <0.70, 0.70, 0.80, 0.00, 0.00> ]
      [ 0.8 rgbft <0.65, 0.65, 0.70, 0.00, 0.00> ]
      [ 1.0 rgbft <0.70, 0.70, 0.80, 0.00, 0.00> ]
    }
    turbulence 1.2
    ramp_wave
  }
}

#declare DirtyWalls = texture
{
  pigment
  {
    bozo
    color_map
    {
      [ 0.0 rgbft <0.84, 0.84, 0.84, 0.00, 0.00>]
      [ 1.0 rgbft <1.00, 1.00, 1.00, 1.00, 1.00>]
    }
    turbulence 0.5
  }
}
    

/****************************************************************
 * Camera & Scene lights                                        *
 ****************************************************************/

camera {
  location  <6.00, 6.00, 10.00>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-3.00, 4.00, 0.00>
  focal_point <-3, 4, 0>
  aperture 0.15
  blur_samples 100
  confidence 0.9 
  variance 0.0001
}


light_source {
  <100.00, 150.00, 500.00>
  color rgb 0.6
}

light_source {
  <-100.00, 150.00, 500.00>
  color rgb 0.6 
}

/****************************************************************
 * Scene components                                             *
 ****************************************************************/

#declare cell_interior = union
{
  box{ <3.00, -1.00,  0.00>, <-3.00, 8.00, -9.00>}
  box{ <2.50, -1.00,  1.00>, <-2.50, 7.00, -1.00>}
}   

#declare bed = union
{
  difference
  {
    box{<-1.00  2.00, -2.90>, <-3.00, 2.20, -8.90>}
    box{<-1.05, 1.90, -2.95>, <-2.95, 2.25, -8.85>}
    texture{T_Chrome_2C
      normal{
        bumps 0.02
        scale 0.05
      }    
    }
  }
  union
  {
    box {< -1.00, 2.00, -2.90>, < -1.20, 2.01, -8.90>} 
    box {< -1.60, 2.00, -2.90>, < -1.80, 2.01, -8.90>} 
    box {< -2.20, 2.00, -2.90>, < -2.40, 2.01, -8.90>} 
    box {< -2.80, 2.00, -2.90>, < -3.00, 2.01, -8.90>} 
  
    box {< -1.00, 2.00, -2.90>, < -3.00, 2.01, -3.10>} 
    box {< -1.00, 2.00, -4.30>, < -3.00, 2.01, -4.50>} 
    box {< -1.00, 2.00, -5.30>, < -3.00, 2.01, -5.50>} 
    box {< -1.00, 2.00, -6.30>, < -3.00, 2.01, -6.50>} 
    box {< -1.00, 2.00, -7.30>, < -3.00, 2.01, -7.50>} 
    box {< -1.00, 2.00, -8.70>, < -3.00, 2.01, -8.90>}
    pigment{color DarkOliveGreen}
  }
   
  union{
    box{<0.10, -0.10, 0.00>, <-0.10, 2.18,  0.04>}
    box{<0.10, -0.10, 0.00>, <-0.10, 0.04, -0.30>}
    translate <-1.5, 0, -2.9>
    texture{T_Chrome_2C
      normal{
        bumps 0.02
        scale 0.05
      }
    }
  }
  union{
    box{<0.10, -0.10, 0.00>, <-0.10, 2.18, 0.04>}
    box{<0.10, -0.10, 0.00>, <-0.10, 0.04, 0.30>}
    translate <-1.50, 0.00, -8.94>
    texture{T_Chrome_2C
      normal{
        bumps 0.02
        scale 0.05
      }
    }
  }
}                    

#declare Door = union
{
  union
  {
    difference
    {
      box{<0.05, -0.01, -0.125>, <-2.5, 7.0, 0.125>}
      box{<0.00, 0.05, -0.25>, <-2.45, 0.95, 0.25>}  
      #declare LCV = 1;
      #while (LCV < 7)
        box{<0.00, LCV, -0.25>, <-2.45, LCV+ 0.95, 0125>}  
        #declare LCV = LCV+1;
      #end
    }
    #declare LCV = .5;
    #while (LCV < 2.2)  
      cylinder {<-LCV, 0, 0>, <-LCV, 7, 0>, .06}
      #declare LCV = LCV + 0.5;
    #end
    translate <0.00, 0.00, 0.125>
  }
  union
  {
    difference
    {
      box{<0.0, -0.01, -0.125>, <-2.5, 7.0, 0.125>}
      box{<0.05, 0.05, -0.25>, <-2.45, 0.95, 0.25>}  
      #declare LCV = 1;
      #while (LCV < 7)
        box{<0.00, LCV, -0.25>, <-2.45, LCV+ 0.95, 0125>}  
        #declare LCV = LCV+1;
      #end
    }
    #declare LCV = .5;
    #while (LCV < 2.2)  
      cylinder{<-LCV, 0, 0>, <-LCV, 7, 0>, .06}
      #declare LCV = LCV + 0.5;
    #end
    translate <2.5, 0, 0.4>
  }
  box{<2.5, 0.01, 0>,<-2.5, 0, .5>}
  texture {
    pigment{color Gray15}
    normal{
      bumps 0.17
      scale .0175
    } 
  }
  finish{F_MetalA}


}

#declare cell = union 
{
  difference
  {
    box { <3.5, -1,  0.55>, <-3.5, 10, -10>}
    object {cell_interior}
  }
  #if (DrawBed)
    bed
  #end
  #if (DrawSoftLights)
    light_source {
      0*y
      color rgb 1.25
      area_light
      <0.75, 0, 0> <0.25, 0, 3>
      4, 16
      jitter 
      translate <0, 7.8, -3>
    }
  #end
  #if (DrawDoors)
    object {Door}
  #end
}


/****************************************************************
 * Scene layout                                                 *
 ****************************************************************/
  
// Floor  
union{
  plane{y, 0
    texture{CementTexture scale 3}
  }
  box{<0, 0, 4>, <-13, 0.00001, 4.5>
    pigment{color Goldenrod}
  }
}


// cell #1
union{
  object{ cell
    texture{
      pigment{color White}
      normal{
        wrinkles 0.075   
        scale 0.05
      }
      finish{Shiny} 
    }
    texture{DirtyWalls translate <0, -5, 0>}
  }
  text{ttf "ariblk.ttf", "12", 0.1, 0.0 
    rotate y*180
    scale <.25, .25, 1>
    translate <0, 7.25, .551>
    pigment{color Gray15}
  }
}

// cell #2
union{           
  object{ cell 
    texture{
      pigment{color White}
      normal {
        wrinkles 0.075
        scale 0.05
      } 
      finish{Shiny} 
    }
    texture{DirtyWalls translate<6.5, -5, 0>}
  }
  text{ttf "ARIBLK.ttf", "13", 0.1, 0.0
    rotate y*180                                                                                             
    scale <.25, .25, 1>
    translate <0, 7.25, .551>
    pigment{color Gray15}
  }
  translate <-6.5, 0, 0>

}

// cell #3
union{
  object{ cell 
    texture{
      pigment{color White}
      normal {
        wrinkles 0.075   
        scale 0.05
      } 
      finish{Shiny} 
    }
    texture{DirtyWalls translate<13, -5, 0>}
  }
  text{ttf "ariblk.ttf", "14", 0.1, 0.0
    rotate y*180
    scale <.25, .25, 1>
    translate <0, 7.25, .551>
    pigment{color Gray15}
  }
  translate <-13, 0, 0>
}    



// pipes over cells
union { 
  cylinder{<3, 8, 0.59>, <-16, 8, 0.59>, 0.04}

  cylinder{<3, 8.09, 0.59>, <-10.09, 8.09, 0.59>, 0.04}                  
  sphere{<-10.09, 8.09, 0.59>, 0.04}
  cylinder{<-10.09, 8.09, 0.59>, <-10.09, 9.5, 0.59>, 0.04}

  cylinder{<3, 8.18, 0.59>, <-10, 8.18, 0.59>, 0.04}
  sphere{<-10, 8.18, 0.59>, 0.04}
  cylinder{<-10, 8.18, 0.59>, <-10, 9.5, 0.59>, 0.04}
  
  texture{T_Chrome_4A}
}     



#declare OBJuvPOVmaxX =  .102515;
#declare OBJuvPOVminX = -.109485;
#declare OBJuvPOVmaxY =  .599023;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .0580599;
#declare OBJuvPOVminZ = -.235591;
#declare OBJuvPOV_Texture = texture{pigment{color Flesh}}// finish {Dull}}
#declare OBJuvPOV_Texture_OBJuvPOVshirt = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare ConvObject =
union
{
    #include "prisoner.inc"
}
object {ConvObject
  rotate <0, 180, 0>
  scale 8
  translate <-11.75, 0.13, -0.8>
}