// includes
#include "colors.inc"
#include "glass.inc"
#include "metals.inc"
#include "consts.inc"
#include "woods.inc" 
  
// Variables
#declare rw=6;          // Room Width
#declare rd=8;          // Room depth
#declare rh=3;          // Room height
#declare cl=<3,1,1>;    // Camera location
#declare ct=<1,1,7>;    // Camera target
#declare lc=<.7,.7,1>;  // lighning color
#declare dw=.3;         // Wall Diffusion
#declare nf=3;          // Number of Frame Levels
#declare nd=8;         // Number of steps to make scissor like hands
#declare nh=4;          // Number of Head Sphere Levels
#declare lv=0;          // Loop Variable

// Globals
global_settings {
        assumed_gamma 1
        radiosity {
                pretrace_start 0.08
                pretrace_end   0.04
                count 35
                nearest_count 5
                error_bound 0.2
                recursion_limit 1
                low_error_factor .5
                gray_threshold 0.0
                minimum_reuse 0.015
                brightness 1
                adc_bailout 0.01/2
        }
}

// Camera
camera {
        location        cl
        look_at        ct
}

// Lights

//  -Light from lightning
light_source {
        <8,2,4>
        color   lc
}
//  -Light for painting
light_source {
        <0.1, 1, rd-2.5>,
        color  Col_Amber_01
        fade_distance 1
        fade_power 2
        looks_like { 
                cylinder {
                        <0.1, 1, rd-2.01>,
                        <0.1, 1, rd-2.99>,
                        0.005       
                }
        }
        
}
// Misc items 

sphere {    
        <1,.5,2.5>
        .5
        hollow on
        finish {
                F_Glass8
                reflection 0.5
        }
        pigment {
                gradient y
                color_map {
                [0.0 1.0 color Blue color Gray30]
                }
                scale 10000
        }
}
sphere {    
        <3,.05,2>
        .05
        hollow on
        finish {
                F_Glass8
                reflection 0.5 
        }
        pigment {
                gradient y
                color_map {
                [0.0 1.0 color Blue color Gray30]
                }
                scale 10000
        }
}
sphere {    
        <rw,rh,rd>
        3
        hollow on
        finish {
                F_Glass8
                reflection 0.5 
        }
        pigment {
                gradient y
                color_map {
                [0.0 1.0 color Blue color Gray30]
                }
                scale 10000
        }
}

// Room

//  -misc wall
box{
        <3,0,rd>
        <3,rh,rd-1.5>
        pigment {
                P_Chrome2
        }
        texture {
                F_MetalD 
        }
}

//  -Ground
box{
        <0, 0, 0>
        <rw, 0, rd>
        texture {
                pigment { 
                        color rgb 1 
                }
                finish { 
                        diffuse dw 
                        ambient 0
                }
        }
}
//  -Cieling
box{
        <0, rh, 0>
        <rw, rh, rd>
        texture {
                pigment { 
                        color rgb 1 
                }
                finish { 
                        diffuse dw 
                        ambient 0
                }
        }
}
//  -Left Wall
box{
        <-0.1, 0, 0>
        <0, rh, rd>
        texture {
                pigment { 
                        color rgb 1 
                }
                finish { 
                        diffuse dw 
                        ambient 0 
                }
        }
}
//  -Back wall
box{
        <0, 0, rd+0.1>
        <rw, rh, rd>
        texture {
                pigment { 
                        color rgb 1 
                }
                finish { 
                        diffuse dw 
                        ambient 0 
                }
        }
}
//  -Front Wall
box{
        <0, 0, 0>
        <rw, rh, -0.1>
        texture {
                pigment { 
                        color rgb 1 
                }
                finish { 
                        diffuse dw 
                        ambient 0 
                }
        }
}
//  -Right wall with window
union {
        box{
                <rw+0.1, 0, (rd*0.6)+0.3>
                <rw, rh, rd>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
        box{
                <rw+0.1, 0, 0>
                <rw, rh, (rd*0.6)-0.3>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
        box{
                <rw+0.1, 2, (rd*0.6)+0.3>
                <rw, rh, (rd*0.6)-0.3>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
        box{
                <rw+0.1, 1, (rd*0.6)+0.3>
                <rw, 0, (rd*0.6)-0.3>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
        box{
                <rw+0.1, 1.5, (rd*0.6)+0.3>
                <rw, 1.55, (rd*0.6)-0.3>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
        box{
                <rw+0.1, 2, (rd*0.6)+0.02>
                <rw, 1, (rd*0.6)-0.02>
                texture {
                        pigment { 
                                color rgb 1 
                        }
                        finish { 
                                diffuse dw 
                                ambient 0 
                        }
                }
        }               
}
//  -light fixture for room
sphere {
        <2,3,5>,
        .3
        pigment{
                color White
        }
        finish {
                diffuse 1
                ambient 1
        }
}
//  -light fixture for painting
union {
        box {
                <0.12, 0.98, rd-2>
                <0, 0.98, rd-2>
                texture{
                        T_Chrome_3C
                }
        }
        box {
                <0.12, 0.98, rd-3>
                <0, 0.98, rd-3>
                texture{
                        T_Chrome_3C
                }
        }
        box {
                <0.12, 0.98, rd-3>
                <0, 0.98, rd-2>
                texture{
                        T_Chrome_3C
                }
        }
        box {
                <0.12, 1.02, rd-3>
                <0.12, 0.98, rd-2>
                texture{
                        T_Chrome_3C
                }
        }
}
//  -Frame & picture
union { 
        plane{  
                <0,0,1>
                1
                        pigment {
                                image_map {
                                        png "prof.png"
                                        map_type 0 
                                        interpolate 2
                                }
                                translate <.5,0,.65>
                                scale <.7,.7,.7>
                        }
                rotate 90
                translate <0.001, 1.01, rd-1.9>
                bounded_by {
                        box{
                                <0.001, 1.01, rd-1.9>
                                <0.001, 2, rd-3.1>
                        }
                }
        }
        #while (lv<nf)
        box {
                <0.001, 1.01+(lv/100), rd-1.9>
                <0.001+(lv/100), 1.02+(lv/100), rd-3.1>
                texture {
                        T_Wood19
                }
        }
        box {
                <0.001, 2-(lv/100), rd-1.9>
                <0.001+(lv/100), 2-(lv/100), rd-3.1>
                texture {
                        T_Wood19
                }
        }
        box {
                <0.001, 2, rd-3.1>
                <0.001+(lv/100), 1.01, rd-(3.1+(lv/100))>
                texture {
                        T_Wood19
                }
        }
        box {
                <0.001, 2, rd-1.9>
                <0.001+(lv/100), 1.01, rd-(1.9+(lv/100))>
                texture {
                        T_Wood19
                }
        }
        #declare lv=lv+1;
        #end
        #declare lv=0;
}
// Creature
blob{
        threshold 0.65
        #while (lv<nh)
        sphere {
                <2,1-(lv*.1),7>,
                .3-(lv*.03),
                2
        }
        #declare lv=lv+1;
        #end
        #declare lv=0;
        cylinder{
                <2,.6,7>,
                <2,.4,7>,
                .15,
                1
        }
        cylinder{
                <2,.4,7>,
                <1.5,.7,6>,
                .15,
                1
        }
        cylinder{
                <1.5,.7,6>,
                <1,.9,5.5>,
                .15,
                1
        }
        sphere {
                <1.5,.7,6>,
                .05,
                1
        }
        #while (lv<nd)
                cylinder{
                        <1-(lv*0.01),0.9+(lv*0.008),5.5-(lv*0.01)>,
                        <1-(lv*0.01),0.85+(lv*0.009),5.5-(lv*0.01)>,
                        0.1-(lv*0.01),
                        1
                }                

                #declare lv=lv+1;
        #end
        #declare lv=0;
        cylinder{
                <2,.4,7>,
                <2,.1,5>,
                .23,
                1
        }
        cylinder{
                <1.8,.1,5>,
                <1.8,.4,4>,
                .17,
                1
        }
        cylinder{
                <2.2,.1,5>,
                <2.2,.4,4>,
                .17,
                1
        }
        cylinder{
                <1.8,.4,4>,
                <1.8,0,3>,
                .17,
                1
        }
        cylinder{
                <2.2,.4,4>,
                <2.2,0,3>,
                .17,
                1
        }
        pigment{
                color White
        }
        finish { 
                diffuse 1
                ambient .1 
        }
} 
blob{
        threshold 0.65
        cylinder{
                <3.5,.1,7>,
                <4,.1,6>,
                .17,
                1
        }
        cylinder{
                <4,.1,6>,
                <3.5,.1,5>,
                .17,
                1
        }
        pigment{
                color White
        }
        finish { 
                diffuse 1
                ambient .1 
        }
}        
sphere {
        <1.95,.97,6.9>
        0.15
        pigment {
                color Col_Blue_02
        }
        finish { 
                reflection {
                        0.0, .5
                        fresnel on
                }
                diffuse 1
                ambient .3
        }
}
sphere {
        <1.89,.985,6.6>
        0.05
        pigment {
                color Black
        }
        finish { 
                diffuse 1
                ambient .3
        }
}
