// by veijo.vilva@animal.helsinki.fi

                // the light sources can be individually tested
	       
#declare Sunshine = 1;  // the Sun
#declare Has_Lamps = 1; // the three lamps on the wall
#declare LPow = 0.27;   // Lamp intensity
#declare Spots = 1;     // Interior spotlights
#declare Ambient = 1;   // Ambient illumination

               // the golden tower, the mirage effect and the abyss can be
	       // left out for speed reasons when testing other parts of the
	       // image
	       
#declare GTower = 1;        // the golden tower
#declare Mirage_Effect = 1; // the shimmering air in front of the golden tower 
#declare Abyss = 1;         // the abyss crossing the terrain

#include "colors.inc"
#include "stones.inc"
#include "golds.inc"
#include "woods.inc"
#include "consts.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
// #include "instrum.inc"  // the harpsichord, the seat
// #include "utensils.inc" // the goblet, the cup

camera {
  location <0, 7.5, -20>
  look_at <0,1.5,0>
  angle 30
  right 1.5*x
  }

global_settings { ambient_light rgb <0,0,0> }
  
#if ( Sunshine )
light_source {
  <40,50,-50>
  rgb <0.6,0.6,0.6>
  spotlight
    radius 5
    falloff 20
    tightness 0
    point_at <-2,2.5,-5>
  area_light <15,0,0>, <0,15,0>
    3, 3
    adaptive 1
    jitter
  }
#end

#if ( Ambient )
  light_source { <-100,102,0> rgb <0.25,0.25,0.25>
  area_light <0,200,0>, <0,0,200>
    2, 2
    adaptive 1
    jitter
    }
  light_source { <100,102,0> rgb <0.25,0.25,0.25>
  area_light <0,200,0>, <0,0,200>
    2, 2
    adaptive 1
    jitter
    }
  light_source { <0,102,-100> rgb <0.25,0.25,0.25>
  area_light <200,0,0>, <0,200,0>
    2, 2
    adaptive 1
    jitter
    }
  light_source { <0,102,100> rgb <0.25,0.25,0.25>
  area_light <200,0,0>, <0,200,0>
    2, 2
    adaptive 1
    jitter
    }
#end

sky_sphere { // modified from S_Cloud5
    pigment { rgb <0.220, 0.210, 0.230> }
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.8
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
}


#declare M_FlW1 = material {
  texture { T_Wood1 rotate 90*y scale 0.15
  finish { ambient 0 diffuse 0.6
    specular 0.25 roughness 0.02 reflection 0.02 }
    }
  }

#declare M_FlW2 = material {
  texture { T_Wood2 rotate 90*y scale 0.15
    finish { ambient 0 diffuse 0.6
    specular 0.25 roughness 0.02 reflection 0.02 }
    }
  }

#declare Ground = union {
  height_field {
    tga "hf2b.tga"  // 1024x768
    smooth
    scale <50, 0.4, 50>
    translate <-25,-1.5,-10>
    texture { T_Stone17 scale 0.3 }
    }
  height_field {
    tga "hf3b.tga"  // 1024x768
    smooth
    scale <50, 0.8, 50>
    translate <-25,-1.7,-10>
    texture { T_Stone17 }
    }
  }
  
#declare GroundS = difference {
  object { Ground }
  height_field {
    tga "hf3b.tga"  // 1024x768
    smooth
    scale <50, 0.8, 50>
    translate <-25,-2.2,-10>
    texture { T_Stone17 }
    }
  }

#if ( Abyss )
difference {
  object { Ground }
  object { GroundS
    translate -10*z scale <1,7,1>
    rotate 40*x
    rotate 15*y
    translate 29*z
    }
  }
#else
  object { Ground }
#end

#declare TFace = union {
  intersection {
    height_field {
      tga "hf3.tga" // 640x480
      scale <10, 0.03, 10>
      translate 0.05*y
      }
    box { <0,-0.1,0>, <4.2,2,2>}
    translate <-2.1,0,-1>
    rotate -90*x
    texture { T_Silver_5C }
    }
  sphere { <-1.6,-0.5,0> 0.2 } 
  sphere { <-1.6,0.5,0> 0.2 } 
  sphere { <1.6,-0.5,0> 0.2 } 
  sphere { <1.6,0.5,0> 0.2 } 
  texture { T_Gold_3C }
  }

#declare TFace1 = intersection {
  height_field {
    tga "hf3.tga" // 640x480
    scale <10, 0.03, 10>
    translate 0.05*y
    }
  box { <0,-0.1,0>, <4.2,2,2>}
  translate <-2.1,0,-1>
  rotate -90*x
  texture { T_Chrome_2C }
  }

#declare TFace2 = intersection {
  height_field {
    tga "hf.tga" // 640x480
    smooth
    scale <10, 0.15, 10>
    translate 0.05*y
    }
  box { <0,-0.1,0>, <4.2,2,2>}
  translate <-2.1,0,-1>
  rotate -90*x
    texture { T_Gold_4B }
  }

#macro WTile( S, AX, AY, DY, DZ ) union {
  box { <-2.1,-1,0.1>, <2.1,1,1.9> pigment { Black } }
  #if ( S )
    object { TFace1 rotate 0.5*AX*x rotate 0.5*AY*y translate <0,-0.1,DZ> }
    object { TFace rotate (180+AX)*x rotate AY*y 
      translate <0,DY-0.1,1.9> scale <0.9,0.9,1>
      }
    cone { <0,0.3,1.8>, 0.2
           <0,-0.7,3.8> , 0.01
           texture { T_Gold_3C }
         }
  #else
    object { TFace2 rotate 180*x translate <0,-0.1,1.9> scale <0.9,0.9,1> }
  #end

  scale <0.1,0.1,0.15>
  }
#end

#declare Pen = union {
  cylinder { <-0.6,0.05,0>, <0.6,0.05,0> 0.05 pigment { Yellow } }
  cone { <-0.72,0.05,0>, 0.02
         <-0.6,0.05,0>, 0.05
	 pigment { rgb <0.6,0.3,0.2> }
       }
  }

#macro Book(R,G,B,H) intersection {
  union {
    cylinder { <0,0,0>, <0,0.135*H,0> 0.06 }
    cylinder { <0,0.085*H,0>, <0,0.105*H,0> 0.061
      texture { T_Gold_4B }
      }
    }
  box { <-0.015,-0.01,-0.1>, <0.015,0.18,0.12> }
  pigment { rgb <R, G, B> }
  translate 0.06*z
  }
#end

#declare BookShelf = union {
  box { <-0.27,0,-0.005>, <0.27,0.9,0.005> }
  box { <-0.28,0,-0.14>, <-0.27,0.9,0.005> }
  box { <0.27,0,-0.14>, <0.28,0.9,0.005> }
  box { <-0.27,0.89,-0.14>, <0.27,0.9,0.005> }
  box { <-0.27,0.72,-0.14>, <0.27,0.73,0.005> }
  box { <-0.27,0.54,-0.14>, <0.27,0.55,0.005> }
  box { <-0.27,0.36,-0.14>, <0.27,0.37,0.005> }
  box { <-0.27,0.18,-0.14>, <0.27,0.19,0.005> }
  box { <-0.27,0,-0.14>, <0.27,0.01,0.005> }
  #declare RS = seed(127);
  #declare BR = 0;
  #while (BR < 5)
    #declare BL = 0.18*BR+0.01;
    #declare BC = 0;
    #while (BC < 17)
      object { Book( 0.4+0.1*sin(180*rand(RS)),
                     0.4+0.1*sin(180*rand(RS)),
		     0.4+0.1*sin(180*rand(RS)),
		     0.92+0.15*sin(180*rand(RS)))
        translate <0.03*BC-0.24,BL,-0.13+0.01*sin(180*rand(RS))>
	}
      #declare BC = BC+1;
      #end
    #declare BR = BR+1;
    #end
  material { M_FlW2 }
  }
  
#declare Opus = union {
  box { <-0.6,0,0>, <0.6,1.75,0.3> texture { T_Stone17 } }
  text { ttf "timrom.ttf" "OPUS" 0.15, 0
    texture { T_Gold_3A }
    scale 0.4
    translate <-0.48,1.1,-0.017>
    }
 scale 0.25
 }

#declare Table = union {
  box { <-0.15,0,-0.15>, <0.15,0.36,0.15> material { M_FlW2 } }
  union {
    cylinder { <-0.13,0.02,-0.15>, <0.13,0.02,-0.15> 0.005 }
    cylinder { <-0.13,0.34,-0.15>, <0.13,0.34,-0.15> 0.005 }
    cylinder { <-0.13,0.02,-0.15>, <-0.13,0.34,-0.15> 0.005 }
    cylinder { <0.13,0.02,-0.15>, <0.13,0.34,-0.15> 0.005 }
    cylinder { <-0.15,0.02,-0.13>, <-0.15,0.02,0.13> 0.005 }
    cylinder { <-0.15,0.34,-0.13>, <-0.15,0.34,0.13> 0.005 }
    cylinder { <-0.15,0.02,-0.13>, <-0.15,0.34,-0.13> 0.005 }
    cylinder { <-0.15,0.02,0.13>, <-0.15,0.34,0.13> 0.005 }
    cylinder { <0.15,0.02,-0.13>, <0.15,0.02,0.13> 0.005 }
    cylinder { <0.15,0.34,-0.13>, <0.15,0.34,0.13> 0.005 }
    cylinder { <0.15,0.02,-0.13>, <0.15,0.34,-0.13> 0.005 }
    cylinder { <0.15,0.02,0.13>, <0.15,0.34,0.13> 0.005 }
    texture { T_Gold_3C }
    }
  // object { Goblet scale 0.7 translate <0.05,0.36,0.04> }
  // object { Cup scale 0.7 translate <-0.07,0.36,0.03> }
  }

#declare Lamp =
  union {
    light_source { <0,0,0> color rgb <LPow,LPow,LPow>
      spotlight
      radius 85
      falloff 90 
      tightness 0
      point_at <0,-3,0>
      }
    union {
      difference {
        sphere { <0,0,0> 0.132 }
        sphere { <0,0,0> 0.131 }
        box { <-1,-1,-1>, <1,0,1> }
        }
      cylinder { <0,0.125,0>, <0,0.175,0> 0.025 }
      sphere { <0,0.175,0> 0.025 }
      cylinder { <0,0.19,0.03>, <0,0.19,-0.43> 0.016 }
      cylinder { <0,-0.3,-0.4>, <0,0.25,-0.4> 0.02 }
      difference {
        torus { 0.11 0.005 rotate 90*z }
        box { <-1,-1,-1>, <1,0,1> }
	translate 0.06*y
        }
      difference {
        torus { 0.11 0.005 rotate 90*x }
        box { <-1,-1,-1>, <1,0,1> }
	translate 0.06*y
        }
      difference {
        torus { 0.132 0.005 rotate 90*z }
        box { <-1,-1,-1>, <1,0.02,1> }
        }
      difference {
        torus { 0.132 0.005 rotate 90*x }
        box { <-1,-1,-1>, <1,0.02,1> }
        }
      texture { T_Gold_3C }
      }
    }

#macro BWalls( T ) union {
    #declare RST = seed(117);
    #declare L = 0;
    #while (L < 28)
      union {
        #declare Count = 0;
        #while (Count < 36)
          #if ((L < 24) | (L > 26) | ((L = 24) & ((Count < 19) | (Count > 21))) | ((L > 24) & ((Count < 20) | (Count > 22))))
            object {
	      WTile ( T, -2+4*rand(RST),2*rand(RST)-1,-0.055+0.11*rand(RST),
	        0.05*rand(RST)-0.025)
              rotate (10*Count-90)*y
              translate vrotate (<0,0,2>, <0,10*Count-90, 0>)
              }
            #end
          #declare Count = Count+1;
          #end
        translate (0.2*L-2)*y
        rotate (-5*L)*(0.99+0.02*rand(RST))*y
        }
      #declare L = L+1;
      #end
    #declare HP = 0.2*L-2.1;
  }
#end

#macro TWalls( T ) union {
    object { BWalls( T ) }
    cylinder { <0,2.4,0>, <0,2.5,0> 2
      texture { T_Wood7 scale 0.02 rotate 90*y }
      }
    torus { 2 0.03 translate (HP-0.02)*y
      texture { T_Chrome_1B }
      }
    #if ( T )
    #else
    difference {
      union {
        #declare WCount = 0;
        #while ( WCount < 40 )
          box { <-0.14,2.5,-0.05>, <0.14,HP,0.01> 
            rotate (9*WCount-7)*y translate vrotate(<0,0,2>, <0,9*WCount-7,0>)
	    #if ( T )
             texture { T_Stone31 scale <0.05,0.05,(0.05+0.02*sin(exp(Count+7)))>
            #else
	      texture { T_Wood7 scale <0.25,0.15,(0.14+0.02*sin(exp(Count+7)))>
            #end
	      rotate -90*x
              normal { bozo 0.005 scale 0.5 }
               translate (-4+2*sin(exp(Count+5)))*y
	      finish { specular 0.15 roughness 0.02 reflection 0.02 }
              }
	    }
          #declare WCount = WCount+1;
          #end
	}
      union {
	box { <-0.38,0.05,1>, <-0.03,0.61,3> }
	box { <0.03,0.05,1>, <0.38,0.61,3> }
        translate (HP-0.83)*y
        rotate -7*y
        material { M_FlW2 rotate -90*x scale 0.1 }
	}
      }
    #end
        
    #if ( Has_Lamps )
      object { Lamp scale 0.8 translate <0,3.55,0>
        rotate 173*y translate vrotate(<0,0,1.72>, <0,-7,0>) 
        }
      object { Lamp scale 0.8 translate <0,3.55,0>
        rotate 73*y translate vrotate(<0,0,1.72>, <0,-87,0>) 
        }
      object { Lamp scale 0.8 translate <0,3.6,0>
        rotate -97*y translate vrotate(<0,0,1.72>, <0,83,0>) 
        }
    #end
    }
#end

#declare Pic = union {
  union {
    object { BWalls ( 0 )
      scale <0.4,0.4,0.4>
      translate <0,1,0>
      }
    box { <-1.2,0,-0.05>, <1.2,3.17,0>
      texture { T_Stone8 scale 0.1 }
      }
    box { <-0.1,-0.3,0>, <0.1,3.5,0.1> }
    box { <-1.5,-0.1,0>, <1.5,0.1,0.1> }
    box { <-1.5,-0.1,-0.3>, <1.5,0,0.1> }
    box { <-1.5,3.07,0>, <1.5,3.27,0.1> }
    box { <-1.5,3.17,-0.1>, <1.5,3.27,0.1> }
    material { M_FlW2 }
    rotate 30*x
    }
  box { <-0.2,-6,0.7>, <0.2,1.27,0.85> }
  box { <-2,-6,0.45>, <2,-5.8,1.1> }
  difference {
    union {
      box { <-2,-6.2,-0.7>, <-1.7,-5.6,2.5> } 
      box { <2,-6.2,-0.7>, <1.7,-5.6,2.5> }
      }
    cylinder { <-2.1,-5.5,-0.7>, <2.1,-5.5,-0.7> 0.5 }
    cylinder { <-2.1,-5.5,2.5>, <2.1,-5.5,2.5> 0.5}
    }
  cylinder { <-1.85,-5.9,1.8>, <0,-3,0.775> 0.1 texture { T_Gold_3A } }
  cylinder { <1.85,-5.9,1.8>, <0,-3,0.775> 0.1 texture { T_Gold_3A } }
  box { <-1.3,-1,-1.5>, <1.3,-1.1,1> }
  box { <-1.3,-1,-1.5>, <1.3,-0.9,-1.4> }
  object { Pen rotate 30*y translate <-0.2,-1,-1> }
  object { Pen rotate 20*y translate <0,-1,-0.65> }
  translate 6.2*y
  material { M_FlW2 }
  }

#declare Tower = union {
  object { TWalls( 1 ) }
    intersection {
      union {
        difference {
          cylinder { <0,0,0>, <0,0.66,0> 2.35 }
          cylinder { <0,-0.1,0>, <0,0.81,0> 1.95 }
	  union {
	    box { <-0.35,0.05,1>, <-0.03,0.61,3> }
	    box { <0.03,0.05,1>, <0.35,0.61,3> }
            material { M_FlW1 rotate -90*x scale 0.1 }
	    }
	  }
	union {
	  torus { 1.95 0.005 translate 0.025*y }
	  torus { 1.98  0.01 translate 0.19*y }
	  torus { 1.98  0.01 translate 0.33*y }
	  torus { 1.98  0.01 translate 0.47*y }
	  torus { 1.95 0.005 translate 0.635*y }
	  cylinder { <0,0,0>, <0,0.66,0> 0.01
	    translate vrotate(<0,0,1.98>, <0,-5.3,0>)
	    }
	  cylinder { <0,0,0>, <0,0.66,0> 0.01
	    translate vrotate(<0,0,1.98>, <0,5.3,0>)
	    }
	  texture { T_Gold_3A }
	  }
	}
      box { <-0.6,-0.1,1>, <0.6,0.81,3> }
      material { M_FlW2 rotate -90*x scale 0.1 }
      translate (HP-0.83)*y
      rotate -7*y
      }
  // object { CemSeat scale 0.5 translate <0.3,2.5,-0.2> }
  // object { Cem ( CBMat ) scale 0.5 rotate 35*y translate <0.8,2.5,-0.4> }
  object { BookShelf
    translate 2.5*y
    rotate 25*y
    translate vrotate(<0,0,1.9>, <0,25,0>)
    }
  object { Pic
    scale 0.09
    rotate -36*y
    translate <-1,2.5,1.2>
    }
  object { Table translate <0,2.5,0>
    rotate -55*y translate vrotate(<0,0,1.7>, <0,-55,0>)
    }
  object { Opus rotate 25*x translate <0,2.5,0>
    rotate 7*y translate vrotate(<0,0,1.72>, <0,7,0>)}
  #if ( Spots )
    light_source {
      <0.3,4.3,-2>
      rgb <1,1,1>
      spotlight
      radius 20
      falloff 23
      tightness 20
      point_at <1.15,2.82,0>
      }
    light_source {
      <0,4.3,-2>
      rgb <0.6,0.6,0.6>
      spotlight
      radius 15
      falloff 20
      tightness 20
      point_at <-1.1,3.2,0>
      }
  #end
  }

#declare Spike = union {
  cone { <0,1.3,0>, 0.025 <0,1.14,-0.375> , 0.002 }
  difference {
    cone { <0,1.3,0>, 0.03 <0,1.14,-0.375> , 0.002 }
    box { <-0.1,1.1,-0.4>, <0.1,1.4,-0.075> } 
    }
  texture { T_Silver_3E }
  }

#declare Cage = union {
  #declare Count = 0;
  #while (Count < 36)
    union {
      cylinder { <0,-2,0>, <0,1.28,0> 0.05 texture { T_Chrome_2A } }
      cylinder { <0,1.26,-0.1>, <0,1.26,0> 0.03 texture { T_Chrome_2A } }
      sphere { <0,1.28,0> 0.05 texture { T_Chrome_2A } }
      cylinder { <0,1.04,0>, <0,0.94,-0.10> 0.03 texture { T_Chrome_2A } }
      cylinder { <0,0.84,0>, <0,0.94,-0.10> 0.03 texture { T_Chrome_2A } }
      rotate (10*Count)*y
      translate vrotate(<0,0,5>, <0,10*Count,0>)
      }
    cylinder { <0,-2,0>, <0,1.3,0> 0.02
      translate vrotate(<0,0,5>, <0,10*Count+2.5,0>)
      }
    cylinder { <0,-2,0>, <0,1.3,0> 0.02
      translate vrotate(<0,0,5>, <0,10*Count+5,0>)
      }
    cylinder { <0,-2,0>, <0,1.3,0> 0.02
      translate vrotate(<0,0,5>, <0,10*Count+7.5,0>)
      }
    #declare Count = Count+1;
    #end
  #declare Count = 0;
  #while (Count < 16)
    torus { 5 0.02 translate (-2+0.2*Count)*y }
    #declare Count = Count+1;
    #end
  torus { 5 0.03 translate 1.3*y texture { T_Chrome_2A } }
  torus { 4.9 0.03 translate 1.26*y texture { T_Chrome_2A } }
  torus { 4.9 0.03 translate 0.94*y texture { T_Chrome_2A } }
  #declare Count = 0;
  #while (Count < 144)
    union {
      object { Spike translate <0,-0.04,-0.1> }
      object { Spike translate <0,-0.36,-0.1> }
      rotate (2.5*Count)*y
      translate vrotate(<0,0,5>, <0,2.5*Count,0>)
      }
    #declare Count = Count+1;
    #end
  texture { T_Gold_3B }
  }

#declare MandelIris1 = intersection {
  box { <0,0,0>, <1,1,0.01> 
    texture {
    pigment { 
      mandel 100
      color_map {
        [0.0 rgb <0.1,0.6,0.7> ]
        [0.02 rgb <0.15,0.75,0.9> ]
	[0.04 color Yellow ]
	[0.3 color Brown ]
	[0.97 color Gray90 ]
	[1.0 color Black ]
	}
      scale 0.2
      translate <0.55,0.45,0>
      }
     }
    }
  cylinder { <0.5,0.5,-0.1>, <0.5,0.5,0.1> 0.50 }
  translate <-0.5,-0.5,0>
  }

#declare BPigm = pigment {
          bozo scale <0.18,0.18,0.1>
          turbulence 1.5
          octaves 10
          omega .5
          lambda 2.5
          color_map {
            [0 rgb <0.1,0.6,0.75>]
            [0.5 rgb <0.1,0.6,0.75>]
	    [0.9 color Yellow ]
            [1 rgb <0.15,0.75,0.9>]
            }
	  }

#declare BPigm2 = pigment {
          bozo scale <0.15,0.15,0.1>
          turbulence 1.5
          octaves 8
          omega .5
          lambda 2.5
          color_map {
            [0 rgb <0.15,0.75,0.9>]
            [0.4 rgb <0.15,0.75,0.9>]
	    [1 color Yellow ]
            }
	  }

#declare Pigm2 = pigment { rgb <0.15,0.75,0.9> }
#declare Pigm3 = pigment { color Yellow }
#declare Pigm4 = pigment { color Brown }
#declare Pigm5 = pigment { color Gray90 }
#declare Pigm6 = pigment { color Black }

#declare MandelIris = intersection {
  box { <0,0,0>, <1,1,0.01> 
    texture {
    pigment { 
      mandel 100
      pigment_map {
        [0.0 BPigm ]
        [0.018 BPigm2 ]
	[0.04 Pigm3  ]
	[0.3 Pigm4  ]
	[0.97 Pigm5 ]
	[1.0 Pigm6 ]
	}
      scale 0.2
      translate <0.55,0.45,0>
      }
     }
    }
  cylinder { <0.5,0.5,-0.1>, <0.5,0.5,0.1> 0.50 }
  translate <-0.5,-0.5,0>
  }

#declare Eye = union {
  difference {
    sphere { <0,0,0> 1 pigment { White }
      finish { ambient 0 diffuse 0.7
      specular 0.2 roughness 0.005 reflection 0.01 }
      }
    box { <-2,-2,-2>, <2,2,-0.9115> }
    }
  object { MandelIris scale 0.83 translate -0.911501*z }
  difference {
    sphere { <0,0,-0.345> 0.7 }
    box { <-2,-2,-0.90>, <2,2,2> }
    texture { T_Glass3 } interior { I_Glass }
    }
  }

union {
  object { Tower rotate -5*y translate -1.8*y }
  object { Cage }
  object { Eye rotate 25*x rotate -5*y scale 0.3 translate <2.65,-1.12,2.05> }
  translate <-2.5,0,-2.5>
  }

#if ( GTower )
object { TWalls( 0 ) rotate 60*y translate <-7.2,-1.5,26> }
#end

#if ( Mirage_Effect )
union {
  height_field {
    tga "hf2b.tga"  // 1024x768
    smooth
    scale <20, 0.07, 15>
    }
  box { <0,-0.101,0>, <20,-0.098,15> }
  rotate -90*x
  rotate -30*y
  pigment { rgbt <1,1,1,1> } interior { ior 1.05 }
  translate <-18.4,-1,12>
  }
#end

