
// Castle ////////////// 

#declare Castle = 

merge {
        
    merge{    
        box{<  -30,  -39,  -40>,<  -26,  11, -20>} //base top
        box{<  -26,  -39,  -40>,<  -22,  21, -20>}
        box{<  -22,  -39,  -40>,<  -18,  11, -20>}
        box{<  -18,  -39,  -40>,<  -14,  21, -20>} 
        box{<  -14,  -39,  -40>,<  -10,  11, -20>} 
        box{<  -10,  -39,  -40>,<   -6,  21, -20>}
        box{<   -6,  -39,  -40>,<   -2,  11, -20>} 
        box{<   -2,  -39,  -40>,<    2,  21, -20>} 
        box{<    2,  -39,  -40>,<    6,  11, -20>}
        box{<    6,  -39,  -40>,<   10,  21, -20>} 
        box{<   10,  -39,  -40>,<   14,  11, -20>} 
        box{<   14,  -39,  -40>,<   18,  21, -20>} 
        box{<   18,  -39,  -40>,<   22,  11, -20>}
        box{<   22,  -39,  -40>,<   26,  21, -20>} 
        box{<   26,  -39,  -40>,<  29.999, 11, -20>} 
        texture {T_Grnt25 scale 8}             
        #if (PreTrace = 0)
                finish{ambient .5 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }
    
    merge {
        box{<  -10,  -40,  -42 >,< 10,  -15, -41.5> // door
            texture{T_Wood1 scale 8}
        #if (PreTrace = 0)
                finish{ambient .1 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
        } 

        disc { <0, -12.5, -42>  // center position
               z,         // normal vector
               10,       // outer radius
               texture{T_Wood1 scale 8}
               #if (PreTrace = 0)
                    finish{ambient .1 }
               #else
                    finish {ambient .4 diffuse .4 }
               #end
               clipped_by {sphere {<0, -12.5, -42>,15}}
               }
    }
    
    merge{    
        box{<  -50,  -39,  -45>,<    -46,  40, -20>} //left tower
        box{<  -46,  -39,  -45>,<    -42,  30, -20>} 
        box{<  -42,  -39,  -45>,<    -38,  40, -20>} 
        box{<  -38,  -39,  -45>,<    -34,  30, -20>} 
        box{<  -34,  -39,  -45>,<    -29.999,  40, -20>} 
        texture {T_Grnt25 scale 8}             
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }

    merge{        
        box{<   30,  -39,  -45>,<   34,  40, -20>} //right tower
        box{<   34,  -39,  -45>,<   38,  30, -20>} 
        box{<   38,  -39,  -45>,<   42,  40, -20>} 
        box{<   42,  -39,  -45>,<   46,  30, -20>} 
        box{<   46,  -39,  -45>,<   49.9,  40, -20>} 
        texture {T_Grnt25 scale 8 }          
/*        texture{ pigment { crackle scale 3
                           color_map{
                                     [0.0 rgbf <  0,  0,  0, .9>]
                                     [0.2 rgbf <  0,  0,  0, .9>]
                                     [0.2 rgbf <  .5,  .5,  .5, .9>]
                                     [1.0 rgbf <  .5,  .5,  .5, .9>]
                                    }
                         } 
               } */            
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    } 
    
    difference{
        cylinder{ < 0,   0, -25 >, < 0, 70, -25>,4} //center tower 
        box{ < -2,  55, 30>,< 2, 65, -30>}
        texture {T_Grnt25 scale 8}
 
        #if (PreTrace = 0)
                finish{ambient .5 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }
    
        cylinder { <0, 50, -20>, < 0, 51, -20>, 15
              texture{T_Wood1}
        #if (PreTrace = 0)
                finish{ambient .5 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
              }
 
        cone    { < 0 , 70, -20 >,7 , < 0, 110, -20>,0 //tower top
        texture{ T_Wood1 }
        #if (PreTrace = 0)
                finish{ambient .5 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
        } 
    scale .25 
}

#declare Flag=
        triangle{ <0,0>, <0,10>, <5,5>  //flag
                 scale <1,.25,.25>
                 //rotate x*90 
                 pigment { checker Gray50, Black scale .7}
                 #if (PreTrace = 0)
                      finish{ambient 0 }
                 #else
                      finish {ambient .4 diffuse .4 }
                 #end
        } 


//  Houses  /////////////////

#declare ThatchTex =        //base on brown, not green
     texture {
              pigment {
                         gradient z scale 8
                         color_map {
                                    [0.0  rgb <.18, .3,  .18>] //dark green
                                    [0.3  rgb <.18, .3,  .18>] //dark green
                                    [0.3  rgb <.60, .80, .18>] //yellow green
                                    [0.6  rgb <.60, .80, .18>] //yellow green
                                    [0.6  rgb <.42, .28, .21>] //tan
                                    [1.0  rgb <.13, .55, .13>] //tan
                                   } turbulence .5
                      } normal { gradient z scale 4}
     } 
     texture {
              pigment {
                         gradient x scale 8 
                         color_map {
                                    [0.0  rgbt <.84, .84, .74, .9>] //wheat
                                  //[0.3  rgbt <.84, .84, .74, .9>] //wheat
                                    [0.3  rgbt <.50, 1.0, .00, .95>]   //gray
                                    [0.5  rgbt <.50, 1.0, .00, .95>]    //gray
                                 // [0.5  rgbt <.35, .16, .14, .9>] //green
                                    [1.0  rgbt <.13, .55, .13, .9>] //green 
                                   } 
                      } normal { gradient z scale 4}
     } 
     
#declare ThatchTex1 = 
texture {
           pigment {
           image_map { jpeg "Roofplants04.jpg" 
                       map_type 0
                       once
                       interpolate 2
                     }
    }
}       


#declare ThatchTex2 = 
texture {
           pigment {
           image_map { jpeg "Roofnatfl113.jpg"  //8050150
                       map_type 0
                       once
                       interpolate 2
                     }
    }
}       
            
#declare StoneTex =
    texture {  pigment{ 
                       crackle
                       color_map { 
                           [0  rgb <0.20, 0.20, 0.20>]
                           [.2 rgb <0.20, 0.20, 0.20>]
                           [.2 rgb <0.30, 0.30, 0.30>]
                           [.4 rgb <0.30, 0.30, 0.30>]                     
                           [.5 rgb <0.55, 0.55, 0.55>]
                           [.6 rgb <0.55, 0.55, 0.55>]
                           [.6 rgb <0.43, 0.43, 0.43>]
                           [1  rgb <0.43, 0.43, 0.43>]
                      } scale 4 
                    } 
             } 
             

#declare Building2=
merge {

    difference {
        box{<-30,-30,-30>,<30,30,30>
        }
        box{<-40,-10,-10>,<25,10,10>} //window
        box{<-10,-30,-40>,<10,10,40>} //door way 
        texture{StoneTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    } 
    
    box{<0,0,0>,<1,1,1>  //left roof    -33,-3,-33   33,3,33
        texture{ ThatchTex2 rotate x*90 scale 2} 
        scale <66,6,66>
        translate <-33,-3,-33>
        rotate z*45
        translate <-22.999,38.999,0>
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }  

    box{<0,0,0>,<1,1,1>  //left roof    -33,-3,-33   33,3,33
        texture{ ThatchTex2 rotate x*90 scale 2}
        scale <66,6,66>
        translate <-33,-3,-33>
        rotate z*-45
        translate <22.999,38.999,0>
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    } 

    prism {          //roof support
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    5, // ... up through here
    4, // the number of points making up the shape ...
    <0,0>, <0,10>, <5,5>, <0,0>
    scale 5
    rotate x*90 
    rotate z*90
    translate <-23,30,-30>  //x was -25
    texture {StoneTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }  

    box{<-9,-29,-30>,<10,9,-28>  //door
        texture {T_Wood1}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }
    
    box{ <-20,-20,-20>,<0,90,0>  //chimny
        texture{StoneTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient 0.8 diffuse 1.0 }
        #end
    }
    
    light_source {
    <0,0,0>                  // light's position (translated below)
    color rgb <.8,.8,0>    // light's color 
    fade_distance 18
    fade_power 2
    media_interaction off
    media_attenuation off   
    }
    
scale <.3,.2,.2>
hollow on 
no_shadow
} 

#declare Building3=
merge {

   difference {
        box{<-50,-15,-30>,<50,15,30>
        }
        cylinder{<-60,0,0>,<-40,0,0>,10 } //window
        cylinder{<-30,0,-40>,<-30,0,40>,10 } //window
        texture{StoneTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    } 

    box{<0,0,0>,<1,1,1>  //left roof    -53,-3,-33   24,3,33
        texture{ ThatchTex2 rotate x*90 } 
        scale <77,6,66>
        translate <-53,-3,-33>
        rotate z*27
        translate <-22.999,35.999,0>
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }

    box{<0,0,0>,<1,1,1>  //right roof    -53,-3,-33   24,3,33
        texture{ ThatchTex2 rotate x*90 } 
        scale <77,6,66>
        translate <-53,-3,-33>
        rotate z*-27
        translate <48,23,0>
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }

    prism {          //roof support
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    5, // ... up through here
    4, // the number of points making up the shape ...
    <0,0>, <0,10>, <5,5>, <0,0>
    scale <5,5,10>
    rotate x*90 
    rotate z*90
    translate <-50,15,-31> 
    texture {ThatchTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }  

    disc { <0, -3, -30.001>  // center position
           z,         // normal vector
           10,       // outer radius
           texture{T_Wood1}
           #if (PreTrace = 0)
                finish{ambient 0 }
           #else
                finish {ambient 0.8 diffuse 1.0 }
           #end
           clipped_by {sphere {<0, -5, -30.001>,11}}
           } 

    box{ <-40,-10,-20>,<-20,60,0>  //chimny
        texture{StoneTex}
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    }
    
    light_source {
    <-30,0,0>                  // light's position (translated below)
    color rgb <1,1,0>    // light's color 
    fade_distance 18
    fade_power 2
    media_interaction off
    media_attenuation off   
    }
    
scale <.3,.2,.2>
hollow on 
no_shadow
} 

// Stalk  ////////////
#declare X1 = -130;   //-130 = x
#declare Z1 = 570; 

#declare Stalk=
merge {
       sphere_sweep {
       b_spline
       9,
       <X1+0,-10,Z1+0>,8  
       <X1+5,10,Z1+0>,7
       <X1+8,20,Z1+5>,5
       <X1+5,50,Z1+0>,4
       <X1+0,100,Z1+0>,3
       <X1-5,150,Z1+0>,3
       <X1-8,200,Z1-5>,2
       <X1+0,270,Z1-8>,2
       <X1+0,300,Z1+0>,2
       tolerance .000001
      }

      #declare N1 = 0;

      #while (N1<3)
         #if (N1 = 0)
            #declare Rad = -15;
      #else
         #if (N = 1)
            #declare Rad = 18;
         #else 
            #declare Rad = -20;
         #end
      #end
        
      #declare N = 0;

      #while (N < 3)
       
         #declare N3 = rand(R1)*10;
         #if (mod (N3, 2) = 0) 
            #declare Rad = - Rad;
         #end

         sphere_sweep {
             b_spline
             10,
             <X1+(rand(R1)*Rad),  -10, Z1+ (rand(R1)*Rad) >,3  
             <X1-(rand(R1)*Rad),  10, Z1-(rand(R1)*Rad) >,3
             <X1+(rand(R1)*Rad),  20, Z1+(rand(R1)*Rad) >,3
             <X1-(rand(R1)*Rad),  50, Z1-(rand(R1)*Rad) >,2
             <X1+(rand(R1)*Rad), 100, Z1+(rand(R1)*Rad) >,2
             <X1-(rand(R1)*Rad), 150, Z1-(rand(R1)*Rad) >,2
             <X1+(rand(R1)*Rad), 200, Z1+(rand(R1)*Rad) >,1
             <X1-(rand(R1)*Rad), 250, Z1-(rand(R1)*Rad) >,1
             <X1+(rand(R1)*Rad), 400, Z1+(rand(R1)*Rad) >,1
             <X1-(rand(R1)*Rad), 600, Z1-(rand(R1)*Rad) >,1
             tolerance .000001
         }
        #declare N=N+1;
     #end

     #declare N1 = N1 + 1;

   #end
   texture {
            pigment {
                      wood scale 4 
                      color_map { 
                      [0  rgb <0.32, 0.08, 0.08>] //b
                      [.1 rgb <0.32, 0.08, 0.08>]
                      [.1 rgb <0.13, 0.55, 0.13>] //g
                      [.4 rgb <0.13, 0.55, 0.13>]                     
                      [.4 rgb <0.35, 0.16, 0.14>] // b                   
                      [.7 rgb <0.35, 0.16, 0.14>]
                      [.9 rgb <0.31, 0.31, 0.18>] //g
                      [1  rgb <0.31, 0.31, 0.18>]
                      }warp{turbulence 1.5}
                    }   
    }
    normal{bumps 5}  
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
    double_illuminate
    no_shadow
}

#declare Leaf=
sor { 
    10, // # of points
    <   0.5,   0.0 >
    <   0.5,   1.0 > 
    <   0.5,   3.0 >
    <   1.2,   4.0 >
    <   1.5,   5.0 >
    <   1.0,   6.0 >
    <   0.8,   7.0 >
    <   0.2,   9.0 > 
    <   0.2,   10.0 > 
    <   0.2,   11.0 > 
         texture{ pigment{ bozo scale 5   //30
                           color_map{
                                     [0.0 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .13,  .55,  .13,>]
                                     [1.0 rgb <  .13,  .55,  .13,>] 
                                    }
                          } 
                } 
         texture{ pigment{ crackle scale 3
                           color_map{
                                     [0.0 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .13,  .55,  .13, .6>]
                                     [1.0 rgbf <  .13,  .55,  .13, .6>]
                                    } warp{turbulence .5}
                          } 
                } normal {crackle scale 5 }
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
       double_illuminate
   } 


#declare Leaves=
merge {

   #declare N = 0; 

   #while (N<100)
      #object{Leaf 
              scale <2,1.5,2> 
              rotate x*(rand(R1) * 360) 
              rotate y*(rand(R1) * 360)
              rotate z*(rand(R1) * 360)  
              translate <-130, rand(R1) * 150, 570>
              }
      #declare N=N+1;
   #end

   #declare N = 0; 

   #while (N<200)
      #object{Leaf 
              scale <2.5,1.7,.5> 
              rotate x*(rand(R1) * 360) 
              rotate y*(rand(R1) * 360)
              rotate z*(rand(R1) * 360)  
              translate <-135, 150 + rand(R1) * 250, 570>
              }
      #declare N=N+1;
   #end

   #declare N = 0; 
   
   #while (N<30)
      #object{Leaf 
              scale <3,1.5,.1>
              rotate x*(rand(R1) * 360) 
              rotate y*(rand(R1) * 360)
              rotate z*(rand(R1) * 360)  
              translate <-135, 400, 570>
              }
      #declare N=N+1;
   #end
} 

#declare RGrass=
       sphere_sweep {
       b_spline
       5,
       <  0.0,  0.0, 0>,0.2  
       <  0.2,  0.2, 0>,0.4
       <  0.4,  0.4, 0>,0.6
       <  0.6,  0.6, 0>,0.8
       <  0.8,  0.8, 0>,1.0
       tolerance .000001
         texture{ pigment{ bozo scale 1   //30
                           color_map{
                                     [0.0 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .13,  .31,  .31,>]
                                     [0.2 rgb <  .85,  .85,  .43,>]
                                     [1.0 rgb <  .85,  .85,  .43,>] 
                                    }
                          }
                  normal {bozo scale .5}
                } 
         texture{ pigment{ crackle scale 2
                           color_map{
                                     [0.0 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .31,  .31,  .18, .6>]
                                     [0.3 rgbf <  .85,  .85,  .43, .6>]
                                     [1.0 rgbf <  .85,  .85,  .43, .6>]
                                    } warp{turbulence .5}
                          } 
                 normal {crackle scale .5 }
                } 
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
       }

#declare RGrass1=
       sphere_sweep {
       b_spline
       5,
       <  0.0,  0.0, 0>,0.2  
       <  0.2,  0.2, 0>,0.4
       <  0.4,  0.4, 0>,0.6
       <  0.6,  0.6, 0>,0.8
       <  0.8,  0.8, 0>,1.0
       tolerance .000001
         texture{ pigment{ bozo scale 1   //30
                           color_map{
                                     [0.0 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .18,  .30,  .18,>]
                                     [0.1 rgb <  .85,  .85,  .43,>]
                                     [0.4 rgb <  .85,  .85,  .43,>]
                                     [0.4 rgb <  .39,  .99,  .39,>]
                                     [1.0 rgb <  .39,  .99,  .39,>] 
                                    }
                          }
                  normal {bozo scale .5}
                } 
         texture{ pigment{ crackle scale 1
                           color_map{
                                     [0.0 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .18,  .30,  .18, .6>]
                                     [0.2 rgbf <  .85,  .85,  .43, .6>]
                                     [0.9 rgbf <  .85,  .85,  .43, .6>]
                                     [0.9 rgbf <  .39,  .99,  .39, .6>]
                                     [1.0 rgbf <  .39,  .99,  .39, .6>]
                                    } warp{turbulence .5}
                          } 
                 normal {crackle scale .5 }
                } 
        #if (PreTrace = 0)
                finish{ambient 0 }
        #else
                finish {ambient .4 diffuse .4 }
        #end
       }

#declare RiverGrass=
merge{
   #declare Counter = 3;
   #while (Counter < 11)

      #if (River[Counter][2] >= 400) 
          #declare Scale = 8;
          #declare Offset = 30;
      #end
      #if ((River[Counter][2] > 100) & (River[Counter][2] <= 400))
          #declare Scale = 6;
          #declare Offset = 20;
      #end
      #if ((River[Counter][2] > 50) & (River[Counter][2] <= 100))
          #declare Scale = 2;
          #declare Offset = 8;
      #end
      #if ((River[Counter][2] > 0) & (River[Counter][2] <= 50))
          #declare Scale = 2;
          #declare Offset = 8;
      #end

      #declare N = 0; 

      #while (N<20)    

         #declare N1 = River[Counter][0] + ((Offset/2) - (rand(R1) * Offset));
         #declare N2 = River[Counter][2] + ((Offset*2) - (rand(R1) * Offset*4));
                
         #object{RGrass 
                 scale <Scale/15, Scale, Scale/15> 
                 rotate x*(rand(R1) * 30) 
                 rotate y*(rand(R1) * 360)
                 rotate z*(rand(R1) * 30)  
                 translate <N1, -1, N2>
                 }
         //#debug concat("N1 = ",str(N1,5,0),"   N2 = ",str(N2,5,0), "\n") 
         #object {Rock 
                  scale <rand(R1) * Scale/2, Scale/2, rand(R1) * Scale/2>
                  translate <River[Counter][0] + ((Offset/2) - (rand(R1) * Offset)),
                  -1, 
                  River[Counter][2] + ((Offset*2) - (rand(R1) * Offset*4)) >
                  } 
         #declare N = N + 1;
      #end // wile n

      //#debug concat("Next Loop","\n") 

   #declare Counter = Counter + 1;
   
   #end //while counter
}


#declare Bushes1= 
merge{
   #local N3 = 0; 

   #while (N3<50)
      #object{Leaf 
              scale .5 
              rotate x*(rand(R2) * 360) 
              rotate y*(rand(R2) * 360)
              rotate z*(rand(R2) * 360)  
              translate <0,rand(R1) * 15,0>
              }
      #local N3=N3+1;
   #end
}


#declare Bushes2 = 
merge{
   #local N5 = 0; 
   #declare Scale = 7;

   #while (N5<70)
      #object{RGrass 
              scale <Scale/10, Scale, Scale/10> 
              rotate x*(rand(R2) * 90) 
              rotate y*(rand(R2) * 360)
              rotate z*(rand(R2) * 90)  
              translate <0,rand(R2) * 10,0>
              } 
      #local N5=N5+1;
   #end
}


