
// Glenn's POV-Ray Scene File - Docks
// created 9-Oct-02
// last update 9-Oct-02
// copyright 2002 Glenn McCarter (glenn@mccarters.net)
//
// This scene uses RH coordinate system, Z = up.



//===============================================
//             Scene Switches
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare Radiosty = 0; // 0=off, 1=quick, 2=best radiosity
#declare FocalBlur = 0; // 0=off, 1=focal blur
#declare DoFog = 0; // 0=no fog, 1=fog
#declare AreaSun = 0; // 0=normal light, 1=area light for the sun
#declare GoodGolfers = 0; // 0= simple stand-ins, 1=detailed Poser figures
#declare Vegetation = 0; // 0=no plants, 1=full plants
                  
#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.1,0.1,0.1>
	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
	noise_generator 2

#switch (Radiosty)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.5       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "Vegetation.inc"
#include "Terrain.inc"
#include "Boats.inc"
#include "Marina.inc"
#include "Resort.inc"

//#include "GRuler.inc" // for testing only


//===============================================
//             Variables
//===============================================

//#declare CamPos = <460*Feet,900*Feet,7*Feet>; // Camera Position, docks view 1
#declare CamPos = <550*Feet,980*Feet,11*Feet>; // Camera Position, docks view 2
#declare Seabed = -6*Feet; // height of base of all heightfields

//===============================================
//             Cameras
//===============================================

#declare Dock_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3, 0.0,  0.0>  // aspect ratio
//		right     <16/9, 0.0,  0.0>  // aspect ratio
		angle 40
	location CamPos // render
//	look_at CamPos+<-50*Feet,140*Feet,11*Feet> // docks view 1
	look_at CamPos+<-50*Feet,60*Feet,2*Feet> // docks view 2
#if (FocalBlur = 1)
	 // Focal Blur section: uncomment to enable focal blur
		blur_samples 100 // 100 is ok
		confidence 0.9   // this is a probability
		variance 1/1000  // 1/10000 is pretty good
		aperture 0.6    //lower value = wider range in focus, 10 is very blurry
		focal_point <0,0,1.3+TTH>
	 // end focal blur
#end
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <4/3,     0.0,  0.0>
		angle 60
//	location CamPos+<8*Feet,-26*Feet,12*Feet> // looking at tee box
//	look_at CamPos+<1*Feet,6*Feet,-1*Feet>
//	location <100*Yards,80*Feet,32*Feet> // beach area, catamaran
//	look_at <100*Yards,200*Feet,3*Feet>
	location <80*Yards,320*Feet,45*Feet> // beach area, hole 2
	look_at <120*Yards,440*Feet,3*Feet>
	}

#declare Map_Cam =
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  -1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <-4/3,     0.0,  0.0>

		angle 36
	location <500*Yards,1500*Yards,40000*Feet> // satellite view
	look_at <500*Yards,1500*Yards,0*Feet>
//		angle 36
//	location <50*Yards,160*Yards,3000*Feet> // overview
//	look_at <50*Yards,160*Yards,0*Feet>
//		angle 30
//	location <40*Yards,60*Yards,1200*Feet> // Hole1
//	look_at <40*Yards,60*Yards,0*Feet>
//		angle 30
//	location <60*Yards,60*Yards,1200*Feet> // Beach view
//	look_at <60*Yards,60*Yards,0*Feet>
//		angle 30
//	location <40*Yards,80*Yards,1200*Feet> // Hole1&2
//	look_at <40*Yards,80*Yards,0*Feet>
//		angle 30
//	location <40*Yards,160*Yards,1200*Feet> // Hole2
//	look_at <40*Yards,160*Yards,0*Feet>
//		angle 30
//	location <12*Yards,12*Yards,300*Feet> // tee view
//	look_at <12*Yards,12*Yards,0*Feet>
	}


camera {
//	Special_Cam
//	Map_Cam
	Dock_Cam
  }


//===============================================
//             Textures
//===============================================

#declare SteelTex =
	texture {
		pigment { color rgb<.24,.21,.28>*.34 }
		finish { specular 0.6 roughness .08 }
	}


//===============================================
//             Lighting
//===============================================

#declare OverheadSpotLight =
	light_source { 
		<0*Feet,0*Feet,6.7*Feet> // test
		color rgb <0.820,0.863,0.761>*1.2
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <0,0,0>
		radius 15
		falloff 40
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<1,1,.1> } finish {ambient 20} } } }
	}
//object { OverheadSpotLight translate <-1,9*Feet,0> } // render
//object { TestSphere scale 20 translate <-1, 5*Feet,TTH> }

//light_source{<-4*Feet,0*Feet,4.7*Feet> color rgb<1,1,1> } // for testing only

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*-62 // towards left, down low
  rotate z*70// behind camera
}

#if ( DoFog )

// This fog obscures the entire sky in water reflection!
fog {
	fog_type 1 // constant fog
//	distance 10000*Feet // deep mist, fairly foggy
	distance 22000*Feet // deep mist, fairly foggy
//	distance 50000*Feet // med mist, too thin
//	distance 100000*Feet // fine mist
//	distance 400000*Feet // very fine mist, almost unnoticeable
	color rgbt<.71,.77,1,0.5>
}

/*
fog {
	fog_type 2 // ground fog
//	fog_alt 12*Feet // keeps bottom 20 or 30 feet out of view
	fog_alt 50*Feet
//	fog_alt 8*Feet // test
	up <0,0,1>
	distance 1000*Feet // extremely thin
//	distance 100*Feet // very thin
//	distance 33*Feet // medium
//	distance 19*Feet // thick
//	distance 6*Feet // very thick

//	color rgb<.67,.71,.64> // pale creamy white
	color rgbt<.41,.47,.64,.2> // bluish white
}
*/
#end

//===============================================
//             Environment
//===============================================

background { color rgb <0.046, 0.045, 0.053> } // deep blue grey

sky_sphere { // sunny day
	pigment {
		gradient z
		color_map { // horizon is at about .23, zenith at .75

			[ 0.000 color rgb <0.900,0.908,0.936>*.99 ] // below ground level
			[ 0.070 color rgb <0.970,0.967,0.954>*.92 ] // turbulent clouds
			[ 0.170 color rgb <0.290,0.518,0.749>*.99 ] // top cloud line
			[ 0.300 color rgb <0.106,0.278,0.722>*.80 ] // above image
			[ 0.55 color rgb <0.067,0.169,0.710>*.40 ] // stratosphere
			[ 0.75 color rgb <0.067,0.169,0.710>*.20 ] // to zenith
		}
		scale 2
		translate <0,0,-.5>
		turbulence 0.033
		omega 0.5		
		rotate y*-2
	}
}

//cylinder { <0,0,0>,<0,0,2*Miles>,20*Feet translate <0,100*Feet,0>
//pigment { rgb<1,1,1> } }

#declare GroundPlane =
	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { GroundPlane }

#declare SeaWaterTex = // brownish, clear, not too reflective
	texture {
//		pigment { color rgbt<0.227,0.416,0.451,0.64> } // too clear
//		pigment { color rgb<0.227,0.416,0.451> } // no trans, too opaque
//		pigment { color rgb<1,1,1> } // test white
//		pigment { color rgbf<0.227,0.416,0.282,0.47> } // default
//		pigment { color rgbf<0.167,0.316,0.582,0.87> } // much more blue and clear
//		pigment { color rgbt<0.044,0.084,0.190,0.97> } // test blue, too slatelike
//		pigment { color rgbt<.004,0.24,0.490,0.75> } // test, too bland
		pigment { color rgbt<.004,0.040,0.190,0.75> } // test trying to get more cobolt
//		pigment { color rgbf<1,1,1,0.97> } // test white
//		pigment { color rgbt<.01,.01,.01,0.97> } // test dark grey
		normal { bumps .25 scale <2.2*Feet,2.2*Feet,12> }
//		finish { ambient .001 diffuse .2 specular .1 roughness .005 reflection 0.25} // default
//		finish { ambient 0.001 diffuse .2 specular .1 roughness .003 reflection 0.24}
		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { 0.04, 0.64 } conserve_energy}
	}
#declare SeaWaterInt =
	interior { ior 1.33 fade_distance 12 fade_power 1.0 fade_color <.03,.25,.6> }
#declare SeaWaterMat = // material
	material {
		texture { SeaWaterTex }
		interior { SeaWaterInt }
	}

#declare SeaFloorTex =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.00 color rgb <0.268,0.174,0.084> ] // rocky
					[ 0.05 color rgb <0.603,0.564,0.524> ]
					[ 1.00 color rgb <0.957,0.906,0.851> ] // sandy
				}
				scale 500*Feet
				turbulence .3
		}
		normal { bumps .5 scale 2.7*Meter }
		finish { ambient .1 diffuse .7 specular .2 roughness .15 }
	}

#declare SeaWater =
	union {
			box { <-30*KM,-30*KM,-100*Feet>,<30*KM,30*KM,0*Feet> // this is the transparent surface
			material { SeaWaterMat }
			}
		plane { z, Seabed // this is the ground underneath
			texture { SeaFloorTex }
		}
	} // end union


//===============================================
//             Other Objects
//===============================================

//---------------- Bridges ----------------------

#declare Hole1aBridge =
	object { RoundedBox2(144*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}
#declare Hole1bBridge =
	object { RoundedBox2(100*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}
#declare Hole1cBridge =
	object { RoundedBox2(220*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}
#declare Hole1_2aBridge =
//	object { RoundedBox2(160*Feet,12*Feet,6*Feet,10) 
	object { RoundedBox2(60*Feet,12*Feet,6*Feet,10) 
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}
#declare Hole1_2bBridge =
	object { RoundedBox2(100*Feet,12*Feet,6*Feet,10) 
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}
#declare Hole2aBridge =
	object { RoundedBox2(130*Feet,12*Feet,6*Feet,10) 
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}



//===============================================
//             Object Placement
//===============================================

object { SeaWater translate <0,0,0*Feet> }

// Foreground
object { Hole1 scale 0.4 translate <-13*Yards,17*Yards,120*Feet> } // upper left
object { Hole1Tee rotate z*-8 translate <0*Feet,-10*Feet,120*Feet> } // low view shifted right
object { Hole1 translate <20*Yards,70*Yards,Seabed> } // main

object { Mound3 translate <-5*Yards,55*Yards,Seabed> } // pointed top
object { Hole1aBridge rotate z*-117 translate <15*Yards,72*Yards,75*Feet> } // from mainland
object { Hole1bBridge rotate z*40 translate <15*Yards,72*Yards,75*Feet> } // to hole 1
object { Hole1cBridge rotate z*103 translate <15*Yards,72*Yards,44*Feet> } // to hole 2

object { Mound2Tee rotate <0,0,0> translate <-25*Yards, 124*Yards, Seabed> } // sloping top

// Beach Area
object { MoundVert1Waterfall scale .6 rotate <0,0,-85> translate <140*Yards, 167*Yards, 30*Feet> } // to the right
object { MoundVert1Waterfall scale .6 rotate <0,0,-85> translate <145*Yards, 173*Yards, -50*Feet> } // to the right
object { SandyBeach rotate <0,0,0> translate <42*Yards,40*Yards,-3*Feet> }
object { CatamaranS rotate <0,0,-45> translate <90*Yards,70*Yards,1*Feet> }
object { Hole2Green translate <120*Yards,155*Yards,8*Feet> }

// Far away groups
object { ResortHill rotate z*0 translate <240*Yards,450*Yards,Seabed> }
object { RightCoast rotate z*-40 translate <-0*Yards,200*Yards,Seabed> }
object { FarCoastline rotate z*-20 translate <-600*Yards,1000*Yards,Seabed> } // very distant

object { Mound1 rotate <0,0,0> translate <-350*Yards, 584*Yards, Seabed> } // double top
object { Hole1 scale <1,1.2,1.3> rotate z*-90 translate <-180*Yards,600*Yards,Seabed> } // left
object { Hole3Fairway rotate z*-118 scale <1,1,1> translate <-230*Yards,430*Yards,Seabed-20*Feet> } // left
object { Hole1 rotate z*170 scale <1,1,1.18> translate <-170*Yards,330*Yards,Seabed> } // left

object { Hole1 rotate z*120 translate <140*Yards,500*Yards,Seabed> } // middle
object { Hole3Tee rotate z*-45 translate <250*Yards,440*Yards,Seabed> }
object { Hole3Fairway rotate z*18 scale <-1,1,1> translate <290*Yards,480*Yards,Seabed> } // waterfall


object { ResortGroup rotate <0,0,-60> translate <200*Yards,400*Yards,0> }


//OLD VERSIONS, IGNORE
/*
object { SeaWater translate <0,0,0*Feet> }

//object { Hole1Tee translate <0,0,120*Feet> } // low view
object { Hole1Tee translate <0,0,135*Feet> }
object { Hole1 translate <30*Yards,70*Yards,0*Feet> }
object { Hole2Tee translate <-50*Yards,90*Yards,0*Feet> }
object { Hole2Fairway rotate z*45 translate <0*Yards,150*Yards,-30*Feet> }
object { Hole1 rotate z*120 scale <1,1,1.08> translate <140*Yards,350*Yards,0*Feet> } // Hole2 green

object { Hole1Bridge rotate z*65 translate <40*Feet,30*Feet,60*Feet> }
//object { Hole1_2aBridge rotate <0,-5,140> translate <46*Yards,80*Yards,53*Feet> }
object { Hole1_2aBridge rotate <0,-5,-140> translate <15*Yards,127*Yards,41*Feet> }
object { Hole1_2bBridge rotate <0,-10,142> translate <-1*Yards,112*Yards,103*Feet> }
object { Hole2aBridge rotate <0,0,55> translate <-20*Yards,141*Yards,123*Feet> }

object { Mound1 rotate <0,0,0> translate <-80*Yards, 334*Yards, 0> }
object { Mound2 rotate <0,0,0> translate <-5*Yards, 104*Yards, 0> }
//object { Mound1 rotate <0,0,-120> translate <100*Yards, 238*Yards, 0> } // to the right
//object { MoundVert1Waterfall rotate <0,0,-40> translate <50*Yards, 160*Yards, 30*Feet> } // to the right
object { MoundVert1Waterfall rotate <0,0,-85> translate <110*Yards, 180*Yards, 30*Feet> } // to the right

// Far away groups
object { Hole1 translate <-1220*Yards,4500*Yards,0*Feet> }
object { Hole2Fairway translate <-1180*Yards,4630*Yards,0*Feet> }

object { Hole2Tee rotate z*120 scale <1,1,1.18> translate <1000*Yards,3100*Yards,0*Feet> }
object { Hole2Fairway rotate z*120 scale <1.2,1.3,1.28> translate <1080*Yards,3100*Yards,0*Feet> }

object { Farland translate <-800*Yards,200*Yards,Seabed> }
object { Farland rotate z*-60 scale <1,1,1> translate <-1600*Yards,4000*Yards,Seabed> } // very distant
object { Mound1 rotate <0,0,0> translate <-130*Yards, 584*Yards, Seabed> } // double top

object { Hole1 translate <-1220*Yards,4500*Yards,Seabed> }
object { Hole3Tee rotate z*-45 translate <150*Yards,440*Yards,Seabed> }
object { Hole3Fairway rotate z*18 scale <-1,1,1> translate <190*Yards,480*Yards,Seabed> }
object { Hole1 rotate z*120 scale <1,1,1.08> translate <50*Yards,530*Yards,Seabed> } // Hole2 green

object { ResortGroup rotate <0,0,0> translate <50*Yards,420*Yards,0> }

*/
