
// POV-Ray Object File - A Rocky Tropical Island Golf Course
// created 16-Sep-02
// last update 27-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Foreground.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "Vegetation.inc", "Weeds.inc"
//
// Objects:
// Hole1Tee
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Height extends into +Z

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "Weeds.inc"
	#include "Vegetation.inc"
	#declare Vegetation = 1;
	#include "Bridges.inc"
	#declare GoodGolfers = 0;
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PlainPigment = // for testing only
	pigment { rgb<1,1,1> }

#declare GraniteStone =
		pigment {
			granite
			color_map {
				[ 0.24 color rgb <0.686,0.657,0.639> ]
				[ 0.51 color rgb <0.584,0.541,0.497> ]
				[ 0.77 color rgb <0.675,0.427,0.255>*.4 ] // red rust
				[ 0.92 color rgb <0.753,0.694,0.655>*.1 ] // black holes
			}
			scale <1,1,.6>*.06
		}
#declare CrackedGranite =
		pigment {
			granite
			pigment_map {
				[ 0.475 GraniteStone scale 0.5 ]
				[ 0.50 color rgb <0.753,0.694,0.655>*.04 ] // hairline cracks
				[ 0.525 GraniteStone scale .5 ]
			}
			turbulence 0.3
			scale <1,1,.6>*1
			rotate x*-90 // later it will be set upright again
		}


#declare SmallRockyTex = // for closeup rocks
	texture {
		pigment { CrackedGranite
			scale 30*Feet
			rotate x*90
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.0 roughness 0.2 }
	}

#declare TeeBoxTex =
	texture {
		pigment {
			cells
			color_map {
				[ 0.00 rgb<.68,.78,.83>*0.7 ]
				[ 1.00 rgb<.68,.78,.83>*1.0 ]
			}
			scale <8,16,8>
			turbulence .12
		}
	}

#declare GreenTex =
	texture {
		pigment {
			color rgb<.14,.44,.10>
		}
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================


#declare StandIn = // dummy golfer
	union {
		cylinder { <0,0,0>,<0,0,4.9*Feet>,11 scale <.7,1,1> }
		sphere { <0,0,0>,7 scale <1,.8,1> translate <0,0,5.4*Feet> }
		texture { pigment { rgb<1,1,1> } }
	} // end union

#ifndef (GoodGolfers)
	#declare Golfer2 = object { StandIn }
#else
	#if (GoodGolfers = 0)
		#declare Golfer2 = object { StandIn }
	#else
//		#include "Golfers.inc" // uncomment this line to include the Poser golfer!
		#declare Golfer2 = object { StandIn } // and remove this line!
	#end
#end


#declare Hole1TeeGroup =
	union {
		box { // main tee
			<0,0,-4*Feet>,<40*Feet,20*Feet,-1>
//			translate <30*Feet,15*Feet,36*Feet>
			texture { TeeBoxTex }
		}
		box { // grass
			<12,12,-2>,<40*Feet-12,20*Feet-12,0>
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "GrassMowed.png"
					}
					scale 12*Feet
					rotate z*90
					translate <8*Feet,6*Feet+8,0>
				}
			}
			texture { // kludge to hide extra divot marks
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "GrassMowed.png"
						once
					}
					scale 12*Feet
					rotate z*90
					translate <24*Feet,6*Feet+8,0>
				}
			}
		}
		cylinder { // tee marker
			<0,0,0>,<0,0,5.5>,2.15
			translate <36*Feet,4*Feet,1.0>
			texture { WhitePaint }
		}
		cylinder { // tee marker
			<0,0,0>,<0,0,5.5>,2.15
			translate <36*Feet,16*Feet,1.0>
			texture { WhitePaint }
		}

		#if (GoodGolfers = 1)
			#include "GolfClubs.inc"
			object { FullGolfBag rotate <0,22,90> translate <29*Feet+12,18.3*Feet-28,0> }
			object { BagSupport rotate x*5 translate <29*Feet,18.3*Feet,-3> }
		#end
		object { Golfer2 rotate z*0 translate <35*Feet,10*Feet,0> }
	} // end union

#declare StairGroup =
	union {
//		RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(40,24,10,0.34) rotate z*0  translate <0,0,-2> }
		object { RoundedHalfBox2(40,24,10,0.34) rotate z*8  translate <-2,20,-2+8*1> }
		object { RoundedHalfBox2(40,24,10,0.34) rotate z*12 translate <-4,40,-2+8*2> }
		object { RoundedHalfBox2(40,24,10,0.34) rotate z*16 translate <-6,60,-2+8*3> }
		texture { SmallRockyTex translate <0,0,-60*Feet> }
	} // end union

#declare Hole1Tee =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1THF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1>
			scale <70*Feet,70*Feet,40*Feet>
			translate <4*Feet,7,0>
			texture { SmallRockyTex }
		}
		object { Hole1TeeGroup rotate z*72 translate <53*Feet,0*Feet,32*Feet> } // close and straight
		object { StairGroup translate <25*Feet,19.4*Feet,0> rotate z*72 translate <53*Feet,0*Feet,32*Feet> }
	#if ( Vegetation = 1 )

		object { ShadowPalmTree rotate z*55 scale <1,1,1.3>         translate <16*Feet,14*Feet,30*Feet> } // shadow trees
		object { ShadowPalmTree scale <1.09,1.13,1.38> rotate z*150 translate <4*Feet,28*Feet,34*Feet> } // shadows left terrain
		object { ShadowPalmTree scale <0.94,0.97,1.10> rotate z*95  translate <-8*Feet,38*Feet,34*Feet> }
		object { PalmTree scale <1.09,1.13,1.29> rotate z*160 rotate <-19,5,0> translate <41*Feet,37*Feet,30*Feet> } // visible

		object { TropicalPlant1 scale <1,1,1> rotate z*0 translate <34*Feet,35.6*Feet,34*Feet> } // left group
		object { TropicalPlant1 scale <.95,.95,1.13> rotate z*314 translate <42*Feet,36*Feet,31*Feet> } // edge
		object { TropicalPlant1 scale <1,1,.74> rotate z*240 translate <39*Feet,34.1*Feet,33*Feet> }

		object { TropicalPlant1 scale <.91,.93,.94> rotate z*30 translate <40.7*Feet,29.5*Feet,31.7*Feet> } // beside stairs
		object { TropicalPlant1 scale <.63,.68,.74> rotate z*120 translate <41*Feet,34.5*Feet,32*Feet> } // outside stairs
		object { WeedBlades1 scale <4.63,4.68,4.4> rotate z*0 translate <42.0*Feet,34.5*Feet,32*Feet> } // at corner
		object { WeedBlades1 scale <4.63,4.68,4.4> rotate z*0 translate <41*Feet,35.5*Feet,32*Feet> } // near tree

		object { WeedBlades1 scale <16,16,11> rotate z*0 translate <29.3*Feet,41*Feet,33.3*Feet> } // weedy group
		object { WeedBlades1 scale <8,8,12> rotate z*192 translate <35.9*Feet,40*Feet,33.0*Feet> }
		object { TropicalPlant1 scale <.91,.93,.94> rotate z*256 translate <30.7*Feet,43.3*Feet,34.2*Feet> } // under big blades
		object { TropicalPlant1 scale <1.21,1.33,1.24> rotate z*17 translate <33.0*Feet,37.0*Feet,32.5*Feet> } // out in the open
		object { WeedGroup scale <1.4,1.4,2.2> rotate <0,0,70> translate <22*Feet,49.4*Feet,36.6*Feet> }
		object { WeedGroup scale <1.4,1.4,2.2> rotate <0,0,60> translate <30*Feet,42*Feet,34.8*Feet> }

//		object { ShadowPalmTree scale <0.89,0.83,1.28> rotate z*5  translate <36*Feet,19*Feet,30*Feet> } // provides shadow on right tree
		object { ShadowPalmTree scale <0.89,0.83,1.28> rotate z*15  translate <36*Feet,19*Feet,30*Feet> } // provides shadow on right tree
		object { TropicalPlant1 scale <1,1,1> rotate z*40 translate <62.4*Feet,28.3*Feet,32*Feet> }
		object { TropicalPlant1 scale <1,1,0.9> rotate z*155 translate <64.4*Feet,27.6*Feet,32*Feet> }
		object { TropicalPlant1 scale <1.1,1.1,1.2> rotate z*15 translate <60.0*Feet,25.7*Feet,32.5*Feet> }
		object { TropicalPlant1 scale <1.06,1.0,1.0> rotate <0,-14,167> translate <68.4*Feet,24.7*Feet,33.5*Feet> }

	#end
	} // end union





//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//		angle 25
//		location  <1, -700*Feet, 225*Feet> // overall
//		look_at <20*Feet,70*Feet,50*Feet>
		angle 35
		location  <1, -27*Feet, 28*Feet> // tee group
		look_at <20*Feet,9*Feet,0*Feet>
//		angle 40
//		location  <1, -22*Feet, 5*Feet> // flag
//		look_at <0*Feet,0*Feet,3*Feet>
	}


light_source
{ <400*Feet,-350*Feet,500*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
//{ <-400*Feet,-200*Feet,300*Feet>, <1.13,1.08,0.83>*.8
{ <-400*Feet,-200*Feet,300*Feet>, <1.00,1.00,1.00>*.8 // colorless
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

//object { Hole1Tee translate <-8*Feet,-8*Feet,0> }
object { Hole1TeeGroup translate <-10*Feet,-0*Feet,4> }

#end
