
// POV-Ray Object File - Golf Accessories
// created 10-Sep-02
// last update 19-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "GolfAccessories.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// GolfBallS // simple version, raise it 0.78 to set on table
// GolfBall // complex version, raise it 0.78 to set on table
// GolfTee
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WhitePlastic =
	texture {
		pigment { color rgb<.99,.99,.99>*1.00 }
		finish { ambient 0.53 diffuse 0.3 specular 0.1 roughness 0.02 }
	}

#declare TeePaintTex1 =
	texture {
		pigment { color rgb<.994,.989,.962>*1.00 }
		normal { bumps 0.04 scale <.02,.04,.02> }
		finish { ambient 0.4 diffuse 0.4 specular 0.05 roughness 0.08 }
	}
#declare TeePaintTex2 =
	texture {
		pigment { color rgb<.994,.989,.962>*1.00 }
		normal { bumps 0.30 scale <.02,.07,.02> }
		finish { ambient 0.4 diffuse 0.4 specular 0.05 roughness 0.08 }
	}
#declare TeePaint =
	texture {
		gradient y
		texture_map {
			[ 0.13 TeePaintTex1 ]
			[ 0.18 TeePaintTex2 ]
			[ 0.65 TeePaintTex2 ]
			[ 0.90 TeePaintTex1 ]
		}
		scale <1,2.12,1>
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare GolfBallS = // simple version
	sphere {
		<0,0,0>,0.78
		texture { WhitePlastic }
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					gif "Logo.gif"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
					transmit 15, 1.0
				}
				translate -0.5
				rotate x*90
				scale <.8,.8,.8>
			}
			finish { ambient .4 }
		}
	}
/*	
#declare MainSphere =
	sphere {
		<0,0,0>,0.78
	}
*/
#declare GolfBall = // complex version, 352 dimples
	#declare DimpleRad = 0.15;
	#declare DimpleDepth = DimpleRad-0.020;
	#declare TotalRows = 18;
	#declare HoleArray = array[TotalRows][3] // horizontal rows, each has an azimuth angle, a dimple spacing angle, and starting angle
		{
		{ 80,5,0} // bottom
		{ 70,11,9},
		{ 62,15,0},
		{ 51,18,4},
		{ 43,20,9},
		{ 34,22,2},
		{ 25,25,-9},
		{ 15,28,3},
		{ 5,32,9}, // just below equator
		{-5,32,0}, // just above equator
		{-15,28,11},
		{-25,25,-3},
		{-34,22,9},
		{-43,20,0},
		{-51,18,4},
		{-62,15,0},
		{-70,11,9},
		{-80,5,0} // top
		}
	difference {
//	union { // for testing
	#local MainSphere =
	sphere { // main
		<0,0,0>,0.78
	}
	object { MainSphere }

	#local RowNo = 1;
	#while ( RowNo < TotalRows+1 )
		#local MyNorm = <0,0,0>;
		#local DCount = 0; // current dimple in this row
		#local DCMax = HoleArray[RowNo-1][1]; // total dimples in this row
		#while ( DCount < DCMax )
			#local MyVec = vrotate(vrotate(<2,0,0>,y*HoleArray[RowNo-1][0]),z*DCount*(360/DCMax));
			#local Inter = trace(MainSphere,MyVec,<0,0,0>-MyVec,MyNorm);
			sphere { <0,0,0>,DimpleRad translate Inter+MyNorm*DimpleDepth }
			#local DCount = DCount + 1;
		#end
		#local RowNo = RowNo + 1;
	#end
		texture { WhitePlastic }
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					gif "Logo.gif"
					once
					map_type 0 // planar trace
					interpolate 2 // bilinear
					transmit 15, 1.0
				}
				translate -0.5
				rotate x*90
				scale <.8,.8,.8>
			}
//			finish { ambient .4 }
			finish { ambient 0.53 diffuse 0.3 specular 0.1 roughness 0.02 }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					gif "Logo2.gif"
					once
					map_type 0 // planar trace
					interpolate 2 // bilinear
					transmit 15, 1.0
				}
				translate -0.5
				rotate z*-90
				scale <.8*(2.5/4),.8,.8>
			}
//			finish { ambient .4 }
			finish { ambient 0.53 diffuse 0.3 specular 0.1 roughness 0.02 }
		}

	} // end union

#declare GolfTee =
	lathe { // rotated about the y-axis 
		cubic_spline
	  18,
	  <-0.2,0>,
	  <0,0>,
	  <0.04,0.04>,
	  <.094,.23>,
	  <.098,.26>,
		<.1,.4>,
		<.1,1.3>,
	  <.11,1.55>,
	  <.143,1.8>,
		<.22,1.97>,
	  <.28,2.04>,
	  <.30,2.07>,
	  <.30,2.13>,
	  <.29,2.14>,
	  <.23,2.132>,
		<.13,2.1>,
	  <0,2.07>
	  <-.05,2.07>
	  texture { TeePaint }
  }

	
//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 34
		location  <1, -6, 3> // golf ball
		look_at <0*Feet,0,1>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, <1,1,1>*1.1
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 texture {
	pigment { checker rgb 1, rgb .75 } scale 1 }
	finish { ambient .1 diffuse 0.6 }
	}
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


//object { GolfBall scale 1 rotate z*0 translate <0.8,0,0.78> }
//object { GolfBall scale 1 rotate x*60 translate <-0.8,0,0.78> }
object { GolfTee rotate <6,0,0> translate <0,0,0.1> }
object { GolfTee rotate <6,0,60> translate <1,0,0.1> }
object { GolfTee rotate <6,0,-140> translate <-1,0.5,0.1> }
object { GolfTee rotate <6,0,-90> translate <1.5,3.3,0.1> }
object { GolfTee rotate <6,0,90> translate <-1.5,4,0.1> }
//object { GolfTee scale 5 rotate <6,0,70> translate <10,-7,0.1> }
#end
