
// POV-Ray Object File - Golf Clubs
// created 19-Oct-02
// last update 29-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "GolfClubs.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// GolfBag
// BagSupport
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is along the waterline, at the base of the mast
// Mast extends into +Z

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare TopBottomTex =
	texture {
		pigment { color rgb<.23,.23,.33>*1.00 }
		normal { facets 0.2 scale <0.5,0.5,0.3> }
		finish { specular 0.63 roughness 0.08 }
	}

#declare BagTex =
	texture {
		pigment { color rgb<.33,.38,.67>*1.00 }
		finish { specular 0.13 roughness 0.14 }
	}

#declare BrightChrome =
	texture {
		pigment { color rgb<.93,.93,.99>*0.83 }
		finish { specular 0.99 roughness 0.008 metallic reflection 0.3 }
	}
#declare ClubHeadTex =
	texture {
		pigment { color rgb<.93,.93,.95>*0.89 }
		finish { specular 0.49 roughness 0.04 }
	}

#declare HeadCoverTex =
	texture {
		pigment { color rgb<.53,.53,.67>*1.00 }
		finish { specular 0.06 roughness 0.24 }
	}

#declare BagSupportPaint =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 color rgb<.54,.44,.10>*.2 ]
				[ 0.1 color rgb<.54,.44,.10> ]
			}
			scale <1,1,40>
		}
		normal { bumps 0.1 scale <.3,.3,5> }
		finish { specular 0.3 roughness 0.06 }
	}


//===============================================
//             Includes
//===============================================

#include "GolfBagShape.pov"


//===============================================
//             Macros
//===============================================

#macro Irons(IronNo)
	union {
		cylinder { <0,0,0>,<0,0,10>,.15 texture { BrightChrome } }
		cylinder { <0,0,-0.5>,<0,0,0.8>,.23 texture { ClubHeadTex } }
		difference {
			sphere {
				<0,0,0>,1.6
				scale <.22,1,.6>
			}
			box { // cut off face
				<-1,-2,-2>,<0,2,2>
			}
			box { // cut off base
				<-2,-2,-2>,<2,2,-0.5>
			}
			rotate y*IronNo*7
			translate <0,1.6,0>
			texture { ClubHeadTex }
		} // end difference
	} // end union
#end

//===============================================
//             Objects
//===============================================

#declare BagCyl = cylinder { <0,0,0>,<0,0,30>,5 texture { BagTex } }

#declare GolfBag =
	union {
		object { TopBottomGroup texture { TopBottomTex }}
		object { BagShape texture { BagTex } }
		rotate x*90
		scale <12,12,12>
	} // end union

#declare Putter =
	union {
		cylinder { <0,0,0>,<0,0,10>,.15 texture { BrightChrome } }
		cylinder { <0,0,-0.5>,<0,0,0.8>,.23 }
		box { // face
			<0,0,-0.5>,<0.6,3,0.8>
		}
		texture { ClubHeadTex }
	} // end union

#declare HeadCover =
	union {
		sphere_sweep {
			b_spline
			5
			<0,0,-2>,1.6,
			<0,0,0>,1.6,
			<-0.5,0,2>,1.4,
			<0.4,0,4>,1.9,
			<0.8,0,4.4>,2.2
			texture { HeadCoverTex }
		}
		cylinder { <0,0,0>,<0,0,-20>,.15 texture { BrightChrome } }
	} // end union


#declare FullGolfBag =
	union {
		object { GolfBag }
		object { Putter rotate z*70 rotate y*180 translate <-4,0,35> }
		object { Irons(9) rotate z*63 rotate y*184 translate <-4,-2,35.2> }
		object { Irons(8) rotate z*93 rotate y*174 translate <-4,2,35.9> }

		object { Irons(7) rotate z*98 rotate y*179 translate <0,0,38> }
		object { Irons(6) rotate z*79 rotate y*174 translate <0,-3,38.6> }
		object { Irons(4) rotate z*108 rotate y*184 translate <0,3.5,39.4> }

		object { Irons(3) rotate z*72 rotate y*180 translate <4,0,40> }
		object { HeadCover rotate z*0 translate <4,2.6,38> } 
		object { HeadCover rotate z*30 translate <4,-1,39> } 
	} // end union

#declare BagSupport =
	union {
//		RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(3,3,36,0.3) }
		cylinder { <0,0,0>,<0,0,2>,1.0 translate <1.5,1.5,35.9> }
		sphere { <0,0,0>,1.8 translate <1.5,1.5,37.9> }
		object { RoundedHalfBox2(3,3,36,0.3) translate <40,0,0> }
		cylinder { <0,0,0>,<0,0,2>,1.0 translate <40+1.5,1.5,35.9> }
		sphere { <0,0,0>,1.8 translate <40+1.5,1.5,37.9> }
		box { <-3,-1,0>,<46,0,8> translate <0,-1.5,22> } // backplate
		cylinder { <0,0,0>,<0,-5,0>,0.5 rotate x*-20 translate < 0,0,27> } // peg
		cylinder { <0,0,0>,<0,-5,0>,0.5 rotate x*-20 translate <10,0,27> } // peg
		cylinder { <0,0,0>,<0,-5,0>,0.5 rotate x*-20 translate <21,0,27> } // peg
		cylinder { <0,0,0>,<0,-5,0>,0.5 rotate x*-20 translate <32,0,27> } // peg
		cylinder { <0,0,0>,<0,-5,0>,0.5 rotate x*-20 translate <43,0,27> } // peg
		texture { BagSupportPaint }
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 35
		location  <1, -10*Feet, 5*Feet> // overall
		look_at <0*Feet,0,1.5*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.4
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }

//object { TestSphere scale 20 translate <0,0,20> }


//object { BagCyl scale 1 rotate x*0 translate <-20,0,0> }
object { FullGolfBag scale 1 rotate x*0 translate <12,0,0> }
object { FullGolfBag scale 1 rotate z*90 translate <-12,0,0> }
object { FullGolfBag scale 1 rotate z*90 rotate x*40 translate <0,0,0> }

object { Irons(3) rotate <0,0,180> translate <-12,-24,2> }
object { Irons(6) rotate <0,0,180> translate <-6,-24,2> }
object { Irons(9) rotate <0,0,180> translate <-0,-24,2> }

#end
