
// POV-Ray Object File - Grass
// created 28-Sep-02
// last update 29-Sep-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Grass.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// GrassField
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Sky is up

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// temporary sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// mandatory sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare SandyDirtTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgb <0.948,0.935,0.918>*0.70 ]
				[ 0.7 color rgb <0.518,0.345,0.180>*1.00 ]
				[ 1.0 color rgb <0.451,0.329,0.157>*1.00 ]
			}
			scale 4
		}
		normal { crackle .2 scale .3 }
		finish { specular 0.13 roughness 0.24 }
	}
#declare GrassBladeTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgb <0.055,0.506,0.114>*1.00 ]
				[ 1.0 rgb <0.055,0.506,0.114>*0.60 ]
			}
		}
		finish { specular 0.87 roughness 0.04 }
	}


//===============================================
//             Macros
//===============================================

#declare GrassBlade =
	triangle { <0,0,0>,<0,0.08,0>,<0,0,0.75> }
/*
#declare GrassBlade =
	cylinder {
		<0,0,0>,<0,0,.75>,.05
	}
*/
#declare RS = seed(23049);
#declare GrassPlant =
	#local BC = 0;
	#local MaxB = 12;
	#union {
	#while ( BC < MaxB )
		object { GrassBlade
			rotate y*30
			translate x*rand(RS)*.3
			rotate z*360*(BC/MaxB)+rand(RS)*20
		}
		#local BC = BC + 1;
	#end
	texture { GrassBladeTex }
	} // end union


//===============================================
//             Objects
//===============================================

#declare GroundPlane =
	box {
		<0,0,-1>,<100,100,0>
		texture { SandyDirtTex }
	}
/*
// This brute-force method requires excessive numbers
// of plants in order to cover the entire ground.
// Use approx. 1000 per square foot
#declare GrassField =
	union {
		object { GroundPlane }
		#local PS = 1;
		#while (PS < 600)
			object { GrassPlant
				translate <rand(RS)*12,rand(RS)*12,rand(RS)*.1>
			}
			#local PS = PS + 1;
		#end
	} // end union
*/

// This method places the grass plants more regularly,
// (but still randomly) covering the field with less plants
// Uses approx. 600 per square foot.
#macro GrassField(Density,Xdim,Ydim)
// where Density 1.0 = 600 plants per square foot
	union {
		object { GroundPlane }
		#local SqFt = Xdim*Ydim/144;
		#local TotalPlants = Density*600*SqFt;
		#local XC = 0;	
		#local XCmax = sqrt(TotalPlants); 
		#local YCmax = sqrt(TotalPlants); 
		#while ( XC < XCmax )
		#local YC = 0;
			#while ( YC < YCmax )
				object { GrassPlant
					translate <Xdim*(XC/XCmax)+rand(RS)*.5,Ydim*(YC/YCmax)+rand(RS)*.5,rand(RS)*.1>
				}
				#declare YC = YC + 1;
			#end
			#declare XC = XC + 1;
		#end
	} // end union
#end

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

/*
// This camera is for testing
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//		angle 40
//		location  <3*Feet, -6*Feet, 12*Feet> // overview
//		look_at <4*Feet,4,0*Feet>
		angle 40
		location  <.3*Feet, -0.8*Feet, 1*Feet> // one square foot
		look_at <.4*Feet,.3*Feet,0*Feet>
	}
*/

// This camera is for a top-down render of the grass field
// Use this to create an image map for use in other scenes
// Tee box grass is 18 feet wide by 38 feet long
// Use 4 ft x 3 ft and blend them together
// in a paint program
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system, where Z is up
		up        <0.0,     0.0,  -12*3>  // imaged height
		right     <-12*3*1.33333, 0.0,  0.0> // imaged width
//		angle 40
		location  <2.0*Feet, 1.5*Feet, 1*Feet> // one square foot
		look_at   <2.0*Feet, 1.5*Feet, 0*Feet>
	}


light_source
{ <0*Feet,0*Feet,100*Feet>, rgb<1,1,1>*1.5
	rotate y*-35 // towards left
  rotate z*1 // behind camera
	rotate z*18 // compensate for tee box rotation
//  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
/*
light_source
{ <-40*Feet,-20*Feet,30*Feet>, rgb<1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
*/
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }



// Tee box grass is 18 feet wide by 38 feet long
// Use one quarter of this and blend them together
// in a paint program
object { GrassField(1,4*Feet,3*Feet) scale 1 rotate z*0 translate <0,0,1> }


#end
