
// POV-Ray Object File - Miscellaneous Objects
// created 25-Oct-02
// last update 25-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "MiscObjects.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CokeMachineS // simple version
// Peeps
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Objects extend into +X and +Y
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BlackTex =
	texture {
		pigment { color rgb<.04,.01,.08>*.94 }
		finish { specular 0.60 roughness .08 }
	}

#declare SkinTex =
	texture {
		pigment { color rgb <0.906,0.796,0.702>*.94 }
		finish { specular 0.27 roughness .12 }
	}

#macro TorsoTex(ColorDes)
//	texture {
//		pigment { color rgb <0.220,0.404,0.173>*.94 }
		pigment { color ColorDes }
		finish { specular 0.40 roughness .08 }
//	}
#end

//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare CokeMachineS =
	union {
		box { // main
			<0,0,0>,<3*Feet,2.5*Feet,5.9*Feet>
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "CokeMachineColorMap.png"
						once
						map_type 0 // planar
						interpolate 2 // bilinear
					}
					rotate x*90
					scale <3.02*Feet,1,5.92*Feet>
					translate <-0.01,0,-0.01>
				}
				finish { ambient 0.4 diffuse 0.6 specular 0.3 roughness 0.02 }
			}
			translate <0,0,4>
		}
		box { // right side
			<-1,0,0>,<0,2.5*Feet,5.9*Feet>
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "CokeSideColorMap.png"
						once
						map_type 0 // planar
						interpolate 2 // bilinear
					}
					rotate <90,0,90>
					scale <1,2.52*Feet,5.92*Feet>
					translate <0,-0.01,-0.01>
				}
				finish { ambient 0.4 diffuse 0.6 specular 0.3 roughness 0.02 }
			}
			translate <3*Feet+.1,0,4>
		}
		box { // underneath
			<1,1,2>,<3*Feet-1,3*Feet-1,4>
		}
		cylinder { <0,0,0>,<0,0,4>,1 translate <3,3,0> }
		cylinder { <0,0,0>,<0,0,4>,1 translate <3*Feet-3,3,0> }
		texture { BlackTex }
	} // end union

#declare PLegL = // left leg
	union {
		sphere_sweep {
			cubic_spline
			6
			<0,-9,1>,1.2,
			<0,-7,1>,1.2,
			<0,0,2>,2,
			<0,-2,15>,2.5,
			<0,0,28>,3,
			<0,0,30>,3
			texture { SkinTex }
		}
	} // end union
#declare PLegR = object { PLegL scale <-1,1,1> }

#declare PArmL = // left arm
	union {
		sphere_sweep {
			cubic_spline
			6
			<0,0,1>,1.8,
			<0,0,0>,1.8,
			<0,3,-10>,1.3,
			<0,-3,-20>,1.0,
			<0,-4,-22>1.5,
			<0,-5,-23>,1.3
			texture { SkinTex }
		}
	} // end union
#declare PArmR = object { PArmL scale <-1,1,1> }

#macro PTorso(PTorsoTex)
	union {
		sphere_sweep {
			cubic_spline
			4
			<0,0,-8>,5.5,
			<0,0,0>,5.5,
			<0,0,22>,7,
			<0,0,25>,3
			texture { TorsoTex(PTorsoTex) }
			scale <1,0.6,1>
		}
	} // end union
#end

#declare PHead =
	union {
		sphere_sweep {
			cubic_spline
			5
			<0,0,-4>,2.5,
			<0,0,0>,2.5,
			<0,0,2>,2.7,
			<0,0,4>,4,
			<0,0,5>,1
			texture { SkinTex }
		}
	} // end union
#macro Peeps(PTorsoTex)
	union {
		object { PLegR rotate y*5 translate <-6,0,0> }
		object { PLegL rotate y*-5 translate <6,0,0> }
		object { PArmR rotate <0,0,0> translate <-8,0,55> }
		object { PArmL rotate <0,0,0> translate < 8,0,55> }
		object { PTorso(PTorsoTex) translate <0,0,32> }
		object { PHead translate <0,0,62> }
	} // end union
#end

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 30
		location  <1, -24*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { TestSphere scale 20 translate <0,0,20> }


//object { CokeMachineS scale 1 rotate z*-40 translate <1*Feet,0*Feet ,0*Feet> }
//object { CokeMachineS scale 1 rotate z*40 translate <-3*Feet,0*Feet ,0*Feet> }
//object { Peeps(TorsoTex) rotate z*0 translate <2*Feet,0,0> }
//object { Peeps(TorsoTex) rotate z*70 translate <-2*Feet,0,0> }
object { Peeps(rgb<.23,.23,.2>) rotate z*0 translate <2*Feet,0,0> }
object { Peeps(rgb<.23,.93,.92>) rotate z*70 translate <-2*Feet,0,0> }


#end
