
// POV-Ray Object File - A Resort
// created 25-Sep-02
// last update 29-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Resort.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "Marina.inc", "Vegetation.inc"
//
// Objects:
// ResortGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Resort origin is at the center of the main building
// Sky is up

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare Vegetation = 1;
	#include "Vegetation.inc"
	#declare VegQual = 0;
	#include "Boats.inc"
	#include "Marina.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare ResortGrass =
	pigment {
		granite
		color_map {
//			[ 0.12 color rgb<0.957,0.906,0.851> ]
			[ 0.10 color rgb<.04,.22,.11>*1 ]
			[ 0.85 color rgb<.06,.22,.06>*2 ]
		}
		scale 12
	}
#declare ResortSandyTex =
	texture {
		pigment {
			gradient z
			pigment_map {
				[ 0.30 color rgb<0.957,0.906,0.851> ]
				[ 0.35 ResortGrass ]
				[ 0.95 ResortGrass ]
				[ 0.99 color rgb<0.957,0.906,0.851> ]
			}
			turbulence 0.12
//			scale 25*Feet
			scale 44*Feet
			translate <0,0,-5*Feet>
		}
	}

#declare WhiteStucco =
	texture {
		pigment { color rgb<.999,.991,.979>*1.00 }
		finish { specular 0.53 roughness 0.24 }
	}

#declare ClayTile =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 color rgb <0.763,0.124,0.067>*0.15 ]
				[ 0.12 color rgb <0.763,0.124,0.067>*1.00 ]
			}
			turbulence 0.1
			scale 20
		}
		finish { specular 0.30 roughness 0.24 }
	}

#declare PoolwaterTex =
	texture {
		pigment { color rgb<.091,.604,.979>*1.00 }
		normal { bumps 0.3 scale 4 }
		finish { specular 0.99 roughness 0.014 reflection 0.24 }
	}
#declare PatioTex =
	texture {
		pigment {
			cells
			color_map {
				[ 0.00 rgb<.78,.71,.63>*0.96 ]
				[ 1.00 rgb<.78,.71,.63>*1.10 ]
			}
			scale <16,16,16>
			turbulence .12
		}
	}

//===============================================
//             Macros
//===============================================

#macro ClayRoof(Roofx,Roofy)
	union {
		box { <0,0,0>,<Roofx,Roofy,8>
			texture { WhiteStucco }
		}
		#local Ang = 36; // roof angle (degrees from horizontal)
		#local SF = 0.62; // slope factor kludge, use 0.56 for 26-deeg roof
		prism { 0,2,4,<0,0>,<Roofy,0>,<Roofy/2,Roofy*SF>,<0,0> texture { ClayTile } rotate <90-Ang,0,90> translate <0,0,8> }
		prism { 0,2,4,<0,0>,<Roofy,0>,<Roofy/2,Roofy*SF>,<0,0> texture { ClayTile } rotate <-90+Ang,0,90> translate <Roofx,0,8> }
		prism { 0,2,5,<0,0>,<Roofy/2,Roofy*SF>,<Roofx-Roofy/2,Roofy*SF>,<Roofx,0>,<0,0> texture { ClayTile } rotate <-90+Ang,0,0> translate <0,0,8> }
		prism { 0,2,5,<0,0>,<Roofy/2,Roofy*SF>,<Roofx-Roofy/2,Roofy*SF>,<Roofx,0>,<0,0> texture { ClayTile } rotate <90-Ang,0,0> translate <0,Roofy,8> }
	} // end union
#end

//===============================================
//             Objects
//===============================================

#declare ResortLand =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "ResortLandHF.png"
		smooth
		water_level .01
		rotate x*90
		scale <1,-1,1>
//		scale <300*Yards,300*Yards,26*Feet>
		scale <300*Yards,300*Yards,40*Feet>
		texture { ResortSandyTex }
		translate <-150*Yards,-150*Yards,-2>
	}

#declare Archway =
	difference {
		box { <0,0,0>,<12*Feet,2*Feet,20*Feet> }
		box { <1*Feet,-1,-1>,<12*Feet-1*Feet,2*Feet+1,12*Feet> }
		cylinder { <0,-1,0>,<0,2*Feet+1,0>,5*Feet translate <6*Feet,0,12*Feet> }
		texture { WhiteStucco }
	}

#declare MainBldg =
	union {
		box { <0,8*Feet,0>,<120*Feet,40*Feet,18*Feet> }
		box { <0.1,-6*Feet,-6*Feet>,<120*Feet-0.1,39*Feet,0*Feet> } // lower walkway
		box { <0.1,1.2*Feet,9*Feet>,<120*Feet-0.1,39*Feet,10*Feet> } // upper walkway
		box { <0,-3*Feet,-10*Feet>,<3*Feet,3*Feet,6*Feet> translate <80*Feet,20*Feet,34*Feet> } // chimney
		box { <0,-4*Feet,5*Feet>,<4*Feet,4*Feet,8*Feet> translate <80*Feet,20*Feet,34*Feet> } // chimney
		#local AC = 0;
		#while ( AC < 10 )
			object { Archway translate <AC*12*Feet,0,0> }
			#local AC = AC + 1;
		#end
		object { ClayRoof(126*Feet,46*Feet)
			translate <-3*Feet,-3*Feet,20*Feet>
		}
		texture { WhiteStucco }
	} // end union

#declare HotelBldg =
	union {
		object { MainBldg }
		object { MainBldg scale <-1,1,1> rotate z*90 translate <40*Feet,40*Feet,0> }
	} // end union

#declare SquareBox =
	union {
		box { <1.1*Feet,1.1*Feet,0>,<40*Feet-1.1*Feet,40*Feet-1.1*Feet,20*Feet> }
		box { <0*Feet,0*Feet,0>,<4*Feet,4*Feet,20*Feet> }
		box { <0*Feet,0*Feet,0>,<4*Feet,4*Feet,20*Feet> translate <40*Feet-4*Feet,0,0> }
		object { ClayRoof(46*Feet,46*Feet)
			translate <-3*Feet,-3*Feet,20*Feet>
		}
		texture { WhiteStucco }
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "Windows4.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <20*Feet,1,20*Feet>
				translate <10*Feet,0,0*Feet>
			}
		}
	} // end union

#declare BeachHouse =
	object { SquareBox }

#declare Awning =
	union {
		object { ClayRoof(22*Feet,22*Feet)
			translate <0,0,7.5*Feet> }
		cylinder { <0,0,-3*Feet>,<0,0,8*Feet>,3 translate <1.5*Feet,1.5*Feet,0> }
		cylinder { <0,0,-3*Feet>,<0,0,8*Feet>,3 translate <26*Feet-1.5*Feet,1.5*Feet,0> }
		cylinder { <0,0,-3*Feet>,<0,0,8*Feet>,3 translate <1.5*Feet,26*Feet-1.5*Feet,0> }
		cylinder { <0,0,-3*Feet>,<0,0,8*Feet>,3 translate <26*Feet-1.5*Feet,26*Feet-1.5*Feet,0> }
		box { <0,0,-30>,<3*Feet,8*Feet,38> translate <3*Feet,7*Feet,0> }
		texture { ClayTile }
	} // end union

#macro Walkway(XLength)
	union {
		box { <0,-4*Feet,-20>,<XLength,4*Feet,0> } // walkway
		box { <0,-4*Feet,0>,<XLength,4*Feet,8> translate <0,0,9*Feet>} // roof
		#local PC = 0;
		#while ( PC < XLength )
			cylinder { <0,0,0>,<0,0,9*Feet>,3.4 translate <PC,-4*Feet+18,0> }
			cylinder { <0,0,0>,<0,0,9*Feet>,3.4 translate <PC, 4*Feet-18,0> }
			#local PC = PC + 8*Feet;
		#end
		texture { WhiteStucco }
	} // end union
#end

#declare SwimmingPool =
	union {
		difference {
			box { <-30*Feet,-20*Feet,-12*Feet>,<30*Feet,20*Feet,0> } // main walls
			box { <-30*Feet+2*Feet,-20*Feet+2*Feet,-8*Feet>,<30*Feet-2*Feet,20*Feet-2*Feet,1> }
			texture { WhiteStucco }
		} // end difference
		box { <-30*Feet,-20*Feet,-11*Feet>,<30*Feet,20*Feet,-8> texture { PoolwaterTex } }
	} // end union
#declare SwimmingPoolGroup =
	union {
		object { SwimmingPool }
		box { <30*Feet,-20*Feet,-20>,<60*Feet,50*Feet,0> texture { PatioTex } }
		box { <-30*Feet,-32*Feet,-20>,<60*Feet,-20*Feet,0> translate <0,0,-20> texture { PatioTex } }
		object { Awning translate <40*Feet,0,0> }
	} // end union

#declare SeaWall =
	union {
		box { <0,0,-24>,<120*Feet,14*Feet,4*Feet> } // wall
		box { <0,-18*Feet,-24>,<120*Feet,0,0> } // walkway
		box { <0,-19*Feet,-8*Feet>,<120*Feet,-18*Feet,24> } // lower wall
		texture { PatioTex }
	} // end union

#declare HotelGroup =
	union {
		object { HotelBldg rotate z*-45 }
		object { SwimmingPoolGroup translate <20*Feet,-100*Feet,-0.5*Feet> }
		object { SquareBox rotate z*0 translate <-140*Feet,20*Feet,6*Feet> } // left
		object { SquareBox rotate z*0 translate < 100*Feet,20*Feet,5*Feet> } // right
		object { BeachHouse scale 0.6 rotate z*20 translate <-100*Feet,-150*Feet,-8*Feet> } // front
		object { Walkway(70*Feet) rotate <0,-3,40> translate <-88*Feet,-110*Feet,-3.5*Feet> }
		object { Awning rotate z*40 translate <-240*Feet,-170*Feet,0> }
		object { SeaWall translate <-20*Feet,-160*Feet,-8*Feet> }
	} // end union


#declare TreeGroup =
	union {
		object { PalmTree scale 1 rotate z*0 translate <-77*Feet,-0*Feet,8*Feet> }
		object { PalmTree scale 0.92 rotate z*34 translate <-82*Feet,-5*Feet,8*Feet> }

		object { PalmTree scale 0.98 rotate z*-14 translate <108*Feet,35*Feet,12*Feet> } // right

		object { PalmTree scale 1.18 rotate z*66 translate <112*Feet,-97*Feet,12*Feet> } // right
		object { PalmTree scale 1.34 rotate z*204 translate <104*Feet,-115*Feet,18*Feet> } // right

		object { PalmTree scale 1.03 rotate z*48 translate <-58*Feet,-135*Feet,3*Feet> } // left front

	} // end union

#declare ResortGroup =
	union {
		object { ResortLand }
		object { HotelGroup translate <0,0,18*Feet> }
		object { MarinaGroup rotate z*-90 translate <0,-180*Feet,0> }
		#if (Vegetation = 1)

			object { TreeGroup }
			object { TreeCluster(36,80*Feet) translate <-260*Feet,-80*Feet,20*Feet> }
			object { TreeCluster(30,180*Feet) translate <-130*Feet,80*Feet,20*Feet> }
			object { TreeCluster(10,46*Feet) translate <-140*Feet,-200*Feet,10*Feet> }
			object { TreeCluster(14,55*Feet) translate <60*Feet,120*Feet,20*Feet> }

			object { TreeCluster(12,50*Feet) translate <140*Feet,-170*Feet,20*Feet> } // near hole 18
			object { FarTreeGroup(VegQual,30,200*Feet,40*Feet) rotate z*12 translate <-380*Feet,200*Feet,20*Feet> }
			object { FarTreeGroup(VegQual,20,110*Feet,30*Feet) translate <90*Feet,100*Feet,30*Feet> }

			object { FarTreeGroup(VegQual,10,80*Feet,20*Feet) scale 0.6 translate <-78*Feet,80*Feet,20*Feet> } // center
			object { FarTreeGroup(VegQual,10,80*Feet,20*Feet) scale 0.79 translate <140*Feet,-120*Feet,20*Feet> } // right
		#end
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {	max_trace_level 50 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
//		location  <0*Feet, -100*Feet, 1500*Feet> // helicopter view
//		look_at <1*Feet,-40*Feet,8*Feet>
		location  <300*Feet, -900*Feet, 180*Feet> // distant view
		look_at <1*Feet,40*Feet,8*Feet>
//		location  <0*Feet, -480*Feet, 92*Feet> // overall
//		look_at <1*Feet,40*Feet,8*Feet>
//		location  <20*Feet, -280*Feet, 52*Feet> // main building
//		look_at <40*Feet,0*Feet,8*Feet>
//		location  <20*Feet, 40*Feet, 182*Feet> // up
//		look_at <40*Feet,40*Feet,8*Feet>
	}


light_source
{ <800*Feet,-700*Feet,1000*Feet>, 1.5
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-400*Feet,-200*Feet,300*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}

plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }


//object { MainBox scale 1 rotate z*40 translate <0,0,0> }
//object { Resort scale 1 rotate z*0 translate <0,0,0> }
object { ResortGroup scale 1 rotate z*0 translate <0,0,0> }
  

#end
