
//#include "RockHF1.inc"

// Glenn's Rocks POV-Ray Scene File
// first concept 28-May-97 last update 20-Oct-02
// copyright 1997-2002 Glenn McCarter (glenn@mccarters.net)
// This file does not render.  #include "Rocks.inc" in another .pov file
//
// A collection of various rocks
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//===============================================
//             Variable Declarations
//===============================================



//===============================================
//             Textures
//===============================================

#declare PlainTan =
	texture {
		pigment { color rgb<.6,.5,.2> }
		finish { specular .3 roughness .1 }
	}
#declare PlainGrey =
	texture {
		pigment { color rgb<.58,.52,.46> }
		finish { specular .3 roughness .1 }
	}

#declare RockTex1 =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0  color rgb<0.2,0.40,0.32> ]
				[ 0.4  color rgb<0.6,0.53,0.38> ]
				[ 0.7  color rgb<0.13,0.03,0.19> ]
				[ 1.0  color rgb<0.2,0.40,0.32> ]
			}
		}
		normal { bumps 0.8 scale .4 }
		finish { specular .3 roughness .2 }
	}


//===============================================
//       Spherical-based Rocks
//===============================================

#declare SPebble1 =
	sphere {
		<0,0,0>,.3
		scale <1,.8,1.2>
		texture { RockTex1 }
	}

#declare SStone1 =
	sphere {
		<0,0,0>,.8
		scale <1,.8,1.2>
		texture { RockTex1 }
	}

#declare SRock1 =
	sphere {
		<0,0,0>,2
		scale <1,.8,1.2>
		texture { RockTex1 }
	}

//===============================================
//       Height_field - based Rocks
//===============================================


#declare RockHF1 =
	height_field {
		png "RockHF1.png"
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,0> //center on origin
		rotate z*90
		scale <5,8,3> // scale it up
		texture { RockTex1 }
	}

#declare HFOffset = -1;
#declare HFRock1 =
	intersection {
		object { RockHF1 translate z*HFOffset rotate <180,0,0> translate <0,0,0> }
		object { RockHF1 translate z*HFOffset rotate <60,0,0> translate <0,0,0> }
		object { RockHF1 translate z*HFOffset rotate <60,0,120> translate <0,0,0> }
		object { RockHF1 translate z*HFOffset rotate <60,0,240> translate <0,0,0> }
		bounded_by { sphere { <0,0,0>,8 } }
	}


#declare BlankRockHF1 = // no texture?
	height_field {
		png "RockHF1.png"
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,0> //center on origin
		rotate z*90
		scale <5,8,3> // scale it up
	}

#declare HFOffset = -1;
#declare BlankHFRock1 = // no texture
	intersection {
		object { BlankRockHF1 translate z*HFOffset rotate <180,0,0> translate <0,0,0> }
		object { BlankRockHF1 translate z*HFOffset rotate <60,0,0> translate <0,0,0> }
		object { BlankRockHF1 translate z*HFOffset rotate <60,0,120> translate <0,0,0> }
		object { BlankRockHF1 translate z*HFOffset rotate <60,0,240> translate <0,0,0> }
		bounded_by { sphere { <0,0,0>,8 } }
	}

#declare HFRockTest =
	object { RockHF1 translate z*HFOffset rotate <0,0,0> translate <0,0,0> }
