
// POV-Ray Object File - A Rocky Tropical Island Golf Course
// created 16-Sep-02
// last update 29-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Terrain.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "Vegetation.inc"
//
// Objects:
// VolcanicFormation
// LeftFormation
// Hole1
// Mound2TeeGroup
// Hole2Green
// Hole3Tee
// Hole3Fairway
// Hole9
// Mound1
// Mound2Tee
// Mound2Toppled
// Mound4TeeGroup
// MoundVert1
// SandyBeach
// Farland
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Height extends into +Z

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "Vegetation.inc"
	#declare Vegetation = 1;
	#declare VegQual = 1;
	#include "MiscObjects.inc"
	#include "Bridges.inc"
	#declare GoodGolfers = 1;
	#include "GolfClubs.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "Rocks.inc"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PlainPigment = // for testing only
	pigment { rgb<1,1,1> }

#declare GraniteStone =
		pigment {
			granite
			color_map {
				[ 0.24 color rgb <0.686,0.657,0.639> ]
				[ 0.51 color rgb <0.584,0.541,0.497> ]
				[ 0.77 color rgb <0.675,0.427,0.255>*.4 ] // red rust
				[ 0.92 color rgb <0.753,0.694,0.655>*.1 ] // black holes
			}
			scale <1,1,.6>*.06
		}
#declare CrackedGranite =
		pigment {
			granite
			pigment_map {
				[ 0.475 GraniteStone scale 0.5 ]
				[ 0.50 color rgb <0.753,0.694,0.655>*.04 ] // hairline cracks
				[ 0.525 GraniteStone scale .5 ]
			}
			turbulence 0.3
			scale <1,1,.6>*1
			rotate x*-90 // later it will be set upright again
		}

#declare UnderwaterRocks =
		pigment {
			bozo
			color_map {
				[ 0.00 color rgb <0.345,0.392,0.333>*1 ]
				[ 0.50 color rgb <0.184,0.292,0.114> ]
				[ 0.99 color rgb <0.086,0.282,0.302>*1 ]
			}
			scale 1/100
		}
#declare WaterlineVeg =
		pigment {
			bozo
			color_map {
//				[ 0.00 color rgb <0.345,0.392,0.333>*.7 ]
				[ 0.00 color rgb <0.305,0.792,0.283>*.7 ]
				[ 0.50 color rgb <0.184,0.292,0.114>*.5 ]
				[ 0.99 color rgb <0.086,0.282,0.302>*.8 ]
			}
			scale 1/100
		}

#declare RockyTex =
	texture {
		pigment {
			planar // from 1 to 0 along Y
			pigment_map {
//				[ 1-0.22 GraniteStone ]
				[ 1-0.22 CrackedGranite ]
				[ 1-0.06 WaterlineVeg ]
				[ 1-0.04 UnderwaterRocks ]
			}
			scale 111*Feet
			rotate x*90
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.0 roughness 0.2 }
	}

#declare FarlandTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.03 rgb <0.957,0.906,0.851> ] // sandy
				[ 0.04 rgb<.34,.29,.28> ] // to dirty rock
				[ 0.05 rgb<.04,.22,.08> ] // to dark green
				[ 1.00 rgb<.04,.22,.08> ] // dark green
			}
			turbulence 0.04
		}
	}
#declare DistantIslandTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.03 rgb <0.957,0.906,0.851> ] // sandy
				[ 0.04 rgb<.34,.29,.28>*1.6 ] // to dirty rock
				[ 0.05 rgb<.14,.22,.28>*1.6 ] // to grey green
				[ 1.00 rgb<.04,.22,.28>*1.6 ] // blue green
			}
			turbulence 0.04
		}
	}

#declare ResortHillTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.006 rgb<0.957,0.906,0.851> ] // sandy
//				[ 0.034 rgb<0.305,0.349,0.328>*.6 ] // to dirty rock
//				[ 0.054 rgb<0.245,0.349,0.328> ] // to dirty rock
				[ 0.027 rgb<0.040,0.220,0.080> ] // to dark green
				[ 1.000 rgb<0.040,0.220,0.080> ] // dark green
			}
			turbulence 0.02
		}
	}

#declare SandyTex =
	texture {
		pigment {
			color rgb <0.957,0.906,0.851>
		}
	}

#declare TeeBoxTex =
	texture {
		pigment {
			cells
			color_map {
				[ 0.00 rgb<.68,.78,.83>*0.7 ]
				[ 1.00 rgb<.68,.78,.83>*1.0 ]
			}
			scale <8,16,8>
			turbulence .12
		}
	}

#declare GreenTex =
	texture {
		pigment {
			color rgb<.14,.44,.10>
		}
	}

#declare FairwayGrass =
		pigment {
			bozo
			color_map {
				[ 0.2 rgb<.047,.424,.042>*.40 ]
				[ 0.5 rgb<.047,.424,.042>*.63 ]
				[ 0.9 rgb<.047,.424,.042>*.40 ]
			}
			scale 30*Feet
		}

#declare DarkGrass =
		pigment {
			bozo
			color_map {
				[ 0.2 rgb<.047,.424,.042>*.32 ]
				[ 0.5 rgb<.047,.424,.042>*.40 ]
				[ 0.9 rgb<.047,.424,.042>*.32 ]
			}
			scale 30*Feet
		}

#declare BoardwalkTex =
	texture {
		pigment { color rgb <0.451,0.329,0.157>*1.00 }
		normal { bumps 0.2 scale <2,3,6> }
		finish { specular 0.23 roughness 0.34 }
	}

//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================



#declare TestPillar =

	union {
		cone {
			<0,0,0>,50*Feet,<0,0,60*Feet>,30*Feet
		}
		cone {
			<0,0,60*Feet>,30*Feet,<0,0,110*Feet>,40*Feet
		}
		texture { RockyTex scale 1 }
	} // end union


#declare FlagStick =
	union {
		cylinder { // cup
			<0,0,-3>,<0,0,0.1>,6
			texture { pigment { rgb<1,1,1> } finish { ambient 5 } }
		}
		cylinder {
			<0,0,-5>,<0,0,0.6>,3.2
			texture { pigment { rgb<.17,.14,.04> } }
		}
		cylinder {
			<0,0,0>,<0,0,7*Feet>,3.8
//			<0,0,0>,<0,0,7*Feet>,2.8
//			texture { pigment { rgb<.37,.34,.11> } finish { ambient 1.2 specular 0.8 roughness 0.04 } }
			texture { pigment { rgb<.37,.34,.11>*11 } finish { ambient 1.2 specular 0.8 roughness 0.04 } }
		}
/*
		cylinder { // this provides a very strong shadow
			<0,0,0>,<0,0,7*Feet>,10
			texture { pigment { rgb<.37,.34,.11>*11 } finish { ambient 1.2 specular 0.8 roughness 0.04 } }
			no_image
		}
*/
	} // end union
#declare Flag =
	union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.853, 0.394, 0.392> <2.626, 0.483, 0.311> <2.323, 0.601, 0.204> <2.096, 0.689, 0.123> 
		<2.853, 0.394, 0.392> <2.917, 0.561, -0.191> <2.793, 0.687, -0.122> <2.566, 0.776, -0.203> 
		<2.853, 0.394, 0.392> <2.917, 0.561, -0.191> <2.778, 0.793, -0.389> <2.892, 1.026, -0.914> 
		<2.853, 0.394, 0.392> <3.144, 0.473, -0.110> <3.119, 0.937, -0.833> <3.233, 1.170, -1.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.516, -0.000, 1.544> <1.281, -0.000, 1.127> <0.968, -0.000, 0.571> <0.733, -0.000, 0.154> 
		<1.093, -0.191, 1.662> <0.859, -0.191, 1.245> <0.806, -0.143, 0.519> <0.572, -0.143, 0.102> 
		<0.437, -0.000, 1.828> <0.444, -0.000, 1.259> <0.212, -0.000, 0.652> <0.220, -0.000, 0.083> 
		<-0.026, -0.000, 1.950> <-0.018, -0.000, 1.380> <-0.008, -0.000, 0.621> <0.000, -0.000, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.579, 0.725, 1.499> <1.350, 0.725, 1.145> <1.045, 0.725, 0.672> <0.815, 0.725, 0.318> 
		<1.417, 0.678, 1.638> <1.188, 0.678, 1.284> <0.844, 0.624, 0.677> <0.615, 0.624, 0.322> 
		<1.709, 0.087, 1.489> <1.474, 0.087, 1.073> <1.130, 0.145, 0.624> <0.896, 0.145, 0.207> 
		<1.516, -0.000, 1.544> <1.281, -0.000, 1.127> <0.968, -0.000, 0.571> <0.733, -0.000, 0.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.853, 0.394, 0.392> <2.626, 0.483, 0.311> <2.323, 0.601, 0.204> <2.096, 0.689, 0.123> 
		<2.597, 0.326, 0.834> <2.370, 0.414, 0.754> <2.007, 0.543, 0.423> <1.780, 0.631, 0.342> 
		<1.961, 0.838, 1.170> <1.732, 0.838, 0.816> <1.391, 0.901, 0.664> <1.162, 0.901, 0.310> 
		<1.579, 0.725, 1.499> <1.350, 0.725, 1.145> <1.045, 0.725, 0.672> <0.815, 0.725, 0.318> 
	}
	scale 6
	texture {
//		pigment { rgb <0.0,0.176,0.995>} // bright blue
//		pigment { rgb <1.0,0.176,0.005>} // bright red
		pigment { rgb <12.0,0.176,0.005>} // very bright red
		finish { ambient 1.2 phong 1 }
	}
}
#declare GolfFlag = // this is artifically enlarged to still be visible in the distance!
	union {
		object { FlagStick }
		object { Flag scale 1.8 translate <2,0,7*Feet-16> }
	} // end union


#declare VolcanicUpper =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1UpperHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <1,1,-1> // extrude downwards
			scale <50*Yards,50*Yards,50*Feet>
			translate <0,0,96*Feet>
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1CrownHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,8*Feet>
			translate <0,0,96*Feet>
			texture { // FarGreenTex }
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "CrownColorMap.png"
						once
					}
					scale 150*Feet
					translate <0*Feet,0*Feet,0>
				}
//				finish { specular 0.13 roughness .233 }
				finish { specular 0.05 roughness .233 }
			}
		}
	} // end union

#declare VolcanicFormation =
	union {
		object { VolcanicUpper }
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1LowerHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,50*Feet>
		}
	#if ( Vegetation = 1 )
		object { PalmTreeS scale 0.82 rotate z*128 translate <62*Feet,55*Feet,100*Feet> }
		object { PalmTreeS scale 1.09 rotate z*225 translate <73*Feet,52*Feet,100*Feet> }
		object { PalmTreeS scale 1.00 rotate z*48 translate <100*Feet,58*Feet,100*Feet> }
	#end
		texture { RockyTex }
	} // end union

#declare LeftFormation =
	union {
		object { VolcanicUpper }
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1LowerHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,50*Feet>
		}
	#if ( Vegetation = 1 )
		object { PalmTreeS scale 0.82 rotate z*128 translate <62*Feet,55*Feet,100*Feet> }
		object { PalmTreeS scale 1.09 rotate z*225 translate <73*Feet,52*Feet,100*Feet> }
		object { PalmTreeS scale 1.00 rotate z*48 translate <100*Feet,58*Feet,100*Feet> }
		object { PalmTreeS scale 1.13 rotate z*20 translate <83*Feet,47*Feet,100*Feet> }
	#end
		texture { RockyTex translate <0,0,30*Feet> }
	} // end union

#declare Rock24in =
	object { BlankHFRock1 // about 8-inches long
		scale 3.0
		texture { CrackedGranite scale 0.1 }
	}

#declare Boulder30ft =
	object { BlankHFRock1 // about 8-inches long
		scale 42
		texture { CrackedGranite scale 0.8 }
	}

#declare BoardwalkSpline =
	spline {
		quadratic_spline
		-0.1, <7*Feet,0,0>
		0, <0,0,0>
		0.1 <-7*Feet,0,0>
		0.2 <-15*Feet,2*Feet,0>
		0.3 <-21*Feet,8*Feet,2>
		0.4 <-25*Feet,16*Feet,4>
		0.5 <-28*Feet,24*Feet,5>
		0.6 <-34*Feet,28*Feet,8>
		0.7 <-40*Feet,35*Feet,12>
		0.8 <-48*Feet,44*Feet,12>
		0.9 <-58*Feet,47*Feet,12>
		1, <-60*Feet,60*Feet,12>
	}
#declare HBPost =
	cylinder {
		<0,0,-15*Feet>,<0,0,0>,6
		texture { BoardwalkTex }
	}
#declare HBPlank =
	box {
		<0,0,-2>,<7.5,48,0>
		texture { BoardwalkTex }
	}
#declare HBRailPost =
	cylinder {
		<0,0,0>,<0,0,40>,2.8
		texture { BoardwalkTex }
	}
#declare Hole1Boardwalk =
	union {
		#local CC = 0;
		#while (CC < 1.01)
			object { HBPost // main posts
				translate BoardwalkSpline(CC)
			}
			#local CC = CC + 0.1;
		#end
		#local CC = 0;
		#while (CC < 1.01)
			object { HBPost // main posts, opposite side
				#local VA = vnormalize(BoardwalkSpline(CC)-BoardwalkSpline(CC-0.02));
				#local Vrot = degrees(asin(-VA.y));
				translate <0,48,0>
				rotate z*Vrot
				translate BoardwalkSpline(CC)
			}
			#local CC = CC + 0.1;
		#end

		#local CC = 0;
		#while (CC < 1.01)
			object { HBRailPost // guardrail posts
				translate BoardwalkSpline(CC)
			}
			#local CC = CC + 0.05;
		#end
		#local CC = 0;
		#while (CC < 1.01)
			object { HBRailPost // guardrail posts, opposite side
				#local VA = vnormalize(BoardwalkSpline(CC)-BoardwalkSpline(CC-0.02));
				#local Vrot = degrees(asin(-VA.y));
				translate <0,48,0>
				rotate z*Vrot
				translate BoardwalkSpline(CC)
			}
			#local CC = CC + 0.05;
		#end

		#local CC = 0.0;
		#while (CC < 0.95)
			cylinder { // handrail left
				BoardwalkSpline(CC),BoardwalkSpline(CC+0.05),2.5
				translate <0,0,40>
				texture { BoardwalkTex }
			}
			#local CC = CC + 0.05;
		#end

		#local CC = 0;
		#while (CC < 1.01)
			cylinder { // handrail right
				<0,0,0>,<-6*Feet,0,0>,2.5 // crude but good enough
				#local VA = vnormalize(BoardwalkSpline(CC+0.05)-BoardwalkSpline(CC-0.0));
				#local Vrot = degrees(asin(-VA.y));
				translate <0,48,40>
				rotate z*Vrot
				translate BoardwalkSpline(CC)
				texture { BoardwalkTex }
			}
			#local CC = CC + 0.05;
		#end

		#local CC = 0.0;
		#while (CC < 0.95)
			cylinder { // uhderboard support
				BoardwalkSpline(CC),BoardwalkSpline(CC+0.1),5
				translate <0,0,-6>
				texture { BoardwalkTex }
			}
			cylinder { // lower X support
				BoardwalkSpline(CC)+<0,0,-10>,BoardwalkSpline(CC+0.1)+<0,0,-70>,3.0
				texture { BoardwalkTex }
			}
			cylinder { // lower X support
				BoardwalkSpline(CC)+<0,0,-70>,BoardwalkSpline(CC+0.1)+<0,0,-10>,3.0
				texture { BoardwalkTex }
			}
			#local CC = CC + 0.1;
		#end

		#local CC = 0;
		#while (CC < 1.01)
			object { HBPlank
				#local VA = vnormalize(BoardwalkSpline(CC)-BoardwalkSpline(CC-0.01));
				#local Vrot = degrees(asin(-VA.y));
				//#debug concat("Rot degrees:",str(Vrot,5,3),"\n")
				rotate z*Vrot
				translate BoardwalkSpline(CC)
			}
			#local CC = CC + 0.01;
		#end

	} // end union


#declare Hole1 =
	union {
		object { VolcanicUpper }
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1LowerHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,50*Feet>
		}
		box { // underwater area
			<0,0,0>,<1,1,1>
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "Hole1SandColorMap.png"
						once
						map_type 0 // planar
						interpolate 2 // bilinear
					}
					scale <1,1,1>
				}
			}
			scale <70*Yards,40*Yards,1>
			translate <-10*Yards,-15*Yards,10>
		}
		object { Hole1Boardwalk translate <91.6*Feet,16*Feet,22*Feet> }
		object { Boulder30ft RandRot() scale <2.9,2,2> rotate z*-20 translate <90*Feet, 8*Feet,40> }
		object { Boulder30ft RandRot() translate <81*Feet, -8*Feet,40> }
		object { Boulder30ft RandRot() scale 1.3 translate <67*Feet, -3*Feet,40> }

		object { GolfFlag rotate z*-20 translate <60*Feet,90*Feet,104.1*Feet> }
	#if ( Vegetation = 1 )
		object { PalmTreeS rotate z*48 translate <120*Feet,60*Feet,100*Feet> }
		object { PalmTreeS scale 0.82 rotate z*128 translate <112*Feet,58*Feet,100*Feet> }
		object { PalmTreeS scale 1.09 rotate z*225 translate <103*Feet,102*Feet,100*Feet> }
	#end
		object { Elevator1 rotate z*16 translate <108*Feet,20*Feet,103*Feet> }
		texture { RockyTex }
	} // end union

#declare Hole9 = // taller one
	union {
		object { VolcanicUpper translate <0,0,60*Feet> }
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1LowerHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,50*Feet+60*Feet>
		}
	#if ( Vegetation = 1 )
//		object { PalmTreeS rotate z*48 rotate x*-14 scale <1,1,1.3> translate <112*Feet,83*Feet,160*Feet> }
		object { PalmTreeS rotate z*179 rotate x*-25 scale <1,1,1.3> translate <107*Feet,29.5*Feet,160*Feet> }
		object { PalmTreeS scale <0.82,0.9,0.93>  rotate z*128 rotate x*-7 translate <112*Feet,44*Feet,160*Feet> }
		object { PalmTreeS scale <1.09,1.13,1.38> rotate z*225 rotate x*-20 translate <103*Feet,114*Feet,160*Feet> }
		object { PalmTreeS scale <1.02,1.09,1.13>  rotate z*32 rotate x*-4 translate <97*Feet,48*Feet,160*Feet> }
		object { PalmTreeS scale <1.02,1.09,0.93>  rotate z*2 translate <97*Feet,32*Feet,160*Feet> }
	#end
		texture { RockyTex }
	} // end union

#declare Hole2GreenSteps =
	union {
		box { <-70,0,-80 >,<70,120,8> }
		box { <-50,0,8 >,<50,80,16> }
		box { <-40,0,16>,<40,60,24> }
		box { <-30,0,24>,<30,40,32> }
		box { <-30,0,32>,<30,30,40> }
		box { <-30,0,40>,<30,20,48> }
		box { <-30,-10,48>,<30,10,56> }
		box { <-30,-20,56>,<30,0,64> }
		box { <-30,-30,64>,<30,-10,72> }
		box { <-30,-40,72>,<30,-20,80> }
		texture { pigment { rgb<0.957,0.906,0.851>*.8 } }
	} // end union

#declare Hole2Green = // artificial
	union {
		cylinder { // sand
			<0,0,-30>,<0,0,0>,40*Feet
			texture { SandyTex }
		}
		cylinder { // green
			<0,0,-3>,<0,0,0.1>,32*Feet
//			translate <-6*Feet,-3*Feet,0>
			texture { GreenTex }
		}
		object { GolfFlag rotate z*-25 translate <-6*Feet,-3*Feet,0> }
		cylinder { // wall
			<0,0,-5.6*Feet>,<0,0,-0.5>,40*Feet+12
			texture {
				pigment { color rgb <0.482,0.302,0.161> }
			}
		}
		cylinder { // support base
			<0,0,-20*Feet>,<0,0,-5>,36*Feet
			texture {
				pigment { color rgb <0.482,0.302,0.161>*.5 }
			}
		}
		#local PC = 0;
		#while (PC < 270)
			cylinder {
				<0,0,-5.6*Feet>,<0,0,24>,5
				translate <40*Feet+12+5,0,0>
				rotate z*PC
				texture {
					pigment { color rgb <0.482,0.302,0.161> }
				}
			}
			#declare PC = PC + 10;
		#end
		object { Hole2GreenSteps translate <0,48*Feet+12+30,-100> rotate z*200 }
		object { BlankHFRock1 // boulder
			scale 128 rotate <123,9,209>
			texture { RockyTex scale 0.8 }
			translate <-40*Feet,20*Feet,-15*Feet>
		}
		object { BlankHFRock1 // smaller rock
			rotate <343,108,45> scale <35,58,43>
			texture { RockyTex scale 0.8 }
			translate <-60*Feet,-40*Feet,-15*Feet>
		}
		#if (Vegetation=1)
		object { Peeps(rgb<.35,.63,.24>) scale 1.2 rotate z*20 translate <-6*Feet,2*Feet,0> } // yellow
		object { Peeps(rgb<.93,.23,.10>) scale 0.9 rotate <0,0,200> translate <16*Feet,-8*Feet,0> } // blue
		cylinder { <0,0,5>,<3.5*Feet,0,5>,5 texture {pigment{rgb<.18,.12,0.04>}} rotate <0,0,-40> translate <24*Feet,-16*Feet,0> } // golf bag
		cylinder { <0,0,5>,<3.5*Feet,0,5>,5 texture {pigment{rgb<.18,.18,0.69>}} rotate <0,0,-70> translate <24*Feet,-22*Feet,0> } // golf bag
		#end
	} // end union

#declare Hole3Tee =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
//			png "Test8bitGreyHF.png"
			png "Hole2THF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1>
			scale <70*Yards,70*Yards,160*Feet>
			texture { RockyTex }
		}

#declare Hole3Fairway =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
//			png "Test8bitGreyHF.png"
			png "Hole2FHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1>
			scale <260*Yards,130*Yards,98*Feet>
			texture { RockyTex }
			texture { // slope
				pigment {
					slope <0,0,-1>
					pigment_map {
						[ 0.08 FairwayGrass ]
						[ 0.33 rgbt<1,1,1,1> ]
					}
				}
			}
		}

#declare Hole3Green =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole1UpperHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <1,1,-1> // extrude downwards
			scale <50*Yards,50*Yards,50*Feet>
			translate <0,0,96*Feet>
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole3CrownHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,20*Feet>
			translate <0,0,96*Feet>
			texture { // FarGreenTex }
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "CrownColorMap.png"
						once
					}
					scale 150*Feet
					translate <0*Feet,0*Feet,0>
				}
//				finish { specular 0.13 roughness .233 }
				finish { specular 0.05 roughness .233 }
			}
		}
		#local PC = 0;
		#while (PC < 360)
			cylinder {
				<0,0,-12*Feet>,<0,0,0>,8
				translate <40*Feet+12+5,0,0>
				rotate z*(-90+PC)
				rotate y*-12
				translate <70*Feet,80*Feet,(96+12)*Feet>
				texture {
					pigment { color rgb <0.482,0.302,0.161> }
				}
			}
			#declare PC = PC + 2;
		#end
		object { GolfFlag rotate z*-25 rotate y*-12 translate <70*Feet,80*Feet,(96+15.5)*Feet> }
		texture { RockyTex }
	} // end union

#declare Hole18 =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Hole18HF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <60*Yards,120*Yards,20*Feet>
			texture { RockyTex }

			texture { // slope
				pigment {
					slope <0,0,-1>
					pigment_map {
						[ 0.08 FairwayGrass ]
						[ 0.33 rgbt<1,1,1,1> ]
					}
				}
			}

			texture { // FarGreenTex }
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "Crown2ColorMap.png"
						once
					}
					scale 70*Feet
					translate <15*Yards,82*Yards,0>
				}
//				finish { specular 0.13 roughness .233 }
				finish { specular 0.05 roughness .233 }
			}
		}
//sphere { <0,0,0>,50*Yards texture { pigment{rgb<1,1,1> } } }
	#if ( Vegetation = 1 )
//		object { PalmTreeS rotate z*179 rotate x*-25 scale <1,1,1.3> translate <107*Feet,29.5*Feet,160*Feet> }
	#end
	} // end union

//---------------- Mounds ----------------------

#declare Mound1 =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Mound1HF.png"
		smooth
		water_level .01
		rotate x*90
		scale <1,-1,1>
		scale <140*Yards,100*Yards,216*Feet>
		texture { RockyTex }
		texture { // slope
			pigment {
				slope <0,0,-1>
				color_map {
					[ 0.3 rgb<.047,.424,.042>*.24 ]
					[ 0.48 rgbt<1,1,1,1> ]
				}
			}
		}
	}

#declare Mound2 =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Mound2HF.png"
		smooth
		water_level .01
		rotate x*90
		scale <1,-1,1>
		scale <42*Yards,42*Yards,59*Feet>
		texture { RockyTex }
	}

#declare Mound2TeeGroup =
	union {
		box { // main tee
			<0,0,-4*Feet>,<40*Feet,20*Feet,-1>
			texture { TeeBoxTex }
		}
		box { // grass
			<12,12,-2>,<40*Feet-12,20*Feet-12,0>
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "GrassMowed.png"
					}
					scale 12*Feet
					rotate z*90
				}
			}
		}
		cylinder { // tee marker
			<0,0,0>,<0,0,6>,2.5
			translate <36*Feet,4*Feet,1.0>
			texture { WhitePaint }
		}
		cylinder { // tee marker
			<0,0,0>,<0,0,6>,2.5
			translate <36*Feet,16*Feet,1.0>
			texture { WhitePaint }
		}
		#if (GoodGolfers = 1)
			object { BagSupport rotate x*5 translate <9*Feet,1.3*Feet,-3> }
		#end
	} // end union
#declare Mound2Tee =
	union {
		object { Mound2 }
		object { Mound2TeeGroup rotate <0,2.3,14> translate <22*Yards,20*Yards,59.5*Feet> }
		object { BlankHFRock1 // large boulder
			scale 168 rotate <123,9,209>
			texture { RockyTex scale 0.8 }
			translate <16*Feet,47*Feet,-4*Feet>
		}
		object { BlankHFRock1 // small boulder
			rotate <343,108,45> scale <83,108,98>
			texture { RockyTex scale 0.8 }
			translate <12*Feet,28*Feet,0>
		}
		object { BlankHFRock1 // very large boulder
			rotate <43,168,225> scale <230,178,196>
			texture { RockyTex scale 0.8 }
			translate <44*Feet,-4*Feet,0>
		}
		#if (Vegetation=1)
		object { PalmTreeS scale <1,1,1.0> rotate z*-50 rotate <-8,-8,0> translate <20*Yards,25*Yards,55*Feet> }
		object { PalmTreeS scale <0.92,.92,0.97> rotate z*166 rotate y*-12 translate <19*Yards,22*Yards,55*Feet> }
		object { TropicalPlant1 scale 3.4 translate <21.0*Yards,18.2*Yards,54*Feet> }
		object { TropicalPlant1 scale 4 translate <20.0*Yards,19.2*Yards,55*Feet> }
		object { TropicalPlant1 scale 2 translate <24.7*Yards,20.7*Yards,55*Feet> }
		object { PalmTreeS scale <0.88,.82,.80> rotate z*215  translate <25*Yards,20*Yards,55*Feet> }
		object { FarTreeGroup(VegQual,8,60*Feet,12*Feet) scale 0.33 translate <19*Yards,17*Yards,50*Feet> }
		#end
	} // end union

#declare Mound2Toppled =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Mound2UpperHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <1,1,-1> // extrude downwards
			scale <50*Yards,50*Yards,75*Feet>
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Mound2CrownHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1> // align top left to <0,1,z>
			scale <50*Yards,50*Yards,24*Feet>
		}
		translate <-25*Yards,-25*Yards,0> // center it
		rotate z*45 // face a new side to viewer
		rotate y*-140 // topple it
		translate <0,0,-10*Feet> // establish the waterline
		texture { RockyTex }
	} // end union

#declare Mound3 = // rounded top
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Mound3HF.png"
		smooth
		water_level .01
		rotate x*90
		scale <1,-1,1>
		scale <40*Yards,40*Yards,93*Feet>
		texture { RockyTex }
	}

#declare Mound4TeeGroup = // hole9 tee
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Mound4HF.png"
			smooth
			water_level .04
			rotate x*90
			scale <1,-1,1>
//			scale <200*Yards,400*Yards,160*Feet>
			scale <200*Yards,533*Yards,160*Feet>
			texture { RockyTex translate <0,0,40*Feet> }
			texture { // slope
				pigment {
					slope <0,0,-1>
					pigment_map {
						[ 0.02 DarkGrass ]
						[ 0.04 rgbt<1,1,1,1> ]
					}
				}
			}
			translate <0,-133*Yards,0>
		}
		object { Mound2TeeGroup rotate <0,2.5,-80> translate <328*Feet,70*Feet,95*Feet> }
		#if (Vegetation = 1)
			object { TreeCluster(10,22*Feet) translate <343*Feet,100*Feet,95*Feet> }
		#end
	} // end union


//---------------- Waterfalls ----------------------

#declare MoundVert1 =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "MoundVert1HF.png"
		smooth
		water_level .01
//		rotate x*90
		scale <1,-1,1>
		scale <76*Yards,30*Yards, 76*Yards>
		texture { RockyTex }
			texture { // slope
				pigment {
					slope <0,0,-1>
					pigment_map {
						[ 0.22 DarkGrass ]
						[ 0.32 rgbt<1,1,1,1> ]
					}
				}
			}
	}

#declare ClearTex = texture { pigment { color rgbt<1,1,1,1.0> } }
#declare ConeInt = interior {
	media {
		method 3
//		emission rgb<.1,.1,.1>
		scattering {
			1, // 1= isotropic, 2=Mie
//			rgb<.010,.010,.010> } // milky white
//			rgb<.0025,.0025,.0025> } // fine mist
			rgb<.0025,.0075,.0105> } // use this
//			rgb<.001,.001,.001> } // almost transparent
		density {
			cylindrical
			rotate x*90
			warp { turbulence <.7,.7,.06> }
			scale <100,100,40*Feet>

		}
	}
}
#declare ConeWFMat = material{ texture{ ClearTex } interior{ ConeInt }}

#declare WFCone =
	cone {
		<0,0,0>,5*Feet,<0,0,-200*Feet>,40*Feet
		hollow on
//		texture { pigment { color rgbt<1,1,1,.1> } }
		material { ConeWFMat }
	}

#declare MistInt = interior {
	media {
		method 3
//		emission rgb<.1,.1,.1>
		scattering {
			1, // 1= isotropic, 2=Mie
//			rgb<.010,.010,.010> } // milky white
//			rgb<.0025,.0025,.0025> } // fine mist
//			rgb<.0025,.0075,.0105> } // too thick
			rgb<.0015,.0035,.0055> } // test
//			rgb<.001,.001,.001> } // almost transparent
		density {
			spherical
			warp { turbulence <.7,.7,.7> }
			scale <34*Feet,34*Feet,34*Feet>

		}
	}
}
#declare MistWFMat = material{ texture{ ClearTex } interior{ MistInt }}
#declare WFMist =
	sphere {
		<0,0,0>,60*Feet
		hollow on
//		texture { pigment { color rgbt<1,1,1,.1> } }
		material { MistWFMat }
	}

#declare MoundVert1Waterfall =
	union {
		object { MoundVert1 }
//		object { WFCone rotate <0,-6,0> translate <130*Feet,-80*Feet,160*Feet> }
		object { WFCone rotate <0,-6,0> translate <130*Feet,-80*Feet,190*Feet> }
		object { WFCone rotate <0,-6,0> translate <180*Feet,-80*Feet,210*Feet> }
		object { WFMist rotate <0,0,0> translate <130*Feet,-80*Feet,16*Feet> }
		object { WFMist rotate <0,0,0> translate <180*Feet,-80*Feet,27*Feet> }
	} // end union



//---------------- Beach ----------------------

#declare SandyBeach =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "BeachHF.png"
			smooth
			water_level .01
			rotate x*90
			scale <1,-1,1>
//			scale <100*Yards,120*Yards,6*Feet>
			scale <100*Yards,120*Yards,12*Feet>
//			texture { SandyTex }
			texture {
				pigment {
					image_map { // projected from -Z, with top left at <0,1,0>
						png "BeachColorMap.png"
						once
					}
					scale <100*Yards,120*Yards,1>
				}
			}
		}
		box {
			<0,0,0>,<1,1,1>
			scale <100*Yards,120*Yards,1>
			texture {
				image_pattern { // projected from -Z, with top left at <0,1,0>
					png "BeachWavesColorMap.png"
//png "BeachHF.png"
					once
//					use_alpha
				}
				scale <100*Yards,120*Yards,1>
		    texture_map {
					[0 pigment { transmit 1 } ]
					[1 pigment { rgbt<2,2,2,0.75> } ]
				}
			}
 			translate <0,0,6*Feet+1>
		}

		#if (Vegetation=1)
		object { PalmTreeS scale <1,1,1.3> rotate z*-20 rotate <-8,-8,0> translate <81*Yards,96*Yards,10*Feet> }
		object { TropicalPlant1 scale <1.23,1.28,1.40> translate <81*Yards,94.2*Yards,10*Feet> }
		object { PalmTreeS scale <0.92,.92,1.0> rotate z*120 rotate y*-12 translate <86*Yards,85*Yards,10*Feet> }
		object { PalmTreeS scale <1.02,1.02,1.20> rotate z*145  translate <85*Yards,80*Yards,12*Feet> }

		object { Peeps(rgb<.35,.63,.24>) scale 1 rotate z*200 translate <47*Yards,26*Yards,7*Feet> } // yellow
		object { Peeps(rgb<.23,.23,.40>) scale 1 rotate <-75,0,200> translate <45*Yards,21*Yards,8*Feet> } // blue
		box { <0,0,0>,<6*Feet,-6.5*Feet,0.7> texture {pigment{rgb<.98,.98,0.79>}} rotate <3,0,30> translate <44.5*Yards,21*Yards,8*Feet> } // towel
		box { <0,0,0>,<1*Feet,2*Feet,10> texture {pigment{rgb<.28,.38,0.59>}} rotate <3,0,40> translate <43.7*Yards,20*Yards,8*Feet> } // towel		
		#end

	} // end union


//---------------- Distant Mountains ----------------------

#declare RightCoast =
//	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "FarlandHF.png"
			smooth
			water_level 1/255
			rotate x*90
			scale <1,-1,1>
			scale <1*Miles,1*Miles,200*Feet>
			texture { FarlandTex scale 208*Feet }
			translate <-0.5*Miles,0,0>
		}
//	} // end union

#declare ResortHill =
//	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "ResortHillHF.png"
			smooth
			water_level 1/255
			rotate x*90
			scale <1,-1,1>
			scale <.3*Miles,.3*Miles,360*Feet>
			texture { ResortHillTex scale 368*Feet }
		}
//	} // end union

#declare FarCoastline =
//	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "FarlandHF.png"
			smooth
			water_level 1/255
			rotate x*90
			scale <1,-1,1>
			scale <-1*Miles,1*Miles,600*Feet>
			texture { FarlandTex scale 620*Feet }
		}
//	} // end union

#declare DistantIsland =
//	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "FarlandHF.png"
			smooth
			water_level 1/255
			rotate x*90
			scale <1,-1,1>
			scale <-1*Miles,1*Miles,600*Feet>
			texture { DistantIslandTex scale 620*Feet }
		}
//	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {	max_trace_level 50 }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//		angle 25
//		location  <1, -300*Feet, 725*Feet> // far view
//		look_at <20*Feet,70*Feet,50*Feet>
		angle 35
		location  <1, -250*Feet, 235*Feet> // overall
		look_at <-10*Feet,100*Feet,60*Feet>
//		angle 35
//		location  <1, -70*Feet, 75*Feet> // boardwalk
//		look_at <-20*Feet,20*Feet,15*Feet>
//		angle 35
//		location  <1, -24*Feet, 5*Feet> // origin
//		look_at <0*Feet,0*Feet,1*Feet>
//		angle 40
//		location  <1, -22*Feet, 5*Feet> // flag alone
//		look_at <0*Feet,0*Feet,3*Feet>
//		angle 30
//		location  <1, -25*Feet, 115*Feet> // flag on green
//		look_at <-16*Feet,5*Feet,105*Feet>
	}


light_source
{ <400*Feet,-350*Feet,500*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
//{ <-400*Feet,-200*Feet,300*Feet>, <1.13,1.08,0.83>*.8
{ <-400*Feet,-200*Feet,300*Feet>, <1.00,1.00,1.00>*.8 // colorless
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

//object { TestPillar translate <0,0,0> }
//object { Hole1 translate <-80*Feet,-80*Feet,0> rotate z*0 }
//object { Hole1Boardwalk translate <0,0,8*Feet> }
//object { Hole3Green translate <-80*Feet,-80*Feet,-50*Feet> rotate z*0 }
//object { Hole3Green translate <-80*Feet,-80*Feet,-50*Feet> rotate z*0 rotate x*45 translate <0,200*Feet,50*Feet>}
//object { VolcanicFormation translate <-80*Feet,-80*Feet,0> }
//object { Hole18 translate <-100*Feet,-230*Feet,0> }
//object { Mound2 }
//object { Mound2Tee translate <-100*Feet,0,0> }
//object { Mound2Toppled rotate z*-0 translate <-40*Feet,-40*Feet,-0*Feet> }
//object { Mound4TeeGroup rotate z*-30 translate <-300*Feet,-110*Feet,-0*Feet> } 
object { SandyBeach translate <-200*Feet,0,0> }

#end
