// Persistence of Vision Ray Tracer Scene Description File
// File: jgwisles.pov
// Vers: 3.5
// Desc: Entry for IRTC Sept-Oct 2002
// Date: 28 October 2002
// Auth: Doctor John (jguthkelch@netscape.net)

#version 3.5;

#include "functions.inc"

global_settings {
	assumed_gamma 1.0 //You'll have to play with this to get exactly the effect I got
			  //If you use this setting, your image will be way too light.
}

camera {
	location <5, 0.3, 0>
	angle 120
	look_at <3,0.05,-4>
	right 4.4*x     //This is a quick fix to exaggerate y-axis. Render at 2.667:1
}

light_source {
	<  15, 20, 10>*1000
	color rgb <0.85, 0.85, 1.0>
}

//An typical Scottish sky and sea mist rolling in
sky_sphere {
	pigment {
		gradient y
		color_map {
			[(1-cos(radians( 80)))/2 color 1.0]
			[(1-cos(radians(120)))/2 color rgb <0.0, 0.0, 1.0>]
		}
		scale 2
		translate -1
	}
	pigment {
        	bozo
        	turbulence 1.5
        	octaves 10
        	omega 0.5
        	lambda 2.5
        	color_map {
        		[0.0, 0.4 color rgbt<0.75, 0.75, 0.75, 0> color rgbt<0.9, 0.9, 0.9, 0.8> ]
        		[0.4, 0.7 color rgbt<0.9, 0.9, 0.9, 0.8> color rgbt<1.0, 1.0, 1.0, 1.0> ]
			[0.7, 1.0 color rgbt<1.0, 1.0, 1.0, 1.0> color rgbt<1.0, 1.0, 1.0, 1.0> ]
        	}
    		scale <1, 0.3, 5>
    	}
    	pigment {
        	bozo
        	turbulence 0.6
        	octaves 10
        	omega 0.5
        	lambda 2.5
        	color_map {
			[0.0, 0.4 color rgbt<0.75, 0.75, 0.75, 0.0> color rgbt<0.9, 0.9, 0.9, 0.9> ]
			[0.4, 0.7 color rgbt<0.9, 0.9, 0.9, 0.9> color rgbt<1.0, 1.0, 1.0, 1.0> ]
			[0.7, 1.0 color rgbt<1.0, 1.0, 1.0, 1.0> color rgbt<1.0, 1.0, 1.0, 1.0> ]
        	}
    		scale <1, 0.3, 5>
    	}
	pigment {
        	bozo
        	turbulence 0.8
        	octaves 10
        	omega 0.5
        	lambda 2.5
        	color_map {
			[0.0, 0.4 color rgbt<0.75, 0.75, 0.75, 0.0> color rgbt<0.9, 0.9, 0.9, 0.9> ]
			[0.4, 0.6 color rgbt<0.9, 0.9, 0.9, 0.9> color rgbt<1.0, 1.0, 1.0, 1.0> ]
			[0.6, 1.0 color rgbt<1.0, 1.0, 1.0, 1.0> color rgbt<1.0, 1.0, 1.0, 1.0> ]
		}
		scale <1, 0.3, 5>
    	}
}

fog {
	distance 5
	color rgbf<1.0, 1.0, 1.0, 0.7>
	fog_type 2
	fog_offset 0.0
	fog_alt 0.45
	turbulence 1.2
}

//A calm sea - an unusual occurrence in the Western Isles <ironic grin>
box {
	<-15, -1.5, -30>, <30, 0.03, 1>
	texture {
		pigment {
			color rgb <0.01, 0.04, 0.04>
		}
		finish {
			reflection {
				0.0, 0.65
				fresnel on
			}
			conserve_energy
			specular 0.4
			roughness 0.07
		}
		normal{
			function { f_ridged_mf(x, y, z, 0.07, 2.2,  7, 0.6, 0.9, 1) } 0.8
			scale 0.025
		}
	}
	interior {
		ior 1.31
	}
}

//The land mass - work it out for yourself <big grin>
#declare RUFF=function{
	f_noise3d(x*40,y,z*40)
}

#declare RIDGEF=function{
	y+abs(x+2)*0.15-0.2-f_noise3d(x*2,0,z)*0.5-f_noise3d(x*12,0,z*12)*0.03-
	RUFF(x*0.012,y*0.012,z*0.012)-f_noise3d(x*125,y*5,z*125)*0.005-
	f_noise3d(x*300,y*100,z*300)*0.002-f_noise3d(x*1000,y*400,z*1000)*0.0005
}

isosurface {
	function {
		RIDGEF (x,y,z)
	}
	contained_by {
		box {
			<-10, -0.2, -30>, <10, 1.9, 1>
		}
	}
	max_gradient 2.1
	pigment {
		function {
			RUFF(x,y,z)*((y+0.2)*0.12+y*0.3)
		}
		color_map {
			[0.000, 0.005 color <0.0, 0.0, 0.0 > color <0.2, 0.23, 0.125>]
			[0.005, 0.007 color <0.2, 0.23, 0.125> color <0.25, 0.33, 0.258>]
			[0.007, 0.025 color <0.25, 0.33, 0.258> color <0.2, 0.2, 0.175>]
			[0.025, 0.035 color <0.2, 0.2, 0.175> color <0.45, 0.25, 0.2>]
			[0.035, 0.050 color <0.45, 0.25, 0.2  > color <0.8, 0.8, 0.7>]
			[0.050, 1.000 color <0.8, 0.8, 0.7  > color <0.8, 0.8, 0.07 >]
		}
		frequency 0.23
	}
	normal {
		function {
			1-f_noise3d(x*345,y*345,z*345)
		}
		slope_map {
			[0.0 <1, 1>]
			[0.7 <0, 1>]
		}
		scale 0.1
	}
	finish {
		phong 0.04
	}
}    
