/*********************
Jupiter.pov
Author: Brian Blovett
Date: 9/9/02

Description: standing on Io, watching a sulphur volcano erupt
as Jupiter hangs in the background. We can see some HUD displays
over the scene and a hint of the astronaut's face reflected in
his helmet.

test renders done at 432x243

THINGS TO DO:
texture & light Jupiter
texture landscape
add a canyon? at least make the landscape not so flat
add and light erupting sulfur
background texture
some fog
hud/face reflection
	indicate low O2, power
	indicate exactly 200 years since Neil Armstrong stepped on the moon
*********************/

// Jupiter should be about 3x its diameter from the camera
//sphere{<0,0,0>, 2 pigment{color<1,1,0>} no_shadow translate <-5.25,5,-7>}
#declare Jupiter=sphere{<0,0,0>, 2 
	pigment{image_map{sys "jupiter texmap.pict"} scale 4 translate<2,2,0>}
//	pigment{color <1,1,0>}
	rotate<0,-95,0>
	rotate<-18,0,0>
	no_shadow translate <-5.25,5,-7>
}
// jupiter's spotlight
#declare jup_light=light_source{
	<4,1,-10>
	color <1,1,1>
	spotlight
	radius 7
	falloff 15
	point_at<-5.25,5,-7>
}
/*light_source{
	<4,5,-10> color<1,1,1>
}*/

#declare other_lights=union{
	light_source{ <-5.25,5,-7> color <.8,.8,.8>}
//	light_source{ <2,8,0> color <.3,.3,.3>}
//	light_source{ <2,3,1> color <1,.4,0>}
}

#declare theFog=fog{
	distance 5
	color <.5,.6,1>
	fog_type 2
	fog_offset .07
	fog_alt .03
}

//cylinder{<0,0,0><0,8,0>,.1 pigment {color<1,0,0>}no_shadow translate<2,0,1>}

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
#declare volcano=height_field{
	tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
	"landht.tga"     // the file name to read
	water_level 0/256
	scale<20,4,20>
	translate<-6,0,-11>
//	pigment{color <1,1,1>}
	pigment{
		bozo
		color_map
		{
			[  0.25  color <1,1,0>]
		//	[  0.75  color <1,.5,0>]
			[  1  color <.68,.4,.08>]
		}
		turbulence .5
		scale 1
	}
}

// sulfur lava
#declare lava= blob{
	threshold 0.6
	sphere{<0,0,0>,1,1 scale<2,1,1> translate<2.9,2.8,-1.5>}
	sphere{<0,0,0>,1,1 scale<1,1,1> translate<3,2,-2>}
	sphere{<0,0,0>,1,1 scale<1,1,1.5> translate<3.3,1.3,-2.8>}
	sphere{<0,0,0>,1,1 scale<.5,1,1.5> rotate<0,-15,0> translate<3.3,1.3,-2.8>}
	sphere{<0,0,0>,1,1 scale<.6,1,1.5> rotate<15,-15,0> translate<3.5,.8,-4>}
	sphere{<0,0,0>,1,1 scale<.6,1,1.5> rotate<15,-25,0> translate<3.7,.5,-5>}
	sphere{<0,0,0>,1,1 scale<.6,.5,1.5> rotate<15,-25,0> translate<4.3,.35,-5.3>}
	sphere{<0,0,0>,1,1 scale<.75,.5,1.5> rotate<10,-15,0> translate<4.5,.1,-6>}
	sphere{<0,0,0>,1,1 scale<.75,.25,1.5> rotate<10,-15,0> translate<4.75,.05,-7>}
	sphere{<0,0,0>,1,1 scale<.75,.25,1.5> rotate<0,20,0> translate<4.7,.05,-8>}
	sphere{<0,0,0>,1,1 scale<.5,.15,1.5> rotate<0,40,0> translate<4.25,.0,-8.5>}
	sphere{<0,0,0>,1,1 scale<.5,.1,1.5> rotate<0,60,0> translate<3.75,.0,-9>}
	sphere{<0,0,0>,1,1 scale<.5,.1,3> rotate<0,60,0> translate<2.5,.0,-9.5>}
//	pigment{color<0,1,0,.5>}
	pigment{
		bozo
		color_map
		{
			[  0  color <1,1,0>]
			[  0.75  color <1,.9,0>]
			[  1  color <.5,.23,0>]
		}
		turbulence .5
		scale .1
	}
	
	normal{bumps .75 scale .4}
	finish{specular .5 roughness .1 ambient <.5,.25,0>}
	no_shadow
}
//#declare camVer=1;	// 0=final pos, 1=high up

#declare seed1=seed(1);
#macro eruptionParticle()
//	union{
		sphere{<0,0,0>,.2*rand(seed1) pigment{color<1,1,0,.5>} finish{ambient .05} no_shadow}
//		sphere{<0,0,0>,.02*rand(seed1) pigment{color<.8,1,0>} finish{ambient 1} no_shadow}
	//	light_source{<0,0,0> color<.01,.004,0>}
//	}
#end

// returns a random number between a and b, but much more likely close to a
// than to b
#declare halfBellFactor=1;
#declare halfBellRandomizer=seed(123);
#macro halfBell(a,b)
	#local i=0;
	#local sum=0;
	#while (i<halfBellFactor)
		#local sum=sum+rand(halfBellRandomizer);
		#local i=i+1;
	#end
	#local sum=abs(sum-.5*halfBellFactor)*2/halfBellFactor*(b-a)+a;
	sum
#end

#macro eruptionParticle2(cpt)
	sphere{<0,0,0>,.02 pigment{color<.8,1,0>} finish{ambient 1} no_shadow}
#end

#macro eruptionParticle3(cpt)
	#local cptr=(cpt+1)/3;
	#local blobRad=.15*rand(seed1)+.05;
	sphere{<0,0,0>,blobRad
		pigment{color<1,1,1,1>}
		hollow on
		scale <2,1,1> translate<-.5*blobRad,0,0> rotate<0,0,-45*cpt>
		interior{
			media{
		//	emission <.8,1,0>
			emission <(1-cptr)*.2+.8,1,(1-cptr*3)>
			density{spherical scale .5 turbulence blobRad*2}}
			media{
		//	emission <.8,1,0>
			emission <(1-cptr)*.2+.8,1,(1-cptr*3)>
			density{spherical scale .5 turbulence blobRad*2}}}
		no_shadow
		finish {ambient 1}
	}
#end

#macro eruption(fountParticlles)
//	circle <0,0> r start points for fountain components
//	ranged vars:
	//	altitude	?,?
	//	radius		?,?
	//	angle		0,360
	//	curvept 	-1,1
	#local i=0;
	#local lSeed=seed(321);
	#local fountParticles=500;
	#while(i<fountParticles)
		#local rad	=	rand(lSeed)*2+1;
		#local baseX=	rand(lSeed);
		#local baseY=	rand(lSeed)*360;
		#local alt	=	rand(lSeed)*2+4;
		#local ang	=	rand(lSeed)*360;
	//	#local cpt	=	halfBell(-1,1);
		#local cpt	=	rand(lSeed)*3-1;
		object{
		//	eruptionParticle()	// at <0,0,0>
			eruptionParticle3(cpt)	// at <0,0,0>
			translate<(cpt+1)*rad,alt-(cpt*cpt),0>
			rotate<0,ang,0>
			translate<baseX,0,0>
			rotate<0,baseY,0>
		}
		#local i=i+1;
	#end
#end

#declare craterGlow=sphere{
	<0,0,0>,1.5 hollow on no_shadow
	pigment{color<1,1,1,1>}
	interior{
		media{
			emission<1,1,0>
			density{spherical turbulence .25}
			density{color <.35,.35,.35>}
		}
	}
}

#macro eruption2()
// a neater looking eruption I hope
	lathe{
	//	quadratic_spline
	//	7,<0,0>,<2,4>,<4,-1>,<6,-1>,<2,6>,<0,0>,<0,-1>
		cubic_spline
		8,<0,-1>,<0,2>,<1.1,4.05>,<4,-1>,<9,-1>,<3,6>,<0,5>,<0,-1>
		pigment{color<1,.5,0,1>}
		hollow on
		interior{
			media{emission color<1,.8,0>
				density{spherical scale<7,6,7>}
			}
		}
	}
#end

#macro eruption3()
// a neater looking eruption I hope
	union{
		difference{	
			object{ eruption2()	translate<2,0,1>}
			box{<-10,-2,-20>,<10,10,.99> pigment{color<0,1,1>}}
		}
//		cubic_spline
//		8,<0,-1>,<0,2>,<1.1,4.05>,<4,-1>,<9,-1>,<3,6>,<0,5>,<0,-1>
		#local i=0;
		#local iMax=4;
		#while (i<iMax)
			#local fx=i;//(4/iMax*(i+1));
			#local fx2=fx-1.1;
			#local fy=.188*(fx2*fx2*fx2)-.604*(fx2*fx2)-1.57*fx2+4.05;
			sphere{<fx,fy,0>
				,.05 pigment{color<0,0,0>} translate<2,0,1>}
			#local i=i+.25;
		#end
	/*
		sphere{<0,-1,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<0,2,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<1.1,4.05,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<4,-1,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<9,-1,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<3,6,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<0,5,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		sphere{<0,-1,0>,.05 pigment{color<1,0,0>} translate<2,0,1>}
		
		sphere{<3.25,-.2,0>,.025 pigment{color<1,0,0>} translate<2,0,1> no_shadow}
	*/}
#end

// hud is pretty much done, but may shrink/space individual elements and
// move the whole thing to the bottom of the screen
//#declare hudFont="Andale Mono.ttf"
#declare hudFont="Amelia BT.ttf"
#declare hud=intersection{
	union{
		prism	// lightning bolt
		{
			0,2,7,
			<1,0>,<1.5,3>,<0,3>,<2,7>,<1.5,4>,<3,4>,<1,0>
			scale<.125,1,.125> rotate<-90,0,0>
			translate<5.75,4,1>
		}
		text
		{
			ttf hudFont,
			"3% (00:20)",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<6.25,4.25,-1>
		}
		difference	// thermometer
		{
			union{
				cylinder{<0,0,-1>,<0,0,1>,2}
				cylinder{<0,9,-1>,<0,9,1>,1}
				box{<-1,9,-1>,<1,0,1>}
			}
			union{
				cylinder{<0,9,-2>,<0,9,2>,.5}
				box{<-.5,9,-2>,<.5,6,2>}
			}
			scale<1/9,1/9,1>
			scale<.75,.75,1>
			translate<4,4.05,0>
		}
		text
		{
			ttf hudFont,
			"528 K",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<4.25,4.25,-1>
		}
		union	// clock
		{
			difference
			{
				cylinder{<0,0,-1>,<0,0,1>,4}
				cylinder{<0,0,-2>,<0,0,2>,3.5}
			}
			cylinder{<0,0,-1>,<0,0,1>,.5}
		//	box{<-.25,2.75,-1>,<.25,.75,1>}
		//	box{<-.25,2.25,-1>,<.25,.75,1> rotate<0,0,-45>}
			box{<-.25,2.75,-1>,<.25,.75,1> rotate<0,0,24>}
			box{<-.25,2.25,-1>,<.25,.75,1> rotate<0,0,-88>}
			scale<.125,.125,1>
			translate<0,4.4,0>
		}
		text
		{
			ttf hudFont,
			"Fri July 21, 2169",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<.6,4.5,-1>
		}
		text
		{
			ttf hudFont,
			"02:56:19",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<.6,4,-1>
		}
		union	// globe
		{
			difference
			{
				cylinder{<0,0,-1>,<0,0,1>,4}
				cylinder{<0,0,-2>,<0,0,2>,3.5}
			}
			difference
			{
				cylinder{<0,0,-1>,<0,0,1>,4 scale<2/4,1,1>}
				cylinder{<0,0,-2>,<0,0,2>,3.5 scale<1.5/3.5,1,1>}
			}
			intersection{
				union{
					box{<-4,2.25,-1>,<4,1.75,1>}
					box{<-4,.25,-1>,<4,-.25,1>}
					box{<-4,-2.25,-1>,<4,-1.75,1>}
				}
				cylinder{<0,0,-2>,<0,0,2>,3.75}
			}
			scale<.125,.125,1>
			translate<-6.75,4.4,0>
		}
		text	//gps
		{
			ttf hudFont,
			"18 N 37E",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<-6,4.5,-1>
		}
		text	//gps
		{
			ttf hudFont,
			" +3.8m",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<-6,4,-1>
		}
		union	// compass
		{
			difference
			{
				cylinder{<0,0,-1>,<0,0,1>,4}
				cylinder{<0,0,-2>,<0,0,2>,3.5}
			}
			prism{
				-1,1,5,
				<0,-1>,<1,-2>,<0,2.5>,<-1,-2>,<0,-1>
				rotate<-90,0,0>
				rotate<0,0,45>}
			scale<.125,.125,1>
			translate<-3.25,4.4,0>
		}
		text	// compass heading
		{
			ttf hudFont,
			"315 (NW)",
			2,0 // the extrusion depth, inter-character spacing
			scale <.5,.5,1>
			translate<-2.5,4.25,-1>
		}
	}
	polygon	// to make hud 2-dimensional
	{
		5, // number of points
		<-.5, -.5>, <-.5, .5>, <.5, .5>, <.5, -.5>, <-.5, -.5>
		scale<15.5,1.01,1>
		translate<.5,4.4,0>
	}
	pigment{
		gradient y
		color_map
		{
			[  0  color <0,1,0,.5>]
			[  1.0/3  color <0,1,0,0>]
			[  2.0/3  color <0,1,0,.5>]
			[  5.0/6  color <0,1,0,1>]
			[  1  color <1,.8,0,.5>]
		} // color_map
		scale<1,1/11,1>
	
	//	color<0,1,0>
	}
	finish{ambient 1}
//	scale<2,2,1> translate<-3,0,0>
	translate<-.5,-4.4,0>
}

#declare rockSeed=seed(100);
#declare ptSeed=seed(343);
#declare psxSeed=seed(232);
#declare psySeed=seed(233);
#declare pszSeed=seed(234);
#macro rock()	// rock created by intersection of spheres,boxes,and cylinders
	#local rockPieces=floor(rand(rockSeed)*12)+3;//+8;
	#local i=0;
	intersection{
		#while (i<rockPieces)
			#local pt=floor(rand(ptSeed)*1);
			#local psx=1+rand(psxSeed);
			#local psy=1+rand(psySeed);
			#local psz=1+rand(pszSeed);
			#if (pt=0)
			//	box{<-ps,-ps,-ps>,<ps,ps,ps>
				box{<-1,-1,-1>,<1,1,1>
			#end
			#if (pt=1)
			//	sphere{<0,0,0>,ps
				sphere{<0,0,0>,1
			#end
			#if (pt=2)
			//	cylinder{<0,0,-ps>,<0,0,ps>,ps
				cylinder{<0,0,-1>,<0,0,1>,1
			#end
			scale (<rand(psxSeed),rand(psySeed),rand(pszSeed)>+<.5,.5,.5>)
			rotate <rand(psxSeed)*180,rand(psySeed)*180,rand(pszSeed)*180>
		//	translate <rand(psxSeed)-.5,rand(psySeed)-.5,rand(pszSeed)-.5>
			}
			#local i=i+1;
		#end
		pigment{
			//color<1,.8,.7>
			granite
			color_map
			{
			[  0  color<1,.8,.7>]
			[  2.0/3  color <.5,.3,0>]
			[  1  color <.1,.1,0>]
			} // color_map
			scale .4
		}
	}
#end

//#include 'jupiter_rock2.pov'

#macro randRange(daSeed,least,most)
	((most-least)*rand(daSeed))+least
#end

#macro rock_field(numRocks)
	#local i=0;
	#local scaleSeed=seed(1);
	#local xSeed=seed(23);
	#local ySeed=seed(123);
	#local zSeed=seed(1234);
	union{
		#while (i<numRocks)
			#local finz=randRange(zSeed,-10,3);
			#if (finz<-5)
				#local finx=randRange(xSeed,-5/2*(10+finz)+4,(10+finz)/4+4);
			#else
				#local finx=randRange(xSeed,2*(finz)+1.5,(10+finz)/4+4);
			#end
			#local finy=randRange(ySeed,-.05,.025);
			#local fscale=randRange(scaleSeed,.025,.1);
		//	#render concat(str(finx,4,3)," ",str(finz,4,3),"\n")
		//	object{rock() scale .1 translate<3.5,0,-9.75>}
			object{rock() scale fscale translate<finx,finy,finz>}
			#local i=i+1;
		#end
	}
#end

#macro star_field(numStars)
	#local i=0;
	#local scaleSeed=seed(1);
	#local xSeed=seed(23);
	#local ySeed=seed(123);
	#local zSeed=seed(1234);
	#local cSeed=seed(234);
	union{
	#while (i<numStars)
		#local finz=randRange(zSeed,0,2);
		#local finx=randRange(xSeed,-13,15);
		#local finy=randRange(ySeed,0,11);
		#local fscale=randRange(scaleSeed,.025,.05);
		sphere{<0,0,0>, fscale translate<finx,finy,finz> /*pigment{color<1,1,1>}*/ finish{ambient 1}
			#local fcolor=randRange(cSeed,0,5);
			#if (fcolor<3)
				pigment{color <1,1,1>}
			#else
				#if (fcolor<4)
					pigment{color <1,1,.2>}
				#else
					#if (fcolor<5)
						pigment{color <.2,.2,1>}
					#end
				#end
			#end
		}
		#local i=i+1;
	#end
		translate<0,0,13>
		rotate<0,-degrees(asin(1/sqrt(5))),0>
		translate<4,0,-10>
	}
#end

#macro star_fieldb(numStars)
	box{
		<-13,0,0>,<15,11,2> pigment{color <1,1,1,.5>}
	//	#local finz=randRange(zSeed,0,7);
	//	#local finx=randRange(xSeed,-32,32);
	//	#local finy=randRange(ySeed,0,15);
		
		translate<0,0,13>
		rotate<0,-degrees(asin(1/sqrt(5))),0>
		translate<4,0,-10>
	}
#end

/***********************************************************
************************************************************
************************************************************
***********************************************************/

/**********************
0	final scene
1	Jupiter
2	HUD
3	rocks
4	view angle experiment
5	eruption shaping experiment
**********************/
#declare sceneVer=0;

#if (sceneVer=0)
	// Set a color of the background (sky)
	background { color <0,0,0> }
//	#declare camVer=1;
	#ifndef (camVer)
		#declare camVer=0;	// 0=final pos, 1=high up
	#end
	camera
	{
		#if (camVer=0)
			location <4,.05,-10>
			right <16/9,0,0>
			look_at <-1,2,0>
		#end
		#if (camVer=1)
			location <5,4.05,-12.5>
			right <16/9,0,0>
			look_at <-1,-3,0>
		#end
	//	look_at <2,2,-5>
	}
/*	union{
		eruption(5)//000)
		translate<2,0,1>
	}*/
//	object{ eruption2()	translate<2,0,1>}
	object{ craterGlow scale<3,2,3> translate<2,4,1>}
	Jupiter
	jup_light
	fog{theFog}
	rock_field(150)
	star_field(350)
	other_lights
	volcano
	lava
	#local hscale=.005;
	object{hud scale hscale
		rotate<-degrees(asin(1.95/sqrt(125+1.95*1.95))),-degrees(asin(1/sqrt(5))),0>
		translate<3.978,hscale+.033,-9.95>
		no_shadow}
#end
#if (sceneVer=1)
	background { color <0,0,0> }
	camera
	{
		location  <0.0 , 0.0 ,-5.0>
		right <16/9,0,0>
		look_at   <0.0 , 0.0 , 0.0>
	}

	// Jupiter should be about 3x its diameter from the camera
	//sphere{<0,0,0>, 2 pigment{color<1,1,0>} no_shadow translate <-5.25,5,-7>}
	intersection{
		box{<-2,-2,-2>,<0,2,2>}
		sphere{<0,0,0>, 2 
			pigment{image_map{sys "jupiter texmap.pict"} scale 4 translate<2,2,0>}
			no_shadow //translate <-5.25,5,-7>
		}
	}
	#macro ibc(col1,col2,r)
		col2*r+col1*(1-r)
	#end
	#declare jBrown=<.85,.55,.25>;
	#declare jWhite=<.98,.85,.75>;
	intersection{
		box{<0,-2,-2>,<2,2,2>}
		sphere{<0,0,0>, 2 
			texture{pigment{color jWhite}}
			texture{
				pigment{
				gradient y
				color_map
				{
					[  0  color jBrown]
				//	[ .1 color jWhite]
					[ .15  color jBrown]
					[ .22 color jWhite]
					[ .3 color jWhite]
					[ .4  color jBrown]
					[ .415 color ibc(jBrown,jWhite,.75)]
					[ .45  color ibc(jBrown,jWhite,.25)]
					[ .5 color jWhite]
					[ .6  color jBrown]
					[ .7 color jWhite]
					[ .8  color jBrown]
					[ .9 color jWhite]
					[  1  color jBrown]
				}
				scale<1,4,1> translate<0,-2,0>
			}}
			no_shadow //translate <-5.25,5,-7>
		}
	}
	light_source{
		<0,0,-10> color<1,1,1>
	}
#end
#if (sceneVer=2)
	background { color <0,0,0> }
	camera
	{
		location  <0.0 , 3.0 ,-5.0>
		right <16/9,0,0>
		look_at   <0.0 , 3.0 , 0.0>
	}

//	object{hud scale .1 translate<0,3,-3>}
	object{hud translate<0,3,0>}
/*	Jupiter
	jup_light
	fog{theFog}
	other_lights
	volcano
	lava
*/
	light_source{
		<0,0,-10> color<1,1,1>
	}
#end
#if (sceneVer=3)
	background { color <0,0,0> }
	camera
	{
		location  <0.0 , 0 ,-5.0>
		right <16/9,0,0>
		look_at   <0.0 , 0 , 0.0>
	}
	#local ii=0;
//	object{rock2() translate<0,0,0> rotate<0,360*clock,0> }//normal{bumps .8 scale .2}}
	#while (ii<10)
		object{rock() translate<ii*3-15,0,13> }//normal{bumps .8 scale .2}}
		#local ii=ii+1;
	#end
	light_source{
		<0,0,-10> color<1,1,1>
	}	
#end
#if (sceneVer=4)
	background { color <0,0,0> }
	camera
	{
		location  <0.0 , 0 ,-5.0>
		right <16/9,0,0>
		look_at   <0.0 , 0 , 0.0>
	}
	light_source{
		<0,0,-10> color<0,1,1>
	}
	cylinder {<0,-5,0>,<0,5,0>,.01 pigment{color<1,1,1>} translate<-4.455,0,0>}
	#local ang=degrees(asin(4.455/5));
	#render str(ang,5,4)
	#render "\n"
	#local ang=5*sin(radians(63));
	#render str(ang,5,4)
	// conclusion: horizontal viewing angle 126 (2*63)
#end
#if (sceneVer=5)
	camera{
		location  <0.0 , 4 ,-10.0>
		right <16/9,0,0>
		look_at   <0.0 , 2 , 0.0>
	}
	light_source{
		<-5,0,-10> color<1,1,1>
	}
	light_source{
		<5,0,-10> color<1,1,1>
	}
	difference{
		object{ volcano }
		box{<-10,-2,-20>,<10,10,1> pigment{color<0,0,1>}}
	}
/*	difference{	
		object{ eruption2()	translate<2,0,1>}
		box{<-10,-2,-20>,<10,10,.99> pigment{color<0,1,1>}}
	}
*/
	eruption3()
#end