// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

#include "textures.inc"
#include "rand.inc"
                       
//#include "grass/mgrass/mgrass.pov"

#declare Debug = 0;

#if(Debug)
	#include "half_tree.pov"
#else
	#include "giant_tree.inc"
#end

#include "grass.pov"
#include "house.inc"

#include "windmill.inc"
#include "terrain.pov"
//#include "dolina_top.pov"
#include "road.pov"
  

// 
camera{
	location <45, 2, 5>
	look_at <0, 0, 0>
	right     x*image_width/image_height
	direction 1.5*z

	
	aperture 0.05           // [0...N] larger is narrower depth of field (blurrier)
	blur_samples 100        // number of rays per pixel for sampling
  focal_point <0,0,0>    // point that is in focus <X,Y,Z>
  confidence 0.95       // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/10000         // [0...1] how precise to calculate (smaller is more accurate)
}


/*
//  
camera{
	location <35, -0.8, 2.5>
	look_at <0, 3, 0>
	angle 45.000
}
*/

/*
// 
camera{
	location <3.5, 10, -5>
	look_at <20, 0, 0>
	angle 40.000
}
*/

/*
// 
camera{
	location <27.5, 12, -20>
	look_at <20, 5, 0>
	angle 30.000
}
*/

global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 20


	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}




//  
sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.3  color rgb <0.4, 0.4, 0.5> ]
        [ 1.0  color rgb <0, 0, 0.15> ]
      }
      scale 2
      translate -1
    }
}

// 
sphere {
	<0, 0, 0>, 1
	hollow
	pigment {
		bozo
		color_map {
			[0.00 color rgbt <0, 0, 0, 1>]
			[0.60 color rgbt <0, 0, 0, 1>]
			[0.75 color rgbt <1, 1, 1, .3>]
			[1.00 color rgbt <1, 1, 1, .3>]
		}
		turbulence 0.2
		scale 0.02
	}
	interior {
		ior 1
		media {
		  emission 0//.75
		  scattering {4, <0.0005, 0.00010, 0.00001>}
		  density {
		  	color rgb <1,1,1>
		  }  
		}
	}
	scale 1000
	translate <0, -950, 0>
}


background { color Black }


//   
light_source {
	<0,1000,0> rgb 6
  parallel

  point_at <0, 0, 0>
  rotate <-40, 0, 70>
}

light_source {
	<100, 100, -50> rgb 1
	shadowless
}

sphere {
	<0,0,0> 1
	pigment { color rgbf <1, 1, 1, 1> }
	interior {
		media {
		  scattering {1, .001}
		  density {
		  	spherical
		  	density_map {
		  		[0 rgb <1,.5,0>]
		  		[.1 rgb <1,.5,0>]
		  		[.6 rgb <2,2,0>]
		  	}
		  	turbulence .5
		  	lambda 3
		  }  
		}
	}
	hollow
	no_shadow
	scale 60
	translate <0, 900, 0>
	rotate <-40, 0, 70>
}


//     ()
fog {
	fog_type 2
	distance 50
	color rgb <1, .8, .85>
	fog_offset 4
	fog_alt 2
	turbulence 1	
}
//     ()



//    ()
#declare Points = array[8];
#declare Points[0] = <15.634, 0.000, 1.808>;
#declare Points[1] = <18.840, 0.000, 3.128>;
#declare Points[2] = <21.008, 0.000, 3.128>;
#declare Points[3] = <22.705, 0.000, 2.563>;
#declare Points[4] = <24.780, 0.000, 2.280>;
#declare Points[5] = <26.477, 0.000, 2.751>;
#declare Points[6] = <28.174, 0.000, 2.751>;
#declare Points[7] = <30.343, 0.000, 2.280>;

#declare Radius = array[8];
#declare Radius[0] = 3.5;
#declare Radius[1] = 1.6;
#declare Radius[2] = 1.2;
#declare Radius[3] = 1.2;
#declare Radius[4] = 1.2;
#declare Radius[5] = 1.2;
#declare Radius[6] = 1.2;
#declare Radius[7] = 1.2;

#declare i = 0;

#declare R2 = seed(42);
merge {
#while(i < 7)
	sphere {
		<0, 0, 0> 1
		
		pigment { color rgbt<1, 1, 1, 1> }  
	
		scale <Radius[i], 0.4, Radius[i]>
		translate Points[i]
		hollow
	}
  #declare i = i+1;
#end

	interior {
		media{
	    emission 0.0//75
	    scattering {2, 0.05}
	    density { bozo
	      density_map {
	        [0.0 rgb <0,0,0>]
	        [0.3 rgb <0,0,0>]
	        [0.4 rgb <0.3,0.3,0.3>]
	        [1.0 rgb <0.3,0.3,0.3>]
	      }
	      scale 0.5
	      turbulence 1	      
	    }
	    
		}
	}
} 
//    ()


#declare texTreeTop = texture {
#if(Debug)
	pigment {
		uv_mapping
		color Blue
	}
	
	normal {
		uv_mapping
		bumps 1
		scale 0.1
	}
	
	
/*	
	normal {
		uv_mapping
		gradient x
		slope_map {
			[0.1 <0, 0>]
			[0.15 <4, 1>]
			[0.85 <4, 1>]
			[0.9 <0, 0>]
		}
		turbulence .5
		scale 2
	}
	*/
	
#else
	pigment {
		uv_mapping
		bozo
		color_map {
			[0 rgb <.2, .1, .02>]
			[1 rgb <.3, .15, .04>]
		}
	}
	
	normal {
		uv_mapping
		gradient x
		slope_map {
			[0.1 <0, 0>]
			[0.15 <.5, 1>]
			[0.85 <.5, 1>]
			[0.9 <0, 0>]
		}
		

		turbulence .5
		scale 2
	}
		
	//normal {
		/*
			dents
			normal_map {
				[0.3  bumps scale 2]
	    	[0.3  dents]
	    	[0.6  dents]
	    	[0.9  marble turbulence 1]
			}
			scale 0.03			
			scale y*4
			*/
	//}
#end
}

#declare texTreeBottom = texture {
#if(Debug)
	uv_mapping pigment { color Red }
#else
	pigment {
		bozo
		color_map {
			[0 rgb <.0, .0, .0>]
			[1 rgb <.1, .05, .01>]
		}
	}
	normal {
		uv_mapping
		bumps 1
		scale 0.1
	}
	//normal {
		/*
			dents
			normal_map {
				[0.3  bumps scale 2]
	    	[0.3  dents]
	    	[0.6  dents]
	    	[0.9  marble turbulence 1]
			}
			scale 0.03			
			scale y*4
			*/
	//}
#end
}

#declare texTreeMostBottom = texture {
#if(Debug)
	uv_mapping pigment { color Green }
#else
	pigment {
		bozo
		color_map {
			[0 rgb <0.6, 0.6, 0.2>]
			[1 rgb <0.6, 0.8, 0.2>]
		}
	}
	normal {
		uv_mapping
		bumps 1
		scale 0.05
	}
#end
}



//   ()
object {
		giant_tree
	
		texture {
			gradient y
			texture_map {
				[0.05 texTreeMostBottom]
				[0.07 texTreeBottom]
				[1 texTreeTop]
			}
			turbulence 0.015
			scale <.1, 14, .1>
			translate -1.5
		}
}
//   ()




#declare My_Water =
texture {
    pigment{ rgbf <0.2, 0.2, 0.6, 0.95> }
    normal {
        waves 0.15
        frequency 40
    }
    finish {
        reflection {0.3, 1 fresnel}
        conserve_energy
    }
}

#declare My_Water_Int =
interior {
    ior 1.33
}

#declare My_M_Water = material {
    texture {My_Water}
    interior {My_Water_Int}
}


//  ()
#declare Water = plane {
	y, -1.1
	material {
		My_M_Water
	}
}

object { Water }

//  ()


#declare Potolok = union {
	object { Water }
	object { giant_tree }
}
	

#declare Obj = terrain; 

#declare Norm = <0, 0, 0>; 
#declare PotolokNorm = <0, 0, 0>; 
#declare Start = <0, 0, 0>;

#declare Min = min_extent ( Obj );
#declare Max = max_extent ( Obj );

//  () 
object {
	terrain
	
	pigment {
     bozo
     color_map {
       [0.0, color rgb <0.6, 0.6, 0.2>]
       [0.4, color rgb <0.6, 0.6, 0.2>]
       [0.6, color rgb <0.6, 0.8, 0.2>]
       [1.0, color rgb <0.6, 0.8, 0.2>]
     }
     scale 0.5
	}
	
	normal {
			dents
			normal_map {
				[0.3  bumps scale 2]
	    	[0.3  dents]
	    	[0.6  dents]
	    	[0.9  marble turbulence 1]
			}
			scale 0.1			
   }
}
//  () 


#declare Derevnia = union {
//    ()
//     
#local Windmill_place = <32.5, 0, 4.8>;
#local Inter = trace ( terrain, Windmill_place, -y, Norm ); 
#if (vlength(Norm)!=0)
	object {
		Windmill	
		//translate -y
		scale 0.06
		rotate -y*45
		translate Inter
	}
#end
//    ()

//   ()
//     
#local House_place = array[5];
#local House_angle = array[5];
#local House_place[0] = <32.5, 0, -1.8>;
#local House_place[1] = <28.2, 0, -2.6>;
#local House_place[2] = <33.5, 0, -1.5>;
#local House_place[3] = <33.3, 0, -0.6>;
#local House_place[4] = <32.9, 0, 0.4>;

#local House_angle[0] = 0;
#local House_angle[1] = 45;
#local House_angle[2] = 90;
#local House_angle[3] = 127;
#local House_angle[4] = 30;


#local num_houses = 5;

#while(num_houses > 0)
	#local num_houses = num_houses - 1;
	#local Inter = trace ( terrain, House_place[num_houses], -y, Norm ); 
	#if (vlength(Norm)!=0)
		object {
			MakeHouse(2, 1, 1, 0.2)	
			rotate y*House_angle[num_houses]
			scale 0.25
			translate Inter
		}
	#end
#end
//   ()
}

object {
	Derevnia
}


//    ()
#declare MySpline1=spline {
	quadratic_spline
	0.00	<33.375, -1.052, 1.029>
	0.50	<33.220, -0.733, 2.306>
	1.00	<33.057, -0.972, 3.480>	

}

#declare MySpline2 = spline {
	quadratic_spline
	0.00	<32.241, -1.052, 0.960>
	0.50	<32.150, -0.733, 2.220>
	1.00	<32.055, -0.943, 3.428> 
}

#declare bridge = union {
#declare ctr = 0;
#while (ctr < 1)
  cylinder {
    MySpline1(ctr),MySpline2(ctr),.06
  }
  #declare ctr = ctr + 0.045;
#end

#declare ctr = 0.25;
#while (ctr <= 0.75)
  cylinder {
  	#local pnt = MySpline1(ctr);
    pnt, pnt-y*1,.05
  }
  cylinder {
  	#local pnt = MySpline2(ctr);
    pnt, pnt-y*1,.05
  }
  #declare ctr = ctr + 0.25;
#end

		texture {
	  	pigment { P_WoodGrain2A  color_map { M_Wood2A }}
	  	
	  	normal {
			  wood
			  turbulence 0.04
			  octaves 3
			  scale <0.15, .15, 1>
			  
			  slope_map {
		      [0    <0.5, 1>]   // start in middle and slope up
		      [0.35 <1.0, 0>]   // flat slope at top of wave
		      [0.5  <0.5,-1>]   // slope down at mid point
		      [0.65 <0.0, 0>]   // flat slope at bottom
		      [1    <0.5, 1>]   // finish in middle and slope up
		    }
	  	}
	  	
			finish {
		    specular 0.1
		    roughness 0.001
		    ambient 0.2
		    diffuse 0.6

		    reflection {
		      0.1, 0.3
		      fresnel on
		    }
		    conserve_energy
		  }
	  }
}

object {
	bridge
}
//    ()



//==============================================
// MakeBlade macro
//==============================================
// The MakeBlade macro creates a grass blade with a central fold
// The blade is positionned at posBlade and rotated around the y axis according to segBlade
// Its length is lBlade.
// The blade bends from vector startBend to vector endBend
// The  describes how the curbe bends; low power bend faster
// --------------------------------------
// It first creates an array of points (vertices)
// It then calculates the normals (optional)
// --------------------------------------
/*
#declare Potolok = union {
	object { Water }
	object { giant_tree }
	object { Derevnia }
	object { road_top }
}
*/


#declare R1 = seed(0);

#declare dofile = true;        // true creates a mesh file
#declare fname = "grass_50000.inc";        // true creates a mesh file

/*
#if(dofile=true)          
	#warning concat(fname," mesh file creation starts\n")
	
	#fopen filehandle fname write
	#write(filehandle,"union{\n")
#else
	mesh{
#end

	//    
	#declare doSmooth = false;       // smooth triangles
	#declare posBlade = <0,0,0>;    // position of blade
	#declare rotBlade = 100;        // rotation of blade around y
	#declare segBlade= 1;          // number of blade segments - try low values (5 for instance) for tests
	#declare lBlade = 2/16;           // length of blade
	#declare xBladeStart = 0.1/4;       // width of blade at start
	#declare xBladeEnd = 0.01/4;       // width of blade at the end
	#declare zBladeStart = 0.05/2;     // depth of blade fold at start
	#declare startBend = <0,1,0>;   // bending of blade at start (<0,1,0>=no bending)
	#declare vBend = <0,0,1>;      // force bending the blade (<0,1,1> = 45)
	#declare pwBend = 1;           // bending power (how slowly the curve bends)
	#declare dofold = false;        // true creates a fold in the blade (twice more triangles)
	
	#declare x_angle_min = radians(75);
	#declare x_angle_delta = radians(20);
	#declare z_angle_min = radians(75);
	#declare z_angle_delta = radians(20);
	
	#declare grassMin = min_extent ( grass_top );
	#declare grassMax = max_extent ( grass_top );
	
  #declare i = 0;
  #declare num_blades = 5000;
  #while(i < num_blades)
  	#declare Start = <Min.x + (Max.x - Min.x)*rand(R1), Min.y, Min.z + (Max.z - Min.z)*rand(R1)>;
 
  	#declare Inter= trace ( Obj, Start, y, Norm ); 
  	
	  #if (vlength(Norm)!=0)
		  #declare InterPotolok= trace ( Potolok, Inter, y, PotolokNorm );  
		  #if (vlength(PotolokNorm)=0)
		  	#declare InterGrass= trace ( grass_top, Inter, y, PotolokNorm );  
		  	#if (vlength(PotolokNorm)!=0)
					#declare posBlade = Inter;		  	
					#declare lBlade = InterGrass.y - grassMin.y;
					#declare lBlade = lBlade+lBlade*rand(R1)/3;
					#declare lBlade = lBlade/2;
					
					#local P = 0.2+abs(Rand_Normal(0, 2, R1));

					#if(lBlade < P)					
						#declare rotBlade = 100+45*rand(R1);        // rotation of blade around y
						#declare xBladeStart = lBlade*0.1/2/6.8;       // width of blade at start
						#declare xBladeEnd = lBlade*0.01/2/6.8;       // width of blade at the end
						
			  		#write (filehandle, "cone {<", posBlade.x, ",", posBlade.y, ","posBlade.z, ">,", xBladeStart, ", <", posBlade.x+lBlade*cos(x_angle_min+x_angle_delta*rand(R1)), ",", posBlade.y+lBlade, ","posBlade.z+lBlade*cos(z_angle_min+z_angle_delta*rand(R1)), ">,", xBladeEnd, "}\n")
	       
						#debug concat("Grass: ",str(i/num_blades*100,0,1),"% len=",str(lBlade, 0, 3),"\r")		  	
				  	#declare i = i+1;
				  #end

			  #end
		  #end
		#end
		
	#end


#if(dofile = true)
	#write (filehandle,"pigment {\n	     bozo\n	     color_map {\n	       [0.0, color rgb <0.6, 0.6, 0.2>]\n	       [0.4, color rgb <0.6, 0.6, 0.2>]\n	       [0.6, color rgb <0.6, 0.8, 0.2>]\n	       [1.0, color rgb <0.6, 0.8, 0.2>]\n	     }\n	     scale 0.5\n		}\n	}")
	#fclose filehandle
	#warning concat(fname," file created\n")
	
	#declare grass = #include fname
	object { grass }
#else
		pigment {
	     bozo
	     color_map {
	       [0.0, color rgb <0.6, 0.6, 0.2>]
	       [0.4, color rgb <0.6, 0.6, 0.2>]
	       [0.6, color rgb <0.6, 0.8, 0.2>]
	       [1.0, color rgb <0.6, 0.8, 0.2>]
	     }
	     scale 0.5
		}
	}
#end
*/


#declare grass = #include fname
object { grass }





//  ()
#declare RoadFile="road.inc"
//#declare RoadFile="road_1000.inc"
#declare CreateFile = 0;

#if(CreateFile)
	#fopen filehandle RoadFile write

	#debug "\nCreating road!\n"
	
	#declare Min = min_extent ( road_top );
	#declare Max = max_extent ( road_top );

	#write(filehandle,"union{\n")
		
	#declare i = 0;
	#declare num = 1000;
	#while(i < num)
		#declare Start = <Min.x + (Max.x - Min.x)*rand(R1), Min.y-1, Min.z + (Max.z - Min.z)*rand(R1)>;
	
		#declare Inter= trace ( road_top, Start, y, Norm ); 
		
	  #if (vlength(Norm)!=0)
		  #declare InterGround= trace ( terrain, Inter, -y, Norm );  
		  #if (vlength(Norm)!=0)
		  	#write(filehandle,"	sphere {0, 0.1 scale <1, 0.1, 1> translate ", InterGround, " }\n")
				#declare i = i + 1;
				#debug concat("Road ", str(i/num, 0, 2), "\r")
		  #end
		#end			
	#end

	#write(filehandle,"}\n")
	#debug "\nRoad created!\n"
	
	#fclose filehandle
#end
	
	
object {
	#include RoadFile
	
	pigment {
     granite
     color_map {
       [0.0, color rgb <0.34, 0.23, 0.25>]
       [0.35, color rgb <0.34, 0.23, 0.25>]
       [0.65, color rgb <0.48, 0.37, 0.21>]
       [1.0, color rgb <0.48, 0.37, 0.21>]
     }
     scale 0.2
	}
	
	normal {
			bumps .5
			scale 0.01			
	}
}
//  ()




//  ()
#declare KamishiFile="kamishi_10000.inc"
#declare CreateFile = 0;

#declare minX = 100000;
#declare minZ = 100000;
#declare minY = 100000;
#declare maxX = -100000;
#declare maxZ = -100000;
#declare maxY = -100000;


#if(CreateFile)
	#fopen filehandle KamishiFile write

	#debug "\nCreating kamishi!\n"
	
	#declare Min = min_extent ( terrain );
	#declare Max = max_extent ( terrain );

	#declare Min = <8, Min.y, -22>;
	#declare Max = <38, Max.y, 32>;

	#write(filehandle,"union{\n")
		
	#declare i = 0;
	#declare num = 10000;
	#while(i < num)
		#declare Start = <Min.x + (Max.x - Min.x)*rand(R1), Min.y-1, Min.z + (Max.z - Min.z)*rand(R1)>;
	
		#declare Inter= trace ( terrain, Start, y, Norm ); 
		
	  #if (vlength(Norm)!=0)
		  #declare InterWater= trace ( Water, Inter, y, Norm );  
		  #if (vlength(Norm)!=0)
		  
		  	#declare Deep = (InterWater.y-Inter.y);
		  	#declare Height = Rand_Normal(0.3, 0.1, R1);
		  	#declare Fall = Rand_Normal(0.05, 0.02, R1);
				
				#if(Deep > 0.01)
				#if(Deep < 0.10)	 
					/*
			  	#if(Inter.x < minX)
			  		#declare minX = Inter.x;
			  	#end
			  	#if(Inter.x > maxX)
			  		#declare maxX = Inter.x;
			  	#end
			  	#if(Inter.z < minZ)
			  		#declare minZ = Inter.z;
			  	#end
			  	#if(Inter.z > maxZ)
			  		#declare maxZ = Inter.z;
			  	#end
			  	
			  	#if(Deep < minY)
			  		#declare minY = Deep;
			  	#end
			  	#if(Deep > maxY)
			  		#declare maxY = Deep;
			  	#end
			  	*/
		  	
			  	#write(filehandle,"	cone {0, 0.005, y*", Deep+Height,", 0.00001 translate ", Inter, " texture {TexStebel} }\n")
			  	#write(filehandle,"	cylinder { -y*", Fall,", 0, 0.01 translate ", Inter, " translate y*", Deep+Height-0.005, " texture {TexKamish} }\n")
					#declare i = i + 1;
					#debug concat("Kamishi ", str(i/num, 0, 2), "\r")
				#end
				#end

		  #end
		#end			
	#end

	#write(filehandle,"}\n")
	#debug "\nKamishi created!\n"
	
	#debug concat("minX=", str(minX, 0,1), " maxX=", str(maxX, 0,1), " minZ=", str(minZ, 0,1), " maxZ=", str(maxZ, 0,1), " minY=", str(minY, 0,1), " maxY=", str(maxY, 0,1), "\n")
	
	#fclose filehandle
#end

#declare TexStebel = texture {
	pigment {
		rgb <0.42, 0.80, 0.25>
	}
}

#declare TexKamish = texture {
	pigment {
		rgb <0.50, 0.35, 0.15>
	}
}

	
object {
	#include KamishiFile
}

//  ()


#debug "\a"
