// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
// various (mostly layered) wood textures
// T_Wood1 - T_Wood35
#include "woods.inc"
// a lot of stone textures
// T_Stone1 - T_Stone44
#include "stones.inc"
/*



global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <8.0, 2.5, -8.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.5,  0.0>
}
*/
/*
//          
camera {
  location  <8.0, 20, -26.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 4.5,  0.0>
}
*/
/*
camera {
  location  <16.0, 4, -16.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 6.0,  0.0>
} 
*/
/*
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, 0
  pigment { color rgb <0.6, 0.6, 0.2> }
}
*/

#declare StoneTexture = texture {
	    brick texture{
	    	T_Stone5
	    	normal{bumps 0.5}
	    },
	    texture{
	    	T_Stone12
	    	normal{granite 0.3}
	    }       
	    
	    scale 0.1
}

#declare Windmill = union {
difference {
	union {
		#declare thick = 4;
		#declare minus = .4;

		// 		
		prism {
		    conic_sweep
		    linear_spline
		    .9, // height 1
		    1, // height 2
		    9, // the number of points making up the shape...
		    <thick, thick-minus>,<thick-minus, thick>,
		    <-thick+minus, thick>,<-thick, thick-minus>,
		    <-thick, -thick+minus>,<-thick+minus, -thick>,
		    <thick-minus, -thick>,<thick, -thick+minus>,
		    <thick, thick-minus>
		    rotate <180, 0, 0>
		    translate <0, 1, 0>
		    scale <1, 8, 1>
		    
				texture {
					gradient y
					texture_map {    
						[.2 pigment { color rgb <0.6, 0.6, 0.2> } normal { crackle 0.2 scale 0.4 }]
						[.4 StoneTexture]
					}
				}		    
		}
		
		#declare minus = .8;

		// 		
		prism {
		    conic_sweep
		    linear_spline
		    .5, // height 1
		    .9, // height 2
		    9, // the number of points making up the shape...
		    <thick, thick-minus>,<thick-minus, thick>,
		    <-thick+minus, thick>,<-thick, thick-minus>,
		    <-thick, -thick+minus>,<-thick+minus, -thick>,
		    <thick-minus, -thick>,<thick, -thick+minus>,
		    <thick, thick-minus>
		    rotate <180, 0, 0>
		    translate <0, 1, 0>
		    scale <0.9, 16, 0.9>
		    translate <0, -1, 0>
		    
		texture {
	  	pigment { P_WoodGrain8A  color_map { M_Wood8A }}

	  	rotate y*30
	  	scale 0.4
	  	   
	  	 normal {
		    gradient x       // this is the PATTERN_TYPE
		    slope_map {
		      [0	   <0, 0>]
		      [0.25  <1, 0>]
		      [0.5   <0, 0>]
		      [0.75  <1, 0>]
		      [1		 <0, 0>]
		    }
		    scale 0.5
	  	 }  
	  	 
			finish {
		    specular 0.1
		    roughness 0.001
		    ambient 0.2
		    diffuse 0.6
		   	    
		    conserve_energy
			}

	  }
		    /*
		    texture {
		    	T_Wood1
		    	rotate x*90
		    	scale 0.5
		    }
		    normal {
			    gradient x,10      //this is the PATTERN_TYPE
			    scale 10
			  }*/

         /*
		    normal {
		    	gradient y, 1
		    	
		    	normal_map {
		    		[0 0]
		    		//[0.5 1]
		    		[1 0]
		    	}
		    	
		    }*/
		}
		
		prism {
		    //conic_sweep
		    linear_spline
		    .5, // height 1
		    .9, // height 2
		    9, // the number of points making up the shape...
		    <thick, thick-minus>,<thick-minus, thick>,
		    <-thick+minus, thick>,<-thick, thick-minus>,
		    <-thick, -thick+minus>,<-thick+minus, -thick>,
		    <thick-minus, -thick>,<thick, -thick+minus>,
		    <thick, thick-minus>
		    rotate <180, 0, 0>
		    translate <0, 1, 0>
		    scale <0.6, 9, 0.6>
		    translate <0, 5, 0>
		    
		 texture {
	  	pigment { P_WoodGrain1A  color_map { M_Wood1A }}

	  	rotate y*30
	  	scale 0.4
	  	   
	  	 normal {
		    gradient x       // this is the PATTERN_TYPE
		    slope_map {
		      [0	   <0, 0>]
		      [0.25  <1, 0>]
		      [0.5   <0, 0>]
		      [0.75  <1, 0>]
		      [1		 <0, 0>]
		    }
		    scale 0.75
	  	 }  
	  	 
			finish {
		    specular 0.1
		    roughness 0.001
		    ambient 0.2
		    diffuse 0.6
		   	    
		    conserve_energy
			}

	  }
		}
		
		#declare minus = .2;
		
		prism {
		    conic_sweep
		    linear_spline
		    0, // height 1
		    1, // height 2
		    9, // the number of points making up the shape...
		    <thick, thick-minus>,<thick-minus, thick>,
		    <-thick+minus, thick>,<-thick, thick-minus>,
		    <-thick, -thick+minus>,<-thick+minus, -thick>,
		    <thick-minus, -thick>,<thick, -thick+minus>,
		    <thick, thick-minus>
		    rotate <180, 0, 0>
		    translate <0, 1, 0>
		    scale <0.8, 1, 0.8>
		    translate <0, 9.5, 0>
		    texture {
		    	pigment { color Yellow}
		    	normal { crackle 1 scale 0.3}
		    }
		}
		
		cylinder {
			0, y, 0.5
			pigment { color Red }
			rotate <90, 0, 0>
			scale <1, 1, 4>
			translate <0, 8, -4>
			
			texture {
		 		T_Wood2
		 		scale 0.5
		 	}
		}
		
		
	}


	union {
		box {
			<-0.5, 0, 0>
			<0.5, 2, 3>
		}
		cylinder {
			<0, 2, 0>
			<0, 2, 3>, 0.5
		}
		
		pigment { color Black }
		
		rotate <0, 90, 0>
		translate <0.5, 0.9, 0>
	}
}


#declare len = 15;
#declare width1 = 2;
#declare width2 = 4;
#declare thick = 0.2;
#declare num_pereg = 6;
#declare oslen = 1.5;
#declare osthick = thick;

#declare simbox = box {
		-1, 1
		scale 0.5
		translate <0, 0.5, 0>		
		texture {
	 		T_Wood10
	 		scale 0.1
	 	}
	}

#declare lopast = union {
	union {
		 //  
		 object {
		 	simbox
		 	scale <width1, thick, thick>
		 }
		 //  
		 object {
		 	simbox
		 	scale <width2, thick, thick>
		 	translate <0, len, 0>
		 }

		 //  	
		 object {
		 	simbox
		 	scale <thick, len, thick>
		 }
		 //   		 
		 object {
		 	simbox
		 	scale <thick, sqrt(len*len + (width2-width1)*(width2-width1)), thick>
		 	rotate <0, 0, degrees(atan2((width2-width1)/2, len))>
		 	translate <-width1/2, 0, 0>
		 }
		 object {
		 	simbox
		 	scale <thick, sqrt(len*len + (width2-width1)*(width2-width1)), thick>
		 	rotate <0, 0, -degrees(atan2((width2-width1)/2, len))>
		 	translate <width1/2, 0, 0>
		 }
		 //   		 
		 object {
		 	simbox
		 	scale <thick, sqrt(len*len + (width2-width1)*(width2-width1)), thick>
		 	rotate <0, 0, degrees(atan2((width2-width1)/4, len))>
		 	translate <-width1/4, 0, 0>
		 }
		 object {
		 	simbox
		 	scale <thick, sqrt(len*len + (width2-width1)*(width2-width1)), thick>
		 	rotate <0, 0, -degrees(atan2((width2-width1)/4, len))>
		 	translate <width1/4, 0, 0>
		 }

		// 	
		#declare num_p = num_pereg;	 
		#declare width3 = width1;
		#declare dwidth = (width2-width1)/num_p;
		#declare len_y = 0;
		#declare dlen = len/(num_p+1);
		#while(num_p > 0)
			#declare width3 = width3 + dwidth;
			#declare len_y = len_y + dlen;
			object {
			 	simbox
		 		scale <width3, thick, thick>
		 		translate <0, len_y, 0>
			}
			#declare num_p = num_p-1;
		#end
		
		translate <0, oslen, 0>
	}

	//  
	cylinder {
		<0, 0, 0>
		<0, oslen, 0>, osthick
		//pigment { color Red }
	}
}


#declare num_lopast = 4;
#declare begang = 25;
#declare ang = 0;
#declare gamma = 15;
#declare dang = 360/num_lopast;

#while(ang < 360)
	object {
		lopast
		scale 0.5	
		rotate <0, gamma, begang + ang>
		translate <0, 8, -3.8>
	}
	#declare ang = ang + dang;
#end


}