//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 1 lights, 18 materials and 37 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2002 Lutz + Kretzschmar
// Author Marc Jacquier jacquier.marc@wanadoo.fr www.marcjacquier.fr.st

//  Date : 10/28/2002    (28.10.2002)
//



default {
  texture {
    pigment { rgb <1,0,0> }
  }
}





#declare Main=1;
#declare Area=1;
#declare Rad=1;
#declare Palm_test=0;
#declare Palm=0;
#declare Palm_loin=0; 
#declare Paletuv=0;
#declare Mer=on;
#declare Volcan=on;
#declare Med_ciel=1;
#declare MClouds=1;
#declare S_Clouds=0;

#include "C:\Program Files\3D\POV-Ray for Windows v3.5\include\functions.inc"
#if (Palm=1)
#include "PalmierZup3.inc"
#end
#if (Palm_loin=1)
#include "Cocotier_loin.inc"
#end
#include "ob_feuille.inc"


global_settings {
  adc_bailout 0.1
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 32
  number_of_waves 10
  charset ascii
 #if (Rad=1)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 15                      // higher -> higher quality (1..1600) [35]
    nearest_count 4               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 4             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1.2                 // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/4
   normal on                   // take surface normals into account [off]
   media on                    // take media into account [off]
   }
  #end
}


background { color <0.000,0.000,0.000> }


#if(Palm_test=1)
camera {  //  Camera Camera01
location  <    0,     0,      220> //aerienne
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right    x*image_width/image_height
  angle         54.40000    // Vertical      27.200
  look_at   0
}
#else
camera {  //  Camera Camera01
location  <    -58,     -26.5,       0.5>//bien placee
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    2.0,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      27.200
  look_at   <     71,      28,      20.>
}
#end
//
// *******  L I G H T S *******
//




light_source {
  0*x                 // light's position (translated below)
  color rgb <1,.5,.2>*7//6      // light's color
 #if(Area=1)
  area_light
  <0.07, 0, 0> <0, 0, 0.07> // lights spread out across this distance (x * z)
  3, 3               // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient
 #end
  translate z*20
  scale 10000.0
  rotate <0,80,-20> 
  
  media_attenuation on               
}
 
#if (Rad=0)
light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <0.90 0.9, 1.000>*0.8
  translate  <-50.0, -20.0, 20.0> 
  scale 1000.0
  shadowless
}
#end
//
// ********  MATERIALS  *******
//

#include "mjatlltx.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Plan_nuages = object {
  plane { // Plan_nuages
    z,0
    #if(Med_ciel=1)
    hollow
    #end
    translate  <0.0, -2.463018, 34.482258>
  }
}






//
// ********  OBJECTS  *******
//
#if(MClouds=1)

cylinder { // Nuage_Container
  <0,0,1>, <0,0,0>, 1 
  rotate <-0.0, -0.0, -0.0>
  translate  <0.001519, 0.001855, -0.537965>
  material {
    Mat_nuage_media
   // Med_cloud2
  }
  hollow
  scale <4000, 4000, 450>
  translate  <3500, 2000, 1000>
}

#end

#if (Mer=on)
// Iso_Mer_2
// Fullmoon plugin for Moray, 'Isosurface' version 1 beta by S. Shonfield, morayplugin@yahoo.ca
#declare Echx=1 ;
#declare Echy=1 ;
#declare Damp=0.8 ;
#declare Lacu=1.3 ;
#declare Octav=6 ;
#declare Offst=1.2 ;
#declare Gain=2 ;
#declare Haut_Vag=0.008 ;

isosurface {
   function {
      z +1-f_ridged_mf(x/Echx, y/Echy, 0,Damp,Lacu,Octav,Offst,Gain,1)*Haut_Vag
   }
   contained_by {box{<-1000,-1000,-40>,<1000,1000,1>}}
   threshold 0
   accuracy 0.005 //0.001

   max_gradient 0.775
   max_trace 1
hollow


material { M_Iso_Mer }


translate <0,0,0.7>


} 

#end


#declare Atoll = object { 
  height_field {
    tga "terrain_atollHR.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  translate  -0.98*z
  scale <50.0, 37.59375, 5.0>*3
  rotate <0.5, -0.1, 23.048643>
  translate  1.2*z
 //scale 3.0
}
union { // Solide
  plane { // Fond
    z,0
    translate  -9.6*z
  }
  object { Atoll }
  material {
    Mat_Atoll
    scale <10.0, 10.0, 12.821134>
    translate <0.000000, 0.000000, 1.222690>
  }
}


sphere { // Ciel
  <0,0,0>,1
  translate  -1.0*z
  material {
    Mat_ciel
  }
  no_shadow
  double_illuminate
  hollow
  photons {
    pass_through
  }
  scale 50000.0
  translate  8000.0*z
}


#declare HF_sable = object { 
  height_field {
    tga "terrain_volcan.tga"
    water_level 0.0546
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    M_sable
    scale <0.999139, 1.0, 1.688606>
    translate <0.029266, 0.000000, -0.964048>
  }
  scale <4.5, 4.5, 0.05>
  translate  <0.0, 0.022249, 0.022295>
}
#declare IsoVolcan = object {
// Fullmoon plugin for Moray, 'Isosurface' version 1 beta by S. Shonfield, morayplugin@yahoo.ca
#declare PigMap = pigment {image_map {tga "terrain_volcan_ISO.tga" once interpolate 2}scale 2.1 rotate x*0 translate <-1,-1,-1>} ;
//#declare Plan_Z = function {x*0 + y*0 + z*1} ;
#declare Fun1 = function {pigment {PigMap}} ;
#declare Accid= function {pigment   {wrinkles scale <1,1,4>*0.2}} ;
#declare fn_X = function{Fun1(x/2,y/2,z).gray*0.45-Accid(x,y,z).gray*0.15}  ;
isosurface {
   function {
     // Plan_Z(x,y,z)-fn_X(x,y,z)*1.5  
      z-fn_X(x,y,z)*2
   }
   contained_by {box{<-0.8,-0.8,-0.1>,<0.8,0.8,0.7>}}
   threshold 0
   accuracy 0.001
   max_gradient 5.4
   max_trace 1


material { M_Iso_Volcan }
scale <1,0.9925986528396606,1>
rotate <0,0,0>
translate <0.1628299319727891,-0.0444081632653061,0.127843746087392>
} // end isosurface
}
#declare IsoForet = object {
// Fullmoon plugin for Moray, 'Isosurface' version 1 beta by S. Shonfield, morayplugin@yahoo.ca
#declare Accid2= function {pigment   {granite scale 0.05}} ;
#declare fn_Arbres= function{-(Accid2(x,y,z).gray*0.05+Fun1(x/4,y/4,z).gray*0.35)} ;
isosurface {
   function {
      0.2+z+fn_Arbres(x,y,z)*1.5
   }
   contained_by {box{<-1.2,-1.2,-0.1>,<1.2,1.2,0.8>}}
   threshold 0
   accuracy 0.001
   max_gradient 5.4
   max_trace 1


material { M_ISO_foret }
scale <1,1,1>
rotate <0,0,0>
translate <-3.469446951953614e-018,0,-1.734723475976807e-018>
} // end isosurface
}
#declare GP_iso = union {
  object { IsoVolcan }
  object { IsoForet }
}

#if (Volcan=on)
union { // Gp_Volcan
  object { HF_sable }
  object { GP_iso }
  scale 400.0*1.5
  translate  <2186.018771, 1747.904268, -5>*1.5
  scale 3
}
#end


#if(Palm=1)
       
        #declare Dep=<-54,-28,-0.3>;
        #declare Arr=<-50,-21,0.3>;
        #if(Palm_test=1)
          cone{<    -60.026,     -26.454,       0.5> 0 <     71.185,      27.951,      13.000> 10 pigment{color rgbt <0,1,0,0>}}
        box {Dep, Arr pigment{color rgbt <1,0,0,0.5>}} 
        #else
        #declare Pente=<0,0,0>;
        #declare Pos=<0,0,0>;
        #declare Dens=2; //3
        #declare Step_x=(Arr.x-Dep.x)/Dens;
        #declare Step_y=(Arr.y-Dep.y)/Dens;
        #declare Dir=-z;
        #declare S11=seed(154); 
        #declare S_Trace=seed(1613);
        #declare I=Dep.x;
        #declare J=Dep.y;
        #while (J<Arr.y)

                #while (I<Arr.x)
                #declare Pos=trace(Atoll,<I+(rand(S_Trace)*Step_x),J+(rand(S_Trace)*Step_y),100>,Dir,Pente);
        
                        #if( vlength (Pente)!=0)
                                #if(Pos.z>-0.3)
                              
                                Palm_tree(Pos,(1-0.4*rand(S11))*0.6,z*360*rand(S11) ) 
                              
                                #end
                        #end
                        #declare I=I+Step_x;
                #end
                #declare I=Dep.x;
                #declare J=J+Step_y;
       
        #end  
        #end
object{Palme scale <0.8,1,0.6>*.8 rotate <-130,35,-90> translate <-52,-25,.2>}
#end

#if(Palm_loin=1)

       
        #declare Dep2=<-5,-40,-0.3>;
        #declare Arr2=<90,60,-0.3>;
        #if(Palm_test=1)
      
       box {Dep2, Arr2 pigment{color rgbt <1,0,0,0.5>}} 
      #else
        #declare Pente=<0,0,0>;
        #declare Pos=<0,0,0>;
        #declare Dens=120;
        #declare Step_x=(Arr2.x-Dep2.x)/Dens;
        #declare Step_y=(Arr2.y-Dep2.y)/Dens;
        #declare Dir=-z;
        #declare S1=seed(154); 
        #declare S2=seed(3213);
        #declare S3=seed(225);
        #declare I=Dep2.x;
        #declare J=Dep2.y;
        #while (J<Arr2.y)

                #while (I<Arr2.x)
                #declare Pos=trace(Atoll,<I+(rand(S2)*Step_x),J+(rand(S3)*Step_y),100>,Dir,Pente);
        
                        #if( vlength (Pente)!=0)
                                #if(Pos.z>-0.3)
                              
                               
                                object{Palmier_loin rotate z*360*rand(S1)  scale (1-0.5*rand(S1))*0.4 translate Pos}
                               
                                #end
                        #end
                        #declare I=I+Step_x;
                #end
                #declare I=Dep2.x;
                #declare J=J+Step_y;
       
        #end
       #end
#end

#if(Paletuv=1)
#declare pat_palet=pigment {bozo color_map {[0,color rgb 0][1,color rgb 1]}turbulence 0.5}
#declare Distrib=function{pigment{pat_palet}}

       
        #declare Dep3=<-54,-28,-0.3>;
        #declare Arr3=<-50,-21,0.3>;
       
       
        #declare Pente=<0,0,0>;
        #declare Pos=<0,0,0>;
        #declare Dens=80;
        #declare Step_x=(Arr3.x-Dep3.x)/Dens;
        #declare Step_y=(Arr3.y-Dep3.y)/Dens;
        #declare Dir=-z;
        #declare S11=seed(100); 
        #declare S12=seed(154); 
        #declare S_Trace=seed(1613);
       
        #declare I3=Dep3.x;
        #declare J3=Dep3.y;
        #while (J3<Arr3.y)

                #while (I3<Arr3.x)
                #declare Pos3=trace(Atoll,<I3+(rand(S_Trace)*Step_x),J3+(rand(S_Trace)*Step_y),100>,Dir,Pente);
                        #declare Force_pal=Distrib(Pos3.x,Pos3.y,Pos3.z).gray;
                        #if( vlength (Pente)!=0)
                                #if(Pos3.z>-0.2)
                               #if ( Force_pal>.3)
                               
                               
                              object{Feuille rotate <0,40*(Force_pal*.5+rand(S11)*0.5),360*rand(S11)>  scale (Force_pal-0.4)*0.2 translate Pos3-0.01}
                              
                                #end
                                #end
                        #end
                        #declare I3=I3+Step_x;
                #end
                #declare I3=Dep3.x;
                #declare J3=J3+Step_y;
       
        #end  
        
#end

