/*
 * willow.ini - Maurizio Tomasi 2002 (zio_tom78@hotmail.com)
 *              Visit my website at http://www.geocities.com/zio_tom78
 *
 * Textures to be used with the trees
 */


///////////////////////////////////////////////////////////////////
// tree texture with a image_map
///////////////////////////////////////////////////////////////////

#declare txtWillowTree =
  texture {
    pigment {
      image_map {
	jpeg "bark.jpg"
	map_type 2
	interpolate 2
      }
    }

    normal {
      bump_map {
	// These normals were created using the "Emboss" filter
	// with The GIMP.
	jpeg "bark-normals.jpg"
	bump_size 2.0
      }
    }

    finish { ambient 0 }
    
    scale <1.0, 3.0, 1.0>
  }

#declare colLeaf_1 =
  rgb <0.7,1,0.2> * 0.3;
#declare colLeaf_2 =
  rgb <1,0.7,0.2> * 0.3;
#declare txtWillowLeaf1 =
  texture {
    pigment {
      agate color_map {
	[0.0 color colLeaf_1]
	[0.3 color colLeaf_2]
	[0.7 color colLeaf_2]
	[1.0 color colLeaf_1] 
      }
    }       
    finish {
      ambient 0.1
      roughness 0.01
    }
    
    scale 10
  }


#declare colLeaf_1 =
  rgb <0.7,1,0.2> * 0.2;
#declare colLeaf_2 =
  rgb <1,0.7,0.2> * 0.2;
#declare txtWillowLeaf2 =
  texture {
    pigment {
      agate color_map {
	[0.0 color colLeaf_1]
	[0.3 color colLeaf_2]
	[0.7 color colLeaf_2]
	[1.0 color colLeaf_1] 
      }
    }       
    finish {
      ambient 0.1
      roughness 0.01
    }
    
    scale 10
  }

#declare colLeaf_1 =
  rgb <0.18, 0.35, 0.12> * 0.4;
#declare colLeaf_2 =
  rgb <0.71,0.75,0.23> * 0.4;
#declare txtWillowLeaf3 =
  texture {
    pigment {
      agate color_map {
	[0.0 color colLeaf_1]
	[0.4 color colLeaf_2]
	[0.5 color colLeaf_2]
	[1.0 color colLeaf_1] 
      }
    }       
    finish {
      ambient 0.1
      roughness 0.01
    }
    
    scale 4
  }


//////////////////////////////////////////////////////////////////////


#declare txtLeaf = txtWillowLeaf1;
#declare txtTree = txtWillowTree;

#declare Leaf=
  #include "gtleaf1.inc"

#declare Foliage =
  #include "gtfoliage1.inc"

#declare Tree =
  #include "gttree1.inc"

#declare Willow1 =
  union {
    object {
      Foliage
      
      texture { txtLeaf }
    }
    
    object {
      Tree
    }
    
    // Update the following lines after any change in the tree structure!
  
    #local MinPoint = <-31.857,-6.578,-35.153>;
    #local MaxPoint = <36.836,60.534,37.899>;
    bounded_by {
      box { MinPoint, MaxPoint }
    }
    
    #local Size = MaxPoint - MinPoint;
    #local NewPos = -MinPoint - Size/2;
    translate <NewPos.x, -MinPoint.y, NewPos.z>
  }


//////////////////////////////////////////////////////////////////////


#declare txtLeaf = txtWillowLeaf2;
#declare txtTree = txtWillowTree;

#declare Leaf=
  #include "gtleaf2.inc"

#declare Foliage =
  #include "gtfoliage2.inc"

#declare Tree =
  #include "gttree2.inc"

#declare Willow2 =
  union {
    object {
      Foliage
      
      texture { txtLeaf }
    }
    
    object {
      Tree
    }
    
    // Update the following lines after any change in the tree structure!
  
    #local MinPoint = <-41.136,-6.836,-28.686>;
    #local MaxPoint = <30.827,53.825,44.794>;
    bounded_by {
      box { MinPoint, MaxPoint }
    }
    
    #local Size = MaxPoint - MinPoint;
    #local NewPos = -MinPoint - Size/2;
    translate <NewPos.x, -MinPoint.y, NewPos.z>
  }


//////////////////////////////////////////////////////////////////////


#declare txtLeaf = txtWillowLeaf3;
#declare txtTree = txtWillowTree;

#declare Leaf=
  #include "gtleaf3.inc"

#declare Foliage =
  #include "gtfoliage3.inc"

#declare Tree =
  #include "gttree3.inc"

#declare Willow3 =
  union {
    object {
      Foliage
      
      texture { txtLeaf }
    }
    
    object {
      Tree
    }
    
    // Update the following lines after any change in the tree structure!
  
    #local MinPoint = <-35.809,-5.077,-30.665>;
    #local MaxPoint = <32.002,83.834,46.491>;
    bounded_by {
      box { MinPoint, MaxPoint }
    }
    
    #local Size = MaxPoint - MinPoint;
    #local NewPos = -MinPoint - Size/2;
    translate <NewPos.x, -MinPoint.y, NewPos.z>
  }


