// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#declare Garbagecan=
union
{

  difference
  {
    cylinder
    {
      <0,0,0>,<0,4,0>, 1.5
      texture{ GCanTexture }
    }
    cone
    {
      <0,4.01,0>,1.25
      <0,3.85,0>,.5
    }
    cylinder
    {
      <0,4,0>,<0,3,0>,.5
      texture{ GCanTexture }
    }
    cylinder
    {
      <0,0,0>,<0,3.7,0>,.501
      pigment{ Black }
    }
    texture{ GCanTexture }
  }

  #local slats = 30;
  #local curSlat = 0;
  #local slatRandom = seed(3423);
    union
    {
    #while ( curSlat < slats )
      union
      {
        box
        {
          <-.125,4,-.1>,<.1,0,.1>
        }
        sphere
        {
          0,.065
          scale<1,1,.5>
          translate<0,3.4,.1>
          texture{ T_Chrome_1A finish{ roughness .8 } }
        }
        sphere
        {
          0,.065
          scale<1,1,.5>
          translate<0,2,.1>
          texture{ T_Chrome_1A finish{ roughness .8 } }
        }
        texture
        { 
          GCanTextureSlats
          translate<rand(.1*slatRandom),0,rand(.1*slatRandom)> 
        }
        translate <0,0,1.7>
        rotate y*((360/slats)*curSlat)
      }
      #local curSlat = curSlat + 1;
    #end
    }
  difference
  {
    cylinder
    {
      <0,3.3,0>,<0,3.5,0>, 1.6
    }
    cylinder
    {
      <0,0,0>,<0,4,0>, 1.55
    }
    texture{ rail_steel }
  }
  difference
  {
    cylinder
    {
      <0,1.9,0>,<0,2.1,0>, 1.6
    }
    cylinder
    {
      <0,0,0>,<0,4,0>, 1.55
    }
    texture{ rail_steel }
  }
  difference
  {
    cylinder
    {
      <0,.7,0>,<0,.5,0>, 1.6
    }
    cylinder
    {
      <0,0,0>,<0,4,0>, 1.55
    }
    texture{ rail_steel }
  }
}

