//Bathroom scene for December 2002 IRTC
  // PoVRay 3.5 Scene File " Bathrm1.pov"
// created by   Chris Holtorf  
// Date:   12/22/02
//--------------------------------------------------------------------------
#version 3.5;
global_settings {  assumed_gamma 1.0 ambient_light rgb<.1,.1,0> }
//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"

#include "People2\People2a.inc" 
#include "Shower Stall\Towel holder.inc"
#include "Shower Stall\Door Handle2.inc"
#include "Shower Stall\Drain plate.inc"
#include "Wallpaper\Border.inc"
#include "Shower Stall\WPBase.inc"
#include "Shower Stall\Towel 1.inc"
#include "Shower Stall\Towel2.inc"
#include "Shower Stall\Towel4.inc"
#include "Tub\Tub1.inc"
#include "Tub\Tiles.inc"
#include "Tub\Wood grate.inc"
#include "Shower Stall\Plumbing.inc"
#include "Shower Stall\Brackets.inc"
#include "Tub\Tub Rack.inc"
#include "Posters\Marina.inc"
#include "Parts\Parts.inc"
#include "Parts\Lights.inc"
#include "Parts\Table.inc" 
#include "Parts\Bowl.inc"
#include "Tree\Bonsai.inc" //for bonsai tree
#include "Parts\WallGrates.inc"
#include "Clothes\Sandal Left.inc"
#include "Clothes\Sandal Right.inc"
#include "Parts\TowelWarmer.inc"
 

//Radiosity settings
 global_settings { assumed_gamma 1.0 ambient_light rgb<.1,.1,0> 
   max_trace_level 10 
  
   radiosity {
              pretrace_start 0.08           
              pretrace_end   0.01           
              count 500                     
              nearest_count 8               
              error_bound 0.8              
              recursion_limit 3             
              low_error_factor .5           
              gray_threshold 0.0            
              minimum_reuse 0.015           
              brightness 1                   
              adc_bailout 0.01/2
             }
 } 
                                    
//Lights
object {Lights}

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera { 
         location  <105.0 , 64.0 ,-35.0>
         right     x*image_width/image_height
         look_at   <44.0 , 34.0 , 53.0>
        }

//A Colored Background
background { color rgb<0,0,0>  }
//---------------------------Textures---------------------------------------
//Glass Texture
#declare Glass = material  
   { texture { pigment { color rgbf <1.0, 1.0, 1.0, 0.7> }      
         finish { ambient 0.0 diffuse 0.0 specular 1.0 roughness 0.001 reflection 0.1 } }   
      interior { ior 1.5 }
   }

//--------------------------------------------------------------------------
//------------------------- scene objects ---------------------------------- 
//-------------------------------------------------------------------------- 

//Walls
//Left wall
box { <0,72,-24> <-1,92,108> texture {pigment {Wheat } normal { bumps 0.2 scale 0.1 }}}
box { <0,0,-24> <-1,72,30> texture {pigment {Wheat } normal { bumps 0.2 scale 0.1 }}}
//Center wall
box { <0,72,108> <120,92,109> texture {pigment {Wheat } normal { bumps 0.2 scale 0.1 }}}
//Right Wall
box { <120,0,108> <121,92,108> texture {pigment {Wheat } normal { bumps 0.2 scale 0.1 }}}
//Rear wall
difference {
        box { <0,0,-1> <120,92,0> texture {pigment {Wheat } normal { bumps 0.2 scale 0.1 }}}
        box { <-14,0,-4> <14,71,4> pigment {Wheat} translate<80,0,-40> }
         translate<0,0,-40>
         }

//Ceiling
box { <0,92,-24> <120,93,108> pigment {White}  }

//Floor grout
box { <-5,-.2,-24> <125,-.5,113> pigment {DustyRose} }
//Left wall grout grout
box { <-.1,0,30.1> <-1,72,108> pigment {White} }
//Center wall grout grout
box { <0,0,108.1> <120,72,108.5> pigment {White} }

//Raised platform Grout
box { <0,0,72.1> <36,35.9,108> pigment {HuntersGreen} }
box { <36,0,72.1> <42,23.9,108> pigment {HuntersGreen} }                

//Tub Grout
#declare Tub_Grout = difference {
                 box { <42.1,0,72> <114,23.9,108> }
                 box { <46,2,76> <118,25,104> } 
                   }
   object { Tub_Grout pigment {HuntersGreen} } 
 
//Tub
object { Tub rotate<0,0,0> translate<82,24,88.5> }

//Tub rack
object {Tubrack texture { T_Brass_3C } translate <36,24.2,87.5>}
object {Tubrack texture { T_Brass_3C } scale<1,1,-1> translate <36,24.2,87.5>}

//Shower drain plate
object { Drain_plate translate<18,1,54> texture { T_Brass_3C }}

//Plumbing
object {Plumbing}

//Person
object{ People2a rotate<0,-90,0> translate<44,1,52> }
 
//Glass Panels
box { <0.6,6.1,36> <36,71,36.5> material {Glass} }
box { <35.5,6.1,36.5> <36,71,40.5> material {Glass } }
box { <35.5,6.1,67.5> <36,71,72> material {Glass} }     
box { <0.6,6.1,71.5> <36,71,72> material {Glass} }
 
//Door
#declare Door =
union {
        box { <0,0,0> <-.5,65,27> material {Glass } }  //door glass
        object { Towel_Holder texture { T_Brass_3C } translate <0,-6,0>}
        object { Upr_Pad pigment { Black } translate <0,-6,0>}
        object { Lwr_Pad pigment { Black } translate <0,-6,0>}
        object { Handle texture { T_Brass_3C } translate <0,-6,0>}
        object { Towel1 pigment { rgb <0.6, .1, 0.6>*0.5 } translate <0,-6,0>}
        object {Stops texture { T_Brass_3C } translate<0,62,27>}              
        object {Stops texture { T_Brass_3C } translate<0,3.5,27>}
        rotate<0,85,0> translate<36,6,40.5> 
        }
object { Door } 

//Brackets
object {Brackets texture { T_Brass_3C }}

//Floor towel
object { Towel2 pigment { Tan } translate <36.5,1,71.5>}

//Tile
object {Tile}  

//Wallpaper border
#declare LBorder =
union{
 #declare Nr = 0;     
 #declare EndNr = 5; 
 #while (Nr< EndNr) 

   object{Pattern translate<.1,87,Nr*24-12>} 

 #declare Nr = Nr + 1;  
 #end   
 }
object { LBorder }

#declare CBorder =
union{
 #declare Nr = 0;     
 #declare EndNr = 6; 
 #while (Nr< EndNr) 

   object{Pattern rotate<0,-90,0> translate<Nr*24-12,87,107.9>} 

 #declare Nr = Nr + 1;  
 #end   
 }
object { CBorder }

//Marina picture
object {Poster1 translate<0.1,48,5>}

//Shampoo
object {Shampoo rotate<0,20,0> translate<19,6,39>}

//Lotion Bottle
object {Lotion rotate<0,-12,0> translate<28,6,38>}

//Jar
object {Jar rotate<0,-12,0> translate<4.5,6,40>}

//Razor
object {Razor rotate<0,80,0> translate<33,6,40>}

//Table
object {Table rotate<0,0,0> translate<9,0,12>} 

//Bowl
object {Bowl texture { T_Stone18 scale<1,1,1>} translate<9,32.125,12>}

//Bonsai tree
object {Bonsai scale<0.22,0.22,0.22> translate<9,36,12>}   //Bonsai tree
                       
//Wood grate 
object { Grate translate<0,36,72> }

//Wall Grate
object {Wall_Grate texture { T_Brass_3B } normal { bumps -0.5 scale <0.001, 0.001, 1> }
              scale<0.8,0.8,0.8> translate<0,12,12>  
              } 

//Sandals
object {Sandal_right rotate<0,-12,0> translate<73,0,63>} 
object {Sandal_left rotate<0,5,0> translate<70,0,61>}

//Towel warmer
object {Warmer rotate<-90,0,0> translate<72,58,104> texture { T_Brass_3B }}
object { Towel4 pigment { rgb <0.6, .1, 0.6>*0.5 } rotate<0,-90,0> translate <85.5,8,100>}

