// snowwar.pov

// Copyright 2002 James Edward Gray II
// and Christina Nordloh

#include "colors.inc"
#include "metals.inc"
#include "skies.inc"
#include "glass.inc"
#include "woods.inc"

global_settings { max_trace_level 10 }

camera {
	location <0, 10, -25>
	look_at <0,5,6>
	rotate y*40
}
light_source {
	<0, 990, 0>, color Plum
	area_light
	x * 5, y * 5, 5, 5
	adaptive 1 jitter
	circular orient
	rotate z*75
}
light_source {
	<-150, 115, -113>, color White
	shadowless
}
light_source {
	<150, 115, -113>, color White
	shadowless
}
// nifty sky
sky_sphere { S_Cloud1 }
// ground with hill
union {
	difference {
		plane { y, 0 }
		cylinder {
			0, <-10, 0, 0>, .75
			scale <1, .5, 1>
			rotate y * -15
			translate <-6, 0, 8>
		}
		cylinder {
			0, <-10, 0, 0>, .75
			scale <1, .5, 1>
			translate <-12, 0, 12>
		}
		sphere {
			0, 1
			scale <1, .5, 1>
			translate <-10, 0, -3.5>
		}
		cylinder {
			0, <15, 0, 0>, .75
			scale <1, .5, 1>
			rotate y * -30
			translate <.5, 0, 6.5>
		}
		box { <-.5, .5, 50>, <-3, -2, -50> }
		sphere {
			<-4, -1.5, 49.5>, 4.2
			scale <.45, 1, 1 >
		}
		sphere {
			0, 350
			scale <1, .1, 1>
			translate <0, 20, 350>
			rotate y*75
			pigment { color White }
			finish { ambient .3 }
		}
	}
	difference {
		sphere {
			<8, 0, -2>, 6
			pigment { color White }
			normal { bumps .1 }
			finish { diffuse .5 }
		}
		difference {
			torus {
				6 .75
				rotate x * 90
			}
			box { <-1.3, 0, -10>, <1.3, 10, 10> }
			rotate y * 90
			translate <7, 0, -2>
		}
		scale <2, .6, 2>
		translate x*3
		translate y*-.5
	}
	plane {
		y, -2
		pigment { color White }
		normal { bumps .1 }
		finish { reflection { .1 } }
	}
	pigment { color White }
	normal { bumps .3 scale 10 }
}
// mountains
union {
	difference {
		cone {
			<400,0,1000>, 150,
			<400, 100, 1000>, 10
		}
		sphere { <310, 30, 1000>, 80 }
	}
	cone {
		0, 200, <0, 200, 0>, 20
		scale <.66, 1, 1.5>
		translate <1000, 0, 1000>
	}
	cone {<370, 0, 880>, 60, <370, 58, 880>, 10 }
	cone {
		0, 150, <0, 121, 0>, 8
		translate <620, 0, 1000>
	}
	cone {
		0, 300, <0, 300, 0>, 40
		scale <1, 1.5, 1.5>
		translate <1800, 0, 1000>
	}
	cone {
		0, 50, <0, 50, 0>, 7
		translate <200, 0, 1000>
	}
	cone {
		0, 50, <0, 30, 0>, 5
		translate <230, 0, 1000>
	}
	cone {
		0, 170, <0, 200, 0>, 8
		translate <1100, 0, 850>
	}
	cone {
		0, 170, <0, 180, 0>, 10
		translate <940, 0, 1000>
	}
	cone {
		0, 170, <0, 150, 0>, 10
		translate <850, 0, 1000>
	}
	cylinder {
		0, <0, 140, 0>, 50
		translate <820, 0, 1000>
	}
	cone {
		0, 90, <0, 100, 0>, 15
		translate <675, 0, 1000>
	}
	cone {
		0, 200, <0, 350, 0>, 50
		translate <1695, 0, 1100>
	}
	cone {
		0, 300, <0, 400, 0>, 26
		translate <1800, 0, 900>
	}
	cylinder {
		0, <0, 80, 0>, 30
		translate <450, 0, 1000>
	}
	cone {
		0, 50, <0, 80, 0>, 4
		translate <460, 0, 970>
	}
	cone {
		0, 300, <0, 400, 0>, 40
		translate <2100, 0, 700>
	}
	cylinder {
		0, <0, 300, 0>, 80
		translate <2000, 0, 800>
	}
	texture {
		pigment {
			agate
			color_map {
			    [0.0 rgb 0]
    			[0.5 rgb <0.8, 0.6, 0.5>]
    			[0.6 rgb <0.8, 0.6, 0.3>]
   				[1.0 rgb <0.6, 0.3, 0.1>]
			}
			scale 50
		}
		normal { agate 10 scale 125 }
		finish { diffuse .5 }
	}
	texture {
		pigment {
			gradient y
			color_map {
				[0 color Clear]
				[.2 color Clear]
				[.6 color White]
			}
			scale 450
		}
		normal { bumps .3 scale 50 }
		finish { diffuse .4 }
	}
	texture {
		pigment {
			bozo
			color_map {
				[0 color Clear]
				[.6 color Clear]
				[.7 color White]
				[.9 color White]
			}
			frequency 1.3
			scale 50
		}
		normal { bumps .3 scale 20 }
		finish { diffuse .4 }
	}
}
// Round Fort, Tina's Best Guess
union {
	difference {
		sphere { <-10, 0, -3>, 5 }
		cylinder {
			<-10.8, -5, -3>, <-10.8, 5, -3>, 4
		}
	}
	union {
		cylinder { 0, <0, 2.5, 0> .1 }
		difference {
			box {
				<0, 1.5, -.05>, <1.5, 2.4, .05>
				pigment { color ForestGreen }
				normal {
					gradient x
					slope_map {
						[0, <0, 1>]
						[.5, <1, 1>]
						[1, <0, 1>]
					}
					rotate z * -25
				}
			}
			box {
				<0, 0, -.06>, <1, .9, .06>
				rotate z * -45
				translate <1, 1.95, 0>
			}
		}
		rotate y * 30
		translate <-5.7, 2.5, 0>
	}
	scale <1, .75, 1>
	pigment {
		radial
		color_map{
			[0.5 White]
			[0.3 Gray95]
		}
		frequency 100
		rotate x*-90
	}
	normal { bumps .3 scale .04 }
}
// round snowfort sword #1
cone {
	0, .15
	<1, 2.5, 0> .01
	translate <-7.8, 0, -2>
	pigment { Col_Glass_Bluish }
	finish { F_Glass5 ambient .9 }
	interior { I_Glass1 }
}
// round snowfort sword #2
cone {
	0, .15
	<1, 2.5, 0> .01
	translate <-7.8, 0, -2.4>
	pigment { Col_Glass_Bluish }
	finish { F_Glass5 ambient .9 }
	interior { I_Glass1 }
}
// round snowfort sword #3
cone {
	0, .15
	<1, 2.5, 0> .01
	translate <-7.95, 0, -1.6>
	pigment { Col_Glass_Bluish }
	finish { F_Glass5 ambient .9 }
	interior { I_Glass1 }
}
// box fort
union {
	difference {
		box { 0, <8, 3, -15> }
		box { 0, <7, 4, -14> }
		box { 2, <12, 4, -16> }
	}
	union {
		cylinder { 0, <0, 3, 0>, .1 }
		box {
			<0, 2, -.05>, <1.5, 2.9, .05>
			pigment { color Firebrick }
			normal {
				gradient x
				slope_map {
					[0, <0, 1>]
					[.5, <1, 1>]
					[1, <0, 1>]
				}
				rotate z * -25
			}
		}
		rotate y * 75
		translate <3.5, 2, 2>
	}
	pigment {
		brick color White color Gray85
		scale .2
	}
	normal { bumps .3 }
	translate <9, 0, 18>
}
// The ONLY Cannon
union {
	difference {
		cylinder { 0, <0, 1.5, 0>, .5 }
		cylinder { 0, <0, 2, 0>, .4 }
	}
	difference {
		sphere { 0, .5 }
		box { <-1, 0, -1>, 1 }
	}
	sphere {
		0, 1
		scale <.5, 1, 1>
		translate <-.5, 0, 0>
	}
	texture { T_Chrome_4A }
	rotate z*70
	rotate y*-40
	rotate x* -15
	translate <7, 1.5, 20>
}
// cannon balls
#declare PileOSpheres = union {
	sphere { <-10.5, 0, 0>, .2 }
	sphere { <-10.8, 0, 0>, .2 }
	sphere { <-11.1, 0, 0>, .2 }
	sphere { <-11.4, 0, 0>, .2 }
	sphere { <-11.7, 0, 0>, .2 }
	sphere { <-10.5, 0, .6>, .2 }
	sphere { <-10.8, 0, .6>, .2 }
	sphere { <-11.1, 0, .6>, .2 }
	sphere { <-11.4, 0, .6>, .2 }
	sphere { <-11.7, 0, .6>, .2 }
	sphere { <-10.5, 0, -.6>, .2 }
	sphere { <-10.8, 0, -.6>, .2 }
	sphere { <-11.1, 0, -.6>, .2 }
	sphere { <-11.4, 0, -.6>, .2 }
	sphere { <-11.7, 0, -.6>, .2 }
	sphere { <-10.6, .2, .1>, .2 }
	sphere { <-10.9, .2, .1>, .2 }
	sphere { <-11.2, .2, .1>, .2 }
	sphere { <-11.5, .2, .1>, .2 }
	sphere { <-10.6, .2, -.4>, .2 }
	sphere { <-10.9, .2, -.4>, .2 }
	sphere { <-11.2, .2, -.4>, .2 }
	sphere { <-11.5, .2, -.4>, .2 }
	sphere { <-10.7, .4, 0>, .2 }
	sphere { <-11, .4, 0>, .2 }
	sphere { <-11.3, .4, 0>, .2 }
}
object {
	PileOSpheres
	texture { T_Chrome_1A }
	scale <2.5, 2.5, 2.5>
	translate <27, 0, 28>
	rotate y*15
}
// 50' wall
box {
	<0, 0, -50>, <.7, 1.5, 50>
	pigment {
		brick color White color Gray85
		scale .2
	}
	normal { bumps .3 }
}
// parachute (left)
union {
	difference {
		sphere { 0, 1 }
		sphere { 0, .99 }
		box { -1, <1, -.1, 1> }
		pigment {
			radial
			color_map{
				[0.5 color DarkSlateBlue]
				[0.5 color Maroon]
			}
			frequency 10
		}
	}
	union {
		#declare Count = 0;
		#while (Count < 6)
			cylinder {
				0, <0, .9, 0>, .02
				rotate x * 60
				rotate y * (Count * 60)
			}
			#declare Count = Count + 1;
		#end
		cylinder { 0, <0, -1.2, 0>, .02 }
		translate y * -.4
		pigment { color Black }
	}
	scale 4
	rotate x*10
	translate <22, 14, 12>
}
// parachute (right)
union {
	difference {
		sphere { 0, 1 }
		sphere { 0, .99 }
		box { -1, <1, -.1, 1> }
		pigment {
			radial
			color_map{
				[0.5 color Black]
				[0.5 color Goldenrod]
			}
			frequency 7
			rotate z*-30
		}
	}
	union {
		#declare Count = 0;
		#while (Count < 6)
			cylinder {
				0, <0, .9, 0>, .02
				rotate x * 60
				rotate y * (Count * 60)
			}
			#declare Count = Count + 1;
		#end
		cylinder { 0, <0, -1.5, 0>, .02 }
		translate y * -.4
		pigment { color Black }
	}
	scale 4
	rotate x*-5
	translate <38.5, 19, 6.5>
}
// snowmen
#macro MakeSnowman( BaseTrans, BodyTrans,
					HeadTrans, HeadRot, FaceRot )
	union {
		sphere {
			0, .75
		}
		sphere {
			0, .62
			translate y
			translate BodyTrans
		}
		union {
			sphere { 0, .5 }
			cone {
				0, .1, <.5, 0, 0>, 0
				translate x * .45
				pigment { color MandarinOrange }
				normal { onion .9 scale .7 }
			}
			union {
				sphere {
					0, .125
					scale <.1, 1, .75>
					translate x * .5
					rotate z * 20
					rotate y * -27.5
				}
				sphere {
					0, .125
					scale <.1, 1, .75>
					translate x * .5
					rotate z * 15
					rotate y * 27.5
				}
				sphere {
					0, .05
					translate x * .5
					rotate z * -20
					rotate y * 25
				}
				sphere {
					0, .05
					translate x * .5
					rotate z * -30
					rotate y * 15
				}
				sphere {
					0, .05
					translate x * .5
					rotate z * -30
				}
				sphere {
					0, .05
					translate x * .5
					rotate z * -30
					rotate y * -15
				}
				sphere {
					0, .05
					translate x * .5
					rotate z * -20
					rotate y * -25
				}
				pigment { color Black }
				normal { granite .9 scale .2 }
			}
			rotate HeadRot
			rotate FaceRot
			translate y * 2
			translate HeadTrans
		}
		translate BaseTrans
		pigment { color White }
		normal { bumps .3 scale .04 }
	}
#end
#macro MakeHelmet(HelmTrans, HelmRot, HelmFaceRot)
	union {
		difference {
			sphere { 0, .45 }
			sphere { 0, .44 }
			box { -1, <1, -.1, 1> }
		}
		sphere {
			0, .5
			scale <1, .05, 1>
			translate <.05, -.1, 0>
		}
		cone {
			0, .1, <0, .6, 0>, 0
			translate y * .4
			pigment { color Black }
			finish { phong 1 }
		}
		pigment { color ForestGreen }
		normal {
			crackle .5
			scale .3
			rotate z * 45
		}
		rotate HelmRot
		rotate HelmFaceRot
		translate <0, 2.6, 0>
		translate HelmTrans
	}
#end
#macro MakeHat(HatTrans, HatRot, HatFaceRot)
	difference {
		union {
			sphere {
				0, .45
				scale <1, .3, 1>
			}
			sphere {
				0, .45
				scale <1, .3, 1>
				rotate z * 15
			}
		}
		box { -2, <2, 0, 2> }
		pigment { color Firebrick }
		rotate HatRot
		rotate HatFaceRot
		translate <0, 2.4, 0>
		translate HatTrans
	}
#end
// green team
// wide open snowman (green)
MakeSnowman(<-12, .5, 12>, 0, 0, y * 20, 0)
MakeHelmet(<-12, .5, 12>, y * 20, 0)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -25
		translate x * 1.4
	}
	rotate y * 20
	rotate z * 65
	translate <0, 1.1, -.3>
	translate <-12, 0, 12>
	texture { T_Wood2 }
}
// round fort snoman #1 (green)
MakeSnowman( <-13, .5, -1>, <0, -.2, 0>,
			 <0, -.4, 0>, y * -20, 0 )
MakeHelmet(<-13, .1, -1>, y * -20, 0)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -25
		translate x * 1.4
	}
	rotate y * 20
	rotate z * 45
	translate <0, 1.1, -.3>
	translate <-13, 0, -1>
	texture { T_Wood2 }
}
// snowball from #1 in round fort
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .3
			translate x * (-.55 * Count)
			pigment {
				color White transmit .2 * Count
			}
			normal { bumps .3 scale .04 }
		}
		#declare Count = Count + 1;
	#end
	rotate y * -30
	rotate z * -3
	translate <3, 4.5, 3>
}
// snowball #2 to left paratrooper
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .3
			translate x * (-.55 * Count)
			pigment {
				color White transmit .2 * Count
			}
			normal { bumps .3 scale .04 }
		}
		#declare Count = Count + 1;
	#end
	rotate y * -200
	rotate z * 205
	translate <27, 10.23, 4>
}
// snowball #3 towards trenchman
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .3
			translate x * (-.55 * Count)
			pigment {
				color White transmit .2 * Count
			}
			normal { bumps .3 scale .04 }
		}
		#declare Count = Count + 1;
	#end
	rotate y * 145
	rotate z * 25
	translate <1, 3, -.5>
}
// snowball #4 from green guy outside round fort
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .3
			translate x * (-.55 * Count)
			pigment {
				color White transmit .2 * Count
			}
			normal { bumps .3 scale .04 }
		}
		#declare Count = Count + 1;
	#end
	rotate y* 25
	translate <-1, 2.5, 7.8>
}
// snowball pile, near
object {
	PileOSpheres
	pigment { color White }
	normal { bumps .3 scale .04 }
}
// round fort snoman #2 (green)
MakeSnowman( <-10, .5, -3.5>, <0, -.2, 0>,
			 <0, -.4, 0>, y * -160, 0 )
MakeHelmet(<-10, .1, -3.5>, y * -160, 0)
union {
	cylinder { 0, <-1, 0, 0>, .1 }
	cylinder {
		0, <0, 0, 1>, .1
		rotate y * -40
		translate x * -1
	}
	rotate y * -20
	rotate z * -60
	translate <0, 1.1, -.3>
	translate <-10, 0, -3.5>
	texture { T_Wood2 }
}
// cannonball snowman (green)
MakeSnowman( <-6, .5, 8>, <-1, 0, -.15>,
			 0, y * 25, 0 )
MakeHelmet(<-7, .5, 8>, y * 25, z * 30)
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	rotate x * 180
	translate <.6, 1.1, 0>
	rotate y * 90
	translate <-7, .5, 7.85>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	rotate x * 180
	translate <.6, 1.1, 0>
	rotate y * 270
	translate <-7, .5, 7.85>
	texture { T_Wood2 }
}
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .45
			translate x * (.85 * Count)
			pigment {
				color Black transmit .2 * Count
			}
		}
		#declare Count = Count + 1;
	#end
	rotate y * -45
	translate <-6.4, 1.5, 7.85>
}
// trench snowman (green)
MakeSnowman(<-1.5, -1, -2>, 0, 0, y * 110, 0)
MakeHelmet(<-1.5, -1, -2>, y * 110, 0)
union {
	cylinder { 0, <1, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -90
		rotate x * -30
		translate x * 1
	}
	rotate y * -60
	translate <.4, 1.1, 0>
	rotate y * 180
	translate <-1.5, -.8, -2>
	texture { T_Wood2 }
}
cylinder {
	0, <0, -1.5, 0>, .1
	rotate z * 30
	translate <.3, 1.1, 0>
	rotate y * 45
	translate <-1.5, -.7, -2>
	texture { T_Wood2 }
}
// trenchmans sword
cone {
	0, .15
	<0, 2.5, -3> .01
	rotate y*180
	rotate z*27
	rotate x*8
	translate <-1.8, .3, -3.5>
	pigment { Col_Glass_Bluish }
	finish { F_Glass5 ambient .9 }
	interior { I_Glass1 }
}
// left paratrooper snowman (green)
MakeSnowman( <22, 6.5, 11>, <0, .5, 0>,
			 <0, .5, 0>, y * 155, 0 )
MakeHelmet(<22, 7, 11>, y * 155, 0)
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	translate <.6, 1.1, 0>
	rotate y * 45
	translate <22, 7.1, 11>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	translate <.6, 1.1, 0>
	rotate y * 225
	translate <22, 7.1, 11>
	texture { T_Wood2 }
}
// right paratrooper snowman (green)
MakeSnowman(<38, 10, 7>, 0, <0, .5, 0>, y * 170, 0)
MakeHelmet(<38, 10.5, 7>, y * 170, 0)
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	rotate x * 180
	translate <.6, 1.1, 0>
	rotate y * 45
	translate <38, 10, 7>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <0, -1, 0>, .1 }
	cylinder {
		0, <0, -1.5, 0>, .1
		rotate z * -90
		translate y * -1
	}
	rotate z * 45
	rotate x * 180
	translate <.6, 1.1, 0>
	rotate y * 225
	translate <38, 10, 7>
	texture { T_Wood2 }
}
// hill swordfighter (green)
MakeSnowman(<17, 3.1, -7>, 0, 0, y * 290, 0)
MakeHelmet(<17, 3.1, -7>, y * 290, 0)
union {
	cylinder { 0, <1, 0, 0>, .1 }
	union {
		cylinder {
			0, <1, 0, 0>, .1
		}
		cone {
			0, .15
			<0, 3, 0>, .01
			rotate z * 105
			rotate y * 135
			translate x * 1
			pigment { Col_Glass_Bluish }
			finish { F_Glass5 ambient .9 }
			interior { I_Glass1 }
		}
		rotate y * -100
		translate x * 1
	}
	rotate y * 20
	translate <-.3, 1.1, 0>
	rotate y * -60
	translate <17, 3.1, -7>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <1, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * 150
		translate x * 1
	}
	rotate y * 135
	translate <-.3, 1.1, 0>
	translate <17, 3.1, -7>
	texture { T_Wood2 }
}
// red team
// snowman manning cannon (red)
MakeSnowman( <8, 1, 18>, 0,
			 <0, -.08, 0>, y * 135, 0 )
MakeHat(<8, .92, 18>, y * 135, 0)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate z * 25
		translate x * 1.4
	}
	rotate z * -30
	translate <.3, 1.1, 0>
	rotate y * -90
	translate <8, 1, 18>
	texture { T_Wood2 }
}
cylinder {
	0, <2.5, 0, 0>, .1
	rotate y * 105
	translate <.3, 1.1, 0>
	rotate x * 5
	rotate y * 30
	translate <8, 1, 18>
	texture { T_Wood2 }
}
// snowman on wall (red)
MakeSnowman( <-1, 1.25, 6>, <.5, -.13, .3>,
			 <1.4, -.41, .7>, z * 45, y * 170 )
MakeHat(<.4, .84, 6.7>, z * 45, y * 170)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate z * 25
		translate x * 1.4
	}
	translate <.3, 1.1, 0>
	rotate y * 90
	translate <-.5, 1.12, 6.3>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate z * 25
		translate x * 1.4
	}
	rotate z * 30
	translate <.3, 1.1, 0>
	rotate y * -90
	translate <-.5, 1.12, 6.3>
	texture { T_Wood2 }
}
// box fort snoman #1 (red)
MakeSnowman( <12.5, 1, 18>, 0,
			 <0, -.08, 0>, y * 145, 0 )
MakeHat(<12.5, .92, 18>, y * 145, 0)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -25
		translate x * 1.4
	}
	rotate y * 20
	rotate z * 105
	translate <0, 1.1, -.3>
	rotate y * -45
	translate <12.5, .5, 18>
	texture { T_Wood2 }
}
//#1 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	translate <12.5, 3.6, 16.8>
	} 
// box fort snoman #2 (red)
MakeSnowman( <14.5, 1, 15>, 0,
			 <0, -.08, 0>, y * 55, z * 45 )
MakeHat(<14.5, .92, 15>, y * 55, z * 45)
cylinder {
	0, <2.5, 0, 0>, .1
	rotate y * 10
	rotate z * 50
	translate <0, 1.1, -.3>
	rotate y * 60
	translate <14.5, .5, 15>
	texture { T_Wood2 }
}
// box fort snoman #3 (red)
MakeSnowman( <12.5, 1, 10>, 0,
			 <0, -.08, 0>, y * 145, 0 )
MakeHat(<12.5, .92, 10>, y * 145, 0)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -25
		translate x * 1.4
	}
	rotate y * 20
	rotate z * 145
	translate <0, 1.1, -.3>
	rotate y * -45
	translate <12.5, .5, 10>
	texture { T_Wood2 }
}
// box fort snoman #4 (red)
MakeSnowman( <15.5, 1, 8>, 0,
			 <0, -.08, 0>, y * 100, x * 30 )
MakeHat(<15.5, .92, 8>, y * 100, x * 30)
union {
	cylinder { 0, <2.5, 0, 0>, .1 }
	cylinder {
		0, <1, 0, 0>, .1
		rotate y * -25
		rotate x * 45
		translate x * 1.4
	}
	rotate y * 20
	rotate z * 75
	translate <0, 1.1, -.3>
	rotate y * 45
	translate <15.5, .5, 8>
	texture { T_Wood2 }
}
// arcing snowball from #4 in square fort
union {
	#declare Count = 0;
	#while (Count < 5)
		sphere {
			0, .3
			translate x * 2.5
			rotate z * (36 * (Count + 1))
			pigment {
				color White transmit .2 * Count
			}
			normal { bumps .3 scale .04 }
		}
		#declare Count = Count + 1;
	#end
	rotate y * 90
	translate <17.5, 6, 4>
}
// hill swordfighter snowman (red)
MakeSnowman(<17, 3.3, -1>, 0, 0, y * 90, x * 25)
MakeHat(<17, 3.3, -1>, y * 90, x * 25)
union {
	cylinder { 0, <1, 0, 0>, .1 }
	union {
		cylinder {
			0, <0, 1, 0>, .1
		}
		cone {
			0, .15
			<-3, 0, 0>, .01
			rotate x * -15
			translate y * 1
			pigment { Col_Glass_Bluish }
			finish { F_Glass5 ambient .9 }
			interior { I_Glass1 }
		}
		rotate z * -45
		translate x * 1
	}
	rotate x * 15
	translate <0, 1.1, -.3>
	rotate y * 105
	translate <17, 3.3, -1>
	texture { T_Wood2 }
}
union {
	cylinder { 0, <-1, 0, 0>, .1 }
	cylinder {
		0, <0, 1, 0>, .1
		rotate z * 45
		translate x * -1
	}
	rotate x * -15
	translate <0, 1.1, -.3>
	rotate y * -75
	translate <17, 3.3, -1>
	texture { T_Wood2 }
}
//#2 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	scale <1.5, .5, 1>
	translate <.5, 1.5, -4>
}
//#3 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	finish { ambient .2 }
	scale <.5, 2, 2>
	translate <9.1, 1, 16.8>
}
//#4 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	finish { ambient .2 }
	scale <2, 2.5, .3>
	rotate x*55
	rotate y*115
	translate <8.7, 1, 0>
}
//#5 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	finish { ambient .2 }
	scale <1.5, 1.5, .3>
	rotate x*15
	rotate y*-50
	translate <-6.8, 1.5, -6.4>
}
//#6 snowball
sphere {0,.3
        pigment {color White}
	normal { bumps .3 scale .04 }
	scale <1.5, .3, 1.5>
	translate <-8, 0, 11>
}    