
#include "stars.inc"
#include "shapes.inc"

global_settings{max_trace_level 12}
global_settings{ambient_light rgb 1}
background{color rgb 0}
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,0.05,0>
      right <0.035,0,0>
      up <0,0,0.035*aspect_ratio>
      translate<0,0,19.06>
}

fog{distance 90 color rgb<0.1,0.1,0> turbulence 1 turb_depth 0.5}

// Main lights

light_source{<12,0,2> color <1,1,0>/2.7
  area_light <20, 0, 0>, <0, 60, 0>, 4, 4
  adaptive 1 jitter
}

// Stars

plane{z, 50 texture{Starfield1} hollow no_shadow}

// Clouds

plane{z, 49
 texture{pigment{bozo scale 10
                 color_map{[0 color rgbt<1,1,1,1>][1 color rgb<1,1,0.3>]}}
                 finish{ambient 1}
        }
 hollow no_shadow
}

// Ground

plane{z, 9.99 pigment{color rgb 0}finish{ambient 1} hollow no_shadow}

#declare pavement_height = 0.15;
#declare pavement_ambient = 0.2;

// Right pavement

box{<27.5,-32,9.95><29,30,10+pavement_height>
    pigment{color rgb 1}finish{ambient pavement_ambient} hollow no_shadow
}
box{<28,-33,9.95><50,-30,10+pavement_height>
    pigment{color rgb 1}finish{ambient pavement_ambient} hollow no_shadow
}
cylinder{<28.5,-32,9.95><28.5,-32,10+pavement_height>,1
    pigment{color rgb 1}finish{ambient pavement_ambient} hollow no_shadow
}

// Far pavement

box{<-30,-40,9.95><50,-43,10+pavement_height>
    pigment{color rgb 1}finish{ambient pavement_ambient} hollow no_shadow
}

// Right building

#declare ni=8;
#declare i=0;
#while(i<ni)
  union{
  box{<0,0,0><30,30,2>
      pigment{image_map{png "slab1.png"} rotate<90,0,90> scale 2}
      finish{ambient <0.3,0.3,0>}
     }
  box{<0.1,0.1,2><30,30,3>
      pigment{image_map{png "slab2.png"} rotate<90,0,90> scale <1,2,2>}
      finish{ambient 0.1}
     }
  translate<29,-30,10+i*3>
  }
  #declare i=i+1;
#end
box{<28.9,-30.1,10><50,30,11.9>
    pigment{image_map{png "slab2.png"} rotate<90,0,90> scale <1,2,2>}
    finish{ambient 0.2}
}

// Fence

polygon{5,<-30,-43,10><-30,-43,12.5><50,-43,12.5><50,-43,10><-30,-43,10>
   pigment{gradient x color_map{[0 color rgb 0][1 color rgb 0.5]}triangle_wave scale 0.4}
   finish{ambient 0.5}
}

// Far building

#declare ni=7;
#declare i=0;
#while(i<ni)
  union{
  box{<0,0,0><50,-30,2>
      pigment{image_map{png "slab1.png"} rotate<90,0,0> scale <0.6,1,1>}
      finish{ambient <0.2,0.2,0>}
      translate<0,0,1>
     }
  box{<1,-1,0><49,-29,1>
      pigment{color rgb 0.1}finish{ambient 0.1}
     }
  translate<-5,-65,10+i*3>
  }
  #declare i=i+1;
#end

// Street lights

#declare ni=3;
#declare i=0;
#while(i<ni)
  union{
   cylinder{<0,0,0><0,0,5>,0.1 pigment{color rgb 0.5}finish{ambient 1}}
   sphere{<0,0,5>, 0.15  pigment{color rgb 1}finish{ambient 1}}
   translate<0+15*i,-42.5,10>
  }

  #declare i=i+1;
#end

// -----------------------------------------------------------------

// Car park

// Ground

polygon{5,<-2,-30,0><-2,35,0><20,35,0><20,-30,0><-2,-30,0>
 pigment{image_map{png "carpark.png"} rotate<0,0,90>scale<8,8,1>}
  finish{ambient 0.4 diffuse 0.5 phong 1}
 translate<0,0,10>
 hollow no_shadow
}

// Walls

box{<-2,-29.5,10><20,-30,12>
    pigment{bozo color_map{[0 color rgb 0][1 color rgb 1]} scale 0.1}
    finish{ambient 0.5}
}
box{<19.5,-30.1,10><20,35,12>
    pigment{bozo color_map{[0 color rgb 0][1 color rgb 1]} scale 0.05}
    finish{ambient 0.3} 
}

// Car park lights

#declare fitting = union{
  sphere{<0,0,0> 0.14 texture{pigment{color rgb 1}finish{ambient 1}}}
  sphere{<0,0,0> 0.17 texture{pigment{color rgb 0.2}finish{ambient 1}}
         clipped_by{plane{-z,0}}}
  scale<2,1,1> rotate<0,15,0>
};

#declare pole = cylinder{<0,0,0><0,0,1>,1
  texture{pigment{gradient x color_map{[0 color rgb 1][1 color rgb 0]} 
                  triangle_wave scale 2}
          finish{ambient 1}
         }
};

#declare lighting_unit = union{
   object{pole scale<0.11,0.11,0.5>}
   object{pole scale<0.08,0.08,3>}
   object{pole scale<0.14,0.14,0.1>translate<0,0,3.0>}
   object{fitting  translate<-0.7,0,3>}
   object{fitting  rotate<0,0,180>translate< 0.7,0,3>}
   object{pole translate<0,0,-0.5>scale<1,1,2>rotate<0,90,0>
          scale<0.7,0.06,0.06> translate<0,0,3.1>}
   no_shadow
};

#declare ni=2;
#declare nj=3;
#declare i=0;
#while (i<ni)
  #declare lx = 4 + 8*i;
  #declare j=0;
  #while (j<nj) 
    #declare ly = 22 - 20*j;
    object{lighting_unit translate<lx,ly,10>}
    #declare j=j+1;
  #end
  #declare i=i+1;
#end

// Car

polygon{5,<-0.5,0,0><-0.5,0,1><0.5,0,1><0.5,0,0><-0.5,0,0>
  texture{pigment{image_map{gif "car.gif" transmit 0,1}
                  translate<-0.5,0,0> rotate<90,0,0> }
          finish{ambient 1}
         }
  scale <1.2*2.5,1,1.1>
  translate<9.9,10,10>
}

// -----------------------------------------------------------------

// Main building

#declare unit_height = 2.5;
#declare unit_width = 2.5;
#declare unit_depth = 4;
#declare window_start = 0.6;
#declare window_width = 2.4;

#declare column_size = 0.08;
#declare column_T = texture{
  pigment{color rgb 0.7}
  finish{ambient 0.1 diffuse 0.5 phong 1 phong_size 10 reflection 0.2}
};

#declare seal_size = 0.01;
#declare seal_T = texture{
  pigment{color rgb 0.2}
  finish{ambient 0.1 diffuse 0.9 phong 0.5 phong_size 10}
};

#declare window_frame_size = 0.04;
#declare window_frame_T = texture{
  pigment{color rgb 0.9}
  finish{ambient 0.1 diffuse 0.5 phong 1 phong_size 10}
};

#declare panel_T = texture{
  pigment{color rgb 0.4}
  finish{ambient 0.1 diffuse 1 phong 1 phong_size 20 reflection 0.2}
};

#declare wall_T = texture{
  pigment{color rgb 1}
  finish{ambient 0.4 diffuse 0.5 phong 1.5 phong_size 30}
  normal{bumps 0.1 scale 0.005}
};

#declare prefab_unit = union{

  // Column
  box{<-0.5*column_size,window_width,0>
          < 0.5*column_size,unit_width,unit_height>
      texture{column_T}
  }


  // Window frame
  difference{
     box{<-0.5*window_frame_size,0,window_start>
           <0.5*window_frame_size,window_width,unit_height>}
     box{<-0.6*window_frame_size,window_frame_size,window_start+window_frame_size>
         < 0.6*window_frame_size,window_width-window_frame_size,unit_height-window_frame_size>}
     texture{window_frame_T}
  }

  // Window seal
  difference{
     box{<-0.5*seal_size,window_frame_size, window_start+window_frame_size>
         < 0.5*seal_size,window_width-window_frame_size,unit_height-window_frame_size>}
     box{<-0.6*seal_size,window_frame_size+seal_size,window_start+window_frame_size+seal_size>
         < 0.6*seal_size,window_width-window_frame_size-seal_size,
           unit_height-window_frame_size-seal_size>}
     texture{seal_T}
   }

  // Panel frame
  difference{
     box{<-0.5*window_frame_size,0,0>
         <0.5*window_frame_size,window_width,window_start>}
     box{<-0.6*window_frame_size,window_frame_size,window_frame_size>
         < 0.6*window_frame_size,window_width-window_frame_size,window_start-window_frame_size>}
     texture{window_frame_T}
   }

  // Panel
  box{<-0.001,window_frame_size,window_frame_size>
      <0.001,window_width-window_frame_size,window_start-window_frame_size>
      texture{panel_T}
     }

  // Ceiling
  polygon{5,<0,0,unit_height>,<-unit_depth,0,unit_height><-unit_depth,unit_width,unit_height>
            <0,unit_width,unit_height><0,0,unit_height>
          texture{wall_T}
         }
          
  // Far wall
  polygon{5,<0,unit_width,0>,<-unit_depth,unit_width,0><-unit_depth,unit_width,unit_height>
            <0,unit_width,unit_height><0,unit_width,0>
          texture{wall_T}
          }

  // Back wall
  polygon{5,<-unit_depth,0,0>,<-unit_depth,0,unit_height><-unit_depth,unit_width,unit_height>
            <-unit_depth,unit_width,0><-unit_depth,0,0>
          texture{wall_T}
          }
}

#declare window_glass = polygon{
  5, <0,0,window_start><0,0,unit_height><0,window_width,unit_height>
     <0,window_width,window_start><0,0,window_start>
  texture{pigment{color rgb 0.5}
          finish{ambient 0.1 diffuse 0.1 phong 2 phong_size 10 reflection 0.8}
         }
}

#macro make_building_unit( position, glass_flag)

  object{prefab_unit translate position}

  #if (glass_flag)
    object{window_glass translate position}
  #end

#end

// Left block

#declare window_i = 7;
#declare window_j = 2;

#declare building_x = -1.46;
#declare building_y = -0.8;
#declare building_z = 0.0;

#declare n_up = 11;
#declare n_along = 14;

#declare unit_z = building_z;
#declare i=0;
#while (i<n_up)
  #declare unit_y = building_y;
  #declare j=0;
  #while (j<n_along)

    #if(i=window_i & j=window_j)
      #declare glass_flag = 0;
    #else
      #declare glass_flag = 1;
    #end

    make_building_unit(<building_x,unit_y,unit_z>, glass_flag)

    #declare unit_y = unit_y + unit_width;
    #declare j=j+1;
  #end  
  #declare unit_z = unit_z + unit_height;
  #declare i=i+1;
#end

// Facing block

#declare n_up = 12;
#declare n_along = 8;
#declare glass_flag = 1;
union{

  // height loop
  #declare unit_z = 0;
  #declare i=0;
  #while (i<n_up)
    #declare unit_y = 0;
    #declare j=0;
    #while (j<n_along)
      make_building_unit(<0,unit_y,unit_z>, glass_flag)
      #declare unit_y = unit_y + unit_width;
      #declare j=j+1;
    #end  
    #declare unit_z = unit_z + unit_height;
    #declare i=i+1;
  #end

  rotate<0,0,-90>
  translate <-3.9, 34.2, 0>
}

//------------------------------------------------------------------------

// Room

#declare window_x = building_x;
#declare window_y = building_y + window_j * unit_width + 0.5*window_width;
#declare window_z = building_z + window_i * unit_height
                    + window_start + 0.5*(unit_height-window_start);
#declare wall_y = building_y + (window_j+1) * unit_width;

// Lights

light_source{<window_x-1.7,window_y,window_z+0.8> color rgb <0.9,0.95,1>*0.5}
light_source{<window_x-3,window_y,window_z> color rgb <0.9,0.95,1>*0.9}

#declare desk_height = window_z-0.95;

// Monitor

#declare monitor_T = texture{
  pigment{color rgb 1}
  finish{ambient 0.15 diffuse 0.7 phong 1}
  normal{bumps 0.2 scale 0.01}
};

union{

  difference{
    union{
          object{ Round_Box_Union(<-1.33,-1,0><1.33,1,2> 0.2 ) }
          object{ Round_Box_Union(<-1.5,-1,0><1.5,-0.6,2.3> 0.1 ) }
          texture{monitor_T}
         }
    box{<-1.3,-1.1,0.3><1.3,-0.9,2.1>texture{monitor_T}}

  }

  sphere{<0,0,0>,0.7 texture{monitor_T}}
  object{ Round_Box_Union(<-1.1,-0.8,-0.3><1.1,0.8,-0.6> 0.1 )
          texture{monitor_T}}

  polygon{5,<-1.3,-0.91,0.3><-1.3,-0.91,2.1><1.3,-0.91,2.1>
          <1.3,-0.91,0.3><-1.3,-0.91,0.3>
          texture{pigment{image_map{png "screen.png"}
                          translate<-0.5,0,0> rotate<90,0,0>
                          scale <1.3*2,1,1.8> translate<0,0,0.3>}
                  finish{ambient 1}}
          }

  #declare i=0;
  #while(i<5)
    #declare bx = -0.6 + 1.2*i/5;
      cylinder{<bx,-0.9,0.2><bx,-1.1,0.2>, 0.04 texture{monitor_T}}
    #declare i=i+1;
  #end

  translate<0,0,0.5>
  scale 0.16 translate<window_x-0.31,wall_y-0.3,desk_height>
}

// Desk

box{<window_x-1,wall_y-0.8,desk_height-0.03><window_x-0.01,wall_y,desk_height>
    texture{pigment{color rgb 1}
            finish{ambient 0.3 diffuse 1 phong 1}
           }
}

// Paper

#declare R1 = seed(1);
#declare i=0;
#while(i<60)
  box{<-1,-1,-1><1,1,1>
      texture{pigment{color rgb 1}finish{ambient 0.4 diffuse 1 phong 1}}
      scale <0.2,0.1,0.0025>
      rotate (-15+15*rand(R1))*z
      translate<window_x-0.75,wall_y-0.3,desk_height+i*0.005>
     }
  #declare i=i+1;
#end

// ------------------------------------------------------------------

// Glass

#macro make_shard( p0, p1, p2, p3, shard_thickness )

  #local s = 0.5*shard_thickness;

   mesh{
       // Front
       triangle{p0+s,p1+s,p2+s}
       triangle{p2+s,p3+s,p0+s}

       // Back
       triangle{p0-s,p1-s,p2-s}
       triangle{p2-s,p3-s,p0-s}

       // 0 1
       triangle{p0-s,p1-s,p1+s}
       triangle{p1+s,p0+s,p0-s}

       // 1 2
       triangle{p1-s,p2-s,p2+s}
       triangle{p2+s,p1+s,p1-s}          

       // 2 3
       triangle{p2-s,p3-s,p3+s}
       triangle{p3+s,p2+s,p2-s}

       // 3 0
       triangle{p3-s,p0-s,p0+s}
       triangle{p0+s,p3+s,p3-s}

       texture{pigment{color rgbt<1,1,1,0.9>}finish{reflection 0.2}}
       interior{ior 1.5}
       }
#end

// Window glass

#declare glass_thickness = <0.009,0,0>;

#declare r_max=1.8;
#declare centre=<window_x,window_y,window_z>;
#declare R1 = seed(1);
#declare ni = 30;
#declare d_theta = 2*pi / ni;

union{

  #declare i=0;
  #while(i<ni)
    #declare ti = i/(ni-2);
    #declare theta0 = i * d_theta;
    #declare theta_ratio = 0.1 + 0.85*rand(R1);
    #declare theta1 = theta0 + theta_ratio * d_theta;

    #declare p0 = r_max*<0,cos(theta0),sin(theta0)>;
    #declare p1 = r_max*<0,cos(theta1),sin(theta1)>;
    #declare r2 = r_max * 0.3 + 0.4*rand(R1);
    #declare r3 = r_max * 0.3 + 0.4*rand(R1);
    #declare p2 = r2*<0,cos(theta1),sin(theta1)>;
    #declare p3 = r3*<0,cos(theta0),sin(theta0)>;

    #declare shard = make_shard( p0, p1, p2, p3, glass_thickness );
    object{shard translate centre}

    #declare i=i+1;
  #end

  clipped_by{
    box{<window_x-0.3,window_y-0.51*window_width,window_z-0.51*(unit_height-window_start)>
        <window_x+0.3,window_y+0.51*window_width,window_z+0.51*(unit_height-window_start)>}
  }
}

// Large shards

#declare R1 = seed(3);
#declare R2 = seed(1);

#declare ni=100;
#declare i=0;
#while(i<ni)
  #declare t0 = rand(R1);
  #declare t1 = rand(R1);
  #declare t2 = rand(R1);
  #declare theta = t2 * 2*pi;

  #declare p0 = <0,      -0.6+0.25*rand(R1),      -0.2+0.1*rand(R1)>;
  #declare p3 = <0, p0.y+0.05+0.25*rand(R1), p0.z-0.05-0.1*rand(R1)>;
  #declare p1 = <0, p3.y+0.05+0.25*rand(R1), p3.z+0.05+0.1*rand(R1)>;
  #declare p2 = <0, p1.y+0.05+0.25*rand(R1), p1.z-0.05-0.1*rand(R1)>;
  #declare shard = make_shard( p0, p1, p2, p3, glass_thickness );
 
  #declare r_min = 0.4 - 0.1*t0;
  #declare r_max = 0.5 - 0.1*t0;
  #declare srad = r_min + (r_max - r_min) * t1;
  #declare ss = 0.5 + pow( 1-t0, 2) * 0.5;
  #declare sx = 0.05 + t0 * 0.4;
  #declare sy = srad*cos(theta);
  #declare sz = srad*sin(theta);

  // Cut a hole to see monitor
  #if((t2<0.6) | (t2>0.75) | (rand(R2)<0.3) )

   object{shard scale <1,ss,ss>

         // rotate randomly
         rotate (-360+rand(R1)*720)*t0*t0*y

         // rotate due to impact
         translate 0.6*ss*y
         rotate 45*t0*z

         // move into to position
         rotate<t2*360,0,0>

         translate <window_x+sx,window_y+sy,window_z+sz>
  }

  #end // end cut out

  #declare i=i+1;
#end

// Medium shards

#declare R1 = seed(1);
#declare ni=80;
#declare i=0;
#while(i<ni)
  #declare t0 = rand(R1);
  #declare t1 = rand(R1);
  #declare t2 = rand(R1);
  #declare theta = t2 * 2*pi;

  #declare p0 = <0,      -0.6+0.25*rand(R1),      -0.2+0.1*rand(R1)>;
  #declare p3 = <0, p0.y+0.05+0.25*rand(R1), p0.z-0.05-0.1*rand(R1)>;
  #declare p1 = <0, p3.y+0.05+0.25*rand(R1), p3.z+0.05+0.1*rand(R1)>;
  #declare p2 = <0, p1.y+0.05+0.25*rand(R1), p1.z-0.05-0.1*rand(R1)>;
  #declare shard = make_shard( p0, p1, p2, p3, glass_thickness );
 
  #declare r_min = 0.05;
  #declare r_max = 0.6 + 0.3*t0;
  #declare srad = r_min + (r_max - r_min) * pow(t1,2);
  #declare ss = 0.2 + (1-t1) * 0.4;
  #declare sx = 0.3 + t0 * 0.2;
  #declare sy = srad*cos(theta);
  #declare sz = srad*sin(theta);

  object{shard scale <1,ss,ss>

         // rotate randomly
         rotate (-360+rand(R1)*720)*t0*y
         rotate (-360+rand(R1)*720)*t0*x
         rotate (-360+rand(R1)*720)*t0*z

         // rotate due to impact
         translate 0.6*ss*y

         // move into to position
         rotate<t2*360,0,0>
         translate <window_x+sx,window_y+sy,window_z+sz>
  }

  #declare i=i+1;
#end


// Impact shards

#declare R1 = seed(1);
#declare ni=300;
#declare i=0;
#while(i<ni)
  #declare t0 = rand(R1);
  #declare t1 = rand(R1);
  #declare t2 = rand(R1);
  #declare theta = t2 * 2*pi;

  #declare p0 = <0,      -0.6+0.25*rand(R1),      -0.2+0.1*rand(R1)>;
  #declare p3 = <0, p0.y+0.05+0.25*rand(R1), p0.z-0.05-0.1*rand(R1)>;
  #declare p1 = <0, p3.y+0.05+0.25*rand(R1), p3.z+0.05+0.1*rand(R1)>;
  #declare p2 = <0, p1.y+0.05+0.25*rand(R1), p1.z-0.05-0.1*rand(R1)>;
  #declare shard = make_shard( p0, p1, p2, p3, glass_thickness );
 
  #declare r_min = 0.6 + 0.3*t0;
  #declare r_max = 0.6 + 0.3*t0;
  #declare srad = r_min + (r_max - r_min) * t1;
  #declare ss = 0.07 + pow( t0, 2)* 0.3;
  #declare sx = 0.2 + t0 * 0.7;
  #declare sy = srad*cos(theta);
  #declare sz = srad*sin(theta);

  object{shard scale <1,ss,ss>

         // rotate randomly
         rotate (-360+rand(R1)*720)*y
         rotate (-360+rand(R1)*720)*x
         rotate (-360+rand(R1)*720)*z

         // move into to position
         translate 0.6*ss*y
         rotate<t2*360,0,0>
         translate <window_x+sx,window_y+sy,window_z+sz>
  }

  #declare i=i+1;
#end

// Trail shards

#declare R1 = seed(1);
#declare R2 = seed(1);
#declare ni=200;
#declare i=0;
#while(i<ni)
  #declare t0 = rand(R1);
  #declare t1 = rand(R1);
  #declare t2 = rand(R1);
  #declare theta = t2 * 2*pi;
 
  #declare p0 = <0,      -0.6+0.25*rand(R1),      -0.2+0.1*rand(R1)>;
  #declare p3 = <0, p0.y+0.05+0.25*rand(R1), p0.z-0.05-0.1*rand(R1)>;
  #declare p1 = <0, p3.y+0.05+0.25*rand(R1), p3.z+0.05+0.1*rand(R1)>;
  #declare p2 = <0, p1.y+0.05+0.25*rand(R1), p1.z-0.05-0.1*rand(R1)>;
  #declare shard = make_shard( p0, p1, p2, p3, glass_thickness );
 
  #declare ss = 0.07 + (1-t0) * 0.2;
  #declare sx = 0.4 + t0 * 1.2;
  #declare sy = 0.0;
  #declare sz = 0.0;

  object{shard scale <1,ss,ss>

         // rotate randomly
         rotate (-360+rand(R1)*720)*y
         rotate (-360+rand(R1)*720)*x
         rotate (-360+rand(R1)*720)*z

         // move into to position
         translate 0.6*ss*y
         rotate<t2*360,0,0>
         translate <window_x+sx,window_y+sy,window_z+sz>

         translate z*(rand(R2)-0.5)*0.1
  }

  #declare i=i+1;
#end

// ---------------------------------------------------------------------------------

// Keyboard

#declare keyboard_pos = <window_x+1.4,window_y,window_z>;
#declare keyboard_rot = <-250,10,-45>;
#declare keyboard_scale = 0.25;

#declare key_height = 0.12;
union{
  Round_Box_Union(<-1,-0.3,-0.01>, <1,0.3,0.01>, 0.07 )
  height_field{png "keys.png"
    rotate<-90,0,0>translate<-0.5,-0.5,0>scale <1.85,1.85,1>
    scale<1,0.3,-key_height>translate<0,0,0>}

  scale keyboard_scale rotate keyboard_rot translate keyboard_pos
  texture{pigment{color rgb<1,1,0.9>}
          finish{ambient 0.2 diffuse 0.7 phong 1.5 phong_size 40}}
}
