//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 24 materials and 654 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 12/31/2002    (31.12.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.
Comment merged from arnejac.mdl:
This scene was created with Moray For Windows.
Comment merged from skeid.mdl:
This scene was created with Moray V3.2 For Windows.
Comment merged from dropaprufa.mdl:
This scene was created with Moray For Windows.
Comment merged from blomapottur.mdl:
This scene was created with Moray For Windows.
Comment merged from upptvottabursti.mdl:
This scene was created with Moray V3.3a For Windows.
Comment merged from icecube.mdl:
This scene was created with Moray V3.2 For Windows.
Comment merged from ledurstoll.mdl:
This scene was created with Moray V3.3a For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.0392
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       0.7
    count            200
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.0
    low_error_factor 0.2
    minimum_reuse    0.015
    nearest_count    8
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.445,     -11.463,      24.399>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <      0.438,      -0.216,      19.026>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <     -0.100,      -0.001,      28.000> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.43616,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         75.17817    // Vertical      56.384
  look_at   <     -0.100,       0.000,      27.000> // Following Spotlight001
}

*/

/*
camera {  //  Camera SpotCam002
  location  <     -0.100,      25.151,      28.000> // Attached to Spotlight002
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.43616,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         75.17817    // Vertical      56.384
  look_at   <     -0.100,      25.152,      27.000> // Following Spotlight002
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.950, 0.850>*2.0000
  translate  <45.247033, -7.179274, 40.718123>
}

light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.900>*0.5000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    30.000  // outer radius (in deg)
    radius     10.000  // inner radius
    tightness  0.000
  fade_distance  1.0
  fade_power 1.0
  translate  <-0.1, 25.151962, 28.0>
}

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.900>*0.5000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    30.000  // outer radius (in deg)
    radius     10.000  // inner radius
    tightness  0.000
  fade_distance  1.0
  fade_power 1.0
  translate  <-0.1, 0.0, 28.0>
}


//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "hkadrop.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union { // dropar
  sphere { // dropi1
    <0,0,0>,1
    material {
      vatn_1
    }
    scale 0.05
    translate  <-0.878961, -0.09485, 15.651553>
  }
  sphere { // dropi2
    <0,0,0>,1
    material {
      vatn_1
    }
    scale 0.04
    translate  <-0.284265, -0.008184, 15.548242>
  }
  sphere { // dropi3
    <0,0,0>,1
    material {
      vatn_1
    }
    scale <0.04, 0.03, 0.03>
    rotate <-0.0, 0.0, -69.560059>
    translate  <-0.418205, -0.071214, 15.569904>
  }
  sphere { // dropi4
    <0,0,0>,1
    material {
      vatn_1
    }
    scale 0.04
    translate  <-1.904982, -0.126366, 15.802381>
  }
  sphere { // dropi5
    <0,0,0>,1
    material {
      vatn_1
    }
    scale 0.04
    translate  <-1.968012, -0.285017, 15.642042>
  }
}




superellipsoid { // ismoli1
  <0.5, 0.5>
  material {
    klaki
  }
  scale 0.3
  rotate <-0.0, -15.125113, 0.0>
  translate  <-2.927193, 5.314609, 19.000287>
}


//
// Include file contains 'vatnsglas'
//
#include "hkadrop.in1"
object {   // vatnsglas
  vatnsglas_Raw
  material {
    gler2
  }
  scale 0.2
  translate  <-2.712214, 5.254954, 17.981482>
}


//
// Include file contains 'eplabukur1'
//
#include "hkadrop.in2"
#declare eplabukur1 = object {
  eplabukur1_Raw
  material {
    eplalitur
  }
  no_shadow
  scale 20.0
}
#declare eplahanki1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 0.000000>, <-1.000000, -1.333333, 0.000000>, <1.000000, -1.333333, 0.000000>, <1.000000, -0.000000, 0.000000>, 
      <-1.000000, -0.000002, 2.000000>, <-1.000000, -1.333333, 2.000000>, <1.000000, -1.333333, 2.000000>, <1.000000, -0.000000, 2.000000>, 
      <-1.000000, -0.000002, 4.000000>, <-1.000000, -1.333333, 4.000000>, <1.000000, -1.333333, 4.000000>, <1.000000, -0.000000, 4.000000>, 
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 0.000000>, <1.000000, 1.333333, 0.000000>, <-1.000000, 1.333330, 0.000000>, <-1.000000, -0.000002, 0.000000>, 
      <1.000000, -0.000000, 2.000000>, <1.000000, 1.333333, 2.000000>, <-1.000000, 1.333330, 2.000000>, <-1.000000, -0.000002, 2.000000>, 
      <1.000000, -0.000000, 4.000000>, <1.000000, 1.333333, 4.000000>, <-1.000000, 1.333330, 4.000000>, <-1.000000, -0.000002, 4.000000>, 
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>, 
      <-1.000000, -0.000002, 8.000000>, <-1.000000, -1.333333, 8.000000>, <1.000000, -1.333333, 8.000000>, <1.000000, -0.000000, 8.000000>, 
      <-1.000000, -0.000002, 10.000000>, <-1.000000, -1.333333, 10.000000>, <1.000000, -1.333333, 10.000000>, <1.000000, -0.000000, 10.000000>, 
      <-1.000000, -0.258300, 12.539957>, <-1.000000, -1.494359, 12.305583>, <1.000000, -1.494359, 12.305583>, <1.000000, -0.258299, 12.539957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>, 
      <1.000000, -0.000000, 8.000000>, <1.000000, 1.333333, 8.000000>, <-1.000000, 1.333330, 8.000000>, <-1.000000, -0.000002, 8.000000>, 
      <1.000000, -0.000000, 10.000000>, <1.000000, 1.333333, 10.000000>, <-1.000000, 1.333330, 10.000000>, <-1.000000, -0.000002, 10.000000>, 
      <1.000000, -0.258299, 12.539957>, <1.000000, 1.085943, 12.777648>, <-1.000000, 1.085940, 12.777648>, <-1.000000, -0.258300, 12.539957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.258300, 12.539957>, <-1.000000, -1.494359, 12.305583>, <1.000000, -1.494359, 12.305583>, <1.000000, -0.258299, 12.539957>, 
      <-1.000000, -0.408417, 15.083231>, <-1.000000, -1.655385, 14.611167>, <1.000000, -1.655385, 14.611167>, <1.000000, -0.408416, 15.083232>, 
      <-1.000000, -3.523175, 16.999628>, <-1.000000, -4.040217, 15.770628>, <1.000000, -4.040217, 15.770628>, <1.000000, -3.523175, 16.999630>, 
      <-1.000000, -6.922411, 16.865601>, <-1.000000, -6.620699, 15.566854>, <1.000000, -6.620699, 15.566854>, <1.000000, -6.922412, 16.865602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.258299, 12.539957>, <1.000000, 1.085943, 12.777648>, <-1.000000, 1.085940, 12.777648>, <-1.000000, -0.258300, 12.539957>, 
      <1.000000, -0.408416, 15.083232>, <1.000000, 0.838553, 15.555297>, <-1.000000, 0.838550, 15.555296>, <-1.000000, -0.408417, 15.083231>, 
      <1.000000, -3.523175, 16.999630>, <1.000000, -3.006132, 18.228631>, <-1.000000, -3.006133, 18.228628>, <-1.000000, -3.523175, 16.999628>, 
      <1.000000, -6.922412, 16.865602>, <1.000000, -7.224125, 18.164350>, <-1.000000, -7.224124, 18.164347>, <-1.000000, -6.922411, 16.865601>
    }
  }
  material {
    epladot
  }
  translate  25.0*z
}
union { // epli2
  object { eplabukur1 }
  object { eplahanki1 }
  scale 0.03
  rotate <0.0, -0.0, 20.812183>
  translate  <2.421999, 10.063766, 18.5>
}


//
// Include file contains 'vatnsdropi1'
//
#include "hkadrop.in3"
object {   // vatnsdropi1
  vatnsdropi1_Raw
  material {
    vatn
  }
  scale 0.05
  translate  <-0.007951, 0.0, 20.881724>
}


//
// Include file contains 'nidurfallshringur'
//
#include "hkadrop.in4"
#declare nidurfallshringur = object {
  nidurfallshringur_Raw
  material {
    krom1
  }
  translate  <1.0, 0.0, 14.47>
}
#declare skrufuhaus = difference {
  sphere { // skrufa
    <0,0,0>,1
    material {
      krom1
    }
    scale <0.15, 0.15, 0.1>
    translate  14.25*z
  }
  box { // skrufurauf
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale <0.14, 0.01, 0.12>
    rotate -35.0*z
    translate  14.45*z
  }
}
#declare botnsia = difference {
  cylinder { // nidurfallsrist
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.45, 0.45, 0.02>
    translate  14.3*z
  }
  cylinder { // nidurfallsgat
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <0.0, 0.26, 14.2>
  }
  cylinder { // nidurfallsgat1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <0.0, -0.26, 14.2>
  }
  cylinder { // nidurfallsgat2
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <-0.23, -0.13, 14.2>
  }
  cylinder { // nidurfallsgat3
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <-0.23, 0.13, 14.2>
  }
  cylinder { // nidurfallsgat4
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <0.23, 0.13, 14.2>
  }
  cylinder { // nidurfallsgat5
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.1, 0.1, 0.2>
    translate  <0.23, -0.13, 14.2>
  }
}
#declare vasksian = union {
  object { skrufuhaus }
  object { botnsia }
  translate  1.0*x
}
union { // vasknidurfallid
  object { nidurfallshringur }
  object { vasksian }
  translate  0.5*z
}


#declare allistinn = difference {
  box { // gluggarammi3
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom1
    }
    scale <0.019, 1.4, 0.45>
    translate  <0.8, 0.0, 2.35>
  }
  box { // gluggarammi4
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom1
    }
    scale <0.1, 1.339, 0.389>
    translate  <0.8, 0.0, 2.35>
  }
}
#declare gluggaramminn = difference {
  box { // gluggarammi1
    <-1, -1, -1>, <1, 1, 1>
    material {
      svartlam
    }
    scale <0.06, 1.4, 0.45>
    translate  <0.8, 0.0, 2.35>
  }
  box { // gluggarammi2
    <-1, -1, -1>, <1, 1, 1>
    material {
      svartlam
    }
    scale <0.1, 1.34, 0.39>
    translate  <0.8, 0.0, 2.35>
  }
}
union { // gluggastykki
  object { allistinn }
  box { // glerruda1
    <-1, -1, -1>, <1, 1, 1>
    material {
      gluggagler1
    }
    scale <0.001, 1.4, 0.45>
    translate  <0.785, 0.0, 2.35>
  }
  object { gluggaramminn }
  scale 10.0
  translate  1.0*x
}


//
// Include file contains 'eplabukur'
//
#include "hkadrop.in5"
#declare eplabukur = object {
  eplabukur_Raw
  material {
    eplalitur
  }
  no_shadow
  scale 20.0
}
#declare eplahanki = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 0.000000>, <-1.000000, -1.333333, 0.000000>, <1.000000, -1.333333, 0.000000>, <1.000000, -0.000000, 0.000000>, 
      <-1.000000, -0.000002, 2.000000>, <-1.000000, -1.333333, 2.000000>, <1.000000, -1.333333, 2.000000>, <1.000000, -0.000000, 2.000000>, 
      <-1.000000, -0.000002, 4.000000>, <-1.000000, -1.333333, 4.000000>, <1.000000, -1.333333, 4.000000>, <1.000000, -0.000000, 4.000000>, 
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 0.000000>, <1.000000, 1.333333, 0.000000>, <-1.000000, 1.333330, 0.000000>, <-1.000000, -0.000002, 0.000000>, 
      <1.000000, -0.000000, 2.000000>, <1.000000, 1.333333, 2.000000>, <-1.000000, 1.333330, 2.000000>, <-1.000000, -0.000002, 2.000000>, 
      <1.000000, -0.000000, 4.000000>, <1.000000, 1.333333, 4.000000>, <-1.000000, 1.333330, 4.000000>, <-1.000000, -0.000002, 4.000000>, 
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>, 
      <-1.000000, -0.000002, 8.000000>, <-1.000000, -1.333333, 8.000000>, <1.000000, -1.333333, 8.000000>, <1.000000, -0.000000, 8.000000>, 
      <-1.000000, -0.000002, 10.000000>, <-1.000000, -1.333333, 10.000000>, <1.000000, -1.333333, 10.000000>, <1.000000, -0.000000, 10.000000>, 
      <-1.000000, -0.258300, 12.539957>, <-1.000000, -1.494359, 12.305583>, <1.000000, -1.494359, 12.305583>, <1.000000, -0.258299, 12.539957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>, 
      <1.000000, -0.000000, 8.000000>, <1.000000, 1.333333, 8.000000>, <-1.000000, 1.333330, 8.000000>, <-1.000000, -0.000002, 8.000000>, 
      <1.000000, -0.000000, 10.000000>, <1.000000, 1.333333, 10.000000>, <-1.000000, 1.333330, 10.000000>, <-1.000000, -0.000002, 10.000000>, 
      <1.000000, -0.258299, 12.539957>, <1.000000, 1.085943, 12.777648>, <-1.000000, 1.085940, 12.777648>, <-1.000000, -0.258300, 12.539957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.258300, 12.539957>, <-1.000000, -1.494359, 12.305583>, <1.000000, -1.494359, 12.305583>, <1.000000, -0.258299, 12.539957>, 
      <-1.000000, -0.408417, 15.083231>, <-1.000000, -1.655385, 14.611167>, <1.000000, -1.655385, 14.611167>, <1.000000, -0.408416, 15.083232>, 
      <-1.000000, -3.523175, 16.999628>, <-1.000000, -4.040217, 15.770628>, <1.000000, -4.040217, 15.770628>, <1.000000, -3.523175, 16.999630>, 
      <-1.000000, -6.922411, 16.865601>, <-1.000000, -6.620699, 15.566854>, <1.000000, -6.620699, 15.566854>, <1.000000, -6.922412, 16.865602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.258299, 12.539957>, <1.000000, 1.085943, 12.777648>, <-1.000000, 1.085940, 12.777648>, <-1.000000, -0.258300, 12.539957>, 
      <1.000000, -0.408416, 15.083232>, <1.000000, 0.838553, 15.555297>, <-1.000000, 0.838550, 15.555296>, <-1.000000, -0.408417, 15.083231>, 
      <1.000000, -3.523175, 16.999630>, <1.000000, -3.006132, 18.228631>, <-1.000000, -3.006133, 18.228628>, <-1.000000, -3.523175, 16.999628>, 
      <1.000000, -6.922412, 16.865602>, <1.000000, -7.224125, 18.164350>, <-1.000000, -7.224124, 18.164347>, <-1.000000, -6.922411, 16.865601>
    }
  }
  material {
    epladot
  }
  translate  25.0*z
}
union { // epli1
  object { eplabukur }
  object { eplahanki }
  scale 0.03
  rotate 48.55479*z
  translate  <0.158098, 5.787508, 18.5>
}




#declare CSG001 = union {
  box { // bordplata
    <-1, -1, -1>, <1, 1, 1>
    material {
      staldull
    }
    scale <0.6, 5.0, 0.1>
    translate  1.7*z
  }
  box { // vaskkassi
    <-1, -1, -1>, <1, 1, 1>
    scale 0.6
    translate  1.0*z
  }
}
#declare vasksett = difference {
  object { CSG001 }
  superellipsoid { // vaskuttak
    <0.35, 0.35>
    scale <0.35, 0.4, 0.25>
    translate  <-0.1, 0.0, 1.75>
  }
  superellipsoid { // vaskuttak1
    <0.35, 0.1>
    scale <0.355, 0.405, 0.1>
    translate  <-0.1, 0.0, 1.88>
  }
  cylinder { // nidurfallsror
    <0,0,1>, <0,0,0>, 1 
    material {
      svartlam
    }
    scale <0.07, 0.07, 0.5>
    translate  <0.1, 0.0, 1.1>
  }
  material {
    krom1
  }
}
union { // skapar
  box { // bordsokkull
    <-1, -1, -1>, <1, 1, 1>
    material {
      svartlam
    }
    scale <0.05, 4.9, 0.8>
    translate  <-0.55, 0.0, 0.8>
  }
  box { // efriskapur
    <-1, -1, -1>, <1, 1, 1>
    material {
      svartlam
    }
    scale <0.4, 4.9, 0.5>
    translate  <0.2, 0.0, 3.4>
  }
  object { vasksett }
  scale 10.0
}


#declare utveggurinn = difference {
  box { // veggur1
    <-1, -1, -1>, <1, 1, 1>
    material {
      utveggur
    }
    scale <0.2, 5.0, 2.5>
    translate  <0.8, 0.0, 2.5>
  }
  box { // gluggagat
    <-1, -1, -1>, <1, 1, 1>
    material {
      utveggur
    }
    scale <0.4, 1.4, 0.45>
    translate  <0.8, 0.0, 2.35>
  }
}
union { // veggir
  object { utveggurinn }
  box { // endaveggur1
    <-1, -1, -1>, <1, 1, 1>
    material {
      utveggur
    }
    scale <4.0, 0.1, 2.5>
    translate  <-3.0, 5.0, 2.5>
  }
  box { // endaveggur2
    <-1, -1, -1>, <1, 1, 1>
    material {
      utveggur
    }
    scale <4.0, 0.1, 2.5>
    translate  <-3.0, -5.0, 2.5>
  }
  box { // veggur2
    <-1, -1, -1>, <1, 1, 1>
    material {
      utveggur
    }
    scale <0.1, 5.0, 2.5>
    translate  <-5.0, 0.0, 2.5>
  }
  box { // loft
    <-1, -1, -1>, <1, 1, 1>
    material {
      golfefni
    }
    scale <5.0, 5.0, 0.1>
    translate  <-4.4, 0.0, 5.0>
  }
  box { // golf
    <-1, -1, -1>, <1, 1, 1>
    material {
      golfefni
    }
    scale <5.0, 5.0, 0.1>
    translate  <-4.4, 0.0, -0.1>
  }
  scale 10.0
}


#declare kranabogi1 = difference {
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    material {
      krom1
    }
    scale 0.04
    rotate <0.0, 90.0, -90.0>
    translate  <0.37, 0.0, 2.14>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale 0.1
    translate  <0.361451, 0.0, 2.04>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale 0.1
    translate  <0.27, 0.0, 2.131532>
  }
}
#declare kranabogi2 = difference {
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    material {
      krom1
    }
    scale 0.04
    rotate <0.0, 90.0, -90.0>
    translate  <0.37, 0.0, 2.14>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale 0.1
    translate  <0.361451, 0.0, 2.04>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale 0.1
    translate  <0.27, 0.0, 2.131532>
  }
  rotate -180.0*z
  translate  0.5*x
}
#declare utskurdur = difference {
  cylinder { // tverror1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.035, 0.035, 0.09>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.345, 0.0, 1.89>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale <0.015, 0.002, 0.05>
    translate  <0.26, -0.01, 1.885927>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      dokkgratt
    }
    scale <0.015, 0.002, 0.05>
    translate  <0.26, 0.01, 1.885927>
  }
}
union { // kranasett
  cylinder { // botnror
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.03, 0.03, 0.08>
    translate  <0.38, 0.0, 1.8>
  }
  cylinder { // tverror
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.035, 0.035, 0.11>
    rotate <-0.0, -90.0, -0.0>
    translate  <0.46, 0.0, 1.89>
  }
  cylinder { // tverror2
    <0,0,1>, <0,0,0>, 1 
    material {
      dokkgratt
    }
    scale <0.03, 0.03, 0.16>
    rotate <-0.0, -90.0, -0.0>
    translate  <0.43, 0.0, 1.89>
  }
  cylinder { // botnror1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.033, 0.033, 0.01>
    translate  <0.38, 0.0, 1.802>
  }
  cylinder { // efraror1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.02, 0.02, 0.04>
    translate  <0.43, 0.0, 1.9>
  }
  cylinder { // efraror2
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.02, 0.02, 0.2>
    translate  <0.43, 0.0, 1.942>
  }
  object { kranabogi1 }
  cylinder { // efraror3
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.02, 0.02, 0.08>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.37, 0.0, 2.2>
  }
  cylinder { // efraror4
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.02, 0.02, 0.16>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.288, 0.0, 2.2>
  }
  object { kranabogi2 }
  cylinder { // efraror5
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.02, 0.02, 0.03>
    translate  <0.07, 0.0, 2.108>
  }
  cylinder { // pinni
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.005, 0.005, 0.04>
    translate  <0.265, 0.0, 1.92>
  }
  object { utskurdur }
  scale 10.0
  translate  -0.7*x
}




plane { // Plane001
  z,0
  material {
    eplalitur
  }
  translate  -0.2*z
}


sphere { // himinhvolf
  <0,0,0>,1
  material {
    himinn
  }
  hollow
  scale 300.0
}


// Include contains 'halda'
#include "hkadrop.in6"

#declare halda = object {
  halda_Raw
  material {
    SVART
  }
  scale <0.9, 0.9, 0.5>
  rotate 90.0*x
  translate  <1.5, 0.25, 1.188675>
}
#declare CSG002 = merge {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 3.3>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 1.0>
    rotate -30.0*y
    translate  <-0.9, 0.0, 2.45>
  }
}
#declare CSG003 = merge {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <1.36, 1.36, 3.0>
    translate  0.1*z
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.56, 0.56, 1.0>
    rotate -30.0*y
    translate  <-0.9, 0.0, 2.44>
  }
}
#declare CSG004 = difference {
  object { CSG002 }
  object { CSG003 }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.0>
    translate  <-0.2, -0.0444, 4.0>
  }
  material {
    stal
  }
}
union { // tekannan
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.05, 0.05, 0.25>
    rotate <90.0, -0.0, 90.0>
    translate  <1.4, 0.0, 2.6>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.05, 0.05, 0.25>
    rotate <90.0, -0.0, 90.0>
    translate  <1.4, 0.0, 2.85>
  }
  object { halda }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <1.0, 1.0, 0.04>
    translate  2.95*z
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.6, 0.6, 0.15>
    translate  2.78*z
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <1.3, 1.3, 0.1>
    translate  2.7*z
  }
  object { CSG004 }
  rotate -170.31665*z
  translate  <-1.099984, 8.825615, 18.0>
}


#declare tesiubotn = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.96, 0.96, 1.0>
    translate  0.1*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.2>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.0, -0.56, 0.9>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.2>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.0, -0.56, 0.95>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.2>
    rotate -90.0*x
    translate  <0.0, 0.0, 0.95>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.0, -0.56, 0.95>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.0, -0.56, 0.98>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.0, -0.56, 1.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.1, 1.2>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.0, -0.56, 1.05>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.0, -0.56, 0.95>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate -90.0*x
    translate  0.95*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.0, -0.56, 0.98>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate -90.0*x
    translate  0.98*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.0, -0.56, 1.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.1, 1.2>
    rotate -90.0*x
    translate  1.0*z
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.1, 1.2>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.0, -0.56, 1.05>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.1, 1.2>
    rotate -90.0*x
    translate  1.05*z
  }
  material {
    stal
  }
}
#declare tesiuskal = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.94
    translate  1.1*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.9
    translate  1.1*z
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    translate  2.0*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 20.0*x
    translate  <0.1, 0.369042, 0.067141>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 30.0*x
    translate  <0.1, 0.527931, 0.140839>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 40.0*x
    translate  <0.1, 0.671172, 0.237236>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 50.0*x
    translate  <0.1, 0.797598, 0.358408>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 60.0*x
    translate  <0.1, 0.9, 0.5>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 20.0*x
    translate  <-0.1, 0.369042, 0.067141>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 30.0*x
    translate  <-0.1, 0.527931, 0.140839>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 40.0*x
    translate  <-0.1, 0.671172, 0.237236>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 50.0*x
    translate  <-0.1, 0.797598, 0.358408>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate 60.0*x
    translate  <-0.1, 0.9, 0.5>
  }
  material {
    stal
  }
}
union { // tesian
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.045, 0.045, 0.8>
    rotate <-90.0, 0.0, 60.0>
    translate  <1.55, -0.88, 0.9>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.045, 0.045, 0.8>
    rotate <-90.0, 0.0, -60.0>
    translate  <-1.55, -0.88, 0.9>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      stal
    }
    scale <0.045, 0.045, 0.8>
    rotate -90.0*x
    translate  <0.0, 1.0, 0.9>
  }
  object { tesiubotn }
  object { tesiuskal }
  rotate -29.05929*z
  translate  <3.792, 8.40302, 18.0>
}


object {   // vatnsdropar
  height_field {
    tga "D:\Program Files\Moray For Windows\Maps\vatnsdr.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    vatn_1
  }
  scale <2.5, 2.5, 0.2>
  translate  <-1.3, 0.5, 14.875>
}


//
// Include file contains 'pottur'
//
#include "hkadrop.in7"
#declare pottur = object {
  pottur_Raw
  material {
    leirker
  }
}
//
// Include file contains 'kaktus'
//
#include "hkadrop.in8"
#declare kaktus = object {
  kaktus_Raw
  material {
    kaktuslitur
  }
  translate  1.5*z
}
//
// Include file contains 'pottaskal'
//
#include "hkadrop.in9"
#declare pottaskal = object {
  pottaskal_Raw
  material {
    leirker
  }
}
#declare kaktusnala1 = union {
  cone { // gaddur1
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur2
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur3
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur4
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur5
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
}
#declare kaktusnalb1 = union {
  cone { // gaddur81
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur82
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur83
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur84
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur85
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
}
#declare kaktusnalc1 = union {
  cone { // gaddur6
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur7
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur8
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur9
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur10
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
}
#declare kaktusnald1 = union {
  cone { // gaddur86
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur87
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur88
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur89
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur90
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
}
#declare kaktusnale1 = union {
  cone { // gaddur91
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur92
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur93
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur94
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur95
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
}
#declare kaktusnalf1 = union {
  cone { // gaddur96
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur97
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur98
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur99
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur100
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
}
#declare kaktusnalg1 = union {
  cone { // gaddur101
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur102
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur103
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur104
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur105
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
}
#declare kaktusnalh = union {
  cone { // gaddur106
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -180.0*x
    translate  <0.0, -0.000498, 2.766522>
  }
  cone { // gaddur107
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -160.0*x
    translate  <0.0, -0.087261, 2.751158>
  }
  cone { // gaddur108
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -200.0*x
    translate  <0.0, 0.081745, 2.74935>
  }
  cone { // gaddur109
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <0.0, -160.0, -180.0>
    translate  <-0.085366, -0.001599, 2.749031>
  }
  cone { // gaddur110
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <0.0, -200.0, -180.0>
    translate  <0.08515, -0.00246, 2.753215>
  }
}
#declare kaktusnala2 = union {
  cone { // gaddur11
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur12
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur13
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur14
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur15
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -45.0*z
}
#declare kaktusnala3 = union {
  cone { // gaddur16
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur17
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur18
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur19
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur20
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -90.0*z
}
#declare kaktusnala4 = union {
  cone { // gaddur21
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur22
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur23
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur24
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur25
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -135.0*z
}
#declare kaktusnala5 = union {
  cone { // gaddur26
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur27
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur28
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur29
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur30
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -180.0*z
}
#declare kaktusnala6 = union {
  cone { // gaddur31
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur32
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur33
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur34
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur35
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -225.0*z
}
#declare kaktusnala7 = union {
  cone { // gaddur36
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur37
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur38
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur39
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur40
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -270.0*z
}
#declare kaktusnala8 = union {
  cone { // gaddur41
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, -20.0>
    translate  <-0.16938, -1.022642, 1.556619>
  }
  cone { // gaddur42
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -110.0*x
    translate  <0.0, -1.024932, 1.726367>
  }
  cone { // gaddur43
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -70.0*x
    translate  <0.0, -1.027612, 1.386064>
  }
  cone { // gaddur44
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <-0.0, -1.053439, 1.556619>
  }
  cone { // gaddur45
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.5>
    rotate <-90.0, 0.0, 20.0>
    translate  <0.167669, -1.022642, 1.556619>
  }
  rotate -315.0*z
}
#declare kaktusnalb2 = union {
  cone { // gaddur111
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur112
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur113
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur114
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur115
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -45.0*z
}
#declare kaktusnalb3 = union {
  cone { // gaddur116
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur117
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur118
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur119
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur120
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -90.0*z
}
#declare kaktusnalb4 = union {
  cone { // gaddur121
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur122
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur123
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur124
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur125
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -135.0*z
}
#declare kaktusnalb5 = union {
  cone { // gaddur126
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur127
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur128
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur129
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur130
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -180.0*z
}
#declare kaktusnalb6 = union {
  cone { // gaddur131
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur132
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur133
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur134
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur135
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -225.0*z
}
#declare kaktusnalb7 = union {
  cone { // gaddur136
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur137
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur138
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur139
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur140
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -270.0*z
}
#declare kaktusnalb8 = union {
  cone { // gaddur141
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -95.0*x
    translate  <0.0, -0.979647, 1.903607>
  }
  cone { // gaddur142
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -115.0*x
    translate  <0.0, -0.93841, 2.052593>
  }
  cone { // gaddur143
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -75.0*x
    translate  <0.0, -0.966775, 1.744774>
  }
  cone { // gaddur144
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, -20.0>
    translate  <-0.151988, -0.956916, 1.903815>
  }
  cone { // gaddur145
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-95.0, 0.0, 20.0>
    translate  <0.150453, -0.954798, 1.901188>
  }
  rotate -315.0*z
}
#declare kaktusnalc2 = union {
  cone { // gaddur46
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur47
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur48
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur49
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur50
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -45.0*z
}
#declare kaktusnalc3 = union {
  cone { // gaddur51
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur52
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur53
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur54
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur55
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -90.0*z
}
#declare kaktusnalc4 = union {
  cone { // gaddur56
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur57
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur58
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur59
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur60
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -135.0*z
}
#declare kaktusnalc5 = union {
  cone { // gaddur61
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur62
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur63
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur64
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur65
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -180.0*z
}
#declare kaktusnalc6 = union {
  cone { // gaddur66
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur67
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur68
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur69
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur70
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -225.0*z
}
#declare kaktusnalc7 = union {
  cone { // gaddur71
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur72
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur73
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur74
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur75
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -270.0*z
}
#declare kaktusnalc8 = union {
  cone { // gaddur76
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -85.0*x
    translate  <0.001031, -0.978762, 1.235773>
  }
  cone { // gaddur77
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -105.0*x
    translate  <0.001031, -0.964818, 1.386473>
  }
  cone { // gaddur78
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate -65.0*x
    translate  <0.002567, -0.941151, 1.082641>
  }
  cone { // gaddur79
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, -20.0>
    translate  <-0.149422, -0.95049, 1.235773>
  }
  cone { // gaddur80
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.45>
    rotate <-85.0, 0.0, 20.0>
    translate  <0.151484, -0.95049, 1.235773>
  }
  rotate -315.0*z
}
#declare kaktusnald2 = union {
  cone { // gaddur146
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur147
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur148
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur149
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur150
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -45.0*z
}
#declare kaktusnald3 = union {
  cone { // gaddur151
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur152
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur153
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur154
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur155
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -90.0*z
}
#declare kaktusnald4 = union {
  cone { // gaddur156
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur157
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur158
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur159
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur160
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -135.0*z
}
#declare kaktusnald5 = union {
  cone { // gaddur161
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur162
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur163
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur164
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur165
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -180.0*z
}
#declare kaktusnald6 = union {
  cone { // gaddur166
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur167
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur168
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur169
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur170
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -225.0*z
}
#declare kaktusnald7 = union {
  cone { // gaddur171
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur172
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur173
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur174
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur175
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -270.0*z
}
#declare kaktusnald8 = union {
  cone { // gaddur176
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -105.0*x
    translate  <0.0, -0.871468, 2.212739>
  }
  cone { // gaddur177
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -125.0*x
    translate  <0.0, -0.817115, 2.338137>
  }
  cone { // gaddur178
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate -85.0*x
    translate  <0.0, -0.882186, 2.074865>
  }
  cone { // gaddur179
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, -20.0>
    translate  <-0.12896, -0.850887, 2.213735>
  }
  cone { // gaddur180
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.4>
    rotate <-105.0, 0.0, 20.0>
    translate  <0.13203, -0.849891, 2.212739>
  }
  rotate -315.0*z
}
#declare kaktusnale2 = union {
  cone { // gaddur181
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur182
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur183
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur184
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur185
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -45.0*z
}
#declare kaktusnale3 = union {
  cone { // gaddur186
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur187
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur188
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur189
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur190
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -90.0*z
}
#declare kaktusnale4 = union {
  cone { // gaddur191
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur192
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur193
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur194
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur195
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -135.0*z
}
#declare kaktusnale5 = union {
  cone { // gaddur196
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur197
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur198
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur199
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur200
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -180.0*z
}
#declare kaktusnale6 = union {
  cone { // gaddur201
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur202
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur203
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur204
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur205
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -225.0*z
}
#declare kaktusnale7 = union {
  cone { // gaddur206
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur207
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur208
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur209
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur210
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -270.0*z
}
#declare kaktusnale8 = union {
  cone { // gaddur211
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -120.0*x
    translate  <0.0, -0.712233, 2.476504>
  }
  cone { // gaddur212
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -100.0*x
    translate  <0.0, -0.755285, 2.363139>
  }
  cone { // gaddur213
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate -140.0*x
    translate  <0.0, -0.636154, 2.571369>
  }
  cone { // gaddur214
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, -20.0>
    translate  <-0.102861, -0.695346, 2.476504>
  }
  cone { // gaddur215
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.35>
    rotate <-120.0, 0.0, 20.0>
    translate  <0.101325, -0.695346, 2.476504>
  }
  rotate -315.0*z
}
#declare kaktusnalf2 = union {
  cone { // gaddur216
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur217
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur218
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur219
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur220
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -45.0*z
}
#declare kaktusnalf3 = union {
  cone { // gaddur221
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur222
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur223
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur224
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur225
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -90.0*z
}
#declare kaktusnalf4 = union {
  cone { // gaddur226
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur227
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur228
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur229
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur230
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -135.0*z
}
#declare kaktusnalf5 = union {
  cone { // gaddur231
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur232
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur233
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur234
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur235
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -180.0*z
}
#declare kaktusnalf6 = union {
  cone { // gaddur236
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur237
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur238
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur239
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur240
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -225.0*z
}
#declare kaktusnalf7 = union {
  cone { // gaddur241
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur242
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur243
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur244
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur245
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -270.0*z
}
#declare kaktusnalf8 = union {
  cone { // gaddur246
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -135.0*x
    translate  <0.0, -0.47662, 2.665033>
  }
  cone { // gaddur247
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -155.0*x
    translate  <0.0, -0.391963, 2.724945>
  }
  cone { // gaddur248
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate -115.0*x
    translate  <0.0, -0.53523, 2.580375>
  }
  cone { // gaddur249
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, -20.0>
    translate  <-0.072156, -0.464339, 2.665033>
  }
  cone { // gaddur250
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.3>
    rotate <-135.0, 0.0, 20.0>
    translate  <0.070621, -0.464339, 2.665033>
  }
  rotate -315.0*z
}
#declare kaktusnalg2 = union {
  cone { // gaddur251
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur252
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur253
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur254
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur255
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -45.0*z
}
#declare kaktusnalg3 = union {
  cone { // gaddur256
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur257
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur258
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur259
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur260
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -90.0*z
}
#declare kaktusnalg4 = union {
  cone { // gaddur261
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur262
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur263
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur264
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur265
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -135.0*z
}
#declare kaktusnalg5 = union {
  cone { // gaddur266
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur267
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur268
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur269
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur270
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -180.0*z
}
#declare kaktusnalg6 = union {
  cone { // gaddur271
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur272
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur273
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur274
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur275
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -225.0*z
}
#declare kaktusnalg7 = union {
  cone { // gaddur276
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur277
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur278
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur279
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur280
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -270.0*z
}
#declare kaktusnalg8 = union {
  cone { // gaddur281
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -155.0*x
    translate  <0.0, -0.230631, 2.736587>
  }
  cone { // gaddur282
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -135.0*x
    translate  <0.0, -0.305225, 2.688974>
  }
  cone { // gaddur283
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate -175.0*x
    translate  <0.0, -0.144926, 2.760394>
  }
  cone { // gaddur284
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, 20.0>
    translate  <0.036814, -0.222171, 2.736587>
  }
  cone { // gaddur285
    <0,0,0>, 0.0, <0,0,1>, 0.01
    material {
      nalar
    }
    scale <1.0, 1.0, 0.25>
    rotate <-155.0, 0.0, -20.0>
    translate  <-0.036446, -0.222171, 2.736587>
  }
  rotate -315.0*z
}
#declare kaktusnalar = union {
  object { kaktusnala1 }
  object { kaktusnalb1 }
  object { kaktusnalc1 }
  object { kaktusnald1 }
  object { kaktusnale1 }
  object { kaktusnalf1 }
  object { kaktusnalg1 }
  object { kaktusnalh }
  object { kaktusnala2 }
  object { kaktusnala3 }
  object { kaktusnala4 }
  object { kaktusnala5 }
  object { kaktusnala6 }
  object { kaktusnala7 }
  object { kaktusnala8 }
  object { kaktusnalb2 }
  object { kaktusnalb3 }
  object { kaktusnalb4 }
  object { kaktusnalb5 }
  object { kaktusnalb6 }
  object { kaktusnalb7 }
  object { kaktusnalb8 }
  object { kaktusnalc2 }
  object { kaktusnalc3 }
  object { kaktusnalc4 }
  object { kaktusnalc5 }
  object { kaktusnalc6 }
  object { kaktusnalc7 }
  object { kaktusnalc8 }
  object { kaktusnald2 }
  object { kaktusnald3 }
  object { kaktusnald4 }
  object { kaktusnald5 }
  object { kaktusnald6 }
  object { kaktusnald7 }
  object { kaktusnald8 }
  object { kaktusnale2 }
  object { kaktusnale3 }
  object { kaktusnale4 }
  object { kaktusnale5 }
  object { kaktusnale6 }
  object { kaktusnale7 }
  object { kaktusnale8 }
  object { kaktusnalf2 }
  object { kaktusnalf3 }
  object { kaktusnalf4 }
  object { kaktusnalf5 }
  object { kaktusnalf6 }
  object { kaktusnalf7 }
  object { kaktusnalf8 }
  object { kaktusnalg2 }
  object { kaktusnalg3 }
  object { kaktusnalg4 }
  object { kaktusnalg5 }
  object { kaktusnalg6 }
  object { kaktusnalg7 }
  object { kaktusnalg8 }
}
union { // kaktusinn
  object { pottur }
  cone { // moldin
    <0,0,0>, 0.6, <0,0,1>, 0.8
    material {
      mold
    }
    scale <1.0, 1.0, 1.7>
    translate  -1.0*z
  }
  object { kaktus }
  object { pottaskal }
  object { kaktusnalar }
  translate  <4.539026, -2.662179, 19.01309>
}


#declare handfang = difference {
  superellipsoid { // SuperQ001
    <0.4, 0.3>
    material {
      plast
    }
    scale <2.5, 9.5, 1.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      plast
    }
    scale <1.2, 1.2, 3.0>
    translate  <0.0, -7.4, -1.5>
  }
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -5.5*y
  }
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -4.5*y
  }
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -3.5*y
  }
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -2.5*y
  }
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -1.5*y
  }
  torus { // Torus008
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  -0.5*y
  }
  torus { // Torus009
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  0.5*y
  }
  torus { // Torus010
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  1.5*y
  }
  torus { // Torus011
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  2.5*y
  }
  torus { // Torus012
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  3.5*y
  }
  torus { // Torus013
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  4.5*y
  }
  torus { // Torus014
    1.5, 0.5  rotate -x*90
    material {
      plast
    }
    scale <2.55, 0.8, 0.5>
    rotate -90.0*x
    translate  5.5*y
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      plast
    }
    scale 2.0
    translate  <0.0, 7.4, 2.4>
  }
  sphere { // Sphere004
    <0,0,0>,1
    material {
      plast
    }
    scale 2.0
    translate  <0.0, 7.4, -2.4>
  }
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.780860, 0.000000>, <-1.000000, -0.552472, 0.000000>, <1.000000, -0.552472, 0.000000>, <1.000000, 0.780861, 0.000000>, 
      <-1.000000, -0.000002, 2.000000>, <-1.000000, -1.333333, 2.000000>, <1.000000, -1.333333, 2.000000>, <1.000000, -0.000000, 2.000000>, 
      <-1.000000, -0.000002, 4.000000>, <-1.000000, -1.333333, 4.000000>, <1.000000, -1.333333, 4.000000>, <1.000000, -0.000000, 4.000000>, 
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.780861, 0.000000>, <1.000000, 2.114194, 0.000000>, <-1.000000, 2.114191, 0.000000>, <-1.000000, 0.780860, 0.000000>, 
      <1.000000, -0.000000, 2.000000>, <1.000000, 1.333333, 2.000000>, <-1.000000, 1.333330, 2.000000>, <-1.000000, -0.000002, 2.000000>, 
      <1.000000, -0.000000, 4.000000>, <1.000000, 1.333333, 4.000000>, <-1.000000, 1.333330, 4.000000>, <-1.000000, -0.000002, 4.000000>, 
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>, 
      <-1.000000, -0.000002, 8.000000>, <-1.000000, -1.333333, 8.000000>, <1.000000, -1.333333, 8.000000>, <1.000000, -0.000000, 8.000000>, 
      <-1.000000, -0.000002, 10.000000>, <-1.000000, -1.333333, 10.000000>, <1.000000, -1.333333, 10.000000>, <1.000000, -0.000000, 10.000000>, 
      <-1.000000, -0.000002, 12.000000>, <-1.000000, -1.333333, 12.000000>, <1.000000, -1.333333, 12.000000>, <1.000000, -0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>, 
      <1.000000, -0.000000, 8.000000>, <1.000000, 1.333333, 8.000000>, <-1.000000, 1.333330, 8.000000>, <-1.000000, -0.000002, 8.000000>, 
      <1.000000, -0.000000, 10.000000>, <1.000000, 1.333333, 10.000000>, <-1.000000, 1.333330, 10.000000>, <-1.000000, -0.000002, 10.000000>, 
      <1.000000, -0.000000, 12.000000>, <1.000000, 1.333333, 12.000000>, <-1.000000, 1.333330, 12.000000>, <-1.000000, -0.000002, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.000002, 12.000000>, <-1.000000, -1.333333, 12.000000>, <1.000000, -1.333333, 12.000000>, <1.000000, -0.000000, 12.000000>, 
      <-1.000000, -0.000002, 14.000000>, <-1.000000, -1.333333, 14.000000>, <1.000000, -1.333333, 14.000000>, <1.000000, -0.000000, 14.000000>, 
      <-1.000000, -0.325361, 17.366507>, <-1.000000, -1.658692, 17.366507>, <1.000000, -1.658692, 17.366507>, <1.000000, -0.325359, 17.366507>, 
      <-1.000000, -1.388065, 18.642368>, <-1.000000, -2.717628, 18.542182>, <1.000000, -2.717628, 18.542182>, <1.000000, -1.388064, 18.642368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.000000, 12.000000>, <1.000000, 1.333333, 12.000000>, <-1.000000, 1.333330, 12.000000>, <-1.000000, -0.000002, 12.000000>, 
      <1.000000, -0.000000, 14.000000>, <1.000000, 1.333333, 14.000000>, <-1.000000, 1.333330, 14.000000>, <-1.000000, -0.000002, 14.000000>, 
      <1.000000, -0.325359, 17.366507>, <1.000000, 1.007974, 17.366507>, <-1.000000, 1.007971, 17.366507>, <-1.000000, -0.325361, 17.366507>, 
      <1.000000, -1.388064, 18.642368>, <1.000000, -0.058500, 18.742554>, <-1.000000, -0.058503, 18.742554>, <-1.000000, -1.388065, 18.642368>
    }
  }
  material {
    plast
  }
  scale <1.7, 0.7, 1.0>
  rotate -108.959526*x
  translate  <0.0, 9.151793, 0.524658>
}
#declare CSG005 = union {
  cone { // Cone001
    <0,0,0>, 2.5, <0,0,1>, 3.0
    material {
      plast
    }
    scale <1.0, 1.0, 8.0>
    rotate -68.0*x
    translate  <0.0, 26.301856, -4.747955>
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      plast
    }
    scale 3.1
    rotate -68.0*x
    translate  <0.013236, 33.749277, -1.735717>
  }
}
#declare nedrihaus = difference {
  object { CSG005 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      plast
    }
    scale <5.0, 2.0, 10.0>
    rotate -68.0*x
    translate  <0.364496, 34.035236, 0.0>
  }
  rotate -11.667695*x
  translate  <0.0, 1.924689, 6.1>
}
#declare uburstinn = union {
  object { handfang }
  object { BezPtch001 }
  object { nedrihaus }
  rotate -10.280944*x
}
// Include contains 'TransSweep001'
#include "hkadrop.i10"

#declare TransSweep001 = object {
  TransSweep001_Raw
  material {
    plast
  }
  scale <1.0, 1.0, 0.5>
  translate  <0.0, -0.138154, -9.104564>
}
#declare hara1 = union {
  cylinder { // har1
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har2
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har3
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har4
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har5
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 0.28677, -0.063727>
}
#declare hara2 = union {
  cylinder { // har6
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har7
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har8
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har9
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har10
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 1.38287, -0.123205>
}
#declare hara3 = union {
  cylinder { // har11
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har12
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har13
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har14
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har15
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 2.417368, -0.182683>
}
#declare hara4 = union {
  cylinder { // har16
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har17
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har18
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har19
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har20
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 3.547455, -0.244286>
}
#declare hara5 = union {
  cylinder { // har21
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har22
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har23
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har24
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har25
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 4.586201, -0.303764>
}
#declare hara6 = union {
  cylinder { // har26
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har27
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har28
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har29
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har30
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 5.588835, -0.333503>
}
#declare hara7 = union {
  cylinder { // har31
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har32
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har33
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har34
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har35
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  translate  <0.0, 6.695556, -0.361118>
}
#declare hara8 = union {
  cylinder { // har36
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har37
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har38
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har39
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har40
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 10.0*x
  translate  <0.0, 6.364177, -4.949443>
}
#declare hara9 = union {
  cylinder { // har41
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har42
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har43
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har44
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har45
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 20.0*x
  translate  <0.0, 6.586694, -9.379011>
}
#declare hara10 = union {
  cylinder { // har46
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har47
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har48
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har49
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har50
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 40.0*x
  translate  <0.0, 8.743309, -18.378792>
}
#declare hara11 = union {
  cylinder { // har51
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har52
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har53
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har54
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har55
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, -0.223044, 0.370555>
}
#declare hara13 = union {
  cylinder { // har61
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har62
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har63
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har64
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har65
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 2.007392, 0.383405>
}
#declare hara12 = union {
  cylinder { // har56
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har57
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har58
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har59
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har60
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 0.860311, 0.415268>
}
#declare hara14 = union {
  cylinder { // har66
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har67
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har68
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har69
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har70
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 2.995157, 0.383405>
}
#declare hara15 = union {
  cylinder { // har71
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har72
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har73
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har74
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har75
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 3.982921, 0.351541>
}
#declare hara16 = union {
  cylinder { // har76
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har77
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har78
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har79
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har80
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 5.161866, 0.351541>
}
#declare hara17 = union {
  cylinder { // har81
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har82
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har83
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har84
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har85
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 15.0*y
  translate  <1.535151, 6.022177, 0.287814>
}
#declare hara18 = union {
  cylinder { // har86
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har87
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har88
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har89
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har90
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <5.0, 15.0, 0.0>
  translate  <0.741399, 6.406965, -1.827496>
}
#declare hara19 = union {
  cylinder { // har91
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har92
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har93
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har94
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har95
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <15.0, 15.0, 0.0>
  translate  <-0.254065, 6.486618, -6.192777>
}
#declare hara20 = union {
  cylinder { // har96
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har97
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har98
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har99
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har100
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, -0.223044, 0.436103>
}
#declare hara21 = union {
  cylinder { // har101
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har102
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har103
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har104
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har105
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 0.860311, 0.436103>
}
#declare hara22 = union {
  cylinder { // har106
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har107
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har108
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har109
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har110
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 2.007392, 0.340513>
}
#declare hara23 = union {
  cylinder { // har111
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har112
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har113
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har114
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har115
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 2.963293, 0.372376>
}
#declare hara24 = union {
  cylinder { // har116
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har117
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har118
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har119
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har120
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 3.982921, 0.372376>
}
#declare hara25 = union {
  cylinder { // har121
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har122
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har123
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har124
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har125
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 5.161866, 0.308649>
}
#declare hara26 = union {
  cylinder { // har126
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har127
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har128
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har129
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har130
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -15.0*y
  translate  <-1.677409, 6.05404, 0.276786>
}
#declare hara27 = union {
  cylinder { // har131
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har132
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har133
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har134
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har135
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <5.0, -15.0, 0.0>
  translate  <-0.721939, 6.500127, -1.851653>
}
#declare hara28 = union {
  cylinder { // har136
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har137
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har138
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har139
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har140
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <15.0, -15.0, 0.0>
  translate  <0.225712, 6.661083, -6.192777>
}
#declare hara29 = union {
  cylinder { // har141
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har142
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har143
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har144
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har145
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.395297, 0.28677, 0.008189>
}
#declare hara30 = union {
  cylinder { // har146
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har147
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har148
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har149
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har150
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.286257, 1.370125, 0.103779>
}
#declare hara31 = union {
  cylinder { // har151
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har152
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har153
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har154
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har155
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.242131, 2.389753, 0.119777>
}
#declare hara32 = union {
  cylinder { // har156
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har157
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har158
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har159
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har160
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.176197, 3.473107, 0.119777>
}
#declare hara33 = union {
  cylinder { // har161
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har162
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har163
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har164
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har165
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.154389, 4.588325, 0.046505>
}
#declare hara34 = union {
  cylinder { // har166
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har167
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har168
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har169
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har170
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.045349, 5.57609, 0.065596>
}
#declare hara35 = union {
  cylinder { // har171
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har172
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har173
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har174
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har175
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate 30.0*y
  translate  <3.023541, 6.711418, 0.09114>
}
#declare hara36 = union {
  cylinder { // har176
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har177
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har178
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har179
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har180
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <10.0, 30.0, 0.0>
  translate  <0.995593, 6.791907, -4.048217>
}
#declare hara37 = union {
  cylinder { // har181
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har182
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har183
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har184
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har185
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 0.28677, 0.08286>
}
#declare hara38 = union {
  cylinder { // har186
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har187
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har188
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har189
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har190
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 1.370125, 0.08286>
}
#declare hara39 = union {
  cylinder { // har191
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har192
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har193
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har194
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har195
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 2.389753, 0.114723>
}
#declare hara40 = union {
  cylinder { // har196
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har197
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har198
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har199
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har200
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 3.473107, 0.146587>
}
#declare hara41 = union {
  cylinder { // har201
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har202
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har203
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har204
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har205
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 4.588325, 0.019133>
}
#declare hara42 = union {
  cylinder { // har206
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har207
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har208
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har209
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har210
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 5.57609, 0.114723>
}
#declare hara43 = union {
  cylinder { // har211
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har212
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har213
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har214
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har215
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate -30.0*y
  translate  <-3.053598, 6.786898, 0.114723>
}
#declare hara44 = union {
  cylinder { // har216
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har217
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har218
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har219
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har220
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <10.0, -30.0, 0.0>
  translate  <-1.108265, 6.922755, -4.048217>
}
#declare hara45 = union {
  cylinder { // har221
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har222
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har223
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har224
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har225
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <-163.823868, -209.855804, -192.992584>
  translate  <-6.029006, 7.756813, -6.881944>
}
#declare hara46 = union {
  cylinder { // har226
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    translate  <0.0, 26.588566, -13.554291>
  }
  cylinder { // har227
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*x
    translate  <0.0, 26.242885, -13.509102>
  }
  cylinder { // har228
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*x
    translate  <0.0, 26.903967, -13.51814>
  }
  cylinder { // har229
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate -5.0*y
    translate  <0.349878, 26.588566, -13.515143>
  }
  cylinder { // har230
    <0,0,1>, <0,0,0>, 1 
    material {
      har
    }
    scale <0.05, 0.05, 2.5>
    rotate 5.0*y
    translate  <-0.334974, 26.588566, -13.500238>
  }
  rotate <-138.707977, -181.578308, -217.71698>
  translate  <-15.705104, 14.715627, -18.92415>
}
union { // upptvottabursti
  object { uburstinn }
  object { TransSweep001 }
  object { hara1 }
  object { hara2 }
  object { hara3 }
  object { hara4 }
  object { hara5 }
  object { hara6 }
  object { hara7 }
  object { hara8 }
  object { hara9 }
  object { hara10 }
  object { hara11 }
  object { hara13 }
  object { hara12 }
  object { hara14 }
  object { hara15 }
  object { hara16 }
  object { hara17 }
  object { hara18 }
  object { hara19 }
  object { hara20 }
  object { hara21 }
  object { hara22 }
  object { hara23 }
  object { hara24 }
  object { hara25 }
  object { hara26 }
  object { hara27 }
  object { hara28 }
  object { hara29 }
  object { hara30 }
  object { hara31 }
  object { hara32 }
  object { hara33 }
  object { hara34 }
  object { hara35 }
  object { hara36 }
  object { hara37 }
  object { hara38 }
  object { hara39 }
  object { hara40 }
  object { hara41 }
  object { hara42 }
  object { hara43 }
  object { hara44 }
  object { hara45 }
  object { hara46 }
  scale 0.12
  rotate <198.336594, -207.037018, 95.78904>
  translate  <-2.844106, -0.304258, 15.499629>
}


superellipsoid { // ismoli
  <0.5, 0.5>
  material {
    klaki
  }
  scale 0.3
  rotate <-0.0, -4.46697, 0.0>
  translate  <-2.584587, 5.265389, 18.462082>
}


union { // ledurstoll
  superellipsoid { // SuperQ002
    <1.0, 4.0>
    material {
      krom1
    }
    scale 5.0
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      krom1
    }
    scale <0.5, 0.5, 15.0>
  }
  superellipsoid { // seta
    <1.0, 0.3>
    material {
      ledur
    }
    scale <4.0, 4.0, 2.0>
    translate  <0.077505, 0.0, 16.0>
  }
  scale 0.9
  translate  <-15.276461, 30.954934, 0.0>
}


