#include "clock.inc"
#include "cube.inc" 

#declare earth_radius = 180000; 
#declare sun_distance = 1000000;
#declare latitude = 20;

#declare water_tex = texture
{
        pigment
        {
                color rgbt< 0, 0.5, 1, 0.5 >
        }
        finish
        {
                reflection 0.5 
                phong 0.7  
                ambient 0.0
        }
        normal
        {
                waves 0.06
                frequency 50000.0
                scale 10
                turbulence 3 
                omega 1.2
        }
}

#declare solid_tex = texture
{
        pigment
        {
                color rgb< 0, 0, 1 >
        }
        finish
        {
                ambient 0.0
        }
}

#declare iced_clock = union
{  
        object
        {
                ice_cube
        }
        
        
        object
        {
                theclock
                translate< 0, 0.5, 0 >
                rotate< 30, 0, 0 >
                rotate< 0, -20, 0 >
        }

        rotate< 0, -20, 0 >        
        rotate< -38, 0, 0 >

        translate< 0, -0.5, 0 >  
} 

#declare sun_material = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {
                        emission rgb < 0.12, 0.07, 0.03 >
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 1000.0  rgb <0.5, 0.5, 0.5> ]
                                }
                                turbulence 0.01
                                triangle_wave
                        }
                }
        }
}

#declare atmosphere_material = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {       
                        scattering
                        { 
                                    1
                                    rgb<2, 3, 5>
                                    extinction 0
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 10000.0  rgb <1.0, 1.0, 1.0> ]
                                }
                        }
                }
        }
}

#declare scene = union
{
        sphere
        {
                <0, 0, 0 >,1
                material{ atmosphere_material }
                scale 1.1   
                hollow
                scale earth_radius
        }
        difference
        {
                union
                {       
                        sphere
                        {
                                <0, 0, 0 >,1
                                hollow
                                texture{ water_tex }
                        } 
                        sphere
                        {
                                <0, 0, 0 >,1
                                texture{ solid_tex }
                                scale 0.99999
                        }
                        
                        scale earth_radius
                } 
                object
                {
                        iced_clock
                        translate< 0, earth_radius, 0 >
                }   
        } 
        union
        {
                object
                {
                        iced_clock
                }
                light_source
                {
                        <0, 0, 0 >
                        color rgb< 0.5, 0.5, 0.5 >
                        
                        translate< 0, 0, -20 >   
                        
                        fade_distance 20
                        fade_power 3

                        
                }
                translate< 0, earth_radius, 0 >
                rotate< latitude, 0, 0 >
        }
        
        translate< 0, 0, -sun_distance >
} 

#declare sun = sphere
{
        <0, 0, 0 >, 1 
        material{ sun_material }
        scale 100000
              
        hollow
}
