//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002

//	Draw a mortar/stucco encrusted brick wall
//	0,0,0 is the bottom left corner - modified stucco to go 1.0' down
//	Brick starts left to ensure random pattern in image

#include "functions.inc"

#macro BrickWall(WallWidth, WallHeight, Full)  		

#local RBrick = seed(2);  //  2
#local WallScale = <3,2,3>;  //  3,2,3
#local WallTrans = <8, 0, 0>;  //  Change raised stucco pattern by translating 
#local STurbulence = 0.3;  //  was 0.3

#if ( Full = 1 )
	#local DoBricks = 0;
#else
	#local DoBricks = 1;
#end

//	Stucco pigment

#local StuccoPigment =
pigment {
	wrinkles  
      color_map {
		[ 0.00 color rgb <1.0, 0.55, 0.30>*0.8 ]  //  Orange  // -Deep
		[ 0.35 color rgb <1.0, 0.80, 0.50>*0.8 ]  //  Peach
        [ 0.85 color rgb <0.9, 0.90, 0.90>*0.8 ]  //  Light gray
        [ 1.00 color rgb <0.9, 0.90, 0.90>*0.8 ]  //  White  //  -Bumps
                 }
	warp { turbulence STurbulence }
	scale WallScale  translate WallTrans
           }  //  end of pigment

//	Load the mushroom cloud image

#declare MushroomPigment =
  pigment {
    image_map {
        gif "Mushroom3.gif" 

//        once (big image, so not necessary - isosurface needs full coverage)
        map_type 0
        interpolate 2
               }
    scale < 9.5, 6.0, 1.0 >
	translate <0, -0.1, 0>  //  lower left corner of image at top of baseboard

	translate <-WallWidth*0.5, 0.0, -WallWidth*0.5>
	rotate -45*y
           }

//	Brick pigment

#local BrickPigment =
pigment {

    crackle
    color_map {

//      Reddish-yellow gray, colored by stucco color

      [0.000 color rgb <0.20, 0.20, 0.2>*0.8]
      [0.005 color rgb <0.45, 0.35, 0.3>*0.8]
      [0.100 color rgb <1.00, 0.95, 0.9>*0.8]
      [0.200 color rgb <0.75, 0.65, 0.6>*0.8]
      [0.400 color rgb <0.45, 0.35, 0.3>*0.8]

//      Following colors are not seen in color map:

      [0.52 color rgb <0.45, 0.3, 0.2>]  //  few
      [0.54 color rgb <0.15, 0.1, 0.1>]  //  Black cracks
      [0.55 color rgb <0.35, 0.2, 0.1>]  //  Gray cracks
      [0.56 color rgb <0.15, 0.1, 0.1>]  //  Black cracks
      [0.58 color rgb <0.95, 0.8, 0.7>]  //

      [0.60 color rgb <0.65, 0.6, 0.5>]  // few
      [0.80 color rgb <1.00, 0.8, 0.7>]  // few
      [1.00 color rgb <0.40, 0.4, 0.6>]  // few

               }

  scale <100, 50, 100>  //  Each brick has a very dominant color

       turbulence 1.0
       octaves 8        //  6   fuzzy   8 sharper
       lambda 2.8       //  2.0 fuzzy 2.8 more swirly
       omega 0.6        //  0.5 fuzzy 0.6 crinkly

          }  //  end of pigment

//		Dark water stains at base (in feet)
//		(ligher for Shadow wall)

#local StreakyGreenPigment =
  pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.05, 0.15, 0.0, 1.0>]
      [0.10 color rgbt <0.00, 0.15, 0.0, 0.6>]
      [0.25 color rgbt <0.05, 0.10, 0.0, 1.0>]
      [0.37 color rgbt <0.00, 0.10, 0.0, 0.6>]
      [0.63 color rgbt <0.05, 0.15, 0.0, 1.0>]
      [0.75 color rgbt <0.00, 0.15, 0.0, 0.6>]
      [0.90 color rgbt <0.05, 0.10, 0.0, 1.0>]
      [1.00 color rgbt <0.00, 0.10, 0.0, 0.6>]
               }
      scale <15., 15., 15.>
       turbulence 1.00
       lambda 2.8
       omega 0.6
       octaves 8
           }

#local StreakyClearPigment =
  pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.20, 0.15, 0.00, 1.0>]  
      [1.00 color rgbt <0.20, 0.15, 0.00, 1.0>]
               }

      scale 10 

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           } 

#local BlackWater = pigment { color rgbt <0, 0.02, 0, 0> } 
#local GrayStain = pigment { color rgbt <0.01, 0.03, 0.0, 0.6> } 

//      Water mark fades as it nears the top (scaled to 1/10 foot)
//      Green tint for color

#local OneWaterStains =
texture {
	pigment {
		gradient y
		pigment_map {
//       		[0.00 BlackWater ]  //  bottom is black
       		[0.00 GrayStain ]  //  bottom is gray
       		[0.03 StreakyGreenPigment  scale 0.05 ]
       		[0.06 StreakyGreenPigment  scale 0.10 ]
       		[0.12 StreakyClearPigment  scale 0.15 ] 
       		[0.80 StreakyClearPigment  scale 0.20 ] 
       		[1.00 GrayStain ]  //  top
             		 }
    scale 10.0  //  scale to fit the wall
	translate <2, 0, 0>
        	}
	    }

//		Transparent version of stucco colors for brick overlay

#macro StuccoTrans(Trans)
		pigment {
			wrinkles  
      		color_map {
				[ 0.00 color rgbt <1.0, 0.55, 0.30, Trans> ]  //  Orange  // -Deep
				[ 0.30 color rgbt <1.0, 0.80, 0.50, Trans> ]  //  Peach
        		[ 0.80 color rgbt <1.0, 1.00, 1.00, Trans> ]  //  White
        		[ 1.00 color rgbt <1.0, 1.00, 1.00, Trans> ]  //  White  //  -Bumps
                 	   }
	warp { turbulence STurbulence }
	scale WallScale  translate WallTrans
           		}  //  end of pigment
#end

//*******************************************************************

//		Wall size

#local DiagSize = WallWidth*0.5*1.4142;

//	Draw the whole thing in a union

union {

#if ( Full > 0 )

//	Define functions

#local IStucco1 =  function { pigment { wrinkles  	
								scale WallScale  translate WallTrans
							  	warp { turbulence STurbulence }  //  small wrinkles, 60% slower
									   } 
							}
#local IStucco2 =  function { pigment { wrinkles  
								scale WallScale 
								translate WallTrans } }

#local MushroomF = function { pigment { MushroomPigment } }

#local SmallGraniteNormal = normal { granite 0.4  scale 0.2 } 
#local	 BigGraniteNormal = normal { granite 0.3  scale 0.8 } 

//		The Stucco wall (mortar)

#local Stucco  = function { abs(x) + abs(z) - DiagSize }  //  square box, drawn rotated 45 degrees

#if ( Full > 0 )
	difference {
#else
	union {
#end

isosurface {
	function { Stucco(x,y,z) -  IStucco1(x,y,z).gray*0.300   // 0.30   0.25 is nice also, smooth
							 - MushroomF(x,y,z).gray*0.045 }  //  0.040 is just visible
	max_gradient 3
	contained_by { box { <-DiagSize-0.45, -1.0, -DiagSize-0.45>, 
					     < DiagSize+0.45, WallHeight, DiagSize+0.45>} }
		    }

//		Take out the door and window holes

#if ( Full > 0 )

	union {

//	Window

	box { <1, 3.78, -1>, <4, 10, 2> } 

//	Circle top door

	cylinder { <11, 5, -1>, <11, 5, 7>, 2 }
	box { <9, -0.5, -1.0>, <13, 5, 7> }

//	Rotate to match diagonal isosurface

	translate <-WallWidth*0.5, 0.0, -WallWidth*0.5>
	rotate -45*y

		}  //  end of hole union
#end

	texture {

		pigment { StuccoPigment } 
//		pigment { MushroomPigment }  //  For test purposes

//		normal { granite 0.3  scale 0.2 }

		normal {
			average 
			normal_map {
				[ 1.0 SmallGraniteNormal ]
				[ 1.0 BigGraniteNormal ]
						}
				}

			}  //  end of primary stucco texture

//		Add dark water stains

	texture { OneWaterStains }

	rotate 45*y
	translate <WallWidth*0.5, 0.0, WallWidth*0.5>

	   }  //  end of Stucco wall difference/union

//		Declare a surface for trace to use 
//		(slightly different from actual wall - no turbulence)

#local StuccoSurface = isosurface {
	function { Stucco(x,y,z) - IStucco2(x,y,z).gray*0.23 }  // was 0.21  0.16 is nice, smooth
	max_gradient 3.0
	contained_by { box { <-DiagSize-0.4,-1.0, -DiagSize-0.4>, 
						 < DiagSize+0.4, WallHeight, DiagSize+0.4>} }
	rotate 45*y
	translate <WallWidth*0.5, 0.0, WallWidth*0.5>
		    						 }

//		The Bricks 

#if (DoBricks > 0 ) 

#local RowCount = 0;
#local ColCount = 0;  

#while ( RowCount < WallHeight )
#while ( ColCount < WallWidth )

//	Skip bricks inside door

#local Skip = 0;
#local DistS1 = sqrt( ((ColCount - 11)*(ColCount - 11  )) +
					  ((RowCount -  5)*(RowCount -  5)) ); 

#if ( DistS1 < 2.7 )  //  Door is 2.0, but arch is 0.5 
	#local Skip = 1;
#end

//	Skip bricks inside square part of door 8.35 is the start

#if ( ColCount > 8.05 &  RowCount < 5 )  //  Door is 9.0, but pillar is 0.5
	#local Skip = 1;
#end

//	Skip bricks inside window

#if ( ColCount < 3.8  &  ColCount > 0.9  &  RowCount > 3.7  )
	#local Skip = 1;
#end

//	Skip bricks here

#if ( Skip = 0 ) 

//	A partly random brick surface scale

#local GraniteSize = 0.80 + (rand(RBrick)*1.2);

//	Brick length tends toward 0.5' and shorter...

#local TempRand = rand(RBrick);
#if ( rand(RBrick) > 0.6 )
	#local BrickLength = 0.25 + (TempRand*TempRand*TempRand*0.15);
#else
	#local BrickLength = 0.25 - (TempRand*TempRand*TempRand*0.15);
#end

//	Short bricks to the left of window

#if ( ColCount < 4  &  ColCount > 0.5  &  RowCount > 3.7  )
	#local BrickLength = BrickLength*0.3;
#end

//	Brick and brick surface functions

#local Brick = 	function { f_rounded_box(x,y,z, 0.02, BrickLength, 0.075, 0.4) }
#local BrickGranite = function { pigment { 
									granite  
										scale <GraniteSize, GraniteSize, 0.50>
										translate <RowCount,ColCount,0> } } 

//		Locate the brick using trace()

#local Norm = <0, 0, 0>; 
#local Inter = trace ( StuccoSurface, 
					<ColCount + BrickLength, RowCount, -1.0>, 
					<0,0,1>, Norm ); 

//		Draw the brick

object {
isosurface {
	function { Brick(x,y,z) + BrickGranite(x,y,z).gray*0.025 }
	max_gradient 2.0
	contained_by { box { <-BrickLength, -0.075, -0.4>, <BrickLength, 0.075, 0.4>} }

//	If surface found, place brick on it (probably always found)

#if (vlength(Norm) != 0)
	translate Inter
#else 
	translate <ColCount + BrickLength, RowCount, 0.19 + ((rand(RBrick)-0.5)*0.05) >
#end

	translate <-WallWidth*0.5, 0.0, -WallWidth*0.5 + 0.35 >  //  The 0.35 is to put almost flush
	rotate -45*y

		    }

//	Each brick has a texture/color

	texture { 
		pigment {
			BrickPigment
			scale(rand(RBrick) + 1.0)
			translate <rand(RBrick)*10.0, rand(RBrick)*10.0, rand(RBrick)*10.0>
				}
		normal { granite 0.2  scale 0.4 }
			}	

//		Transparent version of stucco pattern

	texture {
		StuccoTrans(0.5)
		normal { granite 0.2  scale 0.4 }
			 }

//		Water stains

	texture { OneWaterStains }

//		Position to stucco isosurface

	rotate 45*y
	translate <WallWidth*0.5, 0.0, WallWidth*0.5>

	   }

//	Undeclare inside loop functions

#undef Brick
#undef BrickGranite

#end  //  end of skip

//	Space the bricks tightly together (side to side)

#local TempRand = rand(RBrick);
#local MortarLength = TempRand*TempRand*TempRand*TempRand*TempRand*0.030;  //  was 0.020 (gap between)

#local ColCount = ColCount + BrickLength*2 - MortarLength;

#end

#local ColCount = -rand(RBrick)*0.5;  //  Random placing of left bricks

//	Space the bricks touching each other (0.7*2 - 0.05 - 0.05)
//	Use the last brick's mortarlength to determine extra height

#local RowCount = RowCount + 0.13 + MortarLength*0.3;  //  was "+ 0.14" for .16' high

#end  //  of the Bricks 

#end //  of DoBricks

//		Fast rendering/test version

#else

//	Diagonal box to emulate the iso box

difference {

object {
	box { <-WallWidth*0.5, -1.0, -WallWidth*0.5>, 
		  < WallWidth*0.5,  WallHeight, WallWidth*0.5> }
	rotate -45*y
	texture {
		pigment { StuccoPigment }
//		pigment { MushroomPigment }  //  For testing image map
		normal { granite 0.3  scale 0.2 }
			 }
	rotate 45*y
	translate <WallWidth*0.5, 0.0, WallWidth*0.5>
		}

//		Holes for a door and a window

union {

//		Window

	box { <1, 3.8, -1>, <4, 9, 2> } 

//	Circle top door

	cylinder { <11, 5, -1>, <11, 5, 2>, 2 }
	box { <9, -1.0, -1.0>, <13, 5, 2.0> }

	pigment { color rgb 1 }
	   }

			}  //  end of difference

#end

	   }  //  end of Brick Wall union

#end