// Persistence of Vision Ray Tracer Scene Description File
// File: jgperspe.pov
// Vers: 3.5
// Desc: Entry for IRTC December 2002 
// Date: 29 December 2002
// Auth: John Guthkelch (Doctor John) <jguthkelch[at]netscape[dot]net>

/**********************READ THIS*******IMPORTANT**********************
*                                                                    *
*     You _must_ turn off Vista Buffers by using -uv on the          *
*     command line before attempting to render this file.            *
*                                                                    *
*********************************************************************/

#version 3.5;

global_settings {
	assumed_gamma 1.0
	max_trace_level 15
}

// A macro that simulates a true architectural field camera. No longer do 
// you have to ensure that the camera location/look_at vector is parallel to 
// the XY or YZ planes before shearing the camera to get parallel verticals.

#macro FieldCam (CP, CL)
	#local CD=CL-CP;
	#local HypoXZ=sqrt(pow(CD.x, 2)+pow(CD.z, 2));
	#local CosThetaX=CD.x/HypoXZ;
	#local CosThetaZ=CD.z/HypoXZ;
	#if (CD.x=0)
		#local ShearX=0;
	#else
		#local ShearX=(CD.y/CD.x)*pow(CosThetaX, 2);
	#end
	#if (CD.z=0)
		#local ShearZ=0;
	#else
		#local ShearZ=(CD.y/CD.z)*pow(CosThetaZ, 2);
	#end
	#declare NoFall=transform {
		matrix <1, 0, 0, ShearX, 1, ShearZ, 0, 0, 1, 0, 0, 0>
	}
#end

#declare CamPos=<-4, 4, -10>;
#declare CamLook=<1, 0, 0>;

camera {
	FieldCam (CamPos, CamLook)
	perspective
	location CamPos
	transform { NoFall }
	look_at CamLook				
}

light_source {
	<-400, 200, 400>
	rgb 2
	area_light x*50, y*50, 5, 5
	adaptive 1
}

light_source {
	<200, 100, -500>
	rgb <0.4, 0.5, 0.6>
	shadowless
}

#include "starfield.inc"

// An infinity box delineated with white cylinders. Inspired by
// a friend's explanation of quartz crystal vibration and atomic
// lattices.

union {
	union {
		box {<-1, 0,-1>, < 1, 2, 1>
			texture {
				pigment {
					colour rgbf 1
				}
			}
			interior_texture {
				pigment {
					colour rgb 0
				}
				finish {
					reflection 0.99
				}
			}
			no_shadow
		}
		cylinder {<-1, 0,-1>, < 1, 0,-1>, 0.05}
		cylinder {< 1, 0,-1>, < 1, 0, 1>, 0.05}
		cylinder {< 1, 0, 1>, <-1, 0, 1>, 0.05}
		cylinder {<-1, 0, 1>, <-1, 0,-1>, 0.05}
		cylinder {<-1, 2,-1>, < 1, 2,-1>, 0.05}
		cylinder {< 1, 2,-1>, < 1, 2, 1>, 0.05}
		cylinder {< 1, 2, 1>, <-1, 2, 1>, 0.05}
		cylinder {<-1, 2, 1>, <-1, 2,-1>, 0.05}
		cylinder {<-1, 0,-1>, <-1, 2,-1>, 0.05}
		cylinder {< 1, 0,-1>, < 1, 2,-1>, 0.05}
		cylinder {< 1, 0, 1>, < 1, 2, 1>, 0.05}
		cylinder {<-1, 0, 1>, <-1, 2, 1>, 0.05}
		sphere {<-1, 0,-1>, 0.05}
		sphere {< 1, 0,-1>, 0.05}
		sphere {< 1, 0, 1>, 0.05}
		sphere {<-1, 0, 1>, 0.05}
		sphere {<-1, 2,-1>, 0.05}
		sphere {< 1, 2,-1>, 0.05}
		sphere {< 1, 2, 1>, 0.05}
		sphere {<-1, 2, 1>, 0.05}
		texture {
			pigment {
				colour rgb 1
			}
		}
		rotate -y*20
		translate <1, -0.45, -6>
	}
	sphere {
		<0, 0, 0>, 0.3
		texture {
			pigment {
				colour rgb <1, 0, 0>
			}
			finish {
				diffuse 0.25
				brilliance 2
				specular 1
				roughness 0.01
				metallic
				ambient 0.3
			}
		}
		translate <1, -0.45, -6>
		no_shadow
	}
	sphere {
		<0, 0, 0>, 0.3
		texture {
			pigment {
				colour rgb < 0.5, 0.5, 0>
			}
			finish {
				diffuse 0.4
				brilliance 2
				specular 1
				roughness 0.01
				metallic
				ambient 0.3
			}
		}	
		translate <0, 1, 0.5>
		rotate -y*110
		translate <1, -0.65, -6>
		no_image
		no_shadow
	}
	scale 1
	translate <0, 0, 0.3>
}

// Macros for production of gear-wheels. Mainly the work of Marc Schimmler,
// modified by me whilst searching for a way to use them with isosurfaces.

#macro gear_fd (gear_z, gear_m, gear_flank, gear_alpha)
	#local gear_c=0.25*gear_m; 
	#local gear_p=gear_m*pi;
	#local gear_rt=gear_z*gear_m/2;
	#local gear_hf=gear_m+gear_c;
	#local gear_rk=gear_rt+gear_m;
	#local gear_rf=gear_rt-gear_hf;
	#local gear_rg=gear_rt*cos(radians(gear_alpha));
	#local gear_lo=-gear_flank/2;
	#local gear_hi=gear_flank/2;
	#local gear_th=gear_rk-gear_rg;
	union {
		cylinder {
			<0, gear_lo, 0>, < 0, gear_hi, 0>, gear_rf
		}
		#local _g_count = 0;
		#local _g_X=array[11]
		#local _g_Y=array[11]
		#local _g_xmax=0;
		#local _g_ymax=0;
		#local _g_ymin=1e+20;
		#local _g_tooth=object {
			union{ 
				#while (_g_count<10)
					#local g_inv_a=tan(radians(20))-radians(20);
					#local gear_ry0=gear_rk-(gear_th/10*_g_count);
					#local gear_ay0=acos(gear_rg/gear_ry0);
					#local g_inv_y0=tan(gear_ay0)-gear_ay0;
					#local gear_sy0=2*gear_ry0*((pi/2/gear_z)-g_inv_y0+g_inv_a);
					#local gear_ry1=gear_rk-(gear_th/10*(_g_count+1));
					#local gear_ay1=acos(gear_rg/gear_ry1);
					#local g_inv_y1=tan(gear_ay1)-gear_ay1;
					#local gear_sy1=2*gear_ry1*((pi/2/gear_z)-g_inv_y1+g_inv_a);
					#local g_p_1x=gear_ry0*sin(gear_sy0/2/gear_ry0);
					#local g_p_1y=gear_ry0*cos(gear_sy0/2/gear_ry0);
					#local g_p_2x=-gear_ry0*sin(gear_sy0/2/gear_ry0);
					#local g_p_2y=gear_ry0*cos(gear_sy0/2/gear_ry0);
					#local g_p_3x=-gear_ry1*sin(gear_sy1/2/gear_ry1);
					#local g_p_3y=gear_ry1*cos(gear_sy1/2/gear_ry1);
					#local g_p_4x=gear_ry1*sin(gear_sy1/2/gear_ry1);
					#local g_p_4y=gear_ry1*cos(gear_sy1/2/gear_ry1);
					#local _g_X[_g_count]=g_p_1x;
					#local _g_xmax=max(_g_xmax, abs(g_p_1x));
					#local _g_X[_g_count+1]=g_p_4x;
					#local _g_xmax=max(_g_xmax, abs(g_p_4x));
					#local _g_Y[_g_count]=g_p_1y;
					#local _g_ymax=max(_g_ymax, g_p_1y);
					#local _g_ymin=min(_g_ymin, g_p_1y);
					#local _g_Y[_g_count+1]=g_p_4y;
					#local _g_ymax=max(_g_ymax, g_p_4y);
					#local _g_ymin=min(_g_ymin, g_p_4y);
					#if (_g_count=0)
						difference {
							cylinder {
								<0, gear_lo, 0>, <0, gear_hi, 0>, gear_rk
							}
							#local g_rk_al=degrees(gear_sy0/2/gear_rk);
							plane {
								x, 0
								rotate <0, -g_rk_al, 0>
							}
							plane {
								-x, 0
								rotate <0, g_rk_al, 0>
							}
						}
					#end    
					#local _g_count=_g_count+1;                             
				#end
				#local g_foot_m=(g_p_1y-g_p_4y)/(g_p_1x-g_p_4x);
				#local g_p_5x=(0.75*gear_rf-g_p_4y)/g_foot_m+g_p_4x;
				#local g_p_5y=0.75*gear_rf;
				#local g_p_6x=-g_p_5x;
				#local g_p_6y=g_p_5y;
				#local _g_xmax=max(_g_xmax, abs(g_p_5x));
				#local _g_ymax=max(_g_ymax, g_p_5y);
				#local _g_ymin=min(_g_ymin, g_p_5y);
				prism{
					linear_sweep
					linear_spline
					gear_lo,
					gear_hi,
					25
					#local _g_count=0;
					#while (_g_count<11)
						<_g_X[_g_count],
						_g_Y[_g_count]>,
						#local _g_count=_g_count+1;
					#end
					<g_p_5x,g_p_5y>,
					<g_p_6x,g_p_6y>,
					#local _g_count=10;
					#while (_g_count>=0)
						<-_g_X[_g_count],
						_g_Y[_g_count]>,
						#local _g_count=_g_count-1;
					#end
					<_g_X[0],
					_g_Y[0]>
					bounded_by {
						box{<-_g_xmax, gear_lo, _g_ymin>, <_g_xmax, gear_hi, _g_ymax>}
					}
				}
			}
		}
		#local _g_count=0;
		#while (_g_count<gear_z)
			#local _g_ang=360/gear_z;
			object {
				_g_tooth
				rotate <0,_g_count*_g_ang,0>
			}
			#local _g_count=_g_count+1;
		#end
		bounded_by{
			cylinder {<0, gear_lo, 0>, <0, gear_hi, 0>, gear_rk}
		}
	}
	#declare gear_fd_lower_radius=gear_rf;
#end

#macro gear_cut(N, rmin, rmax, delta, rconge)
	union{
		difference{
			cylinder {-y, y, rmax-rconge}
			cylinder {-1.1*y, 1.1*y, rmin+rconge}
			plane {-x, delta/2 rotate 180/N*y}
			plane {x, delta/2 rotate -180/N*y}
		}
		#local a=180/pi*asin((rconge+delta/2)/(rconge+rmin));
		#local b=180/pi*asin((rconge+delta/2)/(rmax-rconge));
		difference{
			cylinder {-y, y, rmin+rconge}
			cylinder {-1.1*y, 1.1*y, rmin}
			plane {-x, 0 rotate (180/N-a)*y}
			plane {x, 0 rotate -(180/N-a)*y}
		}
		difference{
			cylinder {-y, y, rmax}
			cylinder {-1.1*y, 1.1*y, rmax-rconge}
			plane {-x, 0 rotate (180/N-b)*y}
			plane {x, 0 rotate -(180/N-b)*y}
		}
		cylinder {
			-y*1.0001, y*1.0001, rconge
			translate <0, 0, rmin+rconge>
			rotate (180/N-a)*y
		}
		cylinder {
			-y*1.0001, y*1.0001, rconge
			translate <0, 0, rmin+rconge>
			rotate -(180/N-a)*y
		}
		cylinder {
			-y*1.0001, y*1.0001, rconge
			translate <0, 0, rmax-rconge>
			rotate (180/N-b)*y
		}
		cylinder {
			-y*1.0001, y*1.0001, rconge
			translate <0, 0, rmax-rconge>
			rotate -(180/N-b)*y
		}
		bounded_by {
			cylinder {-y, y, rmax-rconge}
		}
	}
#end

#declare gear_seed1=seed(1);
#macro gear_wrapper(gear_z, gear_m, gear_flank, gear_alpha)
	#local r1min=0.01;
	difference{
		gear_fd(gear_z, gear_m, gear_flank, gear_alpha)
		#local rr=gear_fd_lower_radius;
		#local N=int(2+7*rand(gear_seed1));
		#local r1=max(rr*(.1+.3*rand(gear_seed1)), r1min*1.5);
		#local r2=rr*(.9-.3*rand(gear_seed1));
		#local rc=r1*(1+.5*rand(gear_seed1))/N;
		#local de=r1*(2+.5*rand(gear_seed1))/N;
		#local al=360*rand(gear_seed1);
		#local i=0;
		#while (i<N)
			object {
				gear_cut(N, r1, r2, de, rc)
				rotate (i*360/N+al)*y
			}
			#local i=i+1;
		#end
		#local rt1=r1min*1.5+rand(gear_seed1)*(r1-r1min*1.5);
		#local rt2=r2+rand(gear_seed1)*(.9*rr-r2);
		#local rt=min(rc, (rt2-rt1)/2);
		torus {
			rt2-rt, rt
			scale <1, gear_flank/4/rt, 1>
			translate gear_flank/2*y
		}
		torus {
			rt2-rt, rt
			scale <1, gear_flank/4/rt, 1>
			translate -gear_flank/2*y
		}
		torus {
			rt1+rt, rt
			scale <1, gear_flank/4/rt, 1>
			translate  gear_flank/2*y
		}
		torus {
			rt1+rt, rt
			scale <1, gear_flank/4/rt, 1>
			translate -gear_flank/2*y
		}
		difference {
			cylinder{gear_flank/4*y, gear_flank*y, rt2-rt}
			cylinder{gear_flank/4*y, gear_flank*1.1*y, rt1+rt}
		}
		difference {
			cylinder{-gear_flank/4*y, -gear_flank*y, rt2-rt}
			cylinder{-gear_flank/4*y, -gear_flank*1.1*y, rt1+rt}
		}
		cylinder {-y, y, r1min}
		texture {
			pigment {
				colour rgb <0.58, 0.42, 0.20>*1.5
			}
			finish {
				ambient 0.15
				brilliance 5
				diffuse 0.1
				metallic
				specular 0.7
				roughness 0.018
			}
			normal{
				wood
				scallop_wave
				bump_size .25
				scale 0.003
			}
			rotate 90*x
		}
	}
	cone {
		gear_flank/4*y, r1min, gear_flank/2*y, r1min*.7
		texture{
			pigment {
				colour rgb <0.75, 0.75, 0.75>
			}
			finish {
				ambient 0.3
				brilliance 3
				diffuse 0.4
				metallic
				specular 0.7
				roughness 0.018
				reflection 0.25
			}
		}
	}
#end

// The cog-wheel group. Positioning maths produced using F. Dispot's gearmess algorithm

light_group {
	light_source {
		<100, 0, -80>
		colour rgb 2.5 
	}
	light_source {
		<-200, -20, -50>
		rgb 1.5
	}
	object {
		union {
			union{
				gear_wrapper(12, 0.021384, .08, 20)
				rotate -90*x
				rotate -81.819170*z
				translate <0.491167, 0.909725, 0.1>
			}
			union{
				gear_wrapper(16, 0.012411, .08, 20)
				rotate -90*x
				rotate 198.955742*z
				translate <0.491167, 0.909725, 0.3>
			}
			union{
				gear_wrapper(15, 0.021384, .08, 20)
				rotate -90*x
				rotate 83.180830*z
				translate <0.777590, 0.875473, 0.1>
			}
			union{
				gear_wrapper(33, 0.009532, .08, 20)
				rotate -90*x
				rotate -216.382039*z
				translate <0.777590, 0.875473, 0.2>
			}
			union{
				gear_wrapper(34, 0.009532, .08, 20)
				rotate -90*x
				rotate -41.836584*z
				translate <0.039217, 0.050708, 0.2>
			}
			union{
				gear_wrapper(31, 0.011894, .08, 20)
				rotate -90*x
				rotate 7.702416*z
				translate <0.039217, 0.050708, 0.3>
			}
			union{
				gear_wrapper(24, 0.011894, .08, 20)
				rotate -90*x
				rotate 181.895965*z
				translate <0.028394, 0.377654, 0.3>
			}
			union{
				gear_wrapper(14, 0.012946, .08, 20)
				rotate -90*x
				rotate -96.941141*z
				translate <0.028394, 0.377654, 0.4>
			}
			union{
				gear_wrapper(35, 0.011535, .08, 20)
				rotate -90*x
				rotate 189.571369*z
				translate <0.308579, 0.536559, 0.1>
			}
			union{
				gear_wrapper(28, 0.012476, .08, 20)
				rotate -90*x
				rotate -87.105560*z
				translate <0.308579, 0.536559, 0.2>
			}
			union{
				gear_wrapper(14, 0.011535, .08, 20)
				rotate -90*x
				rotate 22.428512*z
				translate <0.355212, 0.260003, 0.1>
			}
			union{
				gear_wrapper(40, 0.012946, .08, 20)
				rotate -90*x
				rotate 70.201716*z
				translate <0.355212, 0.260003, 0.4>
			}
			union{
				gear_wrapper(22, 0.012476, .08, 20)
				rotate -90*x
				rotate 86.465869*z
				translate <0.626070, 0.516951, 0.2>
			}
			union{
				gear_wrapper(50, 0.012411, .08, 20)
				rotate -90*x
				rotate 22.555742*z
				translate <0.626070, 0.516951, 0.3>
			}
		}	
		translate <-0.5, -0.5, 0>
		scale <10, 10, 6>
	}
	global_lights on
}

// A type M planet, nothing special here.

#declare LandP=pigment {
	bozo
	colour_map {
		[0.00 colour rgb <0.534, 0.534, 0.450>]
		[0.07 colour rgb <0.534, 0.560, 0.450>]
		[0.15 colour rgb <0.500, 0.560, 0.450>]
		[0.22 colour rgb <0.534, 0.534, 0.450>]
		[0.30 colour rgb <0.534, 0.560, 0.450>]
		[0.35 colour rgb <0.500, 0.560, 0.450>]
		[0.50 colour rgb <0.600, 0.600, 0.600>]
		[0.75 colour rgb <0.600, 0.750, 0.600>]
		[1.00 colour rgb <0.550, 0.700, 0.600>]
	}
	turbulence 1.75
	lambda 3.0
	omega 0.75
	scale 0.25
}

#declare PolarP=pigment {
	colour rgb <1, 1, 1>
}

#declare LandTex=texture {
	pigment {
		gradient y
		pigment_map {
			[0.00 PolarP]
			[0.10 PolarP]
			[0.10 LandP]
			[0.90 LandP]
			[0.90 PolarP]
			[1.00 PolarP]
		}
		translate y*-0.5
		scale <1, 2, 1>
		turbulence y*0.2
	}
	normal {
		bumps 0.5
		turbulence 0.5
		scale 0.01
	}
	rotate <5, 0, -10>
}

#declare SeaTex=texture {
	pigment {
		bozo
		colour_map {
			[0.00 colour rgb <0.20, 0.50, 0.95>]
			[0.30 colour rgb <0.25, 0.60, 0.95>]
			[0.60 colour rgb <0.30, 0.65, 0.99>]
			[0.64 colour rgb <0.60, 0.85, 1.00>]
			[0.64 colour rgbt <1, 1, 1, 1>]
			[1.00 colour rgbt <1, 1, 1, 1>]
		}
		turbulence 0.7
		lambda 2.35
		omega 0.75
		scale 0.5
	}
	rotate <15, 25, -5>
}

#declare PlanetSphere=sphere {
	<0, 0, 0>, 1
	texture {
		LandTex
	}
	texture {
		SeaTex
	}
}

#declare CloudTex=texture {
	pigment {
		bozo
		colour_map {
			[0.00 colour rgbt <0, 0, 0, 1>]
			[0.10 colour rgbt <0, 0, 0, 1>]
			[0.14 colour rgbt <0.75, 0.75, 0.75, 1.00>]
			[1.00 colour rgbt <1, 1, 1, 0>]
		}
		turbulence 5.0
		lambda 3.0
		omega 0.55
		scale <1, 0.55, 0.5>
	}
}

#declare AerialPersp = texture {
	pigment {
		gradient z
		colour_map {
			[0.00 colour rgbt <0.5, 1, 1, 1>]
			[0.30 colour rgbt <0.5, 1, 1, 1>]
			[0.65 colour rgbt <0, 1, 1, 0.5>]
			[1.00 colour rgbt <0, 1, 1, 0.5>]
		}
		translate z*-0.5
		scale 2.5
	}
}

#declare PlanetCloudSphere=sphere {
	<0, 0, 0>, 1.001
	texture {
		CloudTex
	}
	texture {
		AerialPersp
	}
	rotate x*-10
	scale 1.005
}

#declare Planet = union {
	object {
		PlanetSphere
	}
	object {
		PlanetCloudSphere
	}
}

object {
	Planet
	scale 64
	translate <200, -50, 230>
}

