#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "woods.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"


// fireplace

#declare newBrickWidth       = 19.5; //= 0.1200;   // 8
#declare newBrickHeight      = 5.5;  //= 0.0450;   // 3
#declare newBrickDepth       = 9;    //= 0.0675;   // 4.5
#declare newBrickMortarWidth = 0.5;  //=0.00525;   // 0.35
#declare newBrickBozoScale   = 180;  //= 1.5;      // 100
#declare newBrickClearMortar = 0;
#declare newBrickTurbulence  = 0.08; //= 0.00075;  // 0.05
#include "bricks.inc" 


#ifndef (Area_Lights)     #local  Area_Lights      = false; #end
#ifndef (UsePhotons)      #local  UsePhotons       = false; #end
#ifndef (FirePlaceLight)  #local  FirePlaceLight   = false; #end


#declare t_mantle =
    texture { T_Wood25 rotate y*90 scale 1.5
      finish { ambient 0 diffuse 0.15 roughness 0.1 specular 0.1}
    }

#declare fireplace =
union{
  box {<0,0,0>,<153,16.35,44.4> texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}}}
  difference{
    box {<0,16.349,36>,<153,110,44.4> texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}}}
    box {<28,16.35,35>,<127,83.0,44.5>
      texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}}
      texture { pigment{color rgbf <.8,1,1,.7>}}
    }
  }
  box {<18,16.35,44.3>,<28,83.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //l
    texture { pigment{color rgbf <.8,1,1,.6>}}
  }
  box {<127,16.35,44.3>,<137,83.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //r
    texture { pigment{color rgbf <.8,1,1,.6>}}
  }
  box {<17,83,44.3>,<138,85.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //t
    texture { pigment{color rgbf <.8,1,1,.6>}}
  }
  box {<17,0,44.3>,<138,16.35,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //b
    texture { pigment{color rgbf <.3,.4,.4,.6>}}
  }
  box {<0,0,0>,<10,83,40>  //<127,16.35,44.3>,<137,83.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //ra
    texture { pigment{color rgbf <.3,.4,.4,.6>}}
    rotate y*-30 translate <129,0,50.5>
  }

  box {<0,0,0>,<10,83,40>  //<127,16.35,44.3>,<137,83.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //la
    texture { pigment{color rgbf <.3,.4,.4,.6>}}
    rotate y*30 translate <12.78,0,47.7>
  }
  box {<28,0,74>,<127,83.0,90>
    texture{ T_newBrick translate <-0.5,0.45,-0.1> finish { ambient 0 diffuse 0.2}} //back
    texture { pigment{color rgbf <.3,.4,.4,.6>}}
  }
  difference{
    box {<-11,109.9,25>,<164,120,44.5> texture { t_mantle}} // mantle
    cylinder { <0,0,0>, <177,0,0>, 12 texture { t_mantle} scale <1,1,1.5> translate <-12,107,18>}
    cylinder { <0,0,0>, <20,0,0>, 12 texture { t_mantle} scale <1,1,1.5> rotate y*90 translate <171,107,45>}
    cylinder { <0,0,0>, <20,0,0>, 12 texture { t_mantle} scale <1,1,1.5> rotate y*90 translate <-18,107,45>}
  }
  #if(FirePlaceLight)
  #debug "The fireplace has a fire going ...\n"
    #if(Area_Lights)
      light_source {
        <80, 30, 40>
        color rgb <.12,.10,0>
//        color rgb <.2,.15,0>
        area_light <-5, 0, -5>, <5, 0, 5>, 4, 4
        adaptive 1 jitter
        fade_distance 200 fade_power 1
        #if(UsePhotons)
          photons { area_light refraction on reflection on}
        #end
      }
    #else
      light_source { <80, 30, 40> color rgb <.2,.15,0> fade_distance 200 fade_power 1 
        #if(UsePhotons)
          photons { refraction on reflection on }
        #end
      }
    #end
  #end
  photons{collect on}
}