 
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "woods.inc"
#include "Christmas02.inc"

#declare white = rgbf < 1.0, 1.0, 1.0, 1.0>;

///////////// T E X T U R E S ///////////////

#local t_snow =
texture{
  pigment{rgb <0.9,0.9,0.9>}
  finish{ambient 0 diffuse 0.65 specular 0.0 roughness 0.1}
  normal{
    average 2
    normal_map{
        [bozo 2 scale .05 turbulence 0.75]
//        [bumps 0.4 scale 0.02]  //lamppost_test1-4
        [bumps 0.2 scale 0.02]   //lamppost_test5
        [bumps 0.4 scale 0.00001]
    }
  }
}
#local coal =
        texture { pigment { color Gray20 }
                normal { bumps 0.2 scale 0.002 }
                finish { ambient 0 diffuse 0.2 specular 0.3 roughness 0.1 }
        }

#local Red_Cloth=
        texture { pigment { color rgb <0.44, 0.0, 0.32> }
                finish { ambient 0 diffuse 0.4 phong 0.5 phong_size 10 }
                normal {wrinkles 0.25}
                scale <0.1 0.1 0.1>
        }

#local t_stick =
     texture{ pigment {color rgb <0.52, 0.37, 0.26>}
            normal {            // Copy of WoodGrain6A pigment
            wood 0.4
            turbulence <0.05, 0.08, 1>
            octaves 4
            scale <0.015, .015, .01>
            translate -x*10
        }
//                finish { ambient 0.25 diffuse 0.5 roughness 0.1 }
                finish { ambient 0 diffuse 0.2 roughness 0.1 }
 
     }
     
////////////// S N O W  M A N  ////////////////

//body
#local SnowBody =
blob {  threshold .005
        sphere { <0, .15, 0>, .2, .5 texture { t_snow }}
        sphere { <0, .45, 0>, .15, .5 texture { t_snow }}
        sphere { <0, .66, 0>, .10, .5 texture { t_snow }}
}

//eyes
#local EyeLump = sphere { <0, 0, 0>, .01 texture { coal }}

//nose
#local CarrotNose = 
cone { <0, 0.64, 0.82>, 0.004
       <0, 0.64, 0.91>, 0.008
        texture { pigment { color Orange }}
        normal { bumps 0.2 scale 0.001 }
        finish { ambient 0 diffuse 0.4 phong 1 }
}

//mouth
#local MouthLump = sphere { <0, 0, 0>, .0063 texture { coal }}

//buttons
#local ButtonLump = sphere { <0, 0, 0>, .01 texture { coal }}

//topHat
#local TopHat =
union {
        union{
             cylinder { <0, 0, 0 >, <0, 0.13, 0 >, 0.065 texture {pigment { color Gray30 } finish { ambient 0 diffuse 0.2}}}
             cylinder { <0, .002, 0 >, <0, 0.132, 0 >, 0.063 texture {t_snow}}
        }
        cylinder { <0, 0, 0 >, <0, 0.015, 0 >, 0.066 texture {pigment { color Black }}}
        union{
             cylinder { <0, 0, 0 >, <0, 0.003, 0 >, 0.095 texture {pigment { color Gray30 } finish { ambient 0 diffuse 0.2}}}
             cylinder { <0, .002, 0 >, <0, 0.005, 0 >, 0.090 texture {t_snow}}
        }
}


//arms
#local branch =
union { 
        cone { <0,     0,     0>, 0.0080 <0,     0.050, 0>, 0.0075 } 
        cone { <0,     0.049, 0>, 0.0075 <0.005, 0.100, 0>, 0.0070 } 
        cone { <0.005, 0.099, 0>, 0.0070 <0.015, 0.150, 0>, 0.0065 } 
        cone { <0.015, 0.149, 0>, 0.0065 <0.022, 0.200, 0>, 0.0060 } 
        cone { <0.022, 0.199, 0>, 0.0060 <0.025, 0.250, 0>, 0.0055 } 
        cone { <0.025, 0.249, 0>, 0.0055 <0.028, 0.300, 0>, 0.0050 } 
        cone { <0.028, 0.299, >, 0.0050  <0.030, 0.330, 0>, 0.0040 } 
}

#local twig =
union {
        cone { <0.000, 0.224, 0>, 0.0045 <0.008, 0.235, 0>, 0.0043 } 
        cone { <0.008, 0.234, 0>, 0.0043 <0.018, 0.250, 0>, 0.0040 } 
        cone { <0.018, 0.249, 0>, 0.0040 <0.022, 0.265, 0>, 0.0036 } 
        cone { <0.022, 0.264, 0>, 0.0036 <0.027, 0.280, 0>, 0.0032 } 
} 

#local RArm = union { object{branch} object{twig translate <0.025, 0.025, 0>}}
#local LArm = union { object{branch} object{twig rotate <90, 90, 90> translate <0.025, 0.025, 0>}}

#local RightArm = union {
object{RArm texture { t_stick  finish{ambient 0}}}
object{RArm texture { t_snow } translate z*.003 scale <.99,.99, 1>}
}

#local LeftArm = union {
object{LArm texture { t_stick  finish{ambient 0}}}
object{LArm texture { t_snow } translate <-.002,-.0002,0> scale <.99,.99, 1>}
}

#local scarf1 =
union {
        cone{ < 0, 0.02, 0 >, 0.066, < 0, 0.01, 0 >, 0.060 texture{ Red_Cloth }}
        cylinder { < 0, 0.005, 0 >, < 0, 0.015, 0 >, 0.062 texture { Red_Cloth }}
        cone{ < 0, 0.004, 0 >, 0.072, < 0, 0.01, 0 >, 0.060 texture{ Red_Cloth }}

        cone{ < 0.062, 0.010, 0.005 >, 0.013, < 0.062, 0.010, 0.010>, 0.010 texture{ Red_Cloth }} //right
        cylinder { < 0.062, 0.010, -0.005 >, < 0.062, 0.010, 0.005 >, 0.013 texture { Red_Cloth }}
        cone{ < 0.062, 0.010, -0.010 >, 0.010, < 0.062, 0.010, -0.005>, 0.013 texture{ Red_Cloth }} //left
}
#local scarf2 =
bicubic_patch { type 1 u_steps 4  v_steps 4 flatness 0.001
        < 0.066, 0.587, -0.009>, < 0.063, 0.582, -0.009>, < 0.063, 0.578, -0.009>, < 0.068, 0.576, -0.009>,
        < 0.070, 0.580, -0.018>, < 0.062, 0.579, -0.018>, < 0.065, 0.577, -0.016>, < 0.070, 0.579, -0.016>,
        < 0.130, 0.560, -0.055>, < 0.130, 0.560, -0.040>, < 0.130, 0.560, -0.025>, < 0.130, 0.560, -0.010>,
        < 0.150, 0.460, -0.055>, < 0.150, 0.460, -0.040>, < 0.150, 0.460, -0.025>, < 0.150, 0.460, -0.010>
        texture{ Red_Cloth }
}



//assemble the pieces

#declare SMParts =
union{
object  {TopHat rotate <-8, 0, -20> translate <0.023, 0.723, -0.0095> }
object {RightArm rotate <0, 20, 75> translate <-0.11, .53, 0>}
object {LeftArm rotate <0, 70, -75> translate <0.10, .53, 0>}
object {scarf1 translate <0, 0.57, 0>}
object {scarf2 translate <0, 0, 0>}
}
#local SnowyParts =
union{
  object{SMParts}
  blob{ MakeSnow(SMParts,5000 ,12345,2.00,0.9,-0.4,0.4,-0.3,0.3,0.002,0) texture{t_snow}}
}

#declare OtherSMParts =
union {
object  {SnowBody translate <0, 0, 0> }
object  {EyeLump translate <-0.03, 0.67, -0.09> }  // Left eye
object  {EyeLump translate <0.03, 0.67, -0.09> }  // Right eye
object  {CarrotNose translate <0, 0, -1> }
object  {MouthLump rotate <0, 0, -40> translate <-0.04, 0.613, -0.073> }
object  {MouthLump rotate <0, 0, -15> translate <-0.02, 0.606, -0.075> }
object  {MouthLump translate <0, 0.603, -0.076> }
object  {MouthLump rotate <0, 0, 15> translate <0.02, 0.606, -0.075> } 
object  {MouthLump rotate <0, 0, 40> translate <0.04, 0.613, -0.073> }
object  {ButtonLump translate <-0, 0.55, -0.100> }
object  {ButtonLump translate <-0, 0.49, -0.137> }
object  {ButtonLump translate <-0, 0.43, -0.139> }
object  {ButtonLump translate <-0, 0.37, -0.118> }
object  {ButtonLump translate <-0, 0.31, -0.100> }
}

//object  {TopHat rotate <-8, 0, -20> translate <0.023, 0.723, -0.0095> }
//object {RightArm rotate <0, 20, 75> translate <-0.11, .53, 0>}
//object {LeftArm rotate <0, 70, -75> translate <0.10, .53, 0>}
//object {scarf1 translate <0, 0.57, 0>}
//object {scarf2 translate <0, 0, 0>}
#declare SnowMan =
union{
object{OtherSMParts}
object{SnowyParts}
}
#declare SnowMan2 =
union{
object{OtherSMParts}
object{SMParts}
}
